/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITargetedTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TranslationTextComponentFormatException;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.fml.TextComponentMessageFormatHandler;

public class TranslationTextComponent
extends TextComponent
implements ITargetedTextComponent {
    private static final LanguageMap field_200526_d = new LanguageMap();
    private static final LanguageMap field_200527_e = LanguageMap.func_74808_a();
    private final String field_150276_d;
    private final Object[] field_150277_e;
    private final Object field_150274_f = new Object();
    private long field_150275_g = -1L;
    protected final List<ITextComponent> field_150278_b = Lists.newArrayList();
    public static final Pattern field_150279_c = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public TranslationTextComponent(String translationKey, Object ... args) {
        this.field_150276_d = translationKey;
        this.field_150277_e = args;
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (object instanceof ITextComponent) {
                ITextComponent itextcomponent = ((ITextComponent)object).func_212638_h();
                this.field_150277_e[i] = itextcomponent;
                itextcomponent.func_150256_b().func_150221_a(this.func_150256_b());
                continue;
            }
            if (object != null) continue;
            this.field_150277_e[i] = "null";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    synchronized void func_150270_g() {
        Object object = this.field_150274_f;
        synchronized (object) {
            long i = field_200527_e.func_150510_c();
            if (i == this.field_150275_g) {
                return;
            }
            this.field_150275_g = i;
            this.field_150278_b.clear();
        }
        try {
            this.func_150269_b(field_200527_e.func_74805_b(this.field_150276_d));
        }
        catch (TranslationTextComponentFormatException translationtextcomponentformatexception) {
            this.field_150278_b.clear();
            try {
                this.func_150269_b(field_200526_d.func_74805_b(this.field_150276_d));
            }
            catch (TranslationTextComponentFormatException var5) {
                throw translationtextcomponentformatexception;
            }
        }
    }

    protected void func_150269_b(String format) {
        Matcher matcher = field_150279_c.matcher(format);
        try {
            int i = 0;
            int j = 0;
            while (matcher.find(j)) {
                int k = matcher.start();
                int l = matcher.end();
                if (k > j) {
                    StringTextComponent itextcomponent = new StringTextComponent(String.format(format.substring(j, k), new Object[0]));
                    itextcomponent.func_150256_b().func_150221_a(this.func_150256_b());
                    this.field_150278_b.add((ITextComponent)itextcomponent);
                }
                String s2 = matcher.group(2);
                String s = format.substring(k, l);
                if ("%".equals(s2) && "%%".equals(s)) {
                    StringTextComponent itextcomponent2 = new StringTextComponent("%");
                    itextcomponent2.func_150256_b().func_150221_a(this.func_150256_b());
                    this.field_150278_b.add((ITextComponent)itextcomponent2);
                } else {
                    int i1;
                    if (!"s".equals(s2)) {
                        throw new TranslationTextComponentFormatException(this, "Unsupported format: '" + s + "'");
                    }
                    String s1 = matcher.group(1);
                    int n = i1 = s1 != null ? Integer.parseInt(s1) - 1 : i++;
                    if (i1 < this.field_150277_e.length) {
                        this.field_150278_b.add(this.func_150272_a(i1));
                    }
                }
                j = l;
            }
            if (j == 0) {
                j = TextComponentMessageFormatHandler.handle((TranslationTextComponent)this, this.field_150278_b, (Object[])this.field_150277_e, (String)format);
            }
            if (j < format.length()) {
                StringTextComponent itextcomponent1 = new StringTextComponent(String.format(format.substring(j), new Object[0]));
                itextcomponent1.func_150256_b().func_150221_a(this.func_150256_b());
                this.field_150278_b.add((ITextComponent)itextcomponent1);
            }
        }
        catch (IllegalFormatException illegalformatexception) {
            throw new TranslationTextComponentFormatException(this, (Throwable)illegalformatexception);
        }
    }

    private ITextComponent func_150272_a(int index) {
        ITextComponent itextcomponent;
        if (index >= this.field_150277_e.length) {
            throw new TranslationTextComponentFormatException(this, index);
        }
        Object object = this.field_150277_e[index];
        if (object instanceof ITextComponent) {
            itextcomponent = (ITextComponent)object;
        } else {
            itextcomponent = new StringTextComponent(object == null ? "null" : object.toString());
            itextcomponent.func_150256_b().func_150221_a(this.func_150256_b());
        }
        return itextcomponent;
    }

    public ITextComponent func_150255_a(Style style) {
        super.func_150255_a(style);
        for (Object object : this.field_150277_e) {
            if (!(object instanceof ITextComponent)) continue;
            ((ITextComponent)object).func_150256_b().func_150221_a(this.func_150256_b());
        }
        if (this.field_150275_g > -1L) {
            for (ITextComponent itextcomponent : this.field_150278_b) {
                itextcomponent.func_150256_b().func_150221_a(style);
            }
        }
        return this;
    }

    public Stream<ITextComponent> func_212640_c() {
        this.func_150270_g();
        return Streams.concat((Stream[])new Stream[]{this.field_150278_b.stream(), this.field_150264_a.stream()}).flatMap(ITextComponent::func_212640_c);
    }

    public String func_150261_e() {
        this.func_150270_g();
        StringBuilder stringbuilder = new StringBuilder();
        for (ITextComponent itextcomponent : this.field_150278_b) {
            stringbuilder.append(itextcomponent.func_150261_e());
        }
        return stringbuilder.toString();
    }

    public TranslationTextComponent func_150259_f() {
        Object[] aobject = new Object[this.field_150277_e.length];
        for (int i = 0; i < this.field_150277_e.length; ++i) {
            aobject[i] = this.field_150277_e[i] instanceof ITextComponent ? ((ITextComponent)this.field_150277_e[i]).func_212638_h() : this.field_150277_e[i];
        }
        return new TranslationTextComponent(this.field_150276_d, aobject);
    }

    public ITextComponent func_197668_a(@Nullable CommandSource p_197668_1_, @Nullable Entity p_197668_2_, int p_197668_3_) throws CommandSyntaxException {
        Object[] aobject = new Object[this.field_150277_e.length];
        for (int i = 0; i < aobject.length; ++i) {
            Object object = this.field_150277_e[i];
            aobject[i] = object instanceof ITextComponent ? TextComponentUtils.func_197680_a((CommandSource)p_197668_1_, (ITextComponent)((ITextComponent)object), (Entity)p_197668_2_, (int)p_197668_3_) : object;
        }
        return new TranslationTextComponent(this.field_150276_d, aobject);
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof TranslationTextComponent)) {
            return false;
        }
        TranslationTextComponent translationtextcomponent = (TranslationTextComponent)((Object)p_equals_1_);
        return Arrays.equals(this.field_150277_e, translationtextcomponent.field_150277_e) && this.field_150276_d.equals(translationtextcomponent.field_150276_d) && super.equals(p_equals_1_);
    }

    public int hashCode() {
        int i = super.hashCode();
        i = 31 * i + this.field_150276_d.hashCode();
        i = 31 * i + Arrays.hashCode(this.field_150277_e);
        return i;
    }

    public String toString() {
        return "TranslatableComponent{key='" + this.field_150276_d + '\'' + ", args=" + Arrays.toString(this.field_150277_e) + ", siblings=" + this.field_150264_a + ", style=" + this.func_150256_b() + '}';
    }

    public String func_150268_i() {
        return this.field_150276_d;
    }

    public Object[] func_150271_j() {
        return this.field_150277_e;
    }
}

