/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.lighting;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.lighting.SkyLightStorage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class SkyLightEngine
extends LightEngine<SkyLightStorage.StorageMap, SkyLightStorage> {
    private static final Direction[] field_215633_d = Direction.values();
    private static final Direction[] field_215634_e = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public SkyLightEngine(IChunkLightProvider p_i51289_1_) {
        super(p_i51289_1_, LightType.SKY, new SkyLightStorage(p_i51289_1_));
    }

    @Override
    protected int func_215480_b(long startPos, long endPos, int startLevel) {
        if (endPos == Long.MAX_VALUE) {
            return 15;
        }
        if (startPos == Long.MAX_VALUE) {
            if (!((SkyLightStorage)this.field_215627_c).func_215551_l(endPos)) {
                return 15;
            }
            startLevel = 0;
        }
        if (startLevel >= 15) {
            return startLevel;
        }
        AtomicInteger atomicinteger = new AtomicInteger();
        BlockState blockstate = this.func_223406_a(endPos, atomicinteger);
        if (atomicinteger.get() >= 15) {
            return 15;
        }
        int i = BlockPos.func_218290_b((long)startPos);
        int j = BlockPos.func_218274_c((long)startPos);
        int k = BlockPos.func_218282_d((long)startPos);
        int l = BlockPos.func_218290_b((long)endPos);
        int i1 = BlockPos.func_218274_c((long)endPos);
        int j1 = BlockPos.func_218282_d((long)endPos);
        boolean flag = i == l && k == j1;
        int k1 = Integer.signum(l - i);
        int l1 = Integer.signum(i1 - j);
        int i2 = Integer.signum(j1 - k);
        Direction direction = startPos == Long.MAX_VALUE ? Direction.DOWN : Direction.func_218383_a(k1, l1, i2);
        BlockState blockstate1 = this.func_223406_a(startPos, null);
        if (direction != null) {
            VoxelShape voxelshape1;
            VoxelShape voxelshape = this.func_223405_a(blockstate1, startPos, direction);
            if (VoxelShapes.func_223416_b((VoxelShape)voxelshape, (VoxelShape)(voxelshape1 = this.func_223405_a(blockstate, endPos, direction.func_176734_d())))) {
                return 15;
            }
        } else {
            VoxelShape voxelshape3 = this.func_223405_a(blockstate1, startPos, Direction.DOWN);
            if (VoxelShapes.func_223416_b((VoxelShape)voxelshape3, (VoxelShape)VoxelShapes.func_197880_a())) {
                return 15;
            }
            int j2 = flag ? -1 : 0;
            Direction direction1 = Direction.func_218383_a(k1, j2, i2);
            if (direction1 == null) {
                return 15;
            }
            VoxelShape voxelshape2 = this.func_223405_a(blockstate, endPos, direction1.func_176734_d());
            if (VoxelShapes.func_223416_b((VoxelShape)VoxelShapes.func_197880_a(), (VoxelShape)voxelshape2)) {
                return 15;
            }
        }
        boolean flag1 = startPos == Long.MAX_VALUE || flag && j > i1;
        return flag1 && startLevel == 0 && atomicinteger.get() == 0 ? 0 : startLevel + Math.max(1, atomicinteger.get());
    }

    @Override
    protected void func_215478_a(long pos, int level, boolean isDecreasing) {
        long l1;
        long i2;
        int i1;
        long i = SectionPos.func_218162_e((long)pos);
        int j = BlockPos.func_218274_c((long)pos);
        int k = SectionPos.func_218171_b((int)j);
        int l = SectionPos.func_218159_a((int)j);
        if (k != 0) {
            i1 = 0;
        } else {
            int j1 = 0;
            while (!((SkyLightStorage)this.field_215627_c).func_215518_g(SectionPos.func_218174_a((long)i, (int)0, (int)(-j1 - 1), (int)0)) && ((SkyLightStorage)this.field_215627_c).func_215550_a(l - j1 - 1)) {
                ++j1;
            }
            i1 = j1;
        }
        long i3 = BlockPos.func_218291_a((long)pos, (int)0, (int)(-1 - i1 * 16), (int)0);
        long k1 = SectionPos.func_218162_e((long)i3);
        if (i == k1 || ((SkyLightStorage)this.field_215627_c).func_215518_g(k1)) {
            this.func_215475_b(pos, i3, level, isDecreasing);
        }
        if (i == (i2 = SectionPos.func_218162_e((long)(l1 = BlockPos.func_218289_a((long)pos, (Direction)Direction.UP)))) || ((SkyLightStorage)this.field_215627_c).func_215518_g(i2)) {
            this.func_215475_b(pos, l1, level, isDecreasing);
        }
        block1: for (Direction direction : field_215634_e) {
            int j2 = 0;
            do {
                long k2;
                long l2;
                if (i == (l2 = SectionPos.func_218162_e((long)(k2 = BlockPos.func_218291_a((long)pos, (int)direction.func_82601_c(), (int)(-j2), (int)direction.func_82599_e()))))) {
                    this.func_215475_b(pos, k2, level, isDecreasing);
                    continue block1;
                }
                if (!((SkyLightStorage)this.field_215627_c).func_215518_g(l2)) continue;
                this.func_215475_b(pos, k2, level, isDecreasing);
            } while (++j2 <= i1 * 16);
        }
    }

    @Override
    protected int func_215477_a(long pos, long excludedSourcePos, int level) {
        int i = level;
        if (Long.MAX_VALUE != excludedSourcePos) {
            int j = this.func_215480_b(Long.MAX_VALUE, pos, 0);
            if (level > j) {
                i = j;
            }
            if (i == 0) {
                return i;
            }
        }
        long j1 = SectionPos.func_218162_e((long)pos);
        NibbleArray nibblearray = ((SkyLightStorage)this.field_215627_c).func_215520_a(j1, true);
        for (Direction direction : field_215633_d) {
            int i1;
            long k = BlockPos.func_218289_a((long)pos, (Direction)direction);
            long l = SectionPos.func_218162_e((long)k);
            NibbleArray nibblearray1 = j1 == l ? nibblearray : ((SkyLightStorage)this.field_215627_c).func_215520_a(l, true);
            if (nibblearray1 != null) {
                if (k == excludedSourcePos) continue;
                int k1 = this.func_215480_b(k, pos, this.func_215622_a(nibblearray1, k));
                if (i > k1) {
                    i = k1;
                }
                if (i != 0) continue;
                return i;
            }
            if (direction == Direction.DOWN) continue;
            k = BlockPos.func_218288_f((long)k);
            while (!((SkyLightStorage)this.field_215627_c).func_215518_g(l) && !((SkyLightStorage)this.field_215627_c).func_215549_m(l)) {
                l = SectionPos.func_218172_a((long)l, (Direction)Direction.UP);
                k = BlockPos.func_218291_a((long)k, (int)0, (int)16, (int)0);
            }
            NibbleArray nibblearray2 = ((SkyLightStorage)this.field_215627_c).func_215520_a(l, true);
            if (k == excludedSourcePos) continue;
            if (nibblearray2 != null) {
                i1 = this.func_215480_b(k, pos, this.func_215622_a(nibblearray2, k));
            } else {
                int n = i1 = ((SkyLightStorage)this.field_215627_c).func_215548_n(l) ? 0 : 15;
            }
            if (i > i1) {
                i = i1;
            }
            if (i != 0) continue;
            return i;
        }
        return i;
    }

    @Override
    protected void func_215473_f(long worldPos) {
        ((SkyLightStorage)this.field_215627_c).func_215532_c();
        long i = SectionPos.func_218162_e((long)worldPos);
        if (((SkyLightStorage)this.field_215627_c).func_215518_g(i)) {
            super.func_215473_f(worldPos);
        } else {
            worldPos = BlockPos.func_218288_f((long)worldPos);
            while (!((SkyLightStorage)this.field_215627_c).func_215518_g(i) && !((SkyLightStorage)this.field_215627_c).func_215549_m(i)) {
                i = SectionPos.func_218172_a((long)i, (Direction)Direction.UP);
                worldPos = BlockPos.func_218291_a((long)worldPos, (int)0, (int)16, (int)0);
            }
            if (((SkyLightStorage)this.field_215627_c).func_215518_g(i)) {
                super.func_215473_f(worldPos);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String func_215614_b(long sectionPosIn) {
        return super.func_215614_b(sectionPosIn) + (((SkyLightStorage)this.field_215627_c).func_215549_m(sectionPosIn) ? "*" : "");
    }

    @Override
    public int queuedUpdateSize() {
        return 0;
    }
}

