/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class ApplyBonus
extends LootFunction {
    private static final Map<ResourceLocation, IFormulaDeserializer> field_215875_a = Maps.newHashMap();
    private final Enchantment field_215876_c;
    private final IFormula field_215877_d;

    private ApplyBonus(ILootCondition[] iLootConditionArray, Enchantment enchantment, IFormula iFormula) {
        super(iLootConditionArray);
        this.field_215876_c = enchantment;
        this.field_215877_d = iFormula;
    }

    @Override
    public LootFunctionType func_230425_b_() {
        return LootFunctionManager.field_237443_p_;
    }

    @Override
    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of(LootParameters.field_216289_i);
    }

    @Override
    public ItemStack func_215859_a(ItemStack itemStack2, LootContext lootContext) {
        ItemStack itemStack2;
        ItemStack itemStack3 = lootContext.func_216031_c(LootParameters.field_216289_i);
        if (itemStack3 != null) {
            int n = EnchantmentHelper.func_77506_a(this.field_215876_c, itemStack3);
            \u2603 = this.field_215877_d.func_216204_a(lootContext.func_216032_b(), itemStack2.func_190916_E(), n);
            itemStack2.func_190920_e(\u2603);
        }
        return itemStack2;
    }

    public static LootFunction.Builder<?> func_215870_a(Enchantment enchantment, float f, int n) {
        return ApplyBonus.func_215860_a(iLootConditionArray -> new ApplyBonus((ILootCondition[])iLootConditionArray, enchantment, new BinomialWithBonusCountFormula(n, f)));
    }

    public static LootFunction.Builder<?> func_215869_a(Enchantment enchantment) {
        return ApplyBonus.func_215860_a(iLootConditionArray -> new ApplyBonus((ILootCondition[])iLootConditionArray, enchantment, new OreDropsFormula()));
    }

    public static LootFunction.Builder<?> func_215871_b(Enchantment enchantment) {
        return ApplyBonus.func_215860_a(iLootConditionArray -> new ApplyBonus((ILootCondition[])iLootConditionArray, enchantment, new UniformBonusCountFormula(1)));
    }

    public static LootFunction.Builder<?> func_215865_a(Enchantment enchantment, int n) {
        return ApplyBonus.func_215860_a(iLootConditionArray -> new ApplyBonus((ILootCondition[])iLootConditionArray, enchantment, new UniformBonusCountFormula(n)));
    }

    static {
        field_215875_a.put(BinomialWithBonusCountFormula.field_216211_a, BinomialWithBonusCountFormula::func_216210_a);
        field_215875_a.put(OreDropsFormula.field_216206_a, OreDropsFormula::func_216205_a);
        field_215875_a.put(UniformBonusCountFormula.field_216208_a, UniformBonusCountFormula::func_216207_a);
    }

    public static class Serializer
    extends LootFunction.Serializer<ApplyBonus> {
        @Override
        public void func_230424_a_(JsonObject jsonObject, ApplyBonus applyBonus, JsonSerializationContext jsonSerializationContext) {
            super.func_230424_a_(jsonObject, applyBonus, jsonSerializationContext);
            jsonObject.addProperty("enchantment", Registry.field_212628_q.func_177774_c(applyBonus.field_215876_c).toString());
            jsonObject.addProperty("formula", applyBonus.field_215877_d.func_216203_a().toString());
            JsonObject jsonObject2 = new JsonObject();
            applyBonus.field_215877_d.func_216202_a(jsonObject2, jsonSerializationContext);
            if (jsonObject2.size() > 0) {
                jsonObject.add("parameters", (JsonElement)jsonObject2);
            }
        }

        @Override
        public ApplyBonus func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "enchantment"));
            Enchantment \u26032 = Registry.field_212628_q.func_241873_b(resourceLocation).orElseThrow(() -> new JsonParseException("Invalid enchantment id: " + resourceLocation));
            \u2603 = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "formula"));
            IFormulaDeserializer \u26033 = (IFormulaDeserializer)field_215875_a.get(\u2603);
            if (\u26033 == null) {
                throw new JsonParseException("Invalid formula id: " + \u2603);
            }
            IFormula \u26034 = jsonObject.has("parameters") ? \u26033.deserialize(JSONUtils.func_152754_s(jsonObject, "parameters"), jsonDeserializationContext) : \u26033.deserialize(new JsonObject(), jsonDeserializationContext);
            return new ApplyBonus(iLootConditionArray, \u26032, \u26034);
        }

        @Override
        public /* synthetic */ LootFunction func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            return this.func_186530_b(jsonObject, jsonDeserializationContext, iLootConditionArray);
        }
    }

    static final class OreDropsFormula
    implements IFormula {
        public static final ResourceLocation field_216206_a = new ResourceLocation("ore_drops");

        private OreDropsFormula() {
        }

        @Override
        public int func_216204_a(Random random, int n, int n2) {
            if (n2 > 0) {
                \u2603 = random.nextInt(n2 + 2) - 1;
                if (\u2603 < 0) {
                    \u2603 = 0;
                }
                return n * (\u2603 + 1);
            }
            return n;
        }

        @Override
        public void func_216202_a(JsonObject jsonObject, JsonSerializationContext jsonSerializationContext) {
        }

        public static IFormula func_216205_a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return new OreDropsFormula();
        }

        @Override
        public ResourceLocation func_216203_a() {
            return field_216206_a;
        }
    }

    static final class UniformBonusCountFormula
    implements IFormula {
        public static final ResourceLocation field_216208_a = new ResourceLocation("uniform_bonus_count");
        private final int field_216209_b;

        public UniformBonusCountFormula(int n) {
            this.field_216209_b = n;
        }

        @Override
        public int func_216204_a(Random random, int n, int n2) {
            return n + random.nextInt(this.field_216209_b * n2 + 1);
        }

        @Override
        public void func_216202_a(JsonObject jsonObject, JsonSerializationContext jsonSerializationContext) {
            jsonObject.addProperty("bonusMultiplier", (Number)this.field_216209_b);
        }

        public static IFormula func_216207_a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            int n = JSONUtils.func_151203_m(jsonObject, "bonusMultiplier");
            return new UniformBonusCountFormula(n);
        }

        @Override
        public ResourceLocation func_216203_a() {
            return field_216208_a;
        }
    }

    static final class BinomialWithBonusCountFormula
    implements IFormula {
        public static final ResourceLocation field_216211_a = new ResourceLocation("binomial_with_bonus_count");
        private final int field_216212_b;
        private final float field_216213_c;

        public BinomialWithBonusCountFormula(int n, float f) {
            this.field_216212_b = n;
            this.field_216213_c = f;
        }

        @Override
        public int func_216204_a(Random random, int n, int n2) {
            for (\u2603 = 0; \u2603 < n2 + this.field_216212_b; ++\u2603) {
                if (!(random.nextFloat() < this.field_216213_c)) continue;
                ++n;
            }
            return n;
        }

        @Override
        public void func_216202_a(JsonObject jsonObject, JsonSerializationContext jsonSerializationContext) {
            jsonObject.addProperty("extra", (Number)this.field_216212_b);
            jsonObject.addProperty("probability", (Number)Float.valueOf(this.field_216213_c));
        }

        public static IFormula func_216210_a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            int n = JSONUtils.func_151203_m(jsonObject, "extra");
            float \u26032 = JSONUtils.func_151217_k(jsonObject, "probability");
            return new BinomialWithBonusCountFormula(n, \u26032);
        }

        @Override
        public ResourceLocation func_216203_a() {
            return field_216211_a;
        }
    }

    static interface IFormulaDeserializer {
        public IFormula deserialize(JsonObject var1, JsonDeserializationContext var2);
    }

    static interface IFormula {
        public int func_216204_a(Random var1, int var2, int var3);

        public void func_216202_a(JsonObject var1, JsonSerializationContext var2);

        public ResourceLocation func_216203_a();
    }
}

