/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TagCollectionReader<T> {
    private static final Logger field_242217_a = LogManager.getLogger();
    private static final Gson field_242218_b = new Gson();
    private static final int field_242219_c = ".json".length();
    private final Function<ResourceLocation, Optional<T>> field_242220_d;
    private final String field_242221_e;
    private final String field_242222_f;

    public TagCollectionReader(Function<ResourceLocation, Optional<T>> function, String string, String string2) {
        this.field_242220_d = function;
        this.field_242221_e = string;
        this.field_242222_f = string2;
    }

    public CompletableFuture<Map<ResourceLocation, ITag.Builder>> func_242224_a(IResourceManager iResourceManager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap hashMap = Maps.newHashMap();
            for (ResourceLocation resourceLocation2 : iResourceManager.func_199003_a(this.field_242221_e, string -> string.endsWith(".json"))) {
                String string2 = resourceLocation2.func_110623_a();
                ResourceLocation \u26032 = new ResourceLocation(resourceLocation2.func_110624_b(), string2.substring(this.field_242221_e.length() + 1, string2.length() - field_242219_c));
                try {
                    for (IResource iResource : iResourceManager.func_199004_b(resourceLocation2)) {
                        try {
                            InputStream inputStream = iResource.func_199027_b();
                            Throwable throwable = null;
                            try {
                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                                Throwable throwable2 = null;
                                try {
                                    JsonObject jsonObject = JSONUtils.func_193839_a(field_242218_b, bufferedReader, JsonObject.class);
                                    if (jsonObject == null) {
                                        field_242217_a.error("Couldn't load {} tag list {} from {} in data pack {} as it is empty or null", (Object)this.field_242222_f, (Object)\u26032, (Object)resourceLocation2, (Object)iResource.func_199026_d());
                                        continue;
                                    }
                                    hashMap.computeIfAbsent(\u26032, resourceLocation -> ITag.Builder.func_200047_a()).func_232956_a_(jsonObject, iResource.func_199026_d());
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (bufferedReader == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            ((Reader)bufferedReader).close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    ((Reader)bufferedReader).close();
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (inputStream == null) continue;
                                if (throwable != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                inputStream.close();
                            }
                        }
                        catch (IOException | RuntimeException exception) {
                            field_242217_a.error("Couldn't read {} tag list {} from {} in data pack {}", (Object)this.field_242222_f, (Object)\u26032, (Object)resourceLocation2, (Object)iResource.func_199026_d(), (Object)exception);
                        }
                        finally {
                            IOUtils.closeQuietly((Closeable)iResource);
                        }
                    }
                }
                catch (IOException iOException) {
                    field_242217_a.error("Couldn't read {} tag list {} from {}", (Object)this.field_242222_f, (Object)\u26032, (Object)resourceLocation2, (Object)iOException);
                }
            }
            return hashMap;
        }, executor);
    }

    public ITagCollection<T> func_242226_a(Map<ResourceLocation, ITag.Builder> map) {
        HashMap hashMap = Maps.newHashMap();
        Function \u26032 = hashMap::get;
        Function<ResourceLocation, Object> \u26033 = resourceLocation -> this.field_242220_d.apply((ResourceLocation)resourceLocation).orElse(null);
        while (!map.isEmpty()) {
            boolean \u26036 = false;
            Iterator<Map.Entry<ResourceLocation, ITag.Builder>> \u26034 = map.entrySet().iterator();
            while (\u26034.hasNext()) {
                Map.Entry<ResourceLocation, ITag.Builder> entry = \u26034.next();
                Optional<ITag<Object>> \u26035 = entry.getValue().func_232959_a_(\u26032, \u26033);
                if (!\u26035.isPresent()) continue;
                hashMap.put(entry.getKey(), \u26035.get());
                \u26034.remove();
                \u26036 = true;
            }
            if (\u26036) continue;
            break;
        }
        map.forEach((resourceLocation, builder) -> field_242217_a.error("Couldn't load {} tag {} as it is missing following references: {}", (Object)this.field_242222_f, resourceLocation, (Object)builder.func_232963_b_(\u26032, \u26033).map(Objects::toString).collect(Collectors.joining(","))));
        return ITagCollection.func_242202_a(hashMap);
    }
}

