/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srgutils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.IRenamer;
import net.minecraftforge.srgutils.InternalUtils;
import net.minecraftforge.srgutils.NamedMappingFile;

class MappingFile
implements IMappingFile {
    private Map<String, Package> packages = new HashMap<String, Package>();
    private Collection<Package> packagesView = Collections.unmodifiableCollection(this.packages.values());
    private Map<String, Cls> classes = new HashMap<String, Cls>();
    private Collection<Cls> classesView = Collections.unmodifiableCollection(this.classes.values());
    private Map<String, String> cache = new HashMap<String, String>();
    static final Pattern DESC = Pattern.compile("L(?<cls>[^;]+);");

    MappingFile() {
    }

    MappingFile(NamedMappingFile source, int from, int to) {
        source.getPackages().forEach(pkg -> this.addPackage(pkg.getName(from), pkg.getName(to), pkg.meta));
        source.getClasses().forEach(cls -> {
            Cls c = this.addClass(cls.getName(from), cls.getName(to), cls.meta);
            cls.getFields().forEach(fld -> c.addField(fld.getName(from), fld.getName(to), fld.getDescriptor(from), fld.meta));
            cls.getMethods().forEach(mtd -> {
                Cls.Method m = c.addMethod(mtd.getName(from), mtd.getDescriptor(from), mtd.getName(to), mtd.meta);
                mtd.getParameters().forEach(par -> m.addParameter(par.getIndex(), par.getName(from), par.getName(to), par.meta));
            });
        });
    }

    public Collection<Package> getPackages() {
        return this.packagesView;
    }

    @Override
    @Nullable
    public Package getPackage(String original) {
        return this.packages.get(original);
    }

    private Package addPackage(String original, String mapped, Map<String, String> metadata) {
        return this.packages.put(original, new Package(original, mapped, metadata));
    }

    public Collection<Cls> getClasses() {
        return this.classesView;
    }

    @Override
    @Nullable
    public Cls getClass(String original) {
        return this.classes.get(original);
    }

    private Cls addClass(String original, String mapped, Map<String, String> metadata) {
        return MappingFile.retPut(this.classes, original, new Cls(original, mapped, metadata));
    }

    @Override
    public String remapPackage(String pkg) {
        Package ipkg = this.packages.get(pkg);
        return ipkg == null ? pkg : ipkg.getMapped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String remapClass(String cls) {
        String ret = this.cache.get(cls);
        if (ret == null) {
            String string = cls.intern();
            synchronized (string) {
                ret = this.cache.get(cls);
                if (ret == null) {
                    int idx;
                    Cls _cls = this.classes.get(cls);
                    ret = _cls == null ? ((idx = cls.lastIndexOf(36)) != -1 ? this.remapClass(cls.substring(0, idx)) + '$' + cls.substring(idx + 1) : cls) : _cls.getMapped();
                    this.cache.put(cls, ret);
                }
            }
        }
        return ret;
    }

    @Override
    public String remapDescriptor(String desc) {
        Matcher matcher = DESC.matcher(desc);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buf, Matcher.quoteReplacement("L" + this.remapClass(matcher.group("cls")) + ";"));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    @Override
    public void write(Path path, IMappingFile.Format format, boolean reversed) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        Comparator sort = reversed ? (a, b) -> a.getMapped().compareTo(b.getMapped()) : (a, b) -> a.getOriginal().compareTo(b.getOriginal());
        this.getPackages().stream().sorted(sort).forEachOrdered(pkg -> {
            lines.add(pkg.write(format, reversed));
            InternalUtils.writeMeta(format, lines, InternalUtils.Element.PACKAGE, pkg.getMetadata());
        });
        this.getClasses().stream().sorted(sort).forEachOrdered(cls -> {
            lines.add(cls.write(format, reversed));
            InternalUtils.writeMeta(format, lines, InternalUtils.Element.CLASS, cls.getMetadata());
            cls.getFields().stream().sorted(sort).forEachOrdered(fld -> {
                lines.add(fld.write(format, reversed));
                InternalUtils.writeMeta(format, lines, InternalUtils.Element.FIELD, fld.getMetadata());
            });
            cls.getMethods().stream().sorted(sort).forEachOrdered(mtd -> {
                lines.add(mtd.write(format, reversed));
                InternalUtils.writeMeta(format, lines, InternalUtils.Element.METHOD, mtd.getMetadata());
                mtd.getParameters().stream().sorted((a, b) -> a.getIndex() - b.getIndex()).forEachOrdered(par -> {
                    lines.add(par.write(format, reversed));
                    InternalUtils.writeMeta(format, lines, InternalUtils.Element.PARAMETER, par.getMetadata());
                });
            });
        });
        lines.removeIf(e -> e == null);
        if (!format.isOrdered()) {
            Comparator linesort = format == IMappingFile.Format.SRG || format == IMappingFile.Format.XSRG ? InternalUtils::compareLines : (o1, o2) -> o1.compareTo((String)o2);
            Collections.sort(lines, linesort);
        }
        if (format == IMappingFile.Format.TINY1) {
            lines.add(0, "v1\tleft\tright");
        } else if (format == IMappingFile.Format.TINY) {
            lines.add(0, "tiny\t2\t0\tleft\tright");
        } else if (format == IMappingFile.Format.TSRG2) {
            lines.add(0, "tsrg2 left right");
        }
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (String line : lines) {
                writer.write(line);
                writer.write(10);
            }
        }
    }

    @Override
    public MappingFile reverse() {
        MappingFile ret = new MappingFile();
        this.getPackages().stream().forEach(pkg -> ret.addPackage(pkg.getMapped(), pkg.getOriginal(), pkg.getMetadata()));
        this.getClasses().stream().forEach(cls -> {
            Cls c = ret.addClass(cls.getMapped(), cls.getOriginal(), cls.getMetadata());
            cls.getFields().stream().forEach(fld -> c.addField(fld.getMapped(), fld.getOriginal(), fld.getMappedDescriptor(), fld.getMetadata()));
            cls.getMethods().stream().forEach(mtd -> {
                Cls.Method m = c.addMethod(mtd.getMapped(), mtd.getMappedDescriptor(), mtd.getOriginal(), mtd.getMetadata());
                mtd.getParameters().stream().forEach(par -> m.addParameter(par.getIndex(), par.getMapped(), par.getOriginal(), par.getMetadata()));
            });
        });
        return ret;
    }

    @Override
    public MappingFile rename(IRenamer renamer) {
        MappingFile ret = new MappingFile();
        this.getPackages().stream().forEach(pkg -> ret.addPackage(pkg.getOriginal(), renamer.rename((IMappingFile.IPackage)pkg), pkg.getMetadata()));
        this.getClasses().stream().forEach(cls -> {
            Cls c = ret.addClass(cls.getOriginal(), renamer.rename((IMappingFile.IClass)cls), cls.getMetadata());
            cls.getFields().stream().forEach(fld -> c.addField(fld.getOriginal(), renamer.rename((IMappingFile.IField)fld), fld.getDescriptor(), fld.getMetadata()));
            cls.getMethods().stream().forEach(mtd -> {
                Cls.Method m = c.addMethod(mtd.getOriginal(), mtd.getDescriptor(), renamer.rename((IMappingFile.IMethod)mtd), mtd.getMetadata());
                mtd.getParameters().stream().forEach(par -> m.addParameter(par.getIndex(), par.getOriginal(), renamer.rename((IMappingFile.IParameter)par), par.getMetadata()));
            });
        });
        return ret;
    }

    @Override
    public MappingFile chain(final IMappingFile link) {
        return this.rename(new IRenamer(){

            @Override
            public String rename(IMappingFile.IPackage value) {
                return link.remapPackage(value.getMapped());
            }

            @Override
            public String rename(IMappingFile.IClass value) {
                return link.remapClass(value.getMapped());
            }

            @Override
            public String rename(IMappingFile.IField value) {
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)value.getParent()).getMapped());
                return cls == null ? value.getMapped() : cls.remapField(value.getMapped());
            }

            @Override
            public String rename(IMappingFile.IMethod value) {
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)value.getParent()).getMapped());
                return cls == null ? value.getMapped() : cls.remapMethod(value.getMapped(), value.getMappedDescriptor());
            }

            @Override
            public String rename(IMappingFile.IParameter value) {
                IMappingFile.IMethod mtd = (IMappingFile.IMethod)value.getParent();
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)mtd.getParent()).getMapped());
                mtd = cls == null ? null : cls.getMethod(mtd.getMapped(), mtd.getMappedDescriptor());
                return mtd == null ? value.getMapped() : mtd.remapParameter(value.getIndex(), value.getMapped());
            }
        });
    }

    private static <K, V> V retPut(Map<K, V> map, K key, V value) {
        map.put(key, value);
        return value;
    }

    class Cls
    extends Node
    implements IMappingFile.IClass {
        private Map<String, Field> fields;
        private Collection<Field> fieldsView;
        private Map<String, Method> methods;
        private Collection<Method> methodsView;

        protected Cls(String original, String mapped, Map<String, String> metadata) {
            super(original, mapped, metadata);
            this.fields = new HashMap<String, Field>();
            this.fieldsView = Collections.unmodifiableCollection(this.fields.values());
            this.methods = new HashMap<String, Method>();
            this.methodsView = Collections.unmodifiableCollection(this.methods.values());
        }

        @Override
        @Nullable
        public String write(IMappingFile.Format format, boolean reversed) {
            String oName = !reversed ? this.getOriginal() : this.getMapped();
            String mName = !reversed ? this.getMapped() : this.getOriginal();
            switch (format) {
                case SRG: 
                case XSRG: {
                    return "CL: " + oName + ' ' + mName;
                }
                case CSRG: 
                case TSRG: 
                case TSRG2: {
                    return oName + ' ' + mName;
                }
                case PG: {
                    return oName.replace('/', '.') + " -> " + mName.replace('/', '.') + ':';
                }
                case TINY1: {
                    return "CLASS\t" + oName + '\t' + mName;
                }
                case TINY: {
                    return "c\t" + oName + '\t' + mName;
                }
            }
            throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
        }

        public Collection<Field> getFields() {
            return this.fieldsView;
        }

        @Override
        @Nullable
        public IMappingFile.IField getField(String name) {
            return this.fields.get(name);
        }

        @Override
        public String remapField(String field) {
            Field fld = this.fields.get(field);
            return fld == null ? field : fld.getMapped();
        }

        private Field addField(String original, String mapped, String desc, Map<String, String> metadata) {
            return (Field)MappingFile.retPut(this.fields, original, new Field(original, mapped, desc, metadata));
        }

        public Collection<Method> getMethods() {
            return this.methodsView;
        }

        @Override
        @Nullable
        public IMappingFile.IMethod getMethod(String name, String desc) {
            return this.methods.get(name + desc);
        }

        private Method addMethod(String original, String desc, String mapped, Map<String, String> metadata) {
            return (Method)MappingFile.retPut(this.methods, original + desc, new Method(original, desc, mapped, metadata));
        }

        @Override
        public String remapMethod(String name, String desc) {
            Method mtd = this.methods.get(name + desc);
            return mtd == null ? name : mtd.getMapped();
        }

        public String toString() {
            return this.write(IMappingFile.Format.SRG, false);
        }

        class Method
        extends Node
        implements IMappingFile.IMethod {
            private final String desc;
            private final Map<Integer, Parameter> params;
            private final Collection<Parameter> paramsView;

            private Method(String original, String desc, String mapped, Map<String, String> metadata) {
                super(original, mapped, metadata);
                this.params = new HashMap<Integer, Parameter>();
                this.paramsView = Collections.unmodifiableCollection(this.params.values());
                this.desc = desc;
            }

            @Override
            public String getDescriptor() {
                return this.desc;
            }

            @Override
            public String getMappedDescriptor() {
                return MappingFile.this.remapDescriptor(this.desc);
            }

            public Collection<Parameter> getParameters() {
                return this.paramsView;
            }

            private Parameter addParameter(int index, String original, String mapped, Map<String, String> metadata) {
                return (Parameter)MappingFile.retPut(this.params, index, new Parameter(index, original, mapped, metadata));
            }

            @Override
            public String remapParameter(int index, String name) {
                Parameter param = this.params.get(index);
                return param == null ? name : param.getMapped();
            }

            @Override
            public String write(IMappingFile.Format format, boolean reversed) {
                String oName = !reversed ? this.getOriginal() : this.getMapped();
                String mName = !reversed ? this.getMapped() : this.getOriginal();
                String oOwner = !reversed ? Cls.this.getOriginal() : Cls.this.getMapped();
                String mOwner = !reversed ? Cls.this.getMapped() : Cls.this.getOriginal();
                String oDesc = !reversed ? this.getDescriptor() : this.getMappedDescriptor();
                String mDesc = !reversed ? this.getMappedDescriptor() : this.getDescriptor();
                switch (format) {
                    case SRG: 
                    case XSRG: {
                        return "MD: " + oOwner + '/' + oName + ' ' + oDesc + ' ' + mOwner + '/' + mName + ' ' + mDesc;
                    }
                    case CSRG: {
                        return oOwner + ' ' + oName + ' ' + oDesc + ' ' + mName;
                    }
                    case TSRG: 
                    case TSRG2: {
                        return '\t' + oName + ' ' + oDesc + ' ' + mName;
                    }
                    case TINY1: {
                        return "METHOD\t" + oOwner + '\t' + oDesc + '\t' + oName + '\t' + mName;
                    }
                    case TINY: {
                        return "\tm\t" + oDesc + '\t' + oName + '\t' + mName;
                    }
                    case PG: {
                        int start = Integer.parseInt(this.getMetadata().getOrDefault("start_line", "0"));
                        int end = Integer.parseInt(this.getMetadata().getOrDefault("end_line", "0"));
                        return "    " + (start == 0 && end == 0 ? "" : start + ":" + end + ":") + InternalUtils.toSource(oName, oDesc) + " -> " + mName;
                    }
                }
                throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
            }

            public String toString() {
                return this.write(IMappingFile.Format.SRG, false);
            }

            @Override
            public Cls getParent() {
                return Cls.this;
            }

            class Parameter
            extends Node
            implements IMappingFile.IParameter {
                private final int index;

                protected Parameter(int index, String original, String mapped, Map<String, String> metadata) {
                    super(original, mapped, metadata);
                    this.index = index;
                }

                @Override
                public IMappingFile.IMethod getParent() {
                    return Method.this;
                }

                @Override
                public int getIndex() {
                    return this.index;
                }

                @Override
                public String write(IMappingFile.Format format, boolean reversed) {
                    String oName = !reversed ? this.getOriginal() : this.getMapped();
                    String mName = !reversed ? this.getMapped() : this.getOriginal();
                    switch (format) {
                        case SRG: 
                        case XSRG: 
                        case CSRG: 
                        case TSRG: 
                        case PG: 
                        case TINY1: {
                            return null;
                        }
                        case TINY: {
                            return "\t\tp\t" + this.getIndex() + '\t' + oName + '\t' + mName;
                        }
                        case TSRG2: {
                            return "\t\t" + this.getIndex() + ' ' + oName + ' ' + mName;
                        }
                    }
                    throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
                }
            }
        }

        class Field
        extends Node
        implements IMappingFile.IField {
            private String desc;

            private Field(String original, String mapped, String desc, Map<String, String> metadata) {
                super(original, mapped, metadata);
                this.desc = desc;
            }

            @Override
            public String getDescriptor() {
                return this.desc;
            }

            @Override
            public String getMappedDescriptor() {
                return this.desc == null ? null : MappingFile.this.remapDescriptor(this.desc);
            }

            @Override
            @Nullable
            public String write(IMappingFile.Format format, boolean reversed) {
                if (format != IMappingFile.Format.TSRG2 && format.hasFieldTypes() && this.desc == null) {
                    throw new IllegalStateException("Can not write " + format.name() + " format, field is missing descriptor");
                }
                String oOwner = !reversed ? Cls.this.getOriginal() : Cls.this.getMapped();
                String mOwner = !reversed ? Cls.this.getMapped() : Cls.this.getOriginal();
                String oName = !reversed ? this.getOriginal() : this.getMapped();
                String mName = !reversed ? this.getMapped() : this.getOriginal();
                String oDesc = !reversed ? this.getDescriptor() : this.getMappedDescriptor();
                String mDesc = !reversed ? this.getMappedDescriptor() : this.getDescriptor();
                switch (format) {
                    case SRG: {
                        return "FD: " + oOwner + '/' + oName + ' ' + mOwner + '/' + mName + (oDesc == null ? "" : " # " + oDesc + " " + mDesc);
                    }
                    case XSRG: {
                        return "FD: " + oOwner + '/' + oName + (oDesc == null ? "" : ' ' + oDesc) + ' ' + mOwner + '/' + mName + (mDesc == null ? "" : ' ' + mDesc);
                    }
                    case CSRG: {
                        return oOwner + ' ' + oName + ' ' + mName;
                    }
                    case TSRG: {
                        return '\t' + oName + ' ' + mName;
                    }
                    case TSRG2: {
                        return '\t' + oName + (oDesc == null ? "" : ' ' + oDesc) + ' ' + mName;
                    }
                    case PG: {
                        return "    " + InternalUtils.toSource(oDesc) + ' ' + oName + " -> " + mName;
                    }
                    case TINY1: {
                        return "FIELD\t" + oOwner + '\t' + oDesc + '\t' + oName + '\t' + mName;
                    }
                    case TINY: {
                        return "\tf\t" + oDesc + '\t' + oName + '\t' + mName;
                    }
                }
                throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
            }

            public String toString() {
                return this.write(IMappingFile.Format.SRG, false);
            }

            @Override
            public Cls getParent() {
                return Cls.this;
            }
        }
    }

    class Package
    extends Node
    implements IMappingFile.IPackage {
        protected Package(String original, String mapped, Map<String, String> metadata) {
            super(original, mapped, metadata);
        }

        @Override
        @Nullable
        public String write(IMappingFile.Format format, boolean reversed) {
            String smap;
            String sorig = this.getOriginal().isEmpty() ? "." : this.getOriginal();
            String string = smap = this.getMapped().isEmpty() ? "." : this.getMapped();
            if (reversed) {
                String tmp = sorig;
                sorig = smap;
                smap = tmp;
            }
            switch (format) {
                case SRG: 
                case XSRG: {
                    return "PK: " + sorig + ' ' + smap;
                }
                case CSRG: 
                case TSRG: 
                case TSRG2: {
                    return this.getOriginal() + "/ " + this.getMapped() + '/';
                }
                case PG: 
                case TINY1: {
                    return null;
                }
            }
            throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
        }

        public String toString() {
            return this.write(IMappingFile.Format.SRG, false);
        }
    }

    abstract class Node
    implements IMappingFile.INode {
        private final String original;
        private final String mapped;
        private final Map<String, String> metadata;

        protected Node(String original, String mapped, Map<String, String> metadata) {
            this.original = original;
            this.mapped = mapped;
            this.metadata = metadata.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(metadata);
        }

        @Override
        public String getOriginal() {
            return this.original;
        }

        @Override
        public String getMapped() {
            return this.mapped;
        }

        @Override
        public Map<String, String> getMetadata() {
            return this.metadata;
        }
    }
}

