/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.generators.loaders;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.SeparatePerspectiveModel;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class SeparatePerspectiveModelBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private T base;
    private final Map<String, T> childModels = new LinkedHashMap<String, T>();

    public static <T extends ModelBuilder<T>> SeparatePerspectiveModelBuilder<T> begin(T parent, ExistingFileHelper existingFileHelper) {
        return new SeparatePerspectiveModelBuilder<T>(parent, existingFileHelper);
    }

    protected SeparatePerspectiveModelBuilder(T parent, ExistingFileHelper existingFileHelper) {
        super(new ResourceLocation("forge:separate-perspective"), parent, existingFileHelper);
    }

    public SeparatePerspectiveModelBuilder<T> base(T modelBuilder) {
        Preconditions.checkNotNull(modelBuilder, (Object)"modelBuilder must not be null");
        this.base = modelBuilder;
        return this;
    }

    public SeparatePerspectiveModelBuilder<T> perspective(ItemTransforms.TransformType perspective, T modelBuilder) {
        Preconditions.checkNotNull((Object)perspective, (Object)"layer must not be null");
        Preconditions.checkArgument((boolean)SeparatePerspectiveModel.Loader.PERSPECTIVES.containsValue((Object)perspective), (Object)"perspective is not included in SeparatePerspectiveModel. New mc version?");
        Preconditions.checkNotNull(modelBuilder, (Object)"modelBuilder must not be null");
        this.childModels.put((String)SeparatePerspectiveModel.Loader.PERSPECTIVES.inverse().get((Object)perspective), modelBuilder);
        return this;
    }

    @Override
    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        if (this.base != null) {
            json.add("base", (JsonElement)((ModelBuilder)this.base).toJson());
        }
        JsonObject parts = new JsonObject();
        for (Map.Entry<String, T> entry : this.childModels.entrySet()) {
            parts.add(entry.getKey(), (JsonElement)((ModelBuilder)entry.getValue()).toJson());
        }
        json.add("perspectives", (JsonElement)parts);
        return json;
    }
}

