/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.renderable;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.renderable.IRenderable;
import net.minecraftforge.client.model.renderable.MultipartTransforms;

public class SimpleRenderable
implements IRenderable<MultipartTransforms> {
    private final List<Part> parts = new ArrayList<Part>();

    private SimpleRenderable() {
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource bufferSource, Function<ResourceLocation, RenderType> renderTypeFunction, int lightmapCoord, int overlayCoord, float partialTicks, MultipartTransforms renderValues) {
        for (Part part : this.parts) {
            part.render(poseStack, bufferSource, renderTypeFunction, lightmapCoord, overlayCoord, renderValues);
        }
    }

    public static class Builder {
        private final SimpleRenderable renderable = new SimpleRenderable();

        private Builder() {
        }

        public PartBuilder<Builder> child(String name) {
            Part child = new Part(name);
            this.renderable.parts.add(child);
            return new PartBuilder<Builder>(this, child);
        }

        public SimpleRenderable get() {
            return this.renderable;
        }
    }

    private static class Part {
        private final String name;
        private final List<Part> parts = new ArrayList<Part>();
        private final List<Mesh> meshes = new ArrayList<Mesh>();

        public Part(String name) {
            this.name = name;
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferSource, Function<ResourceLocation, RenderType> renderTypeFunction, int lightmapCoord, int overlayCoord, MultipartTransforms renderValues) {
            Matrix4f matrix = renderValues.getPartValues(this.name);
            if (matrix != null) {
                poseStack.m_85836_();
                poseStack.m_166854_(matrix);
            }
            for (Part part : this.parts) {
                part.render(poseStack, bufferSource, renderTypeFunction, lightmapCoord, overlayCoord, renderValues);
            }
            for (Mesh mesh : this.meshes) {
                mesh.render(poseStack, bufferSource, renderTypeFunction, lightmapCoord, overlayCoord, renderValues);
            }
            if (matrix != null) {
                poseStack.m_85849_();
            }
        }
    }

    public static class PartBuilder<T> {
        private final T parent;
        private final Part part;

        private PartBuilder(T parent, Part part) {
            this.parent = parent;
            this.part = part;
        }

        public PartBuilder<PartBuilder<T>> child(String name) {
            Part child = new Part(this.part.name + "/" + name);
            this.part.parts.add(child);
            return new PartBuilder<PartBuilder<T>>(this, child);
        }

        public PartBuilder<T> addMesh(ResourceLocation texture, List<BakedQuad> quads) {
            Mesh mesh = new Mesh(texture);
            mesh.quads.addAll(quads);
            this.part.meshes.add(mesh);
            return this;
        }

        public T end() {
            return this.parent;
        }
    }

    private static class Mesh {
        private final ResourceLocation texture;
        private final List<BakedQuad> quads = new ArrayList<BakedQuad>();

        public Mesh(ResourceLocation texture) {
            this.texture = texture;
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferSource, Function<ResourceLocation, RenderType> renderTypeFunction, int lightmapCoord, int overlayCoord, MultipartTransforms renderValues) {
            VertexConsumer consumer = bufferSource.m_6299_(renderTypeFunction.apply(this.texture));
            for (BakedQuad quad : this.quads) {
                consumer.putBulkData(poseStack.m_85850_(), quad, 1.0f, 1.0f, 1.0f, 1.0f, lightmapCoord, overlayCoord, true);
            }
        }
    }
}

