/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Lifecycle;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.StaticTagHelper;
import net.minecraft.tags.StaticTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagContainer;
import net.minecraft.tags.TagLoader;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeTagHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Set<ResourceLocation> customTagTypeNames = Collections.emptySet();
    private static boolean tagTypesSet = false;

    @Nullable
    private static <T extends IForgeRegistryEntry<T>> StaticTagHelper<T> getTagHelper(IForgeRegistry<T> registry) {
        return StaticTags.get((ResourceLocation)registry.getRegistryName());
    }

    private static void validateRegistrySupportsTags(IForgeRegistry<?> registry) {
        if (!(ForgeTagHandler.getTagHelper(registry) != null || registry instanceof ForgeRegistry && ((ForgeRegistry)registry).getTagFolder() != null)) {
            throw new IllegalArgumentException("Registry " + registry.getRegistryName() + " does not support tag types.");
        }
    }

    public static <T extends IForgeRegistryEntry<T>> Tag.Named<T> makeWrapperTag(IForgeRegistry<T> registry, ResourceLocation name) {
        ForgeTagHandler.validateRegistrySupportsTags(registry);
        if (tagTypesSet) {
            StaticTagHelper<T> tagRegistry = ForgeTagHandler.getTagHelper(registry);
            if (tagRegistry == null) {
                throw new IllegalArgumentException("Registry " + registry.getRegistryName() + " does not support tag types.");
            }
            return tagRegistry.m_13244_(name.toString());
        }
        return StaticTagHelper.createDelayedTag((ResourceLocation)registry.getRegistryName(), (ResourceLocation)name);
    }

    public static <T extends IForgeRegistryEntry<T>> Tags.IOptionalNamedTag<T> createOptionalTag(IForgeRegistry<T> registry, ResourceLocation name) {
        return ForgeTagHandler.createOptionalTag(registry, name, null);
    }

    public static <T extends IForgeRegistryEntry<T>> Tags.IOptionalNamedTag<T> createOptionalTag(IForgeRegistry<T> registry, ResourceLocation name, @Nullable Set<Supplier<T>> defaults) {
        ForgeTagHandler.validateRegistrySupportsTags(registry);
        if (tagTypesSet) {
            StaticTagHelper<T> tagRegistry = ForgeTagHandler.getTagHelper(registry);
            if (tagRegistry == null) {
                throw new IllegalArgumentException("Registry " + registry.getRegistryName() + " does not support tag types.");
            }
            return tagRegistry.createOptional(name, defaults);
        }
        return StaticTagHelper.createDelayedOptional((ResourceLocation)registry.getRegistryName(), (ResourceLocation)name, defaults);
    }

    public static <T extends IForgeRegistryEntry<T>> Tag.Named<T> makeWrapperTag(ResourceLocation registryName, ResourceLocation name) {
        if (tagTypesSet) {
            ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(registryName);
            if (registry == null) {
                throw new IllegalArgumentException("Could not find registry named: " + registryName);
            }
            return ForgeTagHandler.makeWrapperTag(registry, name);
        }
        return StaticTagHelper.createDelayedTag((ResourceLocation)registryName, (ResourceLocation)name);
    }

    public static <T extends IForgeRegistryEntry<T>> Tags.IOptionalNamedTag<T> createOptionalTag(ResourceLocation registryName, ResourceLocation name) {
        return ForgeTagHandler.createOptionalTag(registryName, name, null);
    }

    public static <T extends IForgeRegistryEntry<T>> Tags.IOptionalNamedTag<T> createOptionalTag(ResourceLocation registryName, ResourceLocation name, @Nullable Set<Supplier<T>> defaults) {
        if (tagTypesSet) {
            ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(registryName);
            if (registry == null) {
                throw new IllegalArgumentException("Could not find registry named: " + registryName);
            }
            return ForgeTagHandler.createOptionalTag(registry, name, defaults);
        }
        return StaticTagHelper.createDelayedOptional((ResourceLocation)registryName, (ResourceLocation)name, defaults);
    }

    public static Set<ResourceLocation> getCustomTagTypeNames() {
        return customTagTypeNames;
    }

    public static void setCustomTagTypes(Set<ResourceLocation> customTagTypesNames) {
        if (tagTypesSet) {
            throw new RuntimeException("Custom tag types have already been set, this method should only be called by forge, and after registries are initialized");
        }
        tagTypesSet = true;
        customTagTypeNames = ImmutableSet.copyOf(customTagTypesNames);
        StaticTagHelper.performDelayedAdd();
    }

    public static Map<ResourceLocation, TagLoader<?>> createCustomTagTypeReaders() {
        LOGGER.debug("Gathering custom tag collection reader from types.");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ResourceLocation registryName : customTagTypeNames) {
            ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(registryName);
            if (registry == null || registry.getTagFolder() == null) continue;
            builder.put((Object)registryName, (Object)new TagLoader(rl -> Optional.ofNullable(registry.getValue((ResourceLocation)rl)), "tags/" + registry.getTagFolder()));
        }
        return builder.build();
    }

    public static <T> Optional<? extends Registry<T>> getWrapperRegistry(ResourceKey<? extends Registry<T>> key, Optional<? extends Registry<T>> vanillaReg) {
        if (vanillaReg.isPresent()) {
            return vanillaReg;
        }
        ForgeRegistry reg = RegistryManager.ACTIVE.getRegistry(key.m_135782_());
        if (reg == null || reg.getTagFolder() == null) {
            return Optional.empty();
        }
        if (reg.getDefaultKey() == null) {
            return Optional.of(GameData.getWrapper(reg.getRegistryKey(), Lifecycle.stable()));
        }
        return Optional.of(GameData.getWrapper(reg.getRegistryKey(), Lifecycle.stable(), "ignored"));
    }

    public static TagContainer reinjectOptionalTags(TagContainer tagCollectionSupplier) {
        TagContainer.Builder builder = new TagContainer.Builder();
        StaticTags.m_144349_(h -> builder.m_144486_(h.m_144338_(), h.reinjectOptionalTags(tagCollectionSupplier.m_144452_(h.m_144338_()))));
        return builder.m_144485_();
    }
}

