/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public final class ForgeRecipeProvider
extends RecipeProvider {
    private Map<Item, Tag<Item>> replacements = new HashMap<Item, Tag<Item>>();
    private Set<ResourceLocation> excludes = new HashSet<ResourceLocation>();

    public ForgeRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    private void exclude(ItemLike item) {
        this.excludes.add(item.m_5456_().getRegistryName());
    }

    private void replace(ItemLike item, Tag<Item> tag) {
        this.replacements.put(item.m_5456_(), tag);
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        this.replace((ItemLike)Items.f_42398_, (Tag<Item>)Tags.Items.RODS_WOODEN);
        this.replace((ItemLike)Items.f_42417_, (Tag<Item>)Tags.Items.INGOTS_GOLD);
        this.replace((ItemLike)Items.f_42416_, (Tag<Item>)Tags.Items.INGOTS_IRON);
        this.replace((ItemLike)Items.f_42418_, (Tag<Item>)Tags.Items.INGOTS_NETHERITE);
        this.replace((ItemLike)Items.f_151052_, (Tag<Item>)Tags.Items.INGOTS_COPPER);
        this.replace((ItemLike)Items.f_151049_, (Tag<Item>)Tags.Items.GEMS_AMETHYST);
        this.replace((ItemLike)Items.f_42415_, (Tag<Item>)Tags.Items.GEMS_DIAMOND);
        this.replace((ItemLike)Items.f_42616_, (Tag<Item>)Tags.Items.GEMS_EMERALD);
        this.replace((ItemLike)Items.f_42009_, (Tag<Item>)Tags.Items.CHESTS_WOODEN);
        this.replace((ItemLike)Blocks.f_50652_, (Tag<Item>)Tags.Items.COBBLESTONE_NORMAL);
        this.replace((ItemLike)Blocks.f_152551_, (Tag<Item>)Tags.Items.COBBLESTONE_DEEPSLATE);
        this.exclude((ItemLike)Blocks.f_50074_);
        this.exclude((ItemLike)Items.f_42587_);
        this.exclude((ItemLike)Blocks.f_50075_);
        this.exclude((ItemLike)Items.f_42749_);
        this.exclude((ItemLike)Blocks.f_50090_);
        this.exclude((ItemLike)Blocks.f_50268_);
        this.exclude((ItemLike)Blocks.f_50721_);
        this.exclude((ItemLike)Blocks.f_152504_);
        this.exclude((ItemLike)Blocks.f_152490_);
        this.exclude((ItemLike)Blocks.f_50157_);
        this.exclude((ItemLike)Blocks.f_50409_);
        this.exclude((ItemLike)Blocks.f_50274_);
        this.exclude((ItemLike)Blocks.f_152552_);
        this.exclude((ItemLike)Blocks.f_152553_);
        this.exclude((ItemLike)Blocks.f_152554_);
        super.m_176531_(vanilla -> {
            FinishedRecipe modified = this.enhance((FinishedRecipe)vanilla);
            if (modified != null) {
                consumer.accept(modified);
            }
        });
    }

    protected void m_126013_(HashCache cache, JsonObject advancementJson, Path pathIn) {
    }

    private FinishedRecipe enhance(FinishedRecipe vanilla) {
        if (vanilla instanceof ShapelessRecipeBuilder.Result) {
            return this.enhance((ShapelessRecipeBuilder.Result)vanilla);
        }
        if (vanilla instanceof ShapedRecipeBuilder.Result) {
            return this.enhance((ShapedRecipeBuilder.Result)vanilla);
        }
        return null;
    }

    private FinishedRecipe enhance(ShapelessRecipeBuilder.Result vanilla) {
        List ingredients = (List)this.getField(ShapelessRecipeBuilder.Result.class, vanilla, 4);
        boolean modified = false;
        for (int x = 0; x < ingredients.size(); ++x) {
            Ingredient ing = this.enhance(vanilla.m_6445_(), (Ingredient)ingredients.get(x));
            if (ing == null) continue;
            ingredients.set(x, ing);
            modified = true;
        }
        return modified ? vanilla : null;
    }

    private FinishedRecipe enhance(ShapedRecipeBuilder.Result vanilla) {
        Map ingredients = (Map)this.getField(ShapedRecipeBuilder.Result.class, vanilla, 5);
        boolean modified = false;
        for (Character x : ingredients.keySet()) {
            Ingredient ing = this.enhance(vanilla.m_6445_(), (Ingredient)ingredients.get(x));
            if (ing == null) continue;
            ingredients.put(x, ing);
            modified = true;
        }
        return modified ? vanilla : null;
    }

    private Ingredient enhance(ResourceLocation name, Ingredient vanilla) {
        Ingredient.Value[] vanillaItems;
        if (this.excludes.contains(name)) {
            return null;
        }
        boolean modified = false;
        ArrayList<Object> items = new ArrayList<Object>();
        for (Ingredient.Value entry : vanillaItems = (Ingredient.Value[])this.getField(Ingredient.class, vanilla, 2)) {
            if (entry instanceof Ingredient.ItemValue) {
                ItemStack stack = entry.m_6223_().stream().findFirst().orElse(ItemStack.f_41583_);
                Tag<Item> replacement = this.replacements.get(stack.m_41720_());
                if (replacement != null) {
                    items.add(new Ingredient.TagValue(replacement));
                    modified = true;
                    continue;
                }
                items.add(entry);
                continue;
            }
            items.add(entry);
        }
        return modified ? Ingredient.m_43938_(items.stream()) : null;
    }

    private <T, R> R getField(Class<T> clz, T inst, int index) {
        Field fld = clz.getDeclaredFields()[index];
        fld.setAccessible(true);
        try {
            return (R)fld.get(inst);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }
}

