/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity;

import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.eventbus.api.Event;

public class EntityEvent
extends Event {
    private final Entity entity;

    public EntityEvent(Entity entity) {
        this.entity = entity;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public static class Size
    extends EntityEvent {
        private final Pose pose;
        private final EntityDimensions oldSize;
        private EntityDimensions newSize;
        private final float oldEyeHeight;
        private float newEyeHeight;

        public Size(Entity entity, Pose pose, EntityDimensions size, float defaultEyeHeight) {
            this(entity, pose, size, size, defaultEyeHeight, defaultEyeHeight);
        }

        public Size(Entity entity, Pose pose, EntityDimensions oldSize, EntityDimensions newSize, float oldEyeHeight, float newEyeHeight) {
            super(entity);
            this.pose = pose;
            this.oldSize = oldSize;
            this.newSize = newSize;
            this.oldEyeHeight = oldEyeHeight;
            this.newEyeHeight = newEyeHeight;
        }

        public Pose getPose() {
            return this.pose;
        }

        public EntityDimensions getOldSize() {
            return this.oldSize;
        }

        public EntityDimensions getNewSize() {
            return this.newSize;
        }

        public void setNewSize(EntityDimensions size) {
            this.setNewSize(size, false);
        }

        public void setNewSize(EntityDimensions size, boolean updateEyeHeight) {
            this.newSize = size;
            if (updateEyeHeight) {
                this.newEyeHeight = this.getEntity().getEyeHeightAccess(this.getPose(), this.newSize);
            }
        }

        public float getOldEyeHeight() {
            return this.oldEyeHeight;
        }

        public float getNewEyeHeight() {
            return this.newEyeHeight;
        }

        public void setNewEyeHeight(float newHeight) {
            this.newEyeHeight = newHeight;
        }
    }

    public static class EnteringSection
    extends EntityEvent {
        private final long packedOldPos;
        private final long packedNewPos;

        public EnteringSection(Entity entity, long packedOldPos, long packedNewPos) {
            super(entity);
            this.packedOldPos = packedOldPos;
            this.packedNewPos = packedNewPos;
        }

        public long getPackedOldPos() {
            return this.packedOldPos;
        }

        public long getPackedNewPos() {
            return this.packedNewPos;
        }

        public SectionPos getOldPos() {
            return SectionPos.m_123184_((long)this.packedOldPos);
        }

        public SectionPos getNewPos() {
            return SectionPos.m_123184_((long)this.packedNewPos);
        }

        public boolean didChunkChange() {
            return SectionPos.m_123213_((long)this.packedOldPos) != SectionPos.m_123213_((long)this.packedNewPos) || SectionPos.m_123230_((long)this.packedOldPos) != SectionPos.m_123230_((long)this.packedNewPos);
        }
    }

    public static class CanUpdate
    extends EntityEvent {
        private boolean canUpdate = false;

        public CanUpdate(Entity entity) {
            super(entity);
        }

        public boolean getCanUpdate() {
            return this.canUpdate;
        }

        public void setCanUpdate(boolean canUpdate) {
            this.canUpdate = canUpdate;
        }
    }

    public static class EntityConstructing
    extends EntityEvent {
        public EntityConstructing(Entity entity) {
            super(entity);
        }
    }
}

