/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network.filters;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.RootCommandNode;
import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCommandsPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateTagsPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagCollection;
import net.minecraftforge.common.ForgeTagHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.filters.CommandTreeCleaner;
import net.minecraftforge.network.filters.VanillaPacketFilter;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ChannelHandler.Sharable
public class VanillaConnectionNetworkFilter
extends VanillaPacketFilter {
    private static final Logger LOGGER = LogManager.getLogger();

    public VanillaConnectionNetworkFilter() {
        super((Map<Class<? extends Packet<?>>, BiConsumer<Packet<?>, List<? super Packet<?>>>>)ImmutableMap.builder().put(VanillaConnectionNetworkFilter.handler(ClientboundUpdateAttributesPacket.class, VanillaConnectionNetworkFilter::filterEntityProperties)).put(VanillaConnectionNetworkFilter.handler(ClientboundCommandsPacket.class, VanillaConnectionNetworkFilter::filterCommandList)).put(VanillaConnectionNetworkFilter.handler(ClientboundUpdateTagsPacket.class, VanillaConnectionNetworkFilter::filterCustomTagTypes)).build());
    }

    @Override
    protected boolean isNecessary(Connection manager) {
        return NetworkHooks.isVanillaConnection(manager);
    }

    @Nonnull
    private static ClientboundUpdateAttributesPacket filterEntityProperties(ClientboundUpdateAttributesPacket msg) {
        ClientboundUpdateAttributesPacket newPacket = new ClientboundUpdateAttributesPacket(msg.m_133588_(), Collections.emptyList());
        msg.m_133591_().stream().filter(snapshot -> {
            ResourceLocation key = ForgeRegistries.ATTRIBUTES.getKey(snapshot.m_133601_());
            return key != null && key.m_135827_().equals("minecraft");
        }).forEach(snapshot -> newPacket.m_133591_().add(snapshot));
        return newPacket;
    }

    @Nonnull
    private static ClientboundCommandsPacket filterCommandList(ClientboundCommandsPacket packet) {
        RootCommandNode root = packet.m_131884_();
        RootCommandNode newRoot = CommandTreeCleaner.cleanArgumentTypes(root, argType -> {
            ResourceLocation id = ArgumentTypes.getId((ArgumentType)argType);
            return id != null && (id.m_135827_().equals("minecraft") || id.m_135827_().equals("brigadier"));
        });
        return new ClientboundCommandsPacket(newRoot);
    }

    private static ClientboundUpdateTagsPacket filterCustomTagTypes(ClientboundUpdateTagsPacket packet) {
        Map<ResourceKey, TagCollection.NetworkPayload> tags = packet.m_179482_().entrySet().stream().filter(e -> !ForgeTagHandler.getCustomTagTypeNames().contains(((ResourceKey)e.getKey()).m_135782_())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new ClientboundUpdateTagsPacket(tags);
    }
}

