/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolderRegistry;
import net.minecraftforge.registries.RegistryManager;

public final class RegistryObject<T extends IForgeRegistryEntry<? super T>>
implements Supplier<T> {
    private final ResourceLocation name;
    @Nullable
    private T value;
    private static RegistryObject<?> EMPTY = new RegistryObject();

    public static <T extends IForgeRegistryEntry<T>, U extends T> RegistryObject<U> of(ResourceLocation name, Supplier<Class<? super T>> registryType) {
        return new RegistryObject<T>(name, registryType);
    }

    public static <T extends IForgeRegistryEntry<T>, U extends T> RegistryObject<U> of(ResourceLocation name, IForgeRegistry<T> registry) {
        return new RegistryObject<T>(name, registry);
    }

    public static <T extends IForgeRegistryEntry<T>, U extends T> RegistryObject<U> of(ResourceLocation name, Class<T> baseType, String modid) {
        return new RegistryObject<T>(name, baseType, modid);
    }

    private static <T extends IForgeRegistryEntry<? super T>> RegistryObject<T> empty() {
        RegistryObject<?> t = EMPTY;
        return t;
    }

    private RegistryObject() {
        this.name = null;
    }

    private <V extends IForgeRegistryEntry<V>> RegistryObject(ResourceLocation name, Supplier<Class<? super V>> registryType) {
        this(name, RegistryManager.ACTIVE.getRegistry(registryType.get()));
    }

    private <V extends IForgeRegistryEntry<V>> RegistryObject(ResourceLocation name, IForgeRegistry<V> registry) {
        if (registry == null) {
            throw new IllegalArgumentException("Invalid registry argument, must not be null");
        }
        this.name = name;
        ObjectHolderRegistry.addHandler(pred -> {
            if (pred.test(registry.getRegistryName())) {
                this.updateReference(registry);
            }
        });
        this.updateReference(registry);
    }

    private <V extends IForgeRegistryEntry<V>> RegistryObject(ResourceLocation name, final Class<V> baseType, final String modid) {
        this.name = name;
        final Throwable callerStack = new Throwable("Calling Site from mod: " + modid);
        ObjectHolderRegistry.addHandler(new Consumer<Predicate<ResourceLocation>>(){
            private IForgeRegistry<V> registry;

            @Override
            public void accept(Predicate<ResourceLocation> pred) {
                if (this.registry == null) {
                    this.registry = RegistryManager.ACTIVE.getRegistry(baseType);
                    if (this.registry == null) {
                        throw new IllegalStateException("Unable to find registry for type " + baseType.getName() + " for mod \"" + modid + "\". Check the 'caused by' to see futher stack.", callerStack);
                    }
                }
                if (pred.test(this.registry.getRegistryName())) {
                    RegistryObject.this.updateReference(this.registry);
                }
            }
        });
        IForgeRegistry<V> registry = RegistryManager.ACTIVE.getRegistry(baseType);
        if (registry != null) {
            this.updateReference(registry);
        }
    }

    @Override
    @Nonnull
    public T get() {
        T ret = this.value;
        Objects.requireNonNull(ret, () -> "Registry Object not present: " + this.name);
        return ret;
    }

    @Deprecated(since="1.18.1")
    public void updateReference(IForgeRegistry<? extends T> registry) {
        this.value = registry.containsKey(this.name) ? registry.getValue(this.getId()) : null;
    }

    public ResourceLocation getId() {
        return this.name;
    }

    public Stream<T> stream() {
        return this.isPresent() ? Stream.of(this.get()) : Stream.of(new IForgeRegistryEntry[0]);
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.get());
        }
    }

    public RegistryObject<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.get()) ? this : RegistryObject.empty();
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.get()));
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Objects.requireNonNull(mapper.apply(this.get()));
    }

    public <U> Supplier<U> lazyMap(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return () -> this.isPresent() ? mapper.apply(this.get()) : null;
    }

    public T orElse(T other) {
        return (T)(this.isPresent() ? this.get() : other);
    }

    public T orElseGet(Supplier<? extends T> other) {
        return (T)(this.isPresent() ? this.get() : (IForgeRegistryEntry)other.get());
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return (T)this.get();
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RegistryObject) {
            return Objects.equals(((RegistryObject)obj).name, this.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }
}

