/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import net.minecraft.CrashReport;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GameTestServer;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.RegistryReadOps;
import net.minecraft.resources.RegistryWriteOps;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.Eula;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerResources;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.progress.LoggerChunkProgressListener;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.gametest.BlockPosValueConverter;
import net.minecraftforge.gametest.ForgeGameTestHooks;
import net.minecraftforge.server.loading.ServerModLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger f_129670_ = LogManager.getLogger();

    @DontObfuscate
    public static void main(String[] p_129699_) {
        SharedConstants.m_142977_();
        OptionParser optionparser = new OptionParser();
        OptionSpecBuilder optionspec = optionparser.accepts("nogui");
        OptionSpecBuilder optionspec1 = optionparser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder optionspec2 = optionparser.accepts("demo");
        OptionSpecBuilder optionspec3 = optionparser.accepts("bonusChest");
        OptionSpecBuilder optionspec4 = optionparser.accepts("forceUpgrade");
        OptionSpecBuilder optionspec5 = optionparser.accepts("eraseCache");
        OptionSpecBuilder optionspec6 = optionparser.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec optionspec7 = optionparser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec optionspec8 = optionparser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec9 = optionparser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec10 = optionparser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec11 = optionparser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec12 = optionparser.accepts("serverId").withRequiredArg();
        OptionSpecBuilder optionspec13 = optionparser.accepts("jfrProfile");
        NonOptionArgumentSpec optionspec14 = optionparser.nonOptions();
        optionparser.accepts("allowUpdates").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)Boolean.TRUE, (Object[])new Boolean[0]);
        optionparser.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]);
        boolean gametestEnabled = Boolean.getBoolean("forge.gameTestServer");
        ArgumentAcceptingOptionSpec spawnPosOpt = gametestEnabled ? optionparser.accepts("spawnPos").withRequiredArg().withValuesConvertedBy((ValueConverter)new BlockPosValueConverter()).defaultsTo((Object)new BlockPos(0, 60, 0), (Object[])new BlockPos[0]) : null;
        try {
            ServerResources serverresources;
            OptionSet optionset = optionparser.parse(p_129699_);
            if (optionset.has((OptionSpec)optionspec7)) {
                optionparser.printHelpOn((OutputStream)System.err);
                return;
            }
            Path path1 = Paths.get("eula.txt", new String[0]);
            Eula eula = new Eula(path1);
            if (!eula.m_135944_()) {
                f_129670_.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            CrashReport.m_127529_();
            if (optionset.has((OptionSpec)optionspec13)) {
                JvmProfiler.f_185340_.m_183425_(Environment.SERVER);
            }
            Bootstrap.m_135870_();
            Bootstrap.m_135889_();
            Util.m_137584_();
            if (!optionset.has((OptionSpec)optionspec1)) {
                ServerModLoader.load();
            }
            Path path = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings dedicatedserversettings = new DedicatedServerSettings(path);
            dedicatedserversettings.m_139780_();
            if (optionset.has((OptionSpec)optionspec1)) {
                f_129670_.info("Initialized '{}' and '{}'", (Object)path.toAbsolutePath(), (Object)path1.toAbsolutePath());
                return;
            }
            File file1 = new File((String)optionset.valueOf((OptionSpec)optionspec9));
            YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(Proxy.NO_PROXY);
            MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
            GameProfileCache gameprofilecache = new GameProfileCache(gameprofilerepository, new File(file1, MinecraftServer.f_129742_.getName()));
            String s = Optional.ofNullable((String)optionset.valueOf((OptionSpec)optionspec10)).orElse(dedicatedserversettings.m_139777_().f_139741_);
            if (s == null || s.isEmpty() || new File(file1, s).getAbsolutePath().equals(new File(s).getAbsolutePath())) {
                f_129670_.error("Invalid world directory specified, must not be null, empty or the same directory as your universe! " + s);
                return;
            }
            LevelStorageSource levelstoragesource = LevelStorageSource.m_78242_(file1.toPath());
            LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = levelstoragesource.m_78260_(s);
            levelstoragesource$levelstorageaccess.readAdditionalLevelSaveData();
            RegistryAccess.RegistryHolder registryaccess$registryholder = RegistryAccess.m_123086_();
            LevelSummary levelsummary = levelstoragesource$levelstorageaccess.m_78308_();
            if (levelsummary != null) {
                if (levelsummary.m_193020_()) {
                    f_129670_.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!levelsummary.m_193021_()) {
                    f_129670_.info("This world was created by an incompatible version.");
                    return;
                }
            }
            DataPackConfig datapackconfig = levelstoragesource$levelstorageaccess.m_78309_();
            boolean flag = optionset.has((OptionSpec)optionspec6);
            if (flag) {
                f_129670_.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            PackRepository packrepository = new PackRepository(PackType.SERVER_DATA, new RepositorySource[]{new ServerPacksSource(), new FolderRepositorySource(levelstoragesource$levelstorageaccess.m_78283_(LevelResource.f_78180_).toFile(), PackSource.f_10529_)});
            DataPackConfig datapackconfig1 = MinecraftServer.m_129819_(packrepository, datapackconfig == null ? DataPackConfig.f_45842_ : datapackconfig, flag);
            CompletableFuture<ServerResources> completablefuture = ServerResources.m_180005_(packrepository.m_10525_(), registryaccess$registryholder, Commands.CommandSelection.DEDICATED, dedicatedserversettings.m_139777_().f_139711_, Util.m_183991_(), Runnable::run);
            try {
                serverresources = completablefuture.get();
            }
            catch (Exception exception) {
                f_129670_.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)exception);
                packrepository.close();
                return;
            }
            serverresources.m_136179_();
            RegistryReadOps registryreadops = RegistryReadOps.m_179866_((DynamicOps)NbtOps.f_128958_, (ResourceManager)serverresources.m_136178_(), (RegistryAccess)registryaccess$registryholder);
            dedicatedserversettings.m_139777_().m_180927_((RegistryAccess)registryaccess$registryholder);
            WorldData worlddata = levelstoragesource$levelstorageaccess.m_78280_((DynamicOps<Tag>)registryreadops, datapackconfig1);
            if (worlddata == null) {
                WorldGenSettings worldgensettings;
                LevelSettings levelsettings;
                if (optionset.has((OptionSpec)optionspec2)) {
                    levelsettings = MinecraftServer.f_129743_;
                    worldgensettings = WorldGenSettings.m_64645_(registryaccess$registryholder);
                } else {
                    DedicatedServerProperties dedicatedserverproperties = dedicatedserversettings.m_139777_();
                    levelsettings = new LevelSettings(dedicatedserverproperties.f_139741_, dedicatedserverproperties.f_139740_, dedicatedserverproperties.f_139752_, dedicatedserverproperties.f_139739_, false, new GameRules(), datapackconfig1);
                    worldgensettings = optionset.has((OptionSpec)optionspec3) ? dedicatedserverproperties.m_180927_((RegistryAccess)registryaccess$registryholder).m_64671_() : dedicatedserverproperties.m_180927_((RegistryAccess)registryaccess$registryholder);
                }
                worldgensettings = (WorldGenSettings)WorldGenSettings.f_64600_.encodeStart((DynamicOps)RegistryWriteOps.m_135767_((DynamicOps)NbtOps.f_128958_, (RegistryAccess)registryaccess$registryholder), (Object)worldgensettings).flatMap(nbt -> WorldGenSettings.f_64600_.parse((DynamicOps)registryreadops, nbt)).getOrThrow(false, errorMsg -> {});
                worlddata = new PrimaryLevelData(levelsettings, worldgensettings, Lifecycle.stable());
            }
            if (optionset.has((OptionSpec)optionspec4)) {
                Main.m_195488_(levelstoragesource$levelstorageaccess, DataFixers.m_14512_(), optionset.has((OptionSpec)optionspec5), () -> true, worlddata.m_5961_());
            }
            levelstoragesource$levelstorageaccess.m_78287_(registryaccess$registryholder, worlddata);
            WorldData worlddata1 = worlddata;
            final MinecraftServer dedicatedserver = MinecraftServer.m_129872_(arg_0 -> Main.lambda$main$3(gametestEnabled, optionset, (OptionSpec)spawnPosOpt, levelstoragesource$levelstorageaccess, packrepository, serverresources, registryaccess$registryholder, worlddata1, dedicatedserversettings, minecraftsessionservice, gameprofilerepository, gameprofilecache, (OptionSpec)optionspec8, (OptionSpec)optionspec11, (OptionSpec)optionspec2, (OptionSpec)optionspec12, (OptionSpec)optionspec, (OptionSpec)optionspec14, arg_0));
            Thread thread = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    if (!(dedicatedserver instanceof GameTestServer)) {
                        dedicatedserver.m_7570_(true);
                    }
                    LogManager.shutdown();
                }
            };
            thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(f_129670_));
            Runtime.getRuntime().addShutdownHook(thread);
        }
        catch (Exception exception1) {
            f_129670_.fatal("Failed to start the minecraft server", (Throwable)exception1);
        }
    }

    private static void m_195488_(LevelStorageSource.LevelStorageAccess p_195489_, DataFixer p_195490_, boolean p_195491_, BooleanSupplier p_195492_, WorldGenSettings p_195493_) {
        f_129670_.info("Forcing world upgrade!");
        WorldUpgrader worldupgrader = new WorldUpgrader(p_195489_, p_195490_, p_195493_, p_195491_);
        Component component = null;
        while (!worldupgrader.m_18829_()) {
            int i;
            Component component1 = worldupgrader.m_18837_();
            if (component != component1) {
                component = component1;
                f_129670_.info(worldupgrader.m_18837_().getString());
            }
            if ((i = worldupgrader.m_18834_()) > 0) {
                int j = worldupgrader.m_18835_() + worldupgrader.m_18836_();
                f_129670_.info("{}% completed ({} / {} chunks)...", (Object)Mth.m_14143_((float)((float)j / (float)i * 100.0f)), (Object)j, (Object)i);
            }
            if (!p_195492_.getAsBoolean()) {
                worldupgrader.m_18820_();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ MinecraftServer lambda$main$3(boolean gametestEnabled, OptionSet optionset, OptionSpec spawnPosOpt, LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess, PackRepository packrepository, ServerResources serverresources, RegistryAccess.RegistryHolder registryaccess$registryholder, WorldData worlddata1, DedicatedServerSettings dedicatedserversettings, MinecraftSessionService minecraftsessionservice, GameProfileRepository gameprofilerepository, GameProfileCache gameprofilecache, OptionSpec optionspec8, OptionSpec optionspec11, OptionSpec optionspec2, OptionSpec optionspec12, OptionSpec optionspec, OptionSpec optionspec14, Thread p_129697_) {
        boolean flag1;
        MinecraftServer dedicatedserver1;
        if (gametestEnabled) {
            ForgeGameTestHooks.registerGametests();
            Collection testBatches = GameTestRunner.m_127724_(GameTestRegistry.m_127658_());
            BlockPos spawnPos = (BlockPos)optionset.valueOf(spawnPosOpt);
            dedicatedserver1 = new GameTestServer(p_129697_, levelstoragesource$levelstorageaccess, packrepository, serverresources, testBatches, spawnPos, registryaccess$registryholder);
        } else {
            dedicatedserver1 = new DedicatedServer(p_129697_, registryaccess$registryholder, levelstoragesource$levelstorageaccess, packrepository, serverresources, worlddata1, dedicatedserversettings, DataFixers.m_14512_(), minecraftsessionservice, gameprofilerepository, gameprofilecache, LoggerChunkProgressListener::new);
        }
        dedicatedserver1.m_129981_((String)optionset.valueOf(optionspec8));
        dedicatedserver1.m_129801_((Integer)optionset.valueOf(optionspec11));
        dedicatedserver1.m_129975_(optionset.has(optionspec2));
        dedicatedserver1.m_129948_((String)optionset.valueOf(optionspec12));
        boolean bl = flag1 = !optionset.has(optionspec) && !optionset.valuesOf(optionspec14).contains("nogui");
        if (dedicatedserver1 instanceof DedicatedServer) {
            DedicatedServer dedicatedServer = (DedicatedServer)dedicatedserver1;
            if (flag1 && !GraphicsEnvironment.isHeadless()) {
                dedicatedServer.m_139667_();
            }
        }
        return dedicatedserver1;
    }

    static {
        Util.m_201353_();
    }
}

