/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.StaticTagHelper;
import net.minecraft.tags.TagContainer;

public class StaticTags {
    private static final Map<ResourceKey<?>, StaticTagHelper<?>> HELPER_MAP = new HashMap();
    private static final Set<ResourceKey<?>> f_144340_ = HELPER_MAP.keySet();
    private static final Collection<StaticTagHelper<?>> f_13264_ = HELPER_MAP.values();

    public static <T> StaticTagHelper<T> m_144351_(ResourceKey<? extends Registry<T>> p_144352_, String p_144353_) {
        if (f_144340_.contains(p_144352_)) {
            throw new IllegalStateException("Duplicate entry for static tag collection: " + p_144352_);
        }
        StaticTagHelper statictaghelper = new StaticTagHelper(p_144352_, p_144353_);
        HELPER_MAP.put(p_144352_, statictaghelper);
        return statictaghelper;
    }

    public static void m_13269_(TagContainer p_13270_) {
        f_13264_.forEach(p_13273_ -> p_13273_.m_13242_(p_13270_));
    }

    public static void m_13266_() {
        f_13264_.forEach(StaticTagHelper::m_13232_);
    }

    public static Multimap<ResourceKey<? extends Registry<?>>, ResourceLocation> m_13283_(TagContainer p_13284_) {
        HashMultimap multimap = HashMultimap.create();
        f_13264_.forEach(arg_0 -> StaticTags.m_144345_((Multimap)multimap, p_13284_, arg_0));
        return multimap;
    }

    public static void m_13282_() {
        StaticTags.m_144356_();
    }

    private static Set<StaticTagHelper<?>> m_144355_() {
        return ImmutableSet.of(BlockTags.f_13053_, ItemTags.f_13163_, FluidTags.f_13130_, EntityTypeTags.f_13119_, GameEventTags.f_144301_);
    }

    private static void m_144356_() {
        StaticTags.m_144355_();
    }

    @Nullable
    public static StaticTagHelper<?> get(ResourceLocation rl) {
        return HELPER_MAP.get(ResourceKey.m_135788_(rl));
    }

    public static void m_144349_(Consumer<StaticTagHelper<?>> p_144350_) {
        f_13264_.forEach(p_144350_);
    }

    public static TagContainer m_144354_() {
        TagContainer.Builder tagcontainer$builder = new TagContainer.Builder();
        StaticTags.m_144356_();
        f_13264_.forEach(p_144344_ -> p_144344_.m_144336_(tagcontainer$builder));
        return tagcontainer$builder.m_144485_();
    }

    private static /* synthetic */ void m_144345_(Multimap p_144346_, TagContainer p_144347_, StaticTagHelper p_144348_) {
        p_144346_.putAll(p_144348_.m_144338_(), p_144348_.m_13247_(p_144347_));
    }
}

