/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.OceanMonumentPieces;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class OceanMonumentFeature
extends StructureFeature<NoneFeatureConfiguration> {
    public static final WeightedRandomList<MobSpawnSettings.SpawnerData> f_66469_ = WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.f_20455_, 1, 2, 4)});

    public OceanMonumentFeature(Codec<NoneFeatureConfiguration> p_66472_) {
        super(p_66472_, PieceGeneratorSupplier.m_197349_(OceanMonumentFeature::m_197131_, OceanMonumentFeature::m_191045_));
    }

    @Override
    protected boolean m_5910_() {
        return false;
    }

    private static boolean m_197131_(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> p_197132_) {
        int i = p_197132_.f_197355_().m_151382_(9);
        int j = p_197132_.f_197355_().m_151391_(9);
        for (Biome biome : p_197132_.f_197353_().m_183399_(i, p_197132_.f_197352_().m_6337_(), j, 29, p_197132_.f_197352_().m_183403_())) {
            if (biome.m_47567_() == Biome.BiomeCategory.OCEAN || biome.m_47567_() == Biome.BiomeCategory.RIVER) continue;
            return false;
        }
        return p_197132_.m_197380_(Heightmap.Types.OCEAN_FLOOR_WG);
    }

    private static StructurePiece m_191024_(ChunkPos p_191025_, WorldgenRandom p_191026_) {
        int i = p_191025_.m_45604_() - 29;
        int j = p_191025_.m_45605_() - 29;
        Direction direction = Direction.Plane.HORIZONTAL.m_122560_((Random)p_191026_);
        return new OceanMonumentPieces.MonumentBuilding((Random)p_191026_, i, j, direction);
    }

    private static void m_191045_(StructurePiecesBuilder p_191046_, PieceGenerator.Context<NoneFeatureConfiguration> p_191047_) {
        p_191046_.m_142679_(OceanMonumentFeature.m_191024_(p_191047_.f_192705_(), p_191047_.f_192708_()));
    }

    public static PiecesContainer m_191020_(ChunkPos p_191021_, long p_191022_, PiecesContainer p_191023_) {
        if (p_191023_.m_192748_()) {
            return p_191023_;
        }
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_189328_()));
        worldgenrandom.m_190068_(p_191022_, p_191021_.f_45578_, p_191021_.f_45579_);
        StructurePiece structurepiece = (StructurePiece)p_191023_.f_192741_().get(0);
        BoundingBox boundingbox = structurepiece.m_73547_();
        int i = boundingbox.m_162395_();
        int j = boundingbox.m_162398_();
        Direction direction = Direction.Plane.HORIZONTAL.m_122560_((Random)worldgenrandom);
        Direction direction1 = Objects.requireNonNullElse(structurepiece.m_73549_(), direction);
        OceanMonumentPieces.MonumentBuilding structurepiece1 = new OceanMonumentPieces.MonumentBuilding((Random)worldgenrandom, i, j, direction1);
        StructurePiecesBuilder structurepiecesbuilder = new StructurePiecesBuilder();
        structurepiecesbuilder.m_142679_((StructurePiece)structurepiece1);
        return structurepiecesbuilder.m_192780_();
    }

    public List<MobSpawnSettings.SpawnerData> getDefaultSpawnList(MobCategory category) {
        if (category == MobCategory.MONSTER) {
            return f_66469_.m_146338_();
        }
        return Collections.emptyList();
    }
}

