/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.FeatureAccess;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.BastionFeature;
import net.minecraft.world.level.levelgen.feature.BuriedTreasureFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.DesertPyramidFeature;
import net.minecraft.world.level.levelgen.feature.EndCityFeature;
import net.minecraft.world.level.levelgen.feature.IglooFeature;
import net.minecraft.world.level.levelgen.feature.JunglePyramidFeature;
import net.minecraft.world.level.levelgen.feature.MineshaftFeature;
import net.minecraft.world.level.levelgen.feature.NetherFortressFeature;
import net.minecraft.world.level.levelgen.feature.OceanMonumentFeature;
import net.minecraft.world.level.levelgen.feature.PillagerOutpostFeature;
import net.minecraft.world.level.levelgen.feature.RuinedPortalFeature;
import net.minecraft.world.level.levelgen.feature.ShipwreckFeature;
import net.minecraft.world.level.levelgen.feature.StrongholdFeature;
import net.minecraft.world.level.levelgen.feature.SwamplandHutFeature;
import net.minecraft.world.level.levelgen.feature.VillageFeature;
import net.minecraft.world.level.levelgen.feature.WoodlandMansionFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.MineshaftConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OceanRuinConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RangeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RuinedPortalConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ShipwreckConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.NetherFossilFeature;
import net.minecraft.world.level.levelgen.structure.OceanRuinFeature;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraftforge.common.extensions.IForgeStructureFeature;
import net.minecraftforge.common.util.ReverseTagWrapper;
import net.minecraftforge.common.world.StructureSpawnManager;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class StructureFeature<C extends FeatureConfiguration>
extends ForgeRegistryEntry<StructureFeature<?>>
implements IForgeStructureFeature {
    public static final BiMap<String, StructureFeature<?>> f_67012_ = HashBiMap.create();
    private static final Map<StructureFeature<?>, GenerationStep.Decoration> f_67032_ = Maps.newHashMap();
    private static final Logger f_67033_ = LogManager.getLogger();
    public static final StructureFeature<JigsawConfiguration> f_67013_ = StructureFeature.m_67089_("Pillager_Outpost", new PillagerOutpostFeature((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<MineshaftConfiguration> f_67014_ = StructureFeature.m_67089_("Mineshaft", new MineshaftFeature(MineshaftConfiguration.f_67780_), GenerationStep.Decoration.UNDERGROUND_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67015_ = StructureFeature.m_67089_("Mansion", new WoodlandMansionFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67016_ = StructureFeature.m_67089_("Jungle_Pyramid", new JunglePyramidFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67017_ = StructureFeature.m_67089_("Desert_Pyramid", new DesertPyramidFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67018_ = StructureFeature.m_67089_("Igloo", new IglooFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<RuinedPortalConfiguration> f_67019_ = StructureFeature.m_67089_("Ruined_Portal", new RuinedPortalFeature(RuinedPortalConfiguration.f_68054_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<ShipwreckConfiguration> f_67020_ = StructureFeature.m_67089_("Shipwreck", new ShipwreckFeature(ShipwreckConfiguration.f_68061_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67021_ = StructureFeature.m_67089_("Swamp_Hut", new SwamplandHutFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67022_ = StructureFeature.m_67089_("Stronghold", new StrongholdFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.STRONGHOLDS);
    public static final StructureFeature<NoneFeatureConfiguration> f_67023_ = StructureFeature.m_67089_("Monument", new OceanMonumentFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<OceanRuinConfiguration> f_67024_ = StructureFeature.m_67089_("Ocean_Ruin", new OceanRuinFeature(OceanRuinConfiguration.f_67820_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67025_ = StructureFeature.m_67089_("Fortress", new NetherFortressFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.UNDERGROUND_DECORATION);
    public static final StructureFeature<NoneFeatureConfiguration> f_67026_ = StructureFeature.m_67089_("EndCity", new EndCityFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<ProbabilityFeatureConfiguration> f_67027_ = StructureFeature.m_67089_("Buried_Treasure", new BuriedTreasureFeature(ProbabilityFeatureConfiguration.f_67858_), GenerationStep.Decoration.UNDERGROUND_STRUCTURES);
    public static final StructureFeature<JigsawConfiguration> f_67028_ = StructureFeature.m_67089_("Village", new VillageFeature(JigsawConfiguration.f_67756_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<RangeConfiguration> f_67029_ = StructureFeature.m_67089_("Nether_Fossil", new NetherFossilFeature(RangeConfiguration.f_191320_), GenerationStep.Decoration.UNDERGROUND_DECORATION);
    public static final StructureFeature<JigsawConfiguration> f_67030_ = StructureFeature.m_67089_("Bastion_Remnant", new BastionFeature(JigsawConfiguration.f_67756_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final List<StructureFeature<?>> f_67031_ = ImmutableList.of(f_67013_, f_67028_, f_67029_, f_67022_);
    public static final int f_160446_ = 8;
    private final ReverseTagWrapper<StructureFeature<?>> reverseTags = new ReverseTagWrapper((Object)this, () -> SerializationTags.m_13199_().m_144452_(Registry.f_122840_));
    private final Codec<ConfiguredStructureFeature<C, StructureFeature<C>>> f_67036_;
    private final PieceGeneratorSupplier<C> f_191106_;
    private final PostPlacementProcessor f_191107_;

    private static <F extends StructureFeature<?>> F m_67089_(String p_67090_, F p_67091_, GenerationStep.Decoration p_67092_) {
        f_67012_.put((Object)p_67090_.toLowerCase(Locale.ROOT), p_67091_);
        f_67032_.put(p_67091_, p_67092_);
        return (F)((Object)Registry.m_122961_(Registry.f_122841_, p_67090_.toLowerCase(Locale.ROOT), p_67091_));
    }

    public StructureFeature(Codec<C> p_197165_, PieceGeneratorSupplier<C> p_197166_) {
        this(p_197165_, p_197166_, PostPlacementProcessor.f_192427_);
    }

    public StructureFeature(Codec<C> p_197168_, PieceGeneratorSupplier<C> p_197169_, PostPlacementProcessor p_197170_) {
        this.f_67036_ = p_197168_.fieldOf("config").xmap(p_67094_ -> new ConfiguredStructureFeature(this, p_67094_), p_67064_ -> p_67064_.f_65404_).codec();
        this.f_191106_ = p_197169_;
        this.f_191107_ = p_197170_;
    }

    public Set<ResourceLocation> getTags() {
        return this.reverseTags.getTagNames();
    }

    public boolean is(Tag<StructureFeature<?>> tag) {
        return tag.m_8110_(this);
    }

    public GenerationStep.Decoration m_67095_() {
        return f_67032_.get((Object)this);
    }

    public static void m_67096_() {
    }

    @Nullable
    public static StructureStart<?> m_191128_(StructurePieceSerializationContext p_191129_, CompoundTag p_191130_, long p_191131_) {
        String s = p_191130_.m_128461_("id");
        if ("INVALID".equals(s)) {
            return StructureStart.f_73561_;
        }
        StructureFeature<?> structurefeature = Registry.f_122841_.m_7745_(new ResourceLocation(s.toLowerCase(Locale.ROOT)));
        if (structurefeature == null) {
            f_67033_.error("Unknown feature id: {}", (Object)s);
            return null;
        }
        ChunkPos chunkpos = new ChunkPos(p_191130_.m_128451_("ChunkX"), p_191130_.m_128451_("ChunkZ"));
        int i = p_191130_.m_128451_("references");
        ListTag listtag = p_191130_.m_128437_("Children", 10);
        try {
            PiecesContainer piecescontainer = PiecesContainer.m_192753_((ListTag)listtag, (StructurePieceSerializationContext)p_191129_);
            if (structurefeature == f_67023_) {
                piecescontainer = OceanMonumentFeature.m_191020_(chunkpos, p_191131_, piecescontainer);
            }
            return new StructureStart(structurefeature, chunkpos, i, piecescontainer);
        }
        catch (Exception exception) {
            f_67033_.error("Failed Start with id {}", (Object)s, (Object)exception);
            return null;
        }
    }

    public Codec<ConfiguredStructureFeature<C, StructureFeature<C>>> m_67097_() {
        return this.f_67036_;
    }

    public ConfiguredStructureFeature<C, ? extends StructureFeature<C>> m_67065_(C p_67066_) {
        return new ConfiguredStructureFeature(this, p_67066_);
    }

    public BlockPos m_183220_(ChunkPos p_191115_) {
        return new BlockPos(p_191115_.m_45604_(), 0, p_191115_.m_45605_());
    }

    @Nullable
    public BlockPos m_67046_(LevelReader p_67047_, StructureFeatureManager p_67048_, BlockPos p_67049_, int p_67050_, boolean p_67051_, long p_67052_, StructureFeatureConfiguration p_67053_) {
        int i = p_67053_.m_68171_();
        int j = SectionPos.m_123171_((int)p_67049_.m_123341_());
        int k = SectionPos.m_123171_((int)p_67049_.m_123343_());
        block0: for (int l = 0; l <= p_67050_; ++l) {
            for (int i1 = -l; i1 <= l; ++i1) {
                boolean flag = i1 == -l || i1 == l;
                for (int j1 = -l; j1 <= l; ++j1) {
                    int l1;
                    int k1;
                    ChunkPos chunkpos;
                    StructureCheckResult structurecheckresult;
                    boolean flag1;
                    boolean bl = flag1 = j1 == -l || j1 == l;
                    if (!flag && !flag1 || (structurecheckresult = p_67048_.m_196670_(chunkpos = this.m_191122_(p_67053_, p_67052_, k1 = j + i * i1, l1 = k + i * j1), this, p_67051_)) == StructureCheckResult.START_NOT_PRESENT) continue;
                    if (!p_67051_ && structurecheckresult == StructureCheckResult.START_PRESENT) {
                        return this.m_183220_(chunkpos);
                    }
                    ChunkAccess chunkaccess = p_67047_.m_46819_(chunkpos.f_45578_, chunkpos.f_45579_, ChunkStatus.f_62315_);
                    StructureStart structurestart = p_67048_.m_47297_(SectionPos.m_175562_((ChunkAccess)chunkaccess), this, (FeatureAccess)chunkaccess);
                    if (structurestart != null && structurestart.m_73603_()) {
                        if (p_67051_ && structurestart.m_73606_()) {
                            p_67048_.m_196674_(structurestart);
                            return this.m_183220_(structurestart.m_163625_());
                        }
                        if (!p_67051_) {
                            return this.m_183220_(structurestart.m_163625_());
                        }
                    }
                    if (l == 0) break;
                }
                if (l == 0) continue block0;
            }
        }
        return null;
    }

    protected boolean m_5910_() {
        return true;
    }

    public final ChunkPos m_191122_(StructureFeatureConfiguration p_191123_, long p_191124_, int p_191125_, int p_191126_) {
        int j1;
        int i1;
        int i = p_191123_.m_68171_();
        int j = p_191123_.m_68176_();
        int k = Math.floorDiv(p_191125_, i);
        int l = Math.floorDiv(p_191126_, i);
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190058_(p_191124_, k, l, p_191123_.m_68179_());
        if (this.m_5910_()) {
            i1 = worldgenrandom.nextInt(i - j);
            j1 = worldgenrandom.nextInt(i - j);
        } else {
            i1 = (worldgenrandom.nextInt(i - j) + worldgenrandom.nextInt(i - j)) / 2;
            j1 = (worldgenrandom.nextInt(i - j) + worldgenrandom.nextInt(i - j)) / 2;
        }
        return new ChunkPos(k * i + i1, l * i + j1);
    }

    public StructureStart<?> m_191132_(RegistryAccess p_191133_, ChunkGenerator p_191134_, BiomeSource p_191135_, StructureManager p_191136_, long p_191137_, ChunkPos p_191138_, int p_191139_, StructureFeatureConfiguration p_191140_, C p_191141_, LevelHeightAccessor p_191142_, Predicate<Biome> p_191143_) {
        Optional optional;
        ChunkPos chunkpos = this.m_191122_(p_191140_, p_191137_, p_191138_.f_45578_, p_191138_.f_45579_);
        if (p_191138_.f_45578_ == chunkpos.f_45578_ && p_191138_.f_45579_ == chunkpos.f_45579_ && (optional = this.f_191106_.m_197347_(new PieceGeneratorSupplier.Context(p_191134_, p_191135_, p_191137_, p_191138_, p_191141_, p_191142_, p_191143_, p_191136_, p_191133_))).isPresent()) {
            StructurePiecesBuilder structurepiecesbuilder = new StructurePiecesBuilder();
            WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            worldgenrandom.m_190068_(p_191137_, p_191138_.f_45578_, p_191138_.f_45579_);
            ((PieceGenerator)optional.get()).m_197325_(structurepiecesbuilder, new PieceGenerator.Context(p_191141_, p_191134_, p_191136_, p_191138_, p_191142_, worldgenrandom, p_191137_));
            StructureStart structurestart = new StructureStart(this, p_191138_, p_191139_, structurepiecesbuilder.m_192780_());
            if (structurestart.m_73603_()) {
                return structurestart;
            }
        }
        return StructureStart.f_73561_;
    }

    public boolean m_197171_(RegistryAccess p_197172_, ChunkGenerator p_197173_, BiomeSource p_197174_, StructureManager p_197175_, long p_197176_, ChunkPos p_197177_, C p_197178_, LevelHeightAccessor p_197179_, Predicate<Biome> p_197180_) {
        return this.f_191106_.m_197347_(new PieceGeneratorSupplier.Context(p_197173_, p_197174_, p_197176_, p_197177_, p_197178_, p_197179_, p_197180_, p_197175_, p_197172_)).isPresent();
    }

    public PostPlacementProcessor m_191144_() {
        return this.f_191107_;
    }

    public String m_67098_() {
        return (String)f_67012_.inverse().get((Object)this);
    }

    public final WeightedRandomList<MobSpawnSettings.SpawnerData> getSpawnList(MobCategory classification) {
        return StructureSpawnManager.getSpawnList((StructureFeature)this, (MobCategory)classification);
    }

    public BoundingBox m_183606_(BoundingBox p_191127_) {
        return p_191127_;
    }
}

