/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.data.worldgen.StructureFeatures;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StrongholdConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public abstract class ChunkGenerator
implements BiomeManager.NoiseBiomeSource {
    public static final Codec<ChunkGenerator> f_62136_;
    protected final BiomeSource f_62137_;
    protected final BiomeSource f_62138_;
    private final StructureSettings f_62139_;
    private final long f_62140_;
    private final List<ChunkPos> f_62141_ = Lists.newArrayList();

    public ChunkGenerator(BiomeSource p_62149_, StructureSettings p_62150_) {
        this(p_62149_, p_62149_, p_62150_, 0L);
    }

    public ChunkGenerator(BiomeSource p_62144_, BiomeSource p_62145_, StructureSettings p_62146_, long p_62147_) {
        this.f_62137_ = p_62144_;
        this.f_62138_ = p_62145_;
        this.f_62139_ = p_62146_;
        this.f_62140_ = p_62147_;
    }

    private void m_62219_() {
        if (!this.f_62141_.isEmpty()) {
            return;
        }
        StrongholdConfiguration $$0 = this.f_62139_.m_64597_();
        if ($$0 == null || $$0.m_68161_() == 0) {
            return;
        }
        ArrayList $$1 = Lists.newArrayList();
        for (Biome $$2 : this.f_62137_.m_196676_()) {
            if (!ChunkGenerator.m_187715_($$2)) continue;
            $$1.add($$2);
        }
        int $$3 = $$0.m_68157_();
        int $$4 = $$0.m_68161_();
        int $$5 = $$0.m_68160_();
        Random $$6 = new Random();
        $$6.setSeed(this.f_62140_);
        double $$7 = $$6.nextDouble() * Math.PI * 2.0;
        int $$8 = 0;
        int $$9 = 0;
        for (int $$10 = 0; $$10 < $$4; ++$$10) {
            double $$11 = (double)(4 * $$3 + $$3 * $$9 * 6) + ($$6.nextDouble() - 0.5) * ((double)$$3 * 2.5);
            int $$12 = (int)Math.round(Math.cos($$7) * $$11);
            int $$13 = (int)Math.round(Math.sin($$7) * $$11);
            BlockPos $$14 = this.f_62137_.m_186710_(SectionPos.m_175554_($$12, 8), 0, SectionPos.m_175554_($$13, 8), 112, $$1::contains, $$6, this.m_183403_());
            if ($$14 != null) {
                $$12 = SectionPos.m_123171_($$14.m_123341_());
                $$13 = SectionPos.m_123171_($$14.m_123343_());
            }
            this.f_62141_.add(new ChunkPos($$12, $$13));
            $$7 += Math.PI * 2 / (double)$$5;
            if (++$$8 != $$5) continue;
            $$8 = 0;
            $$5 += 2 * $$5 / (++$$9 + 1);
            $$5 = Math.min($$5, $$4 - $$10);
            $$7 += $$6.nextDouble() * Math.PI * 2.0;
        }
    }

    private static boolean m_187715_(Biome p_187716_) {
        Biome.BiomeCategory $$1 = p_187716_.m_47567_();
        return $$1 != Biome.BiomeCategory.OCEAN && $$1 != Biome.BiomeCategory.RIVER && $$1 != Biome.BiomeCategory.BEACH && $$1 != Biome.BiomeCategory.SWAMP && $$1 != Biome.BiomeCategory.NETHER && $$1 != Biome.BiomeCategory.THEEND;
    }

    protected abstract Codec<? extends ChunkGenerator> m_6909_();

    public Optional<ResourceKey<Codec<? extends ChunkGenerator>>> m_187743_() {
        return Registry.f_122890_.m_7854_(this.m_6909_());
    }

    public abstract ChunkGenerator m_6819_(long var1);

    public CompletableFuture<ChunkAccess> m_196423_(Registry<Biome> p_196743_, Executor p_196744_, Blender p_196745_, StructureFeatureManager p_196746_, ChunkAccess p_196747_) {
        return CompletableFuture.supplyAsync(Util.m_183946_("init_biomes", () -> {
            p_196747_.m_183442_(this.f_62138_::m_183546_, this.m_183403_());
            return p_196747_;
        }), Util.m_183991_());
    }

    public abstract Climate.Sampler m_183403_();

    @Override
    public Biome m_7158_(int p_187755_, int p_187756_, int p_187757_) {
        return this.m_62218_().m_183546_(p_187755_, p_187756_, p_187757_, this.m_183403_());
    }

    public abstract void m_183516_(WorldGenRegion var1, long var2, BiomeManager var4, StructureFeatureManager var5, ChunkAccess var6, GenerationStep.Carving var7);

    @Nullable
    public BlockPos m_62161_(ServerLevel p_62162_, StructureFeature<?> p_62163_, BlockPos p_62164_, int p_62165_, boolean p_62166_) {
        if (p_62163_ == StructureFeature.f_67022_) {
            this.m_62219_();
            BlockPos $$5 = null;
            double $$6 = Double.MAX_VALUE;
            BlockPos.MutableBlockPos $$7 = new BlockPos.MutableBlockPos();
            for (ChunkPos $$8 : this.f_62141_) {
                $$7.m_122178_(SectionPos.m_175554_($$8.f_45578_, 8), 32, SectionPos.m_175554_($$8.f_45579_, 8));
                double $$9 = $$7.m_123331_(p_62164_);
                if ($$5 == null) {
                    $$5 = new BlockPos($$7);
                    $$6 = $$9;
                    continue;
                }
                if (!($$9 < $$6)) continue;
                $$5 = new BlockPos($$7);
                $$6 = $$9;
            }
            return $$5;
        }
        StructureFeatureConfiguration $$10 = this.f_62139_.m_64593_(p_62163_);
        ImmutableMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> $$11 = this.f_62139_.m_189371_(p_62163_);
        if ($$10 == null || $$11.isEmpty()) {
            return null;
        }
        Registry<Biome> $$12 = p_62162_.m_5962_().m_175515_(Registry.f_122885_);
        Set $$13 = this.f_62138_.m_196676_().stream().flatMap(p_187725_ -> $$12.m_7854_((Biome)p_187725_).stream()).collect(Collectors.toSet());
        if ($$11.values().stream().noneMatch($$13::contains)) {
            return null;
        }
        return p_62163_.m_67046_(p_62162_, p_62162_.m_8595_(), p_62164_, p_62165_, p_62166_, p_62162_.m_7328_(), $$10);
    }

    public void m_183372_(WorldGenLevel p_187712_, ChunkAccess p_187713_, StructureFeatureManager p_187714_) {
        ChunkPos $$3 = p_187713_.m_7697_();
        if (SharedConstants.m_183707_($$3)) {
            return;
        }
        SectionPos $$4 = SectionPos.m_123196_($$3, p_187712_.m_151560_());
        BlockPos $$5 = $$4.m_123249_();
        Map<Integer, List<StructureFeature>> $$6 = Registry.f_122841_.m_123024_().collect(Collectors.groupingBy(p_187720_ -> p_187720_.m_67095_().ordinal()));
        List<BiomeSource.StepFeatureData> $$7 = this.f_62137_.m_186733_();
        WorldgenRandom $$8 = new WorldgenRandom(new XoroshiroRandomSource(RandomSupport.m_189328_()));
        long $$9 = $$8.m_64690_(p_187712_.m_7328_(), $$5.m_123341_(), $$5.m_123343_());
        ObjectArraySet $$10 = new ObjectArraySet();
        if (this instanceof FlatLevelSource) {
            $$10.addAll(this.f_62137_.m_196676_());
        } else {
            ChunkPos.m_45596_($$4.m_123251_(), 1).forEach(arg_0 -> ChunkGenerator.m_196727_(p_187712_, (Set)$$10, arg_0));
            $$10.retainAll(this.f_62137_.m_196676_());
        }
        int $$11 = $$7.size();
        try {
            Registry<PlacedFeature> $$12 = p_187712_.m_5962_().m_175515_(Registry.f_194567_);
            Registry<StructureFeature<?>> $$13 = p_187712_.m_5962_().m_175515_(Registry.f_122840_);
            int $$14 = Math.max(GenerationStep.Decoration.values().length, $$11);
            for (int $$15 = 0; $$15 < $$14; ++$$15) {
                int $$16 = 0;
                if (p_187714_.m_47271_()) {
                    List $$17 = $$6.getOrDefault($$15, Collections.emptyList());
                    for (StructureFeature $$18 : $$17) {
                        $$8.m_190064_($$9, $$16, $$15);
                        Supplier<String> $$19 = () -> $$13.m_7854_($$18).map(Object::toString).orElseGet($$18::toString);
                        try {
                            p_187712_.m_183406_($$19);
                            p_187714_.m_186610_($$4, $$18).forEach(p_196726_ -> p_196726_.m_7129_(p_187712_, p_187714_, this, $$8, ChunkGenerator.m_187717_(p_187713_), $$3));
                        }
                        catch (Exception $$20) {
                            CrashReport $$21 = CrashReport.m_127521_($$20, "Feature placement");
                            $$21.m_127514_("Feature").m_128165_("Description", $$19::get);
                            throw new ReportedException($$21);
                        }
                        ++$$16;
                    }
                }
                if ($$15 >= $$11) continue;
                IntArraySet $$22 = new IntArraySet();
                for (Biome $$23 : $$10) {
                    List<List<Supplier<PlacedFeature>>> $$24 = $$23.m_47536_().m_47818_();
                    if ($$15 >= $$24.size()) continue;
                    List<Supplier<PlacedFeature>> $$25 = $$24.get($$15);
                    BiomeSource.StepFeatureData $$26 = $$7.get($$15);
                    $$25.stream().map(Supplier::get).forEach(arg_0 -> ChunkGenerator.m_196748_((IntSet)$$22, $$26, arg_0));
                }
                int $$27 = $$22.size();
                int[] $$28 = $$22.toIntArray();
                Arrays.sort($$28);
                BiomeSource.StepFeatureData $$29 = $$7.get($$15);
                for (int $$30 = 0; $$30 < $$27; ++$$30) {
                    int $$31 = $$28[$$30];
                    PlacedFeature $$32 = $$29.f_196677_().get($$31);
                    Supplier<String> $$33 = () -> $$12.m_7854_($$32).map(Object::toString).orElseGet($$32::toString);
                    $$8.m_190064_($$9, $$31, $$15);
                    try {
                        p_187712_.m_183406_($$33);
                        $$32.m_191806_(p_187712_, this, $$8, $$5);
                        continue;
                    }
                    catch (Exception $$34) {
                        CrashReport $$35 = CrashReport.m_127521_($$34, "Feature placement");
                        $$35.m_127514_("Feature").m_128165_("Description", $$33::get);
                        throw new ReportedException($$35);
                    }
                }
            }
            p_187712_.m_183406_(null);
        }
        catch (Exception $$36) {
            CrashReport $$37 = CrashReport.m_127521_($$36, "Biome decoration");
            $$37.m_127514_("Generation").m_128159_("CenterX", $$3.f_45578_).m_128159_("CenterZ", $$3.f_45579_).m_128159_("Seed", $$9);
            throw new ReportedException($$37);
        }
    }

    private static BoundingBox m_187717_(ChunkAccess p_187718_) {
        ChunkPos $$1 = p_187718_.m_7697_();
        int $$2 = $$1.m_45604_();
        int $$3 = $$1.m_45605_();
        LevelHeightAccessor $$4 = p_187718_.m_183618_();
        int $$5 = $$4.m_141937_() + 1;
        int $$6 = $$4.m_151558_() - 1;
        return new BoundingBox($$2, $$5, $$3, $$2 + 15, $$6, $$3 + 15);
    }

    public abstract void m_183621_(WorldGenRegion var1, StructureFeatureManager var2, ChunkAccess var3);

    public abstract void m_6929_(WorldGenRegion var1);

    public StructureSettings m_62205_() {
        return this.f_62139_;
    }

    public int m_142051_(LevelHeightAccessor p_156157_) {
        return 64;
    }

    public BiomeSource m_62218_() {
        return this.f_62138_;
    }

    public abstract int m_6331_();

    public WeightedRandomList<MobSpawnSettings.SpawnerData> m_142184_(Biome p_156158_, StructureFeatureManager p_156159_, MobCategory p_156160_, BlockPos p_156161_) {
        return p_156158_.m_47518_().m_151798_(p_156160_);
    }

    public void m_62199_(RegistryAccess p_62200_, StructureFeatureManager p_62201_, ChunkAccess p_62202_, StructureManager p_62203_, long p_62204_) {
        StructureStart<?> $$8;
        ChunkPos $$5 = p_62202_.m_7697_();
        SectionPos $$6 = SectionPos.m_175562_(p_62202_);
        StructureFeatureConfiguration $$7 = this.f_62139_.m_64593_(StructureFeature.f_67022_);
        if (!($$7 == null || ($$8 = p_62201_.m_47297_($$6, StructureFeature.f_67022_, p_62202_)) != null && $$8.m_73603_())) {
            StructureStart<?> $$9 = StructureFeatures.f_127249_.m_190827_(p_62200_, this, this.f_62137_, p_62203_, p_62204_, $$5, ChunkGenerator.m_187700_(p_62201_, p_62202_, $$6, StructureFeature.f_67022_), $$7, p_62202_, ChunkGenerator::m_187715_);
            p_62201_.m_47301_($$6, StructureFeature.f_67022_, $$9, p_62202_);
        }
        Registry<Biome> $$10 = p_62200_.m_175515_(Registry.f_122885_);
        block0: for (StructureFeature structureFeature : Registry.f_122841_) {
            StructureStart<?> $$13;
            StructureFeatureConfiguration $$12;
            if (structureFeature == StructureFeature.f_67022_ || ($$12 = this.f_62139_.m_64593_(structureFeature)) == null || ($$13 = p_62201_.m_47297_($$6, structureFeature, p_62202_)) != null && $$13.m_73603_()) continue;
            int $$14 = ChunkGenerator.m_187700_(p_62201_, p_62202_, $$6, structureFeature);
            for (Map.Entry $$15 : this.f_62139_.m_189371_(structureFeature).asMap().entrySet()) {
                StructureStart<?> $$16 = ((ConfiguredStructureFeature)$$15.getKey()).m_190827_(p_62200_, this, this.f_62137_, p_62203_, p_62204_, $$5, $$14, $$12, p_62202_, p_196742_ -> this.m_183172_($$10, ((Collection)$$15.getValue())::contains, (Biome)p_196742_));
                if (!$$16.m_73603_()) continue;
                p_62201_.m_47301_($$6, structureFeature, $$16, p_62202_);
                continue block0;
            }
            p_62201_.m_47301_($$6, structureFeature, StructureStart.f_73561_, p_62202_);
        }
    }

    private static int m_187700_(StructureFeatureManager p_187701_, ChunkAccess p_187702_, SectionPos p_187703_, StructureFeature<?> p_187704_) {
        StructureStart<?> $$4 = p_187701_.m_47297_(p_187703_, p_187704_, p_187702_);
        return $$4 != null ? $$4.m_73608_() : 0;
    }

    protected boolean m_183172_(Registry<Biome> p_187736_, Predicate<ResourceKey<Biome>> p_187737_, Biome p_187738_) {
        return p_187736_.m_7854_(p_187738_).filter(p_187737_).isPresent();
    }

    public void m_62177_(WorldGenLevel p_62178_, StructureFeatureManager p_62179_, ChunkAccess p_62180_) {
        int $$3 = 8;
        ChunkPos $$4 = p_62180_.m_7697_();
        int $$5 = $$4.f_45578_;
        int $$6 = $$4.f_45579_;
        int $$7 = $$4.m_45604_();
        int $$8 = $$4.m_45605_();
        SectionPos $$9 = SectionPos.m_175562_(p_62180_);
        for (int $$10 = $$5 - 8; $$10 <= $$5 + 8; ++$$10) {
            for (int $$11 = $$6 - 8; $$11 <= $$6 + 8; ++$$11) {
                long $$12 = ChunkPos.m_45589_($$10, $$11);
                for (StructureStart<?> $$13 : p_62178_.m_6325_($$10, $$11).m_6633_().values()) {
                    try {
                        if (!$$13.m_73603_() || !$$13.m_73601_().m_71019_($$7, $$8, $$7 + 15, $$8 + 15)) continue;
                        p_62179_.m_47292_($$9, $$13.m_73610_(), $$12, p_62180_);
                        DebugPackets.m_133711_(p_62178_, $$13);
                    }
                    catch (Exception $$14) {
                        CrashReport $$15 = CrashReport.m_127521_($$14, "Generating structure reference");
                        CrashReportCategory $$16 = $$15.m_127514_("Structure");
                        $$16.m_128165_("Id", () -> Registry.f_122841_.m_7981_($$13.m_73610_()).toString());
                        $$16.m_128165_("Name", () -> $$13.m_73610_().m_67098_());
                        $$16.m_128165_("Class", () -> $$13.m_73610_().getClass().getCanonicalName());
                        throw new ReportedException($$15);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<ChunkAccess> m_183489_(Executor var1, Blender var2, StructureFeatureManager var3, ChunkAccess var4);

    public abstract int m_6337_();

    public abstract int m_142062_();

    public abstract int m_142647_(int var1, int var2, Heightmap.Types var3, LevelHeightAccessor var4);

    public abstract NoiseColumn m_141914_(int var1, int var2, LevelHeightAccessor var3);

    public int m_156174_(int p_156175_, int p_156176_, Heightmap.Types p_156177_, LevelHeightAccessor p_156178_) {
        return this.m_142647_(p_156175_, p_156176_, p_156177_, p_156178_);
    }

    public int m_156179_(int p_156180_, int p_156181_, Heightmap.Types p_156182_, LevelHeightAccessor p_156183_) {
        return this.m_142647_(p_156180_, p_156181_, p_156182_, p_156183_) - 1;
    }

    public boolean m_62172_(ChunkPos p_62173_) {
        this.m_62219_();
        return this.f_62141_.contains(p_62173_);
    }

    private static /* synthetic */ void m_196748_(IntSet p_196749_, BiomeSource.StepFeatureData p_196750_, PlacedFeature p_196751_) {
        p_196749_.add(p_196750_.f_196678_().applyAsInt(p_196751_));
    }

    private static /* synthetic */ void m_196727_(WorldGenLevel p_196728_, Set p_196729_, ChunkPos p_196730_) {
        ChunkAccess $$3 = p_196728_.m_6325_(p_196730_.f_45578_, p_196730_.f_45579_);
        for (LevelChunkSection $$4 : $$3.m_7103_()) {
            $$4.m_188013_().m_196879_(p_196729_::add);
        }
    }

    static {
        Registry.m_122961_(Registry.f_122890_, "noise", NoiseBasedChunkGenerator.f_64314_);
        Registry.m_122961_(Registry.f_122890_, "flat", FlatLevelSource.f_64164_);
        Registry.m_122961_(Registry.f_122890_, "debug", DebugLevelSource.f_64111_);
        f_62136_ = Registry.f_122890_.m_194605_().dispatchStable(ChunkGenerator::m_6909_, Function.identity());
    }
}

