/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.file.Path;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class DimensionType {
    public static final int f_156649_ = BlockPos.f_121857_;
    public static final int f_156650_ = 16;
    public static final int f_156651_ = (1 << f_156649_) - 32;
    public static final int f_156652_ = (f_156651_ >> 1) - 1;
    public static final int f_156653_ = f_156652_ - f_156651_ + 1;
    public static final int f_188293_ = f_156652_ << 4;
    public static final int f_188294_ = f_156653_ << 4;
    public static final ResourceLocation f_63840_ = new ResourceLocation("overworld");
    public static final ResourceLocation f_63841_ = new ResourceLocation("the_nether");
    public static final ResourceLocation f_63842_ = new ResourceLocation("the_end");
    public static final Codec<DimensionType> f_63843_ = RecordCodecBuilder.create(p_63914_ -> p_63914_.group((App)Codec.LONG.optionalFieldOf("fixed_time").xmap(p_156696_ -> p_156696_.map(OptionalLong::of).orElseGet(OptionalLong::empty), p_156698_ -> p_156698_.isPresent() ? Optional.of(p_156698_.getAsLong()) : Optional.empty()).forGetter(p_156731_ -> p_156731_.f_63854_), (App)Codec.BOOL.fieldOf("has_skylight").forGetter(DimensionType::m_63935_), (App)Codec.BOOL.fieldOf("has_ceiling").forGetter(DimensionType::m_63946_), (App)Codec.BOOL.fieldOf("ultrawarm").forGetter(DimensionType::m_63951_), (App)Codec.BOOL.fieldOf("natural").forGetter(DimensionType::m_63956_), (App)Codec.doubleRange((double)1.0E-5f, (double)3.0E7).fieldOf("coordinate_scale").forGetter(DimensionType::m_63959_), (App)Codec.BOOL.fieldOf("piglin_safe").forGetter(DimensionType::m_63960_), (App)Codec.BOOL.fieldOf("bed_works").forGetter(DimensionType::m_63961_), (App)Codec.BOOL.fieldOf("respawn_anchor_works").forGetter(DimensionType::m_63962_), (App)Codec.BOOL.fieldOf("has_raids").forGetter(DimensionType::m_63963_), (App)Codec.intRange((int)f_156653_, (int)f_156652_).fieldOf("min_y").forGetter(DimensionType::m_156732_), (App)Codec.intRange((int)16, (int)f_156651_).fieldOf("height").forGetter(DimensionType::m_156733_), (App)Codec.intRange((int)0, (int)f_156651_).fieldOf("logical_height").forGetter(DimensionType::m_63964_), (App)ResourceLocation.f_135803_.fieldOf("infiniburn").forGetter(p_156729_ -> p_156729_.f_63836_), (App)ResourceLocation.f_135803_.fieldOf("effects").orElse((Object)f_63840_).forGetter(p_156725_ -> p_156725_.f_63837_), (App)Codec.FLOAT.fieldOf("ambient_light").forGetter(p_156721_ -> Float.valueOf(p_156721_.f_63838_))).apply((Applicative)p_63914_, DimensionType::new)).comapFlatMap(DimensionType::m_156718_, Function.identity());
    private static final int f_156654_ = 8;
    public static final float[] f_63844_ = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f, 0.25f, 0.5f, 0.75f};
    public static final ResourceKey<DimensionType> f_63845_ = ResourceKey.m_135785_(Registry.f_122818_, new ResourceLocation("overworld"));
    public static final ResourceKey<DimensionType> f_63846_ = ResourceKey.m_135785_(Registry.f_122818_, new ResourceLocation("the_nether"));
    public static final ResourceKey<DimensionType> f_63847_ = ResourceKey.m_135785_(Registry.f_122818_, new ResourceLocation("the_end"));
    protected static final DimensionType f_63848_ = DimensionType.m_188324_(OptionalLong.empty(), true, false, false, true, 1.0, false, false, true, false, true, -64, 384, 384, BlockTags.f_13058_.m_6979_(), f_63840_, 0.0f);
    protected static final DimensionType f_63849_ = DimensionType.m_188324_(OptionalLong.of(18000L), false, true, true, false, 8.0, false, true, false, true, false, 0, 256, 128, BlockTags.f_13059_.m_6979_(), f_63841_, 0.1f);
    protected static final DimensionType f_63850_ = DimensionType.m_188324_(OptionalLong.of(6000L), false, false, false, false, 1.0, true, false, false, false, true, 0, 256, 256, BlockTags.f_13060_.m_6979_(), f_63842_, 0.0f);
    public static final ResourceKey<DimensionType> f_63851_ = ResourceKey.m_135785_(Registry.f_122818_, new ResourceLocation("overworld_caves"));
    protected static final DimensionType f_63852_ = DimensionType.m_188324_(OptionalLong.empty(), true, true, false, true, 1.0, false, false, true, false, true, -64, 384, 384, BlockTags.f_13058_.m_6979_(), f_63840_, 0.0f);
    public static final Codec<Supplier<DimensionType>> f_63853_ = RegistryFileCodec.m_135589_(Registry.f_122818_, f_63843_);
    private final OptionalLong f_63854_;
    private final boolean f_63855_;
    private final boolean f_63856_;
    private final boolean f_63857_;
    private final boolean f_63858_;
    private final double f_63859_;
    private final boolean f_63860_;
    private final boolean f_63861_;
    private final boolean f_63862_;
    private final boolean f_63863_;
    private final boolean f_63864_;
    private final int f_156647_;
    private final int f_156648_;
    private final int f_63865_;
    private final ResourceLocation f_63836_;
    private final ResourceLocation f_63837_;
    private final float f_63838_;
    private final transient float[] f_63839_;

    private static DataResult<DimensionType> m_156718_(DimensionType p_156719_) {
        if (p_156719_.m_156733_() < 16) {
            return DataResult.error((String)"height has to be at least 16");
        }
        if (p_156719_.m_156732_() + p_156719_.m_156733_() > f_156652_ + 1) {
            return DataResult.error((String)("min_y + height cannot be higher than: " + (f_156652_ + 1)));
        }
        if (p_156719_.m_63964_() > p_156719_.m_156733_()) {
            return DataResult.error((String)"logical_height cannot be higher than height");
        }
        if (p_156719_.m_156733_() % 16 != 0) {
            return DataResult.error((String)"height has to be multiple of 16");
        }
        if (p_156719_.m_156732_() % 16 != 0) {
            return DataResult.error((String)"min_y has to be a multiple of 16");
        }
        return DataResult.success((Object)p_156719_);
    }

    private DimensionType(OptionalLong p_156656_, boolean p_156657_, boolean p_156658_, boolean p_156659_, boolean p_156660_, double p_156661_, boolean p_156662_, boolean p_156663_, boolean p_156664_, boolean p_156665_, int p_156666_, int p_156667_, int p_156668_, ResourceLocation p_156669_, ResourceLocation p_156670_, float p_156671_) {
        this(p_156656_, p_156657_, p_156658_, p_156659_, p_156660_, p_156661_, false, p_156662_, p_156663_, p_156664_, p_156665_, p_156666_, p_156667_, p_156668_, p_156669_, p_156670_, p_156671_);
    }

    public static DimensionType m_188324_(OptionalLong p_188325_, boolean p_188326_, boolean p_188327_, boolean p_188328_, boolean p_188329_, double p_188330_, boolean p_188331_, boolean p_188332_, boolean p_188333_, boolean p_188334_, boolean p_188335_, int p_188336_, int p_188337_, int p_188338_, ResourceLocation p_188339_, ResourceLocation p_188340_, float p_188341_) {
        DimensionType $$17 = new DimensionType(p_188325_, p_188326_, p_188327_, p_188328_, p_188329_, p_188330_, p_188331_, p_188332_, p_188333_, p_188334_, p_188335_, p_188336_, p_188337_, p_188338_, p_188339_, p_188340_, p_188341_);
        DimensionType.m_156718_($$17).error().ifPresent(p_156692_ -> {
            throw new IllegalStateException(p_156692_.message());
        });
        return $$17;
    }

    @Deprecated
    private DimensionType(OptionalLong p_188296_, boolean p_188297_, boolean p_188298_, boolean p_188299_, boolean p_188300_, double p_188301_, boolean p_188302_, boolean p_188303_, boolean p_188304_, boolean p_188305_, boolean p_188306_, int p_188307_, int p_188308_, int p_188309_, ResourceLocation p_188310_, ResourceLocation p_188311_, float p_188312_) {
        this.f_63854_ = p_188296_;
        this.f_63855_ = p_188297_;
        this.f_63856_ = p_188298_;
        this.f_63857_ = p_188299_;
        this.f_63858_ = p_188300_;
        this.f_63859_ = p_188301_;
        this.f_63860_ = p_188302_;
        this.f_63861_ = p_188303_;
        this.f_63862_ = p_188304_;
        this.f_63863_ = p_188305_;
        this.f_63864_ = p_188306_;
        this.f_156647_ = p_188307_;
        this.f_156648_ = p_188308_;
        this.f_63865_ = p_188309_;
        this.f_63836_ = p_188310_;
        this.f_63837_ = p_188311_;
        this.f_63838_ = p_188312_;
        this.f_63839_ = DimensionType.m_63900_(p_188312_);
    }

    private static float[] m_63900_(float p_63901_) {
        float[] $$1 = new float[16];
        for (int $$2 = 0; $$2 <= 15; ++$$2) {
            float $$3 = (float)$$2 / 15.0f;
            float $$4 = $$3 / (4.0f - 3.0f * $$3);
            $$1[$$2] = Mth.m_14179_(p_63901_, $$4, 1.0f);
        }
        return $$1;
    }

    @Deprecated
    public static DataResult<ResourceKey<Level>> m_63911_(Dynamic<?> p_63912_) {
        Optional $$1 = p_63912_.asNumber().result();
        if ($$1.isPresent()) {
            int $$2 = ((Number)$$1.get()).intValue();
            if ($$2 == -1) {
                return DataResult.success(Level.f_46429_);
            }
            if ($$2 == 0) {
                return DataResult.success(Level.f_46428_);
            }
            if ($$2 == 1) {
                return DataResult.success(Level.f_46430_);
            }
        }
        return Level.f_46427_.parse(p_63912_);
    }

    public static RegistryAccess m_188315_(RegistryAccess p_188316_) {
        WritableRegistry<DimensionType> $$1 = p_188316_.m_175512_(Registry.f_122818_);
        $$1.m_7135_(f_63845_, f_63848_, Lifecycle.stable());
        $$1.m_7135_(f_63851_, f_63852_, Lifecycle.stable());
        $$1.m_7135_(f_63846_, f_63849_, Lifecycle.stable());
        $$1.m_7135_(f_63847_, f_63850_, Lifecycle.stable());
        return p_188316_;
    }

    public static MappedRegistry<LevelStem> m_188317_(RegistryAccess p_188318_, long p_188319_) {
        return DimensionType.m_188320_(p_188318_, p_188319_, true);
    }

    public static MappedRegistry<LevelStem> m_188320_(RegistryAccess p_188321_, long p_188322_, boolean p_188323_) {
        MappedRegistry<LevelStem> $$3 = new MappedRegistry<LevelStem>(Registry.f_122820_, Lifecycle.experimental());
        Registry<DimensionType> $$4 = p_188321_.m_175515_(Registry.f_122818_);
        Registry<Biome> $$5 = p_188321_.m_175515_(Registry.f_122885_);
        Registry<NoiseGeneratorSettings> $$6 = p_188321_.m_175515_(Registry.f_122878_);
        Registry<NormalNoise.NoiseParameters> $$7 = p_188321_.m_175515_(Registry.f_194568_);
        $$3.m_7135_(LevelStem.f_63972_, new LevelStem(() -> $$4.m_123013_(f_63846_), new NoiseBasedChunkGenerator($$7, (BiomeSource)MultiNoiseBiomeSource.Preset.f_48512_.m_187104_($$5, p_188323_), p_188322_, () -> $$6.m_123013_(NoiseGeneratorSettings.f_64434_))), Lifecycle.stable());
        $$3.m_7135_(LevelStem.f_63973_, new LevelStem(() -> $$4.m_123013_(f_63847_), new NoiseBasedChunkGenerator($$7, (BiomeSource)new TheEndBiomeSource($$5, p_188322_), p_188322_, () -> $$6.m_123013_(NoiseGeneratorSettings.f_64435_))), Lifecycle.stable());
        return $$3;
    }

    public static double m_63908_(DimensionType p_63909_, DimensionType p_63910_) {
        double $$2 = p_63909_.m_63959_();
        double $$3 = p_63910_.m_63959_();
        return $$2 / $$3;
    }

    @Deprecated
    public String m_63899_() {
        if (this.m_63906_(f_63850_)) {
            return "_end";
        }
        return "";
    }

    public static Path m_196975_(ResourceKey<Level> p_196976_, Path p_196977_) {
        if (p_196976_ == Level.f_46428_) {
            return p_196977_;
        }
        if (p_196976_ == Level.f_46430_) {
            return p_196977_.resolve("DIM1");
        }
        if (p_196976_ == Level.f_46429_) {
            return p_196977_.resolve("DIM-1");
        }
        return p_196977_.resolve("dimensions").resolve(p_196976_.m_135782_().m_135827_()).resolve(p_196976_.m_135782_().m_135815_());
    }

    public boolean m_63935_() {
        return this.f_63855_;
    }

    public boolean m_63946_() {
        return this.f_63856_;
    }

    public boolean m_63951_() {
        return this.f_63857_;
    }

    public boolean m_63956_() {
        return this.f_63858_;
    }

    public double m_63959_() {
        return this.f_63859_;
    }

    public boolean m_63960_() {
        return this.f_63861_;
    }

    public boolean m_63961_() {
        return this.f_63862_;
    }

    public boolean m_63962_() {
        return this.f_63863_;
    }

    public boolean m_63963_() {
        return this.f_63864_;
    }

    public int m_156732_() {
        return this.f_156647_;
    }

    public int m_156733_() {
        return this.f_156648_;
    }

    public int m_63964_() {
        return this.f_63865_;
    }

    public boolean m_63965_() {
        return this.f_63860_;
    }

    public boolean m_63967_() {
        return this.f_63854_.isPresent();
    }

    public float m_63904_(long p_63905_) {
        double $$1 = Mth.m_14185_((double)this.f_63854_.orElse(p_63905_) / 24000.0 - 0.25);
        double $$2 = 0.5 - Math.cos($$1 * Math.PI) / 2.0;
        return (float)($$1 * 2.0 + $$2) / 3.0f;
    }

    public int m_63936_(long p_63937_) {
        return (int)(p_63937_ / 24000L % 8L + 8L) % 8;
    }

    public float m_63902_(int p_63903_) {
        return this.f_63839_[p_63903_];
    }

    public Tag<Block> m_63968_() {
        Tag<Block> $$0 = BlockTags.m_13115_().m_13404_(this.f_63836_);
        return $$0 != null ? $$0 : BlockTags.f_13058_;
    }

    public ResourceLocation m_63969_() {
        return this.f_63837_;
    }

    public boolean m_63906_(DimensionType p_63907_) {
        if (this == p_63907_) {
            return true;
        }
        return this.f_63855_ == p_63907_.f_63855_ && this.f_63856_ == p_63907_.f_63856_ && this.f_63857_ == p_63907_.f_63857_ && this.f_63858_ == p_63907_.f_63858_ && this.f_63859_ == p_63907_.f_63859_ && this.f_63860_ == p_63907_.f_63860_ && this.f_63861_ == p_63907_.f_63861_ && this.f_63862_ == p_63907_.f_63862_ && this.f_63863_ == p_63907_.f_63863_ && this.f_63864_ == p_63907_.f_63864_ && this.f_156647_ == p_63907_.f_156647_ && this.f_156648_ == p_63907_.f_156648_ && this.f_63865_ == p_63907_.f_63865_ && Float.compare(p_63907_.f_63838_, this.f_63838_) == 0 && this.f_63854_.equals(p_63907_.f_63854_) && this.f_63836_.equals(p_63907_.f_63836_) && this.f_63837_.equals(p_63907_.f_63837_);
    }
}

