/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;

public final class LevelStem {
    public static final Codec<LevelStem> f_63970_ = RecordCodecBuilder.create(p_63986_ -> p_63986_.group((App)DimensionType.f_63853_.fieldOf("type").flatXmap(ExtraCodecs.m_181037_(), ExtraCodecs.m_181037_()).forGetter(LevelStem::m_63981_), (App)ChunkGenerator.f_62136_.fieldOf("generator").forGetter(LevelStem::m_63990_)).apply((Applicative)p_63986_, p_63986_.stable(LevelStem::new)));
    public static final ResourceKey<LevelStem> f_63971_ = ResourceKey.m_135785_(Registry.f_122820_, new ResourceLocation("overworld"));
    public static final ResourceKey<LevelStem> f_63972_ = ResourceKey.m_135785_(Registry.f_122820_, new ResourceLocation("the_nether"));
    public static final ResourceKey<LevelStem> f_63973_ = ResourceKey.m_135785_(Registry.f_122820_, new ResourceLocation("the_end"));
    private static final Set<ResourceKey<LevelStem>> f_63974_ = Sets.newLinkedHashSet((Iterable)ImmutableList.of(f_63971_, f_63972_, f_63973_));
    private final Supplier<DimensionType> f_63975_;
    private final ChunkGenerator f_63976_;

    public LevelStem(Supplier<DimensionType> p_63979_, ChunkGenerator p_63980_) {
        this.f_63975_ = p_63979_;
        this.f_63976_ = p_63980_;
    }

    public Supplier<DimensionType> m_63981_() {
        return this.f_63975_;
    }

    public DimensionType m_63989_() {
        return this.f_63975_.get();
    }

    public ChunkGenerator m_63990_() {
        return this.f_63976_;
    }

    public static MappedRegistry<LevelStem> m_63987_(MappedRegistry<LevelStem> p_63988_) {
        MappedRegistry<LevelStem> $$1 = new MappedRegistry<LevelStem>(Registry.f_122820_, Lifecycle.experimental());
        for (ResourceKey<LevelStem> resourceKey : f_63974_) {
            LevelStem $$3 = p_63988_.m_6246_(resourceKey);
            if ($$3 == null) continue;
            $$1.m_7135_(resourceKey, $$3, p_63988_.m_6228_($$3));
        }
        for (Map.Entry entry : p_63988_.m_6579_()) {
            ResourceKey $$5 = (ResourceKey)entry.getKey();
            if (f_63974_.contains($$5)) continue;
            $$1.m_7135_($$5, (LevelStem)entry.getValue(), p_63988_.m_6228_((LevelStem)entry.getValue()));
        }
        return $$1;
    }

    public static boolean m_63982_(long p_63983_, MappedRegistry<LevelStem> p_63984_) {
        ArrayList $$2 = Lists.newArrayList(p_63984_.m_6579_());
        if ($$2.size() != f_63974_.size()) {
            return false;
        }
        Map.Entry $$3 = (Map.Entry)$$2.get(0);
        Map.Entry $$4 = (Map.Entry)$$2.get(1);
        Map.Entry $$5 = (Map.Entry)$$2.get(2);
        if ($$3.getKey() != f_63971_ || $$4.getKey() != f_63972_ || $$5.getKey() != f_63973_) {
            return false;
        }
        if (!((LevelStem)$$3.getValue()).m_63989_().m_63906_(DimensionType.f_63848_) && ((LevelStem)$$3.getValue()).m_63989_() != DimensionType.f_63852_) {
            return false;
        }
        if (!((LevelStem)$$4.getValue()).m_63989_().m_63906_(DimensionType.f_63849_)) {
            return false;
        }
        if (!((LevelStem)$$5.getValue()).m_63989_().m_63906_(DimensionType.f_63850_)) {
            return false;
        }
        if (!(((LevelStem)$$4.getValue()).m_63990_() instanceof NoiseBasedChunkGenerator) || !(((LevelStem)$$5.getValue()).m_63990_() instanceof NoiseBasedChunkGenerator)) {
            return false;
        }
        NoiseBasedChunkGenerator $$6 = (NoiseBasedChunkGenerator)((LevelStem)$$4.getValue()).m_63990_();
        NoiseBasedChunkGenerator $$7 = (NoiseBasedChunkGenerator)((LevelStem)$$5.getValue()).m_63990_();
        if (!$$6.m_64375_(p_63983_, NoiseGeneratorSettings.f_64434_)) {
            return false;
        }
        if (!$$7.m_64375_(p_63983_, NoiseGeneratorSettings.f_64435_)) {
            return false;
        }
        if (!($$6.m_62218_() instanceof MultiNoiseBiomeSource)) {
            return false;
        }
        MultiNoiseBiomeSource $$8 = (MultiNoiseBiomeSource)$$6.m_62218_();
        if (!$$8.m_187063_(MultiNoiseBiomeSource.Preset.f_48512_)) {
            return false;
        }
        BiomeSource $$9 = ((LevelStem)$$3.getValue()).m_63990_().m_62218_();
        if ($$9 instanceof MultiNoiseBiomeSource && !((MultiNoiseBiomeSource)$$9).m_187063_(MultiNoiseBiomeSource.Preset.f_187087_)) {
            return false;
        }
        if (!($$7.m_62218_() instanceof TheEndBiomeSource)) {
            return false;
        }
        TheEndBiomeSource $$10 = (TheEndBiomeSource)$$7.m_62218_();
        return $$10.m_48653_(p_63983_);
    }
}

