/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.SurfaceRuleData;
import net.minecraft.data.worldgen.TerrainProvider;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.NoiseSlider;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;

public final class NoiseGeneratorSettings {
    public static final Codec<NoiseGeneratorSettings> f_64430_ = RecordCodecBuilder.create(p_64475_ -> p_64475_.group((App)StructureSettings.f_64579_.fieldOf("structures").forGetter(NoiseGeneratorSettings::m_64457_), (App)NoiseSettings.f_64507_.fieldOf("noise").forGetter(NoiseGeneratorSettings::m_64481_), (App)BlockState.f_61039_.fieldOf("default_block").forGetter(NoiseGeneratorSettings::m_64482_), (App)BlockState.f_61039_.fieldOf("default_fluid").forGetter(NoiseGeneratorSettings::m_64483_), (App)SurfaceRules.RuleSource.f_189682_.fieldOf("surface_rule").forGetter(NoiseGeneratorSettings::m_188891_), (App)Codec.INT.fieldOf("sea_level").forGetter(NoiseGeneratorSettings::m_64486_), (App)Codec.BOOL.fieldOf("disable_mob_generation").forGetter(NoiseGeneratorSettings::m_64487_), (App)Codec.BOOL.fieldOf("aquifers_enabled").forGetter(NoiseGeneratorSettings::m_158567_), (App)Codec.BOOL.fieldOf("noise_caves_enabled").forGetter(NoiseGeneratorSettings::m_158568_), (App)Codec.BOOL.fieldOf("ore_veins_enabled").forGetter(NoiseGeneratorSettings::m_158570_), (App)Codec.BOOL.fieldOf("noodle_caves_enabled").forGetter(NoiseGeneratorSettings::m_158571_), (App)Codec.BOOL.fieldOf("legacy_random_source").forGetter(NoiseGeneratorSettings::m_188892_)).apply((Applicative)p_64475_, NoiseGeneratorSettings::new));
    public static final Codec<Supplier<NoiseGeneratorSettings>> f_64431_ = RegistryFileCodec.m_135589_(Registry.f_122878_, f_64430_);
    private final WorldgenRandom.Algorithm f_188870_;
    private final StructureSettings f_64438_;
    private final NoiseSettings f_64439_;
    private final BlockState f_64440_;
    private final BlockState f_64441_;
    private final SurfaceRules.RuleSource f_188871_;
    private final int f_64444_;
    private final boolean f_64445_;
    private final boolean f_158533_;
    private final boolean f_158534_;
    private final boolean f_158536_;
    private final boolean f_158537_;
    public static final ResourceKey<NoiseGeneratorSettings> f_64432_ = ResourceKey.m_135785_(Registry.f_122878_, new ResourceLocation("overworld"));
    public static final ResourceKey<NoiseGeneratorSettings> f_188869_ = ResourceKey.m_135785_(Registry.f_122878_, new ResourceLocation("large_biomes"));
    public static final ResourceKey<NoiseGeneratorSettings> f_64433_ = ResourceKey.m_135785_(Registry.f_122878_, new ResourceLocation("amplified"));
    public static final ResourceKey<NoiseGeneratorSettings> f_64434_ = ResourceKey.m_135785_(Registry.f_122878_, new ResourceLocation("nether"));
    public static final ResourceKey<NoiseGeneratorSettings> f_64435_ = ResourceKey.m_135785_(Registry.f_122878_, new ResourceLocation("end"));
    public static final ResourceKey<NoiseGeneratorSettings> f_64436_ = ResourceKey.m_135785_(Registry.f_122878_, new ResourceLocation("caves"));
    public static final ResourceKey<NoiseGeneratorSettings> f_64437_ = ResourceKey.m_135785_(Registry.f_122878_, new ResourceLocation("floating_islands"));

    private NoiseGeneratorSettings(StructureSettings p_188873_, NoiseSettings p_188874_, BlockState p_188875_, BlockState p_188876_, SurfaceRules.RuleSource p_188877_, int p_188878_, boolean p_188879_, boolean p_188880_, boolean p_188881_, boolean p_188882_, boolean p_188883_, boolean p_188884_) {
        this.f_64438_ = p_188873_;
        this.f_64439_ = p_188874_;
        this.f_64440_ = p_188875_;
        this.f_64441_ = p_188876_;
        this.f_188871_ = p_188877_;
        this.f_64444_ = p_188878_;
        this.f_64445_ = p_188879_;
        this.f_158533_ = p_188880_;
        this.f_158534_ = p_188881_;
        this.f_158536_ = p_188882_;
        this.f_158537_ = p_188883_;
        this.f_188870_ = p_188884_ ? WorldgenRandom.Algorithm.LEGACY : WorldgenRandom.Algorithm.XOROSHIRO;
    }

    public StructureSettings m_64457_() {
        return this.f_64438_;
    }

    public NoiseSettings m_64481_() {
        return this.f_64439_;
    }

    public BlockState m_64482_() {
        return this.f_64440_;
    }

    public BlockState m_64483_() {
        return this.f_64441_;
    }

    public SurfaceRules.RuleSource m_188891_() {
        return this.f_188871_;
    }

    public int m_64486_() {
        return this.f_64444_;
    }

    @Deprecated
    protected boolean m_64487_() {
        return this.f_64445_;
    }

    public boolean m_158567_() {
        return this.f_158533_;
    }

    public boolean m_158568_() {
        return this.f_158534_;
    }

    public boolean m_158570_() {
        return this.f_158536_;
    }

    public boolean m_158571_() {
        return this.f_158537_;
    }

    public boolean m_188892_() {
        return this.f_188870_ == WorldgenRandom.Algorithm.LEGACY;
    }

    public RandomSource m_188885_(long p_188886_) {
        return this.m_188893_().m_190084_(p_188886_);
    }

    public WorldgenRandom.Algorithm m_188893_() {
        return this.f_188870_;
    }

    public boolean m_64476_(ResourceKey<NoiseGeneratorSettings> p_64477_) {
        return Objects.equals(this, BuiltinRegistries.f_123866_.m_6246_(p_64477_));
    }

    private static void m_198262_(ResourceKey<NoiseGeneratorSettings> p_198263_, NoiseGeneratorSettings p_198264_) {
        BuiltinRegistries.m_123880_(BuiltinRegistries.f_123866_, p_198263_.m_135782_(), p_198264_);
    }

    public static NoiseGeneratorSettings m_64488_() {
        return (NoiseGeneratorSettings)BuiltinRegistries.f_123866_.iterator().next();
    }

    private static NoiseGeneratorSettings m_198268_() {
        return new NoiseGeneratorSettings(new StructureSettings(false), NoiseSettings.m_189199_(0, 128, new NoiseSamplingSettings(2.0, 1.0, 80.0, 160.0), new NoiseSlider(-23.4375, 64, -46), new NoiseSlider(-0.234375, 7, 1), 2, 1, true, false, false, TerrainProvider.m_194818_()), Blocks.f_50259_.m_49966_(), Blocks.f_50016_.m_49966_(), SurfaceRuleData.m_194813_(), 0, true, false, false, false, false, true);
    }

    private static NoiseGeneratorSettings m_198269_() {
        HashMap $$0 = Maps.newHashMap(StructureSettings.f_64580_);
        $$0.put(StructureFeature.f_67019_, new StructureFeatureConfiguration(25, 10, 34222645));
        return new NoiseGeneratorSettings(new StructureSettings(Optional.empty(), $$0), NoiseSettings.m_189199_(0, 128, new NoiseSamplingSettings(1.0, 3.0, 80.0, 60.0), new NoiseSlider(0.9375, 3, 0), new NoiseSlider(2.5, 4, -1), 1, 2, false, false, false, TerrainProvider.m_194815_()), Blocks.f_50134_.m_49966_(), Blocks.f_49991_.m_49966_(), SurfaceRuleData.m_194812_(), 32, false, false, false, false, false, true);
    }

    private static NoiseGeneratorSettings m_198265_(boolean p_198266_, boolean p_198267_) {
        return new NoiseGeneratorSettings(new StructureSettings(true), NoiseSettings.m_189199_(-64, 384, new NoiseSamplingSettings(1.0, 1.0, 80.0, 160.0), new NoiseSlider(-0.078125, 2, p_198266_ ? 0 : 8), new NoiseSlider(p_198266_ ? 0.4 : 0.1171875, 3, 0), 1, 2, false, p_198266_, p_198267_, TerrainProvider.m_194816_(p_198266_)), Blocks.f_50069_.m_49966_(), Blocks.f_49990_.m_49966_(), SurfaceRuleData.m_194807_(), 63, false, true, true, true, true, false);
    }

    private static NoiseGeneratorSettings m_198270_() {
        return new NoiseGeneratorSettings(new StructureSettings(false), NoiseSettings.m_189199_(-64, 192, new NoiseSamplingSettings(1.0, 3.0, 80.0, 60.0), new NoiseSlider(0.9375, 3, 0), new NoiseSlider(2.5, 4, -1), 1, 2, false, false, false, TerrainProvider.m_198384_()), Blocks.f_50069_.m_49966_(), Blocks.f_49990_.m_49966_(), SurfaceRuleData.m_198380_(false, true, true), 32, false, false, false, false, false, true);
    }

    private static NoiseGeneratorSettings m_198271_() {
        return new NoiseGeneratorSettings(new StructureSettings(true), NoiseSettings.m_189199_(0, 256, new NoiseSamplingSettings(2.0, 1.0, 80.0, 160.0), new NoiseSlider(-23.4375, 64, -46), new NoiseSlider(-0.234375, 7, 1), 2, 1, false, false, false, TerrainProvider.m_198385_()), Blocks.f_50069_.m_49966_(), Blocks.f_49990_.m_49966_(), SurfaceRuleData.m_198380_(false, false, false), -64, false, false, false, false, false, true);
    }

    static {
        NoiseGeneratorSettings.m_198262_(f_64432_, NoiseGeneratorSettings.m_198265_(false, false));
        NoiseGeneratorSettings.m_198262_(f_188869_, NoiseGeneratorSettings.m_198265_(false, true));
        NoiseGeneratorSettings.m_198262_(f_64433_, NoiseGeneratorSettings.m_198265_(true, false));
        NoiseGeneratorSettings.m_198262_(f_64434_, NoiseGeneratorSettings.m_198269_());
        NoiseGeneratorSettings.m_198262_(f_64435_, NoiseGeneratorSettings.m_198268_());
        NoiseGeneratorSettings.m_198262_(f_64436_, NoiseGeneratorSettings.m_198270_());
        NoiseGeneratorSettings.m_198262_(f_64437_, NoiseGeneratorSettings.m_198271_());
    }
}

