/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import net.minecraft.core.QuartPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.NoiseSlider;

public record NoiseSettings(int f_158688_, int f_64508_, NoiseSamplingSettings f_64509_, NoiseSlider f_64510_, NoiseSlider f_64511_, int f_64512_, int f_64513_, boolean f_64518_, boolean f_64519_, boolean f_189185_, TerrainShaper f_189186_) {
    public static final Codec<NoiseSettings> f_64507_ = RecordCodecBuilder.create(p_64536_ -> p_64536_.group((App)Codec.intRange((int)DimensionType.f_156653_, (int)DimensionType.f_156652_).fieldOf("min_y").forGetter(NoiseSettings::f_158688_), (App)Codec.intRange((int)0, (int)DimensionType.f_156651_).fieldOf("height").forGetter(NoiseSettings::f_64508_), (App)NoiseSamplingSettings.f_64489_.fieldOf("sampling").forGetter(NoiseSettings::f_64509_), (App)NoiseSlider.f_189223_.fieldOf("top_slide").forGetter(NoiseSettings::f_64510_), (App)NoiseSlider.f_189223_.fieldOf("bottom_slide").forGetter(NoiseSettings::f_64511_), (App)Codec.intRange((int)1, (int)4).fieldOf("size_horizontal").forGetter(NoiseSettings::f_64512_), (App)Codec.intRange((int)1, (int)4).fieldOf("size_vertical").forGetter(NoiseSettings::f_64513_), (App)Codec.BOOL.optionalFieldOf("island_noise_override", (Object)false, Lifecycle.experimental()).forGetter(NoiseSettings::f_64518_), (App)Codec.BOOL.optionalFieldOf("amplified", (Object)false, Lifecycle.experimental()).forGetter(NoiseSettings::f_64519_), (App)Codec.BOOL.optionalFieldOf("large_biomes", (Object)false, Lifecycle.experimental()).forGetter(NoiseSettings::f_189185_), (App)TerrainShaper.f_187252_.fieldOf("terrain_shaper").forGetter(NoiseSettings::f_189186_)).apply((Applicative)p_64536_, NoiseSettings::new)).comapFlatMap(NoiseSettings::m_158720_, Function.identity());

    private static DataResult<NoiseSettings> m_158720_(NoiseSettings p_158721_) {
        if (p_158721_.f_158688_() + p_158721_.f_64508_() > DimensionType.f_156652_ + 1) {
            return DataResult.error((String)("min_y + height cannot be higher than: " + (DimensionType.f_156652_ + 1)));
        }
        if (p_158721_.f_64508_() % 16 != 0) {
            return DataResult.error((String)"height has to be a multiple of 16");
        }
        if (p_158721_.f_158688_() % 16 != 0) {
            return DataResult.error((String)"min_y has to be a multiple of 16");
        }
        return DataResult.success((Object)p_158721_);
    }

    public static NoiseSettings m_189199_(int p_189200_, int p_189201_, NoiseSamplingSettings p_189202_, NoiseSlider p_189203_, NoiseSlider p_189204_, int p_189205_, int p_189206_, boolean p_189207_, boolean p_189208_, boolean p_189209_, TerrainShaper p_189210_) {
        NoiseSettings $$11 = new NoiseSettings(p_189200_, p_189201_, p_189202_, p_189203_, p_189204_, p_189205_, p_189206_, p_189207_, p_189208_, p_189209_, p_189210_);
        NoiseSettings.m_158720_($$11).error().ifPresent(p_158719_ -> {
            throw new IllegalStateException(p_158719_.message());
        });
        return $$11;
    }

    public int m_189212_() {
        return QuartPos.m_175402_(this.f_64513_());
    }

    public int m_189213_() {
        return QuartPos.m_175402_(this.f_64512_());
    }

    public int m_189216_() {
        return this.f_64508_() / this.m_189212_();
    }

    public int m_189217_() {
        return Mth.m_14042_(this.f_158688_(), this.m_189212_());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSamplingSettings;topSlideSettings;bottomSlideSettings;noiseSizeHorizontal;noiseSizeVertical;islandNoiseOverride;isAmplified;largeBiomes;terrainShaper", "f_158688_", "f_64508_", "f_64509_", "f_64510_", "f_64511_", "f_64512_", "f_64513_", "f_64518_", "f_64519_", "f_189185_", "f_189186_"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSamplingSettings;topSlideSettings;bottomSlideSettings;noiseSizeHorizontal;noiseSizeVertical;islandNoiseOverride;isAmplified;largeBiomes;terrainShaper", "f_158688_", "f_64508_", "f_64509_", "f_64510_", "f_64511_", "f_64512_", "f_64513_", "f_64518_", "f_64519_", "f_189185_", "f_189186_"}, this);
    }

    @Override
    public final boolean equals(Object p_189215_) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSamplingSettings;topSlideSettings;bottomSlideSettings;noiseSizeHorizontal;noiseSizeVertical;islandNoiseOverride;isAmplified;largeBiomes;terrainShaper", "f_158688_", "f_64508_", "f_64509_", "f_64510_", "f_64511_", "f_64512_", "f_64513_", "f_64518_", "f_64519_", "f_189185_", "f_189186_"}, this, p_189215_);
    }
}

