/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RuinedPortalConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.RuinedPortalPiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class RuinedPortalFeature
extends StructureFeature<RuinedPortalConfiguration> {
    private static final String[] f_66664_ = new String[]{"ruined_portal/portal_1", "ruined_portal/portal_2", "ruined_portal/portal_3", "ruined_portal/portal_4", "ruined_portal/portal_5", "ruined_portal/portal_6", "ruined_portal/portal_7", "ruined_portal/portal_8", "ruined_portal/portal_9", "ruined_portal/portal_10"};
    private static final String[] f_66665_ = new String[]{"ruined_portal/giant_portal_1", "ruined_portal/giant_portal_2", "ruined_portal/giant_portal_3"};
    private static final float f_160264_ = 0.05f;
    private static final float f_160265_ = 0.5f;
    private static final float f_160266_ = 0.5f;
    private static final float f_160260_ = 0.8f;
    private static final float f_160261_ = 0.8f;
    private static final float f_160262_ = 0.5f;
    private static final int f_191079_ = 15;

    public RuinedPortalFeature(Codec<RuinedPortalConfiguration> p_66668_) {
        super(p_66668_, RuinedPortalFeature::m_197152_);
    }

    private static Optional<PieceGenerator<RuinedPortalConfiguration>> m_197152_(PieceGeneratorSupplier.Context<RuinedPortalConfiguration> p_197153_) {
        ResourceLocation $$14;
        RuinedPortalPiece.VerticalPlacement $$12;
        RuinedPortalPiece.Properties $$1 = new RuinedPortalPiece.Properties();
        RuinedPortalConfiguration $$2 = p_197153_.f_197356_();
        WorldgenRandom $$3 = new WorldgenRandom(new LegacyRandomSource(0L));
        $$3.m_190068_(p_197153_.f_197354_(), p_197153_.f_197355_().f_45578_, p_197153_.f_197355_().f_45579_);
        if ($$2.f_68055_ == Type.DESERT) {
            RuinedPortalPiece.VerticalPlacement $$4 = RuinedPortalPiece.VerticalPlacement.PARTLY_BURIED;
            $$1.f_72738_ = false;
            $$1.f_72737_ = 0.0f;
        } else if ($$2.f_68055_ == Type.JUNGLE) {
            RuinedPortalPiece.VerticalPlacement $$5 = RuinedPortalPiece.VerticalPlacement.ON_LAND_SURFACE;
            $$1.f_72738_ = $$3.nextFloat() < 0.5f;
            $$1.f_72737_ = 0.8f;
            $$1.f_72739_ = true;
            $$1.f_72740_ = true;
        } else if ($$2.f_68055_ == Type.SWAMP) {
            RuinedPortalPiece.VerticalPlacement $$6 = RuinedPortalPiece.VerticalPlacement.ON_OCEAN_FLOOR;
            $$1.f_72738_ = false;
            $$1.f_72737_ = 0.5f;
            $$1.f_72740_ = true;
        } else if ($$2.f_68055_ == Type.MOUNTAIN) {
            boolean $$7 = $$3.nextFloat() < 0.5f;
            RuinedPortalPiece.VerticalPlacement $$8 = $$7 ? RuinedPortalPiece.VerticalPlacement.IN_MOUNTAIN : RuinedPortalPiece.VerticalPlacement.ON_LAND_SURFACE;
            $$1.f_72738_ = $$7 || $$3.nextFloat() < 0.5f;
        } else if ($$2.f_68055_ == Type.OCEAN) {
            RuinedPortalPiece.VerticalPlacement $$9 = RuinedPortalPiece.VerticalPlacement.ON_OCEAN_FLOOR;
            $$1.f_72738_ = false;
            $$1.f_72737_ = 0.8f;
        } else if ($$2.f_68055_ == Type.NETHER) {
            RuinedPortalPiece.VerticalPlacement $$10 = RuinedPortalPiece.VerticalPlacement.IN_NETHER;
            $$1.f_72738_ = $$3.nextFloat() < 0.5f;
            $$1.f_72737_ = 0.0f;
            $$1.f_72741_ = true;
        } else {
            boolean $$11 = $$3.nextFloat() < 0.5f;
            $$12 = $$11 ? RuinedPortalPiece.VerticalPlacement.UNDERGROUND : RuinedPortalPiece.VerticalPlacement.ON_LAND_SURFACE;
            boolean bl = $$1.f_72738_ = $$11 || $$3.nextFloat() < 0.5f;
        }
        if ($$3.nextFloat() < 0.05f) {
            ResourceLocation $$13 = new ResourceLocation(f_66665_[$$3.nextInt(f_66665_.length)]);
        } else {
            $$14 = new ResourceLocation(f_66664_[$$3.nextInt(f_66664_.length)]);
        }
        StructureTemplate $$15 = p_197153_.f_197359_().m_74341_($$14);
        Rotation $$16 = Util.m_137545_(Rotation.values(), $$3);
        Mirror $$17 = $$3.nextFloat() < 0.5f ? Mirror.NONE : Mirror.FRONT_BACK;
        BlockPos $$18 = new BlockPos($$15.m_163801_().m_123341_() / 2, 0, $$15.m_163801_().m_123343_() / 2);
        BlockPos $$19 = p_197153_.f_197355_().m_45615_();
        BoundingBox $$20 = $$15.m_74598_($$19, $$16, $$18, $$17);
        BlockPos $$21 = $$20.m_162394_();
        int $$22 = p_197153_.f_197352_().m_142647_($$21.m_123341_(), $$21.m_123343_(), RuinedPortalPiece.m_72692_($$12), p_197153_.f_197357_()) - 1;
        int $$23 = RuinedPortalFeature.m_160271_($$3, p_197153_.f_197352_(), $$12, $$1.f_72738_, $$22, $$20.m_71057_(), $$20, p_197153_.f_197357_());
        BlockPos $$24 = new BlockPos($$19.m_123341_(), $$23, $$19.m_123343_());
        if (!p_197153_.f_197358_().test(p_197153_.f_197352_().m_7158_(QuartPos.m_175400_($$24.m_123341_()), QuartPos.m_175400_($$24.m_123342_()), QuartPos.m_175400_($$24.m_123343_())))) {
            return Optional.empty();
        }
        return Optional.of((p_197150_, p_197151_) -> {
            if (p_197140_.f_68055_ == Type.MOUNTAIN || p_197140_.f_68055_ == Type.OCEAN || p_197140_.f_68055_ == Type.STANDARD) {
                p_197141_.f_72736_ = RuinedPortalFeature.m_66688_($$24, p_197153_.f_197352_().m_7158_(QuartPos.m_175400_($$24.m_123341_()), QuartPos.m_175400_($$24.m_123342_()), QuartPos.m_175400_($$24.m_123343_())));
            }
            p_197150_.m_142679_(new RuinedPortalPiece(p_197151_.f_192704_(), $$24, $$12, $$1, $$14, $$15, $$16, $$17, $$18));
        });
    }

    private static boolean m_66688_(BlockPos p_66689_, Biome p_66690_) {
        return p_66690_.m_198904_(p_66689_);
    }

    private static int m_160271_(Random p_160272_, ChunkGenerator p_160273_, RuinedPortalPiece.VerticalPlacement p_160274_, boolean p_160275_, int p_160276_, int p_160277_, BoundingBox p_160278_, LevelHeightAccessor p_160279_) {
        int $$21;
        int $$8 = p_160279_.m_141937_() + 15;
        if (p_160274_ == RuinedPortalPiece.VerticalPlacement.IN_NETHER) {
            if (p_160275_) {
                int $$9 = Mth.m_144928_(p_160272_, 32, 100);
            } else if (p_160272_.nextFloat() < 0.5f) {
                int $$10 = Mth.m_144928_(p_160272_, 27, 29);
            } else {
                int $$11 = Mth.m_144928_(p_160272_, 29, 100);
            }
        } else if (p_160274_ == RuinedPortalPiece.VerticalPlacement.IN_MOUNTAIN) {
            int $$12 = p_160276_ - p_160277_;
            int $$13 = RuinedPortalFeature.m_66691_(p_160272_, 70, $$12);
        } else if (p_160274_ == RuinedPortalPiece.VerticalPlacement.UNDERGROUND) {
            int $$14 = p_160276_ - p_160277_;
            int $$15 = RuinedPortalFeature.m_66691_(p_160272_, $$8, $$14);
        } else if (p_160274_ == RuinedPortalPiece.VerticalPlacement.PARTLY_BURIED) {
            int $$16 = p_160276_ - p_160277_ + Mth.m_144928_(p_160272_, 2, 8);
        } else {
            int $$17 = p_160276_;
        }
        ImmutableList $$18 = ImmutableList.of((Object)new BlockPos(p_160278_.m_162395_(), 0, p_160278_.m_162398_()), (Object)new BlockPos(p_160278_.m_162399_(), 0, p_160278_.m_162398_()), (Object)new BlockPos(p_160278_.m_162395_(), 0, p_160278_.m_162401_()), (Object)new BlockPos(p_160278_.m_162399_(), 0, p_160278_.m_162401_()));
        List $$19 = $$18.stream().map(p_197138_ -> p_160273_.m_141914_(p_197138_.m_123341_(), p_197138_.m_123343_(), p_160279_)).collect(Collectors.toList());
        Heightmap.Types $$20 = p_160274_ == RuinedPortalPiece.VerticalPlacement.ON_OCEAN_FLOOR ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG;
        block0: for ($$21 = $$17; $$21 > $$8; --$$21) {
            int $$22 = 0;
            for (NoiseColumn $$23 : $$19) {
                BlockState $$24 = $$23.m_183556_($$21);
                if (!$$20.m_64299_().test($$24) || ++$$22 != 3) continue;
                break block0;
            }
        }
        return $$21;
    }

    private static int m_66691_(Random p_66692_, int p_66693_, int p_66694_) {
        if (p_66693_ < p_66694_) {
            return Mth.m_144928_(p_66692_, p_66693_, p_66694_);
        }
        return p_66694_;
    }

    public static final class Type
    extends Enum<Type>
    implements StringRepresentable {
        public static final /* enum */ Type STANDARD = new Type("standard");
        public static final /* enum */ Type DESERT = new Type("desert");
        public static final /* enum */ Type JUNGLE = new Type("jungle");
        public static final /* enum */ Type SWAMP = new Type("swamp");
        public static final /* enum */ Type MOUNTAIN = new Type("mountain");
        public static final /* enum */ Type OCEAN = new Type("ocean");
        public static final /* enum */ Type NETHER = new Type("nether");
        public static final Codec<Type> f_66735_;
        private static final Map<String, Type> f_66736_;
        private final String f_66737_;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String p_66751_) {
            return Enum.valueOf(Type.class, p_66751_);
        }

        private Type(String p_66743_) {
            this.f_66737_ = p_66743_;
        }

        public String m_66749_() {
            return this.f_66737_;
        }

        public static Type m_66747_(String p_66748_) {
            return f_66736_.get(p_66748_);
        }

        @Override
        public String m_7912_() {
            return this.f_66737_;
        }

        private static /* synthetic */ Type[] m_160301_() {
            return new Type[]{STANDARD, DESERT, JUNGLE, SWAMP, MOUNTAIN, OCEAN, NETHER};
        }

        static {
            $VALUES = Type.m_160301_();
            f_66735_ = StringRepresentable.m_14350_(Type::values, Type::m_66747_);
            f_66736_ = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::m_66749_, p_66746_ -> p_66746_));
        }
    }
}

