/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

public class OceanMonumentPieces {
    private OceanMonumentPieces() {
    }

    static class FitDoubleYZRoom
    implements MonumentRoomFitter {
        FitDoubleYZRoom() {
        }

        @Override
        public boolean m_7725_(RoomDefinition p_72124_) {
            if (p_72124_.f_72445_[Direction.NORTH.m_122411_()] && !p_72124_.f_72444_[Direction.NORTH.m_122411_()].f_72446_ && p_72124_.f_72445_[Direction.UP.m_122411_()] && !p_72124_.f_72444_[Direction.UP.m_122411_()].f_72446_) {
                RoomDefinition $$1 = p_72124_.f_72444_[Direction.NORTH.m_122411_()];
                return $$1.f_72445_[Direction.UP.m_122411_()] && !$$1.f_72444_[Direction.UP.m_122411_()].f_72446_;
            }
            return false;
        }

        @Override
        public OceanMonumentPiece m_7924_(Direction p_72126_, RoomDefinition p_72127_, Random p_72128_) {
            p_72127_.f_72446_ = true;
            p_72127_.f_72444_[Direction.NORTH.m_122411_()].f_72446_ = true;
            p_72127_.f_72444_[Direction.UP.m_122411_()].f_72446_ = true;
            p_72127_.f_72444_[Direction.NORTH.m_122411_()].f_72444_[Direction.UP.m_122411_()].f_72446_ = true;
            return new OceanMonumentDoubleYZRoom(p_72126_, p_72127_);
        }
    }

    static class FitDoubleXYRoom
    implements MonumentRoomFitter {
        FitDoubleXYRoom() {
        }

        @Override
        public boolean m_7725_(RoomDefinition p_72106_) {
            if (p_72106_.f_72445_[Direction.EAST.m_122411_()] && !p_72106_.f_72444_[Direction.EAST.m_122411_()].f_72446_ && p_72106_.f_72445_[Direction.UP.m_122411_()] && !p_72106_.f_72444_[Direction.UP.m_122411_()].f_72446_) {
                RoomDefinition $$1 = p_72106_.f_72444_[Direction.EAST.m_122411_()];
                return $$1.f_72445_[Direction.UP.m_122411_()] && !$$1.f_72444_[Direction.UP.m_122411_()].f_72446_;
            }
            return false;
        }

        @Override
        public OceanMonumentPiece m_7924_(Direction p_72108_, RoomDefinition p_72109_, Random p_72110_) {
            p_72109_.f_72446_ = true;
            p_72109_.f_72444_[Direction.EAST.m_122411_()].f_72446_ = true;
            p_72109_.f_72444_[Direction.UP.m_122411_()].f_72446_ = true;
            p_72109_.f_72444_[Direction.EAST.m_122411_()].f_72444_[Direction.UP.m_122411_()].f_72446_ = true;
            return new OceanMonumentDoubleXYRoom(p_72108_, p_72109_);
        }
    }

    static class FitDoubleZRoom
    implements MonumentRoomFitter {
        FitDoubleZRoom() {
        }

        @Override
        public boolean m_7725_(RoomDefinition p_72133_) {
            return p_72133_.f_72445_[Direction.NORTH.m_122411_()] && !p_72133_.f_72444_[Direction.NORTH.m_122411_()].f_72446_;
        }

        @Override
        public OceanMonumentPiece m_7924_(Direction p_72135_, RoomDefinition p_72136_, Random p_72137_) {
            RoomDefinition $$3 = p_72136_;
            if (!p_72136_.f_72445_[Direction.NORTH.m_122411_()] || p_72136_.f_72444_[Direction.NORTH.m_122411_()].f_72446_) {
                $$3 = p_72136_.f_72444_[Direction.SOUTH.m_122411_()];
            }
            $$3.f_72446_ = true;
            $$3.f_72444_[Direction.NORTH.m_122411_()].f_72446_ = true;
            return new OceanMonumentDoubleZRoom(p_72135_, $$3);
        }
    }

    static class FitDoubleXRoom
    implements MonumentRoomFitter {
        FitDoubleXRoom() {
        }

        @Override
        public boolean m_7725_(RoomDefinition p_72097_) {
            return p_72097_.f_72445_[Direction.EAST.m_122411_()] && !p_72097_.f_72444_[Direction.EAST.m_122411_()].f_72446_;
        }

        @Override
        public OceanMonumentPiece m_7924_(Direction p_72099_, RoomDefinition p_72100_, Random p_72101_) {
            p_72100_.f_72446_ = true;
            p_72100_.f_72444_[Direction.EAST.m_122411_()].f_72446_ = true;
            return new OceanMonumentDoubleXRoom(p_72099_, p_72100_);
        }
    }

    static class FitDoubleYRoom
    implements MonumentRoomFitter {
        FitDoubleYRoom() {
        }

        @Override
        public boolean m_7725_(RoomDefinition p_72115_) {
            return p_72115_.f_72445_[Direction.UP.m_122411_()] && !p_72115_.f_72444_[Direction.UP.m_122411_()].f_72446_;
        }

        @Override
        public OceanMonumentPiece m_7924_(Direction p_72117_, RoomDefinition p_72118_, Random p_72119_) {
            p_72118_.f_72446_ = true;
            p_72118_.f_72444_[Direction.UP.m_122411_()].f_72446_ = true;
            return new OceanMonumentDoubleYRoom(p_72117_, p_72118_);
        }
    }

    static class FitSimpleTopRoom
    implements MonumentRoomFitter {
        FitSimpleTopRoom() {
        }

        @Override
        public boolean m_7725_(RoomDefinition p_72151_) {
            return !p_72151_.f_72445_[Direction.WEST.m_122411_()] && !p_72151_.f_72445_[Direction.EAST.m_122411_()] && !p_72151_.f_72445_[Direction.NORTH.m_122411_()] && !p_72151_.f_72445_[Direction.SOUTH.m_122411_()] && !p_72151_.f_72445_[Direction.UP.m_122411_()];
        }

        @Override
        public OceanMonumentPiece m_7924_(Direction p_72153_, RoomDefinition p_72154_, Random p_72155_) {
            p_72154_.f_72446_ = true;
            return new OceanMonumentSimpleTopRoom(p_72153_, p_72154_);
        }
    }

    static class FitSimpleRoom
    implements MonumentRoomFitter {
        FitSimpleRoom() {
        }

        @Override
        public boolean m_7725_(RoomDefinition p_72142_) {
            return true;
        }

        @Override
        public OceanMonumentPiece m_7924_(Direction p_72144_, RoomDefinition p_72145_, Random p_72146_) {
            p_72145_.f_72446_ = true;
            return new OceanMonumentSimpleRoom(p_72144_, p_72145_, p_72146_);
        }
    }

    static interface MonumentRoomFitter {
        public boolean m_7725_(RoomDefinition var1);

        public OceanMonumentPiece m_7924_(Direction var1, RoomDefinition var2, Random var3);
    }

    static class RoomDefinition {
        final int f_72443_;
        final RoomDefinition[] f_72444_ = new RoomDefinition[6];
        final boolean[] f_72445_ = new boolean[6];
        boolean f_72446_;
        boolean f_72447_;
        private int f_72448_;

        public RoomDefinition(int p_72450_) {
            this.f_72443_ = p_72450_;
        }

        public void m_72459_(Direction p_72460_, RoomDefinition p_72461_) {
            this.f_72444_[p_72460_.m_122411_()] = p_72461_;
            p_72461_.f_72444_[p_72460_.m_122424_().m_122411_()] = this;
        }

        public void m_72451_() {
            for (int $$0 = 0; $$0 < 6; ++$$0) {
                this.f_72445_[$$0] = this.f_72444_[$$0] != null;
            }
        }

        public boolean m_72452_(int p_72453_) {
            if (this.f_72447_) {
                return true;
            }
            this.f_72448_ = p_72453_;
            for (int $$1 = 0; $$1 < 6; ++$$1) {
                if (this.f_72444_[$$1] == null || !this.f_72445_[$$1] || this.f_72444_[$$1].f_72448_ == p_72453_ || !this.f_72444_[$$1].m_72452_(p_72453_)) continue;
                return true;
            }
            return false;
        }

        public boolean m_72462_() {
            return this.f_72443_ >= 75;
        }

        public int m_72468_() {
            int $$0 = 0;
            for (int $$1 = 0; $$1 < 6; ++$$1) {
                if (!this.f_72445_[$$1]) continue;
                ++$$0;
            }
            return $$0;
        }
    }

    public static class OceanMonumentPenthouse
    extends OceanMonumentPiece {
        public OceanMonumentPenthouse(Direction p_72313_, BoundingBox p_72314_) {
            super(StructurePieceType.f_67126_, p_72313_, 1, p_72314_);
        }

        public OceanMonumentPenthouse(CompoundTag p_192345_) {
            super(StructurePieceType.f_67126_, p_192345_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192347_, StructureFeatureManager p_192348_, ChunkGenerator p_192349_, Random p_192350_, BoundingBox p_192351_, ChunkPos p_192352_, BlockPos p_192353_) {
            this.m_73441_(p_192347_, p_192351_, 2, -1, 2, 11, -1, 11, f_72324_, f_72324_, false);
            this.m_73441_(p_192347_, p_192351_, 0, -1, 0, 1, -1, 11, f_72323_, f_72323_, false);
            this.m_73441_(p_192347_, p_192351_, 12, -1, 0, 13, -1, 11, f_72323_, f_72323_, false);
            this.m_73441_(p_192347_, p_192351_, 2, -1, 0, 11, -1, 1, f_72323_, f_72323_, false);
            this.m_73441_(p_192347_, p_192351_, 2, -1, 12, 11, -1, 13, f_72323_, f_72323_, false);
            this.m_73441_(p_192347_, p_192351_, 0, 0, 0, 0, 0, 13, f_72324_, f_72324_, false);
            this.m_73441_(p_192347_, p_192351_, 13, 0, 0, 13, 0, 13, f_72324_, f_72324_, false);
            this.m_73441_(p_192347_, p_192351_, 1, 0, 0, 12, 0, 0, f_72324_, f_72324_, false);
            this.m_73441_(p_192347_, p_192351_, 1, 0, 13, 12, 0, 13, f_72324_, f_72324_, false);
            for (int $$7 = 2; $$7 <= 11; $$7 += 3) {
                this.m_73434_(p_192347_, f_72327_, 0, 0, $$7, p_192351_);
                this.m_73434_(p_192347_, f_72327_, 13, 0, $$7, p_192351_);
                this.m_73434_(p_192347_, f_72327_, $$7, 0, 0, p_192351_);
            }
            this.m_73441_(p_192347_, p_192351_, 2, 0, 3, 4, 0, 9, f_72324_, f_72324_, false);
            this.m_73441_(p_192347_, p_192351_, 9, 0, 3, 11, 0, 9, f_72324_, f_72324_, false);
            this.m_73441_(p_192347_, p_192351_, 4, 0, 9, 9, 0, 11, f_72324_, f_72324_, false);
            this.m_73434_(p_192347_, f_72324_, 5, 0, 8, p_192351_);
            this.m_73434_(p_192347_, f_72324_, 8, 0, 8, p_192351_);
            this.m_73434_(p_192347_, f_72324_, 10, 0, 10, p_192351_);
            this.m_73434_(p_192347_, f_72324_, 3, 0, 10, p_192351_);
            this.m_73441_(p_192347_, p_192351_, 3, 0, 3, 3, 0, 7, f_72325_, f_72325_, false);
            this.m_73441_(p_192347_, p_192351_, 10, 0, 3, 10, 0, 7, f_72325_, f_72325_, false);
            this.m_73441_(p_192347_, p_192351_, 6, 0, 10, 7, 0, 10, f_72325_, f_72325_, false);
            int $$8 = 3;
            for (int $$9 = 0; $$9 < 2; ++$$9) {
                for (int $$10 = 2; $$10 <= 8; $$10 += 3) {
                    this.m_73441_(p_192347_, p_192351_, $$8, 0, $$10, $$8, 2, $$10, f_72324_, f_72324_, false);
                }
                $$8 = 10;
            }
            this.m_73441_(p_192347_, p_192351_, 5, 0, 10, 5, 2, 10, f_72324_, f_72324_, false);
            this.m_73441_(p_192347_, p_192351_, 8, 0, 10, 8, 2, 10, f_72324_, f_72324_, false);
            this.m_73441_(p_192347_, p_192351_, 6, -1, 7, 7, -1, 8, f_72325_, f_72325_, false);
            this.m_72360_(p_192347_, p_192351_, 6, -1, 3, 7, -1, 4);
            this.m_72354_(p_192347_, p_192351_, 6, 1, 6);
        }
    }

    public static class OceanMonumentWingRoom
    extends OceanMonumentPiece {
        private int f_72427_;

        public OceanMonumentWingRoom(Direction p_72432_, BoundingBox p_72433_, int p_72434_) {
            super(StructurePieceType.f_67129_, p_72432_, 1, p_72433_);
            this.f_72427_ = p_72434_ & 1;
        }

        public OceanMonumentWingRoom(CompoundTag p_192378_) {
            super(StructurePieceType.f_67129_, p_192378_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192380_, StructureFeatureManager p_192381_, ChunkGenerator p_192382_, Random p_192383_, BoundingBox p_192384_, ChunkPos p_192385_, BlockPos p_192386_) {
            if (this.f_72427_ == 0) {
                for (int $$7 = 0; $$7 < 4; ++$$7) {
                    this.m_73441_(p_192380_, p_192384_, 10 - $$7, 3 - $$7, 20 - $$7, 12 + $$7, 3 - $$7, 20, f_72324_, f_72324_, false);
                }
                this.m_73441_(p_192380_, p_192384_, 7, 0, 6, 15, 0, 16, f_72324_, f_72324_, false);
                this.m_73441_(p_192380_, p_192384_, 6, 0, 6, 6, 3, 20, f_72324_, f_72324_, false);
                this.m_73441_(p_192380_, p_192384_, 16, 0, 6, 16, 3, 20, f_72324_, f_72324_, false);
                this.m_73441_(p_192380_, p_192384_, 7, 1, 7, 7, 1, 20, f_72324_, f_72324_, false);
                this.m_73441_(p_192380_, p_192384_, 15, 1, 7, 15, 1, 20, f_72324_, f_72324_, false);
                this.m_73441_(p_192380_, p_192384_, 7, 1, 6, 9, 3, 6, f_72324_, f_72324_, false);
                this.m_73441_(p_192380_, p_192384_, 13, 1, 6, 15, 3, 6, f_72324_, f_72324_, false);
                this.m_73441_(p_192380_, p_192384_, 8, 1, 7, 9, 1, 7, f_72324_, f_72324_, false);
                this.m_73441_(p_192380_, p_192384_, 13, 1, 7, 14, 1, 7, f_72324_, f_72324_, false);
                this.m_73441_(p_192380_, p_192384_, 9, 0, 5, 13, 0, 5, f_72324_, f_72324_, false);
                this.m_73441_(p_192380_, p_192384_, 10, 0, 7, 12, 0, 7, f_72325_, f_72325_, false);
                this.m_73441_(p_192380_, p_192384_, 8, 0, 10, 8, 0, 12, f_72325_, f_72325_, false);
                this.m_73441_(p_192380_, p_192384_, 14, 0, 10, 14, 0, 12, f_72325_, f_72325_, false);
                for (int $$8 = 18; $$8 >= 7; $$8 -= 3) {
                    this.m_73434_(p_192380_, f_72327_, 6, 3, $$8, p_192384_);
                    this.m_73434_(p_192380_, f_72327_, 16, 3, $$8, p_192384_);
                }
                this.m_73434_(p_192380_, f_72327_, 10, 0, 10, p_192384_);
                this.m_73434_(p_192380_, f_72327_, 12, 0, 10, p_192384_);
                this.m_73434_(p_192380_, f_72327_, 10, 0, 12, p_192384_);
                this.m_73434_(p_192380_, f_72327_, 12, 0, 12, p_192384_);
                this.m_73434_(p_192380_, f_72327_, 8, 3, 6, p_192384_);
                this.m_73434_(p_192380_, f_72327_, 14, 3, 6, p_192384_);
                this.m_73434_(p_192380_, f_72324_, 4, 2, 4, p_192384_);
                this.m_73434_(p_192380_, f_72327_, 4, 1, 4, p_192384_);
                this.m_73434_(p_192380_, f_72324_, 4, 0, 4, p_192384_);
                this.m_73434_(p_192380_, f_72324_, 18, 2, 4, p_192384_);
                this.m_73434_(p_192380_, f_72327_, 18, 1, 4, p_192384_);
                this.m_73434_(p_192380_, f_72324_, 18, 0, 4, p_192384_);
                this.m_73434_(p_192380_, f_72324_, 4, 2, 18, p_192384_);
                this.m_73434_(p_192380_, f_72327_, 4, 1, 18, p_192384_);
                this.m_73434_(p_192380_, f_72324_, 4, 0, 18, p_192384_);
                this.m_73434_(p_192380_, f_72324_, 18, 2, 18, p_192384_);
                this.m_73434_(p_192380_, f_72327_, 18, 1, 18, p_192384_);
                this.m_73434_(p_192380_, f_72324_, 18, 0, 18, p_192384_);
                this.m_73434_(p_192380_, f_72324_, 9, 7, 20, p_192384_);
                this.m_73434_(p_192380_, f_72324_, 13, 7, 20, p_192384_);
                this.m_73441_(p_192380_, p_192384_, 6, 0, 21, 7, 4, 21, f_72324_, f_72324_, false);
                this.m_73441_(p_192380_, p_192384_, 15, 0, 21, 16, 4, 21, f_72324_, f_72324_, false);
                this.m_72354_(p_192380_, p_192384_, 11, 2, 16);
            } else if (this.f_72427_ == 1) {
                this.m_73441_(p_192380_, p_192384_, 9, 3, 18, 13, 3, 20, f_72324_, f_72324_, false);
                this.m_73441_(p_192380_, p_192384_, 9, 0, 18, 9, 2, 18, f_72324_, f_72324_, false);
                this.m_73441_(p_192380_, p_192384_, 13, 0, 18, 13, 2, 18, f_72324_, f_72324_, false);
                int $$9 = 9;
                int $$10 = 20;
                int $$11 = 5;
                for (int $$12 = 0; $$12 < 2; ++$$12) {
                    this.m_73434_(p_192380_, f_72324_, $$9, 6, 20, p_192384_);
                    this.m_73434_(p_192380_, f_72327_, $$9, 5, 20, p_192384_);
                    this.m_73434_(p_192380_, f_72324_, $$9, 4, 20, p_192384_);
                    $$9 = 13;
                }
                this.m_73441_(p_192380_, p_192384_, 7, 3, 7, 15, 3, 14, f_72324_, f_72324_, false);
                $$9 = 10;
                for (int $$13 = 0; $$13 < 2; ++$$13) {
                    this.m_73441_(p_192380_, p_192384_, $$9, 0, 10, $$9, 6, 10, f_72324_, f_72324_, false);
                    this.m_73441_(p_192380_, p_192384_, $$9, 0, 12, $$9, 6, 12, f_72324_, f_72324_, false);
                    this.m_73434_(p_192380_, f_72327_, $$9, 0, 10, p_192384_);
                    this.m_73434_(p_192380_, f_72327_, $$9, 0, 12, p_192384_);
                    this.m_73434_(p_192380_, f_72327_, $$9, 4, 10, p_192384_);
                    this.m_73434_(p_192380_, f_72327_, $$9, 4, 12, p_192384_);
                    $$9 = 12;
                }
                $$9 = 8;
                for (int $$14 = 0; $$14 < 2; ++$$14) {
                    this.m_73441_(p_192380_, p_192384_, $$9, 0, 7, $$9, 2, 7, f_72324_, f_72324_, false);
                    this.m_73441_(p_192380_, p_192384_, $$9, 0, 14, $$9, 2, 14, f_72324_, f_72324_, false);
                    $$9 = 14;
                }
                this.m_73441_(p_192380_, p_192384_, 8, 3, 8, 8, 3, 13, f_72325_, f_72325_, false);
                this.m_73441_(p_192380_, p_192384_, 14, 3, 8, 14, 3, 13, f_72325_, f_72325_, false);
                this.m_72354_(p_192380_, p_192384_, 11, 5, 13);
            }
        }
    }

    public static class OceanMonumentCoreRoom
    extends OceanMonumentPiece {
        public OceanMonumentCoreRoom(Direction p_72215_, RoomDefinition p_72216_) {
            super(StructurePieceType.f_67119_, 1, p_72215_, p_72216_, 2, 2, 2);
        }

        public OceanMonumentCoreRoom(CompoundTag p_192275_) {
            super(StructurePieceType.f_67119_, p_192275_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192277_, StructureFeatureManager p_192278_, ChunkGenerator p_192279_, Random p_192280_, BoundingBox p_192281_, ChunkPos p_192282_, BlockPos p_192283_) {
            this.m_72369_(p_192277_, p_192281_, 1, 8, 0, 14, 8, 14, f_72323_);
            int $$7 = 7;
            BlockState $$8 = f_72324_;
            this.m_73441_(p_192277_, p_192281_, 0, 7, 0, 0, 7, 15, $$8, $$8, false);
            this.m_73441_(p_192277_, p_192281_, 15, 7, 0, 15, 7, 15, $$8, $$8, false);
            this.m_73441_(p_192277_, p_192281_, 1, 7, 0, 15, 7, 0, $$8, $$8, false);
            this.m_73441_(p_192277_, p_192281_, 1, 7, 15, 14, 7, 15, $$8, $$8, false);
            for (int $$9 = 1; $$9 <= 6; ++$$9) {
                BlockState $$10 = f_72324_;
                if ($$9 == 2 || $$9 == 6) {
                    $$10 = f_72323_;
                }
                for (int $$11 = 0; $$11 <= 15; $$11 += 15) {
                    this.m_73441_(p_192277_, p_192281_, $$11, $$9, 0, $$11, $$9, 1, $$10, $$10, false);
                    this.m_73441_(p_192277_, p_192281_, $$11, $$9, 6, $$11, $$9, 9, $$10, $$10, false);
                    this.m_73441_(p_192277_, p_192281_, $$11, $$9, 14, $$11, $$9, 15, $$10, $$10, false);
                }
                this.m_73441_(p_192277_, p_192281_, 1, $$9, 0, 1, $$9, 0, $$10, $$10, false);
                this.m_73441_(p_192277_, p_192281_, 6, $$9, 0, 9, $$9, 0, $$10, $$10, false);
                this.m_73441_(p_192277_, p_192281_, 14, $$9, 0, 14, $$9, 0, $$10, $$10, false);
                this.m_73441_(p_192277_, p_192281_, 1, $$9, 15, 14, $$9, 15, $$10, $$10, false);
            }
            this.m_73441_(p_192277_, p_192281_, 6, 3, 6, 9, 6, 9, f_72325_, f_72325_, false);
            this.m_73441_(p_192277_, p_192281_, 7, 4, 7, 8, 5, 8, Blocks.f_50074_.m_49966_(), Blocks.f_50074_.m_49966_(), false);
            for (int $$12 = 3; $$12 <= 6; $$12 += 3) {
                for (int $$13 = 6; $$13 <= 9; $$13 += 3) {
                    this.m_73434_(p_192277_, f_72327_, $$13, $$12, 6, p_192281_);
                    this.m_73434_(p_192277_, f_72327_, $$13, $$12, 9, p_192281_);
                }
            }
            this.m_73441_(p_192277_, p_192281_, 5, 1, 6, 5, 2, 6, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 5, 1, 9, 5, 2, 9, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 10, 1, 6, 10, 2, 6, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 10, 1, 9, 10, 2, 9, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 6, 1, 5, 6, 2, 5, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 9, 1, 5, 9, 2, 5, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 6, 1, 10, 6, 2, 10, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 9, 1, 10, 9, 2, 10, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 5, 2, 5, 5, 6, 5, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 5, 2, 10, 5, 6, 10, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 10, 2, 5, 10, 6, 5, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 10, 2, 10, 10, 6, 10, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 5, 7, 1, 5, 7, 6, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 10, 7, 1, 10, 7, 6, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 5, 7, 9, 5, 7, 14, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 10, 7, 9, 10, 7, 14, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 1, 7, 5, 6, 7, 5, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 1, 7, 10, 6, 7, 10, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 9, 7, 5, 14, 7, 5, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 9, 7, 10, 14, 7, 10, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 2, 1, 2, 2, 1, 3, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 3, 1, 2, 3, 1, 2, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 13, 1, 2, 13, 1, 3, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 12, 1, 2, 12, 1, 2, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 2, 1, 12, 2, 1, 13, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 3, 1, 13, 3, 1, 13, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 13, 1, 12, 13, 1, 13, f_72324_, f_72324_, false);
            this.m_73441_(p_192277_, p_192281_, 12, 1, 13, 12, 1, 13, f_72324_, f_72324_, false);
        }
    }

    public static class OceanMonumentDoubleYZRoom
    extends OceanMonumentPiece {
        public OceanMonumentDoubleYZRoom(Direction p_72271_, RoomDefinition p_72272_) {
            super(StructurePieceType.f_67123_, 1, p_72271_, p_72272_, 1, 2, 2);
        }

        public OceanMonumentDoubleYZRoom(CompoundTag p_192315_) {
            super(StructurePieceType.f_67123_, p_192315_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192317_, StructureFeatureManager p_192318_, ChunkGenerator p_192319_, Random p_192320_, BoundingBox p_192321_, ChunkPos p_192322_, BlockPos p_192323_) {
            RoomDefinition $$7 = this.f_72334_.f_72444_[Direction.NORTH.m_122411_()];
            RoomDefinition $$8 = this.f_72334_;
            RoomDefinition $$9 = $$7.f_72444_[Direction.UP.m_122411_()];
            RoomDefinition $$10 = $$8.f_72444_[Direction.UP.m_122411_()];
            if (this.f_72334_.f_72443_ / 25 > 0) {
                this.m_72379_(p_192317_, p_192321_, 0, 8, $$7.f_72445_[Direction.DOWN.m_122411_()]);
                this.m_72379_(p_192317_, p_192321_, 0, 0, $$8.f_72445_[Direction.DOWN.m_122411_()]);
            }
            if ($$10.f_72444_[Direction.UP.m_122411_()] == null) {
                this.m_72369_(p_192317_, p_192321_, 1, 8, 1, 6, 8, 7, f_72323_);
            }
            if ($$9.f_72444_[Direction.UP.m_122411_()] == null) {
                this.m_72369_(p_192317_, p_192321_, 1, 8, 8, 6, 8, 14, f_72323_);
            }
            for (int $$11 = 1; $$11 <= 7; ++$$11) {
                BlockState $$12 = f_72324_;
                if ($$11 == 2 || $$11 == 6) {
                    $$12 = f_72323_;
                }
                this.m_73441_(p_192317_, p_192321_, 0, $$11, 0, 0, $$11, 15, $$12, $$12, false);
                this.m_73441_(p_192317_, p_192321_, 7, $$11, 0, 7, $$11, 15, $$12, $$12, false);
                this.m_73441_(p_192317_, p_192321_, 1, $$11, 0, 6, $$11, 0, $$12, $$12, false);
                this.m_73441_(p_192317_, p_192321_, 1, $$11, 15, 6, $$11, 15, $$12, $$12, false);
            }
            for (int $$13 = 1; $$13 <= 7; ++$$13) {
                BlockState $$14 = f_72325_;
                if ($$13 == 2 || $$13 == 6) {
                    $$14 = f_72327_;
                }
                this.m_73441_(p_192317_, p_192321_, 3, $$13, 7, 4, $$13, 8, $$14, $$14, false);
            }
            if ($$8.f_72445_[Direction.SOUTH.m_122411_()]) {
                this.m_72360_(p_192317_, p_192321_, 3, 1, 0, 4, 2, 0);
            }
            if ($$8.f_72445_[Direction.EAST.m_122411_()]) {
                this.m_72360_(p_192317_, p_192321_, 7, 1, 3, 7, 2, 4);
            }
            if ($$8.f_72445_[Direction.WEST.m_122411_()]) {
                this.m_72360_(p_192317_, p_192321_, 0, 1, 3, 0, 2, 4);
            }
            if ($$7.f_72445_[Direction.NORTH.m_122411_()]) {
                this.m_72360_(p_192317_, p_192321_, 3, 1, 15, 4, 2, 15);
            }
            if ($$7.f_72445_[Direction.WEST.m_122411_()]) {
                this.m_72360_(p_192317_, p_192321_, 0, 1, 11, 0, 2, 12);
            }
            if ($$7.f_72445_[Direction.EAST.m_122411_()]) {
                this.m_72360_(p_192317_, p_192321_, 7, 1, 11, 7, 2, 12);
            }
            if ($$10.f_72445_[Direction.SOUTH.m_122411_()]) {
                this.m_72360_(p_192317_, p_192321_, 3, 5, 0, 4, 6, 0);
            }
            if ($$10.f_72445_[Direction.EAST.m_122411_()]) {
                this.m_72360_(p_192317_, p_192321_, 7, 5, 3, 7, 6, 4);
                this.m_73441_(p_192317_, p_192321_, 5, 4, 2, 6, 4, 5, f_72324_, f_72324_, false);
                this.m_73441_(p_192317_, p_192321_, 6, 1, 2, 6, 3, 2, f_72324_, f_72324_, false);
                this.m_73441_(p_192317_, p_192321_, 6, 1, 5, 6, 3, 5, f_72324_, f_72324_, false);
            }
            if ($$10.f_72445_[Direction.WEST.m_122411_()]) {
                this.m_72360_(p_192317_, p_192321_, 0, 5, 3, 0, 6, 4);
                this.m_73441_(p_192317_, p_192321_, 1, 4, 2, 2, 4, 5, f_72324_, f_72324_, false);
                this.m_73441_(p_192317_, p_192321_, 1, 1, 2, 1, 3, 2, f_72324_, f_72324_, false);
                this.m_73441_(p_192317_, p_192321_, 1, 1, 5, 1, 3, 5, f_72324_, f_72324_, false);
            }
            if ($$9.f_72445_[Direction.NORTH.m_122411_()]) {
                this.m_72360_(p_192317_, p_192321_, 3, 5, 15, 4, 6, 15);
            }
            if ($$9.f_72445_[Direction.WEST.m_122411_()]) {
                this.m_72360_(p_192317_, p_192321_, 0, 5, 11, 0, 6, 12);
                this.m_73441_(p_192317_, p_192321_, 1, 4, 10, 2, 4, 13, f_72324_, f_72324_, false);
                this.m_73441_(p_192317_, p_192321_, 1, 1, 10, 1, 3, 10, f_72324_, f_72324_, false);
                this.m_73441_(p_192317_, p_192321_, 1, 1, 13, 1, 3, 13, f_72324_, f_72324_, false);
            }
            if ($$9.f_72445_[Direction.EAST.m_122411_()]) {
                this.m_72360_(p_192317_, p_192321_, 7, 5, 11, 7, 6, 12);
                this.m_73441_(p_192317_, p_192321_, 5, 4, 10, 6, 4, 13, f_72324_, f_72324_, false);
                this.m_73441_(p_192317_, p_192321_, 6, 1, 10, 6, 3, 10, f_72324_, f_72324_, false);
                this.m_73441_(p_192317_, p_192321_, 6, 1, 13, 6, 3, 13, f_72324_, f_72324_, false);
            }
        }
    }

    public static class OceanMonumentDoubleXYRoom
    extends OceanMonumentPiece {
        public OceanMonumentDoubleXYRoom(Direction p_72243_, RoomDefinition p_72244_) {
            super(StructurePieceType.f_67121_, 1, p_72243_, p_72244_, 2, 2, 1);
        }

        public OceanMonumentDoubleXYRoom(CompoundTag p_192295_) {
            super(StructurePieceType.f_67121_, p_192295_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192297_, StructureFeatureManager p_192298_, ChunkGenerator p_192299_, Random p_192300_, BoundingBox p_192301_, ChunkPos p_192302_, BlockPos p_192303_) {
            RoomDefinition $$7 = this.f_72334_.f_72444_[Direction.EAST.m_122411_()];
            RoomDefinition $$8 = this.f_72334_;
            RoomDefinition $$9 = $$8.f_72444_[Direction.UP.m_122411_()];
            RoomDefinition $$10 = $$7.f_72444_[Direction.UP.m_122411_()];
            if (this.f_72334_.f_72443_ / 25 > 0) {
                this.m_72379_(p_192297_, p_192301_, 8, 0, $$7.f_72445_[Direction.DOWN.m_122411_()]);
                this.m_72379_(p_192297_, p_192301_, 0, 0, $$8.f_72445_[Direction.DOWN.m_122411_()]);
            }
            if ($$9.f_72444_[Direction.UP.m_122411_()] == null) {
                this.m_72369_(p_192297_, p_192301_, 1, 8, 1, 7, 8, 6, f_72323_);
            }
            if ($$10.f_72444_[Direction.UP.m_122411_()] == null) {
                this.m_72369_(p_192297_, p_192301_, 8, 8, 1, 14, 8, 6, f_72323_);
            }
            for (int $$11 = 1; $$11 <= 7; ++$$11) {
                BlockState $$12 = f_72324_;
                if ($$11 == 2 || $$11 == 6) {
                    $$12 = f_72323_;
                }
                this.m_73441_(p_192297_, p_192301_, 0, $$11, 0, 0, $$11, 7, $$12, $$12, false);
                this.m_73441_(p_192297_, p_192301_, 15, $$11, 0, 15, $$11, 7, $$12, $$12, false);
                this.m_73441_(p_192297_, p_192301_, 1, $$11, 0, 15, $$11, 0, $$12, $$12, false);
                this.m_73441_(p_192297_, p_192301_, 1, $$11, 7, 14, $$11, 7, $$12, $$12, false);
            }
            this.m_73441_(p_192297_, p_192301_, 2, 1, 3, 2, 7, 4, f_72324_, f_72324_, false);
            this.m_73441_(p_192297_, p_192301_, 3, 1, 2, 4, 7, 2, f_72324_, f_72324_, false);
            this.m_73441_(p_192297_, p_192301_, 3, 1, 5, 4, 7, 5, f_72324_, f_72324_, false);
            this.m_73441_(p_192297_, p_192301_, 13, 1, 3, 13, 7, 4, f_72324_, f_72324_, false);
            this.m_73441_(p_192297_, p_192301_, 11, 1, 2, 12, 7, 2, f_72324_, f_72324_, false);
            this.m_73441_(p_192297_, p_192301_, 11, 1, 5, 12, 7, 5, f_72324_, f_72324_, false);
            this.m_73441_(p_192297_, p_192301_, 5, 1, 3, 5, 3, 4, f_72324_, f_72324_, false);
            this.m_73441_(p_192297_, p_192301_, 10, 1, 3, 10, 3, 4, f_72324_, f_72324_, false);
            this.m_73441_(p_192297_, p_192301_, 5, 7, 2, 10, 7, 5, f_72324_, f_72324_, false);
            this.m_73441_(p_192297_, p_192301_, 5, 5, 2, 5, 7, 2, f_72324_, f_72324_, false);
            this.m_73441_(p_192297_, p_192301_, 10, 5, 2, 10, 7, 2, f_72324_, f_72324_, false);
            this.m_73441_(p_192297_, p_192301_, 5, 5, 5, 5, 7, 5, f_72324_, f_72324_, false);
            this.m_73441_(p_192297_, p_192301_, 10, 5, 5, 10, 7, 5, f_72324_, f_72324_, false);
            this.m_73434_(p_192297_, f_72324_, 6, 6, 2, p_192301_);
            this.m_73434_(p_192297_, f_72324_, 9, 6, 2, p_192301_);
            this.m_73434_(p_192297_, f_72324_, 6, 6, 5, p_192301_);
            this.m_73434_(p_192297_, f_72324_, 9, 6, 5, p_192301_);
            this.m_73441_(p_192297_, p_192301_, 5, 4, 3, 6, 4, 4, f_72324_, f_72324_, false);
            this.m_73441_(p_192297_, p_192301_, 9, 4, 3, 10, 4, 4, f_72324_, f_72324_, false);
            this.m_73434_(p_192297_, f_72327_, 5, 4, 2, p_192301_);
            this.m_73434_(p_192297_, f_72327_, 5, 4, 5, p_192301_);
            this.m_73434_(p_192297_, f_72327_, 10, 4, 2, p_192301_);
            this.m_73434_(p_192297_, f_72327_, 10, 4, 5, p_192301_);
            if ($$8.f_72445_[Direction.SOUTH.m_122411_()]) {
                this.m_72360_(p_192297_, p_192301_, 3, 1, 0, 4, 2, 0);
            }
            if ($$8.f_72445_[Direction.NORTH.m_122411_()]) {
                this.m_72360_(p_192297_, p_192301_, 3, 1, 7, 4, 2, 7);
            }
            if ($$8.f_72445_[Direction.WEST.m_122411_()]) {
                this.m_72360_(p_192297_, p_192301_, 0, 1, 3, 0, 2, 4);
            }
            if ($$7.f_72445_[Direction.SOUTH.m_122411_()]) {
                this.m_72360_(p_192297_, p_192301_, 11, 1, 0, 12, 2, 0);
            }
            if ($$7.f_72445_[Direction.NORTH.m_122411_()]) {
                this.m_72360_(p_192297_, p_192301_, 11, 1, 7, 12, 2, 7);
            }
            if ($$7.f_72445_[Direction.EAST.m_122411_()]) {
                this.m_72360_(p_192297_, p_192301_, 15, 1, 3, 15, 2, 4);
            }
            if ($$9.f_72445_[Direction.SOUTH.m_122411_()]) {
                this.m_72360_(p_192297_, p_192301_, 3, 5, 0, 4, 6, 0);
            }
            if ($$9.f_72445_[Direction.NORTH.m_122411_()]) {
                this.m_72360_(p_192297_, p_192301_, 3, 5, 7, 4, 6, 7);
            }
            if ($$9.f_72445_[Direction.WEST.m_122411_()]) {
                this.m_72360_(p_192297_, p_192301_, 0, 5, 3, 0, 6, 4);
            }
            if ($$10.f_72445_[Direction.SOUTH.m_122411_()]) {
                this.m_72360_(p_192297_, p_192301_, 11, 5, 0, 12, 6, 0);
            }
            if ($$10.f_72445_[Direction.NORTH.m_122411_()]) {
                this.m_72360_(p_192297_, p_192301_, 11, 5, 7, 12, 6, 7);
            }
            if ($$10.f_72445_[Direction.EAST.m_122411_()]) {
                this.m_72360_(p_192297_, p_192301_, 15, 5, 3, 15, 6, 4);
            }
        }
    }

    public static class OceanMonumentDoubleZRoom
    extends OceanMonumentPiece {
        public OceanMonumentDoubleZRoom(Direction p_72285_, RoomDefinition p_72286_) {
            super(StructurePieceType.f_67124_, 1, p_72285_, p_72286_, 1, 1, 2);
        }

        public OceanMonumentDoubleZRoom(CompoundTag p_192325_) {
            super(StructurePieceType.f_67124_, p_192325_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192327_, StructureFeatureManager p_192328_, ChunkGenerator p_192329_, Random p_192330_, BoundingBox p_192331_, ChunkPos p_192332_, BlockPos p_192333_) {
            RoomDefinition $$7 = this.f_72334_.f_72444_[Direction.NORTH.m_122411_()];
            RoomDefinition $$8 = this.f_72334_;
            if (this.f_72334_.f_72443_ / 25 > 0) {
                this.m_72379_(p_192327_, p_192331_, 0, 8, $$7.f_72445_[Direction.DOWN.m_122411_()]);
                this.m_72379_(p_192327_, p_192331_, 0, 0, $$8.f_72445_[Direction.DOWN.m_122411_()]);
            }
            if ($$8.f_72444_[Direction.UP.m_122411_()] == null) {
                this.m_72369_(p_192327_, p_192331_, 1, 4, 1, 6, 4, 7, f_72323_);
            }
            if ($$7.f_72444_[Direction.UP.m_122411_()] == null) {
                this.m_72369_(p_192327_, p_192331_, 1, 4, 8, 6, 4, 14, f_72323_);
            }
            this.m_73441_(p_192327_, p_192331_, 0, 3, 0, 0, 3, 15, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 7, 3, 0, 7, 3, 15, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 1, 3, 0, 7, 3, 0, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 1, 3, 15, 6, 3, 15, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 0, 2, 0, 0, 2, 15, f_72323_, f_72323_, false);
            this.m_73441_(p_192327_, p_192331_, 7, 2, 0, 7, 2, 15, f_72323_, f_72323_, false);
            this.m_73441_(p_192327_, p_192331_, 1, 2, 0, 7, 2, 0, f_72323_, f_72323_, false);
            this.m_73441_(p_192327_, p_192331_, 1, 2, 15, 6, 2, 15, f_72323_, f_72323_, false);
            this.m_73441_(p_192327_, p_192331_, 0, 1, 0, 0, 1, 15, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 7, 1, 0, 7, 1, 15, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 1, 1, 0, 7, 1, 0, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 1, 1, 15, 6, 1, 15, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 1, 1, 1, 1, 1, 2, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 6, 1, 1, 6, 1, 2, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 1, 3, 1, 1, 3, 2, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 6, 3, 1, 6, 3, 2, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 1, 1, 13, 1, 1, 14, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 6, 1, 13, 6, 1, 14, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 1, 3, 13, 1, 3, 14, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 6, 3, 13, 6, 3, 14, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 2, 1, 6, 2, 3, 6, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 5, 1, 6, 5, 3, 6, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 2, 1, 9, 2, 3, 9, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 5, 1, 9, 5, 3, 9, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 3, 2, 6, 4, 2, 6, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 3, 2, 9, 4, 2, 9, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 2, 2, 7, 2, 2, 8, f_72324_, f_72324_, false);
            this.m_73441_(p_192327_, p_192331_, 5, 2, 7, 5, 2, 8, f_72324_, f_72324_, false);
            this.m_73434_(p_192327_, f_72327_, 2, 2, 5, p_192331_);
            this.m_73434_(p_192327_, f_72327_, 5, 2, 5, p_192331_);
            this.m_73434_(p_192327_, f_72327_, 2, 2, 10, p_192331_);
            this.m_73434_(p_192327_, f_72327_, 5, 2, 10, p_192331_);
            this.m_73434_(p_192327_, f_72324_, 2, 3, 5, p_192331_);
            this.m_73434_(p_192327_, f_72324_, 5, 3, 5, p_192331_);
            this.m_73434_(p_192327_, f_72324_, 2, 3, 10, p_192331_);
            this.m_73434_(p_192327_, f_72324_, 5, 3, 10, p_192331_);
            if ($$8.f_72445_[Direction.SOUTH.m_122411_()]) {
                this.m_72360_(p_192327_, p_192331_, 3, 1, 0, 4, 2, 0);
            }
            if ($$8.f_72445_[Direction.EAST.m_122411_()]) {
                this.m_72360_(p_192327_, p_192331_, 7, 1, 3, 7, 2, 4);
            }
            if ($$8.f_72445_[Direction.WEST.m_122411_()]) {
                this.m_72360_(p_192327_, p_192331_, 0, 1, 3, 0, 2, 4);
            }
            if ($$7.f_72445_[Direction.NORTH.m_122411_()]) {
                this.m_72360_(p_192327_, p_192331_, 3, 1, 15, 4, 2, 15);
            }
            if ($$7.f_72445_[Direction.WEST.m_122411_()]) {
                this.m_72360_(p_192327_, p_192331_, 0, 1, 11, 0, 2, 12);
            }
            if ($$7.f_72445_[Direction.EAST.m_122411_()]) {
                this.m_72360_(p_192327_, p_192331_, 7, 1, 11, 7, 2, 12);
            }
        }
    }

    public static class OceanMonumentDoubleXRoom
    extends OceanMonumentPiece {
        public OceanMonumentDoubleXRoom(Direction p_72229_, RoomDefinition p_72230_) {
            super(StructurePieceType.f_67120_, 1, p_72229_, p_72230_, 2, 1, 1);
        }

        public OceanMonumentDoubleXRoom(CompoundTag p_192285_) {
            super(StructurePieceType.f_67120_, p_192285_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192287_, StructureFeatureManager p_192288_, ChunkGenerator p_192289_, Random p_192290_, BoundingBox p_192291_, ChunkPos p_192292_, BlockPos p_192293_) {
            RoomDefinition $$7 = this.f_72334_.f_72444_[Direction.EAST.m_122411_()];
            RoomDefinition $$8 = this.f_72334_;
            if (this.f_72334_.f_72443_ / 25 > 0) {
                this.m_72379_(p_192287_, p_192291_, 8, 0, $$7.f_72445_[Direction.DOWN.m_122411_()]);
                this.m_72379_(p_192287_, p_192291_, 0, 0, $$8.f_72445_[Direction.DOWN.m_122411_()]);
            }
            if ($$8.f_72444_[Direction.UP.m_122411_()] == null) {
                this.m_72369_(p_192287_, p_192291_, 1, 4, 1, 7, 4, 6, f_72323_);
            }
            if ($$7.f_72444_[Direction.UP.m_122411_()] == null) {
                this.m_72369_(p_192287_, p_192291_, 8, 4, 1, 14, 4, 6, f_72323_);
            }
            this.m_73441_(p_192287_, p_192291_, 0, 3, 0, 0, 3, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192287_, p_192291_, 15, 3, 0, 15, 3, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192287_, p_192291_, 1, 3, 0, 15, 3, 0, f_72324_, f_72324_, false);
            this.m_73441_(p_192287_, p_192291_, 1, 3, 7, 14, 3, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192287_, p_192291_, 0, 2, 0, 0, 2, 7, f_72323_, f_72323_, false);
            this.m_73441_(p_192287_, p_192291_, 15, 2, 0, 15, 2, 7, f_72323_, f_72323_, false);
            this.m_73441_(p_192287_, p_192291_, 1, 2, 0, 15, 2, 0, f_72323_, f_72323_, false);
            this.m_73441_(p_192287_, p_192291_, 1, 2, 7, 14, 2, 7, f_72323_, f_72323_, false);
            this.m_73441_(p_192287_, p_192291_, 0, 1, 0, 0, 1, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192287_, p_192291_, 15, 1, 0, 15, 1, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192287_, p_192291_, 1, 1, 0, 15, 1, 0, f_72324_, f_72324_, false);
            this.m_73441_(p_192287_, p_192291_, 1, 1, 7, 14, 1, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192287_, p_192291_, 5, 1, 0, 10, 1, 4, f_72324_, f_72324_, false);
            this.m_73441_(p_192287_, p_192291_, 6, 2, 0, 9, 2, 3, f_72323_, f_72323_, false);
            this.m_73441_(p_192287_, p_192291_, 5, 3, 0, 10, 3, 4, f_72324_, f_72324_, false);
            this.m_73434_(p_192287_, f_72327_, 6, 2, 3, p_192291_);
            this.m_73434_(p_192287_, f_72327_, 9, 2, 3, p_192291_);
            if ($$8.f_72445_[Direction.SOUTH.m_122411_()]) {
                this.m_72360_(p_192287_, p_192291_, 3, 1, 0, 4, 2, 0);
            }
            if ($$8.f_72445_[Direction.NORTH.m_122411_()]) {
                this.m_72360_(p_192287_, p_192291_, 3, 1, 7, 4, 2, 7);
            }
            if ($$8.f_72445_[Direction.WEST.m_122411_()]) {
                this.m_72360_(p_192287_, p_192291_, 0, 1, 3, 0, 2, 4);
            }
            if ($$7.f_72445_[Direction.SOUTH.m_122411_()]) {
                this.m_72360_(p_192287_, p_192291_, 11, 1, 0, 12, 2, 0);
            }
            if ($$7.f_72445_[Direction.NORTH.m_122411_()]) {
                this.m_72360_(p_192287_, p_192291_, 11, 1, 7, 12, 2, 7);
            }
            if ($$7.f_72445_[Direction.EAST.m_122411_()]) {
                this.m_72360_(p_192287_, p_192291_, 15, 1, 3, 15, 2, 4);
            }
        }
    }

    public static class OceanMonumentDoubleYRoom
    extends OceanMonumentPiece {
        public OceanMonumentDoubleYRoom(Direction p_72257_, RoomDefinition p_72258_) {
            super(StructurePieceType.f_67122_, 1, p_72257_, p_72258_, 1, 2, 1);
        }

        public OceanMonumentDoubleYRoom(CompoundTag p_192305_) {
            super(StructurePieceType.f_67122_, p_192305_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192307_, StructureFeatureManager p_192308_, ChunkGenerator p_192309_, Random p_192310_, BoundingBox p_192311_, ChunkPos p_192312_, BlockPos p_192313_) {
            if (this.f_72334_.f_72443_ / 25 > 0) {
                this.m_72379_(p_192307_, p_192311_, 0, 0, this.f_72334_.f_72445_[Direction.DOWN.m_122411_()]);
            }
            RoomDefinition $$7 = this.f_72334_.f_72444_[Direction.UP.m_122411_()];
            if ($$7.f_72444_[Direction.UP.m_122411_()] == null) {
                this.m_72369_(p_192307_, p_192311_, 1, 8, 1, 6, 8, 6, f_72323_);
            }
            this.m_73441_(p_192307_, p_192311_, 0, 4, 0, 0, 4, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192307_, p_192311_, 7, 4, 0, 7, 4, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192307_, p_192311_, 1, 4, 0, 6, 4, 0, f_72324_, f_72324_, false);
            this.m_73441_(p_192307_, p_192311_, 1, 4, 7, 6, 4, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192307_, p_192311_, 2, 4, 1, 2, 4, 2, f_72324_, f_72324_, false);
            this.m_73441_(p_192307_, p_192311_, 1, 4, 2, 1, 4, 2, f_72324_, f_72324_, false);
            this.m_73441_(p_192307_, p_192311_, 5, 4, 1, 5, 4, 2, f_72324_, f_72324_, false);
            this.m_73441_(p_192307_, p_192311_, 6, 4, 2, 6, 4, 2, f_72324_, f_72324_, false);
            this.m_73441_(p_192307_, p_192311_, 2, 4, 5, 2, 4, 6, f_72324_, f_72324_, false);
            this.m_73441_(p_192307_, p_192311_, 1, 4, 5, 1, 4, 5, f_72324_, f_72324_, false);
            this.m_73441_(p_192307_, p_192311_, 5, 4, 5, 5, 4, 6, f_72324_, f_72324_, false);
            this.m_73441_(p_192307_, p_192311_, 6, 4, 5, 6, 4, 5, f_72324_, f_72324_, false);
            RoomDefinition $$8 = this.f_72334_;
            for (int $$9 = 1; $$9 <= 5; $$9 += 4) {
                int $$10 = 0;
                if ($$8.f_72445_[Direction.SOUTH.m_122411_()]) {
                    this.m_73441_(p_192307_, p_192311_, 2, $$9, $$10, 2, $$9 + 2, $$10, f_72324_, f_72324_, false);
                    this.m_73441_(p_192307_, p_192311_, 5, $$9, $$10, 5, $$9 + 2, $$10, f_72324_, f_72324_, false);
                    this.m_73441_(p_192307_, p_192311_, 3, $$9 + 2, $$10, 4, $$9 + 2, $$10, f_72324_, f_72324_, false);
                } else {
                    this.m_73441_(p_192307_, p_192311_, 0, $$9, $$10, 7, $$9 + 2, $$10, f_72324_, f_72324_, false);
                    this.m_73441_(p_192307_, p_192311_, 0, $$9 + 1, $$10, 7, $$9 + 1, $$10, f_72323_, f_72323_, false);
                }
                $$10 = 7;
                if ($$8.f_72445_[Direction.NORTH.m_122411_()]) {
                    this.m_73441_(p_192307_, p_192311_, 2, $$9, $$10, 2, $$9 + 2, $$10, f_72324_, f_72324_, false);
                    this.m_73441_(p_192307_, p_192311_, 5, $$9, $$10, 5, $$9 + 2, $$10, f_72324_, f_72324_, false);
                    this.m_73441_(p_192307_, p_192311_, 3, $$9 + 2, $$10, 4, $$9 + 2, $$10, f_72324_, f_72324_, false);
                } else {
                    this.m_73441_(p_192307_, p_192311_, 0, $$9, $$10, 7, $$9 + 2, $$10, f_72324_, f_72324_, false);
                    this.m_73441_(p_192307_, p_192311_, 0, $$9 + 1, $$10, 7, $$9 + 1, $$10, f_72323_, f_72323_, false);
                }
                int $$11 = 0;
                if ($$8.f_72445_[Direction.WEST.m_122411_()]) {
                    this.m_73441_(p_192307_, p_192311_, $$11, $$9, 2, $$11, $$9 + 2, 2, f_72324_, f_72324_, false);
                    this.m_73441_(p_192307_, p_192311_, $$11, $$9, 5, $$11, $$9 + 2, 5, f_72324_, f_72324_, false);
                    this.m_73441_(p_192307_, p_192311_, $$11, $$9 + 2, 3, $$11, $$9 + 2, 4, f_72324_, f_72324_, false);
                } else {
                    this.m_73441_(p_192307_, p_192311_, $$11, $$9, 0, $$11, $$9 + 2, 7, f_72324_, f_72324_, false);
                    this.m_73441_(p_192307_, p_192311_, $$11, $$9 + 1, 0, $$11, $$9 + 1, 7, f_72323_, f_72323_, false);
                }
                $$11 = 7;
                if ($$8.f_72445_[Direction.EAST.m_122411_()]) {
                    this.m_73441_(p_192307_, p_192311_, $$11, $$9, 2, $$11, $$9 + 2, 2, f_72324_, f_72324_, false);
                    this.m_73441_(p_192307_, p_192311_, $$11, $$9, 5, $$11, $$9 + 2, 5, f_72324_, f_72324_, false);
                    this.m_73441_(p_192307_, p_192311_, $$11, $$9 + 2, 3, $$11, $$9 + 2, 4, f_72324_, f_72324_, false);
                } else {
                    this.m_73441_(p_192307_, p_192311_, $$11, $$9, 0, $$11, $$9 + 2, 7, f_72324_, f_72324_, false);
                    this.m_73441_(p_192307_, p_192311_, $$11, $$9 + 1, 0, $$11, $$9 + 1, 7, f_72323_, f_72323_, false);
                }
                $$8 = $$7;
            }
        }
    }

    public static class OceanMonumentSimpleTopRoom
    extends OceanMonumentPiece {
        public OceanMonumentSimpleTopRoom(Direction p_72417_, RoomDefinition p_72418_) {
            super(StructurePieceType.f_67128_, 1, p_72417_, p_72418_, 1, 1, 1);
        }

        public OceanMonumentSimpleTopRoom(CompoundTag p_192368_) {
            super(StructurePieceType.f_67128_, p_192368_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192370_, StructureFeatureManager p_192371_, ChunkGenerator p_192372_, Random p_192373_, BoundingBox p_192374_, ChunkPos p_192375_, BlockPos p_192376_) {
            if (this.f_72334_.f_72443_ / 25 > 0) {
                this.m_72379_(p_192370_, p_192374_, 0, 0, this.f_72334_.f_72445_[Direction.DOWN.m_122411_()]);
            }
            if (this.f_72334_.f_72444_[Direction.UP.m_122411_()] == null) {
                this.m_72369_(p_192370_, p_192374_, 1, 4, 1, 6, 4, 6, f_72323_);
            }
            for (int $$7 = 1; $$7 <= 6; ++$$7) {
                for (int $$8 = 1; $$8 <= 6; ++$$8) {
                    if (p_192373_.nextInt(3) == 0) continue;
                    int $$9 = 2 + (p_192373_.nextInt(4) == 0 ? 0 : 1);
                    BlockState $$10 = Blocks.f_50057_.m_49966_();
                    this.m_73441_(p_192370_, p_192374_, $$7, $$9, $$8, $$7, 3, $$8, $$10, $$10, false);
                }
            }
            this.m_73441_(p_192370_, p_192374_, 0, 1, 0, 0, 1, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192370_, p_192374_, 7, 1, 0, 7, 1, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192370_, p_192374_, 1, 1, 0, 6, 1, 0, f_72324_, f_72324_, false);
            this.m_73441_(p_192370_, p_192374_, 1, 1, 7, 6, 1, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192370_, p_192374_, 0, 2, 0, 0, 2, 7, f_72325_, f_72325_, false);
            this.m_73441_(p_192370_, p_192374_, 7, 2, 0, 7, 2, 7, f_72325_, f_72325_, false);
            this.m_73441_(p_192370_, p_192374_, 1, 2, 0, 6, 2, 0, f_72325_, f_72325_, false);
            this.m_73441_(p_192370_, p_192374_, 1, 2, 7, 6, 2, 7, f_72325_, f_72325_, false);
            this.m_73441_(p_192370_, p_192374_, 0, 3, 0, 0, 3, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192370_, p_192374_, 7, 3, 0, 7, 3, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192370_, p_192374_, 1, 3, 0, 6, 3, 0, f_72324_, f_72324_, false);
            this.m_73441_(p_192370_, p_192374_, 1, 3, 7, 6, 3, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192370_, p_192374_, 0, 1, 3, 0, 2, 4, f_72325_, f_72325_, false);
            this.m_73441_(p_192370_, p_192374_, 7, 1, 3, 7, 2, 4, f_72325_, f_72325_, false);
            this.m_73441_(p_192370_, p_192374_, 3, 1, 0, 4, 2, 0, f_72325_, f_72325_, false);
            this.m_73441_(p_192370_, p_192374_, 3, 1, 7, 4, 2, 7, f_72325_, f_72325_, false);
            if (this.f_72334_.f_72445_[Direction.SOUTH.m_122411_()]) {
                this.m_72360_(p_192370_, p_192374_, 3, 1, 0, 4, 2, 0);
            }
        }
    }

    public static class OceanMonumentSimpleRoom
    extends OceanMonumentPiece {
        private int f_72397_;

        public OceanMonumentSimpleRoom(Direction p_72402_, RoomDefinition p_72403_, Random p_72404_) {
            super(StructurePieceType.f_67127_, 1, p_72402_, p_72403_, 1, 1, 1);
            this.f_72397_ = p_72404_.nextInt(3);
        }

        public OceanMonumentSimpleRoom(CompoundTag p_192358_) {
            super(StructurePieceType.f_67127_, p_192358_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192360_, StructureFeatureManager p_192361_, ChunkGenerator p_192362_, Random p_192363_, BoundingBox p_192364_, ChunkPos p_192365_, BlockPos p_192366_) {
            boolean $$7;
            if (this.f_72334_.f_72443_ / 25 > 0) {
                this.m_72379_(p_192360_, p_192364_, 0, 0, this.f_72334_.f_72445_[Direction.DOWN.m_122411_()]);
            }
            if (this.f_72334_.f_72444_[Direction.UP.m_122411_()] == null) {
                this.m_72369_(p_192360_, p_192364_, 1, 4, 1, 6, 4, 6, f_72323_);
            }
            boolean bl = $$7 = this.f_72397_ != 0 && p_192363_.nextBoolean() && !this.f_72334_.f_72445_[Direction.DOWN.m_122411_()] && !this.f_72334_.f_72445_[Direction.UP.m_122411_()] && this.f_72334_.m_72468_() > 1;
            if (this.f_72397_ == 0) {
                this.m_73441_(p_192360_, p_192364_, 0, 1, 0, 2, 1, 2, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 0, 3, 0, 2, 3, 2, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 0, 2, 0, 0, 2, 2, f_72323_, f_72323_, false);
                this.m_73441_(p_192360_, p_192364_, 1, 2, 0, 2, 2, 0, f_72323_, f_72323_, false);
                this.m_73434_(p_192360_, f_72327_, 1, 2, 1, p_192364_);
                this.m_73441_(p_192360_, p_192364_, 5, 1, 0, 7, 1, 2, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 5, 3, 0, 7, 3, 2, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 7, 2, 0, 7, 2, 2, f_72323_, f_72323_, false);
                this.m_73441_(p_192360_, p_192364_, 5, 2, 0, 6, 2, 0, f_72323_, f_72323_, false);
                this.m_73434_(p_192360_, f_72327_, 6, 2, 1, p_192364_);
                this.m_73441_(p_192360_, p_192364_, 0, 1, 5, 2, 1, 7, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 0, 3, 5, 2, 3, 7, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 0, 2, 5, 0, 2, 7, f_72323_, f_72323_, false);
                this.m_73441_(p_192360_, p_192364_, 1, 2, 7, 2, 2, 7, f_72323_, f_72323_, false);
                this.m_73434_(p_192360_, f_72327_, 1, 2, 6, p_192364_);
                this.m_73441_(p_192360_, p_192364_, 5, 1, 5, 7, 1, 7, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 5, 3, 5, 7, 3, 7, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 7, 2, 5, 7, 2, 7, f_72323_, f_72323_, false);
                this.m_73441_(p_192360_, p_192364_, 5, 2, 7, 6, 2, 7, f_72323_, f_72323_, false);
                this.m_73434_(p_192360_, f_72327_, 6, 2, 6, p_192364_);
                if (this.f_72334_.f_72445_[Direction.SOUTH.m_122411_()]) {
                    this.m_73441_(p_192360_, p_192364_, 3, 3, 0, 4, 3, 0, f_72324_, f_72324_, false);
                } else {
                    this.m_73441_(p_192360_, p_192364_, 3, 3, 0, 4, 3, 1, f_72324_, f_72324_, false);
                    this.m_73441_(p_192360_, p_192364_, 3, 2, 0, 4, 2, 0, f_72323_, f_72323_, false);
                    this.m_73441_(p_192360_, p_192364_, 3, 1, 0, 4, 1, 1, f_72324_, f_72324_, false);
                }
                if (this.f_72334_.f_72445_[Direction.NORTH.m_122411_()]) {
                    this.m_73441_(p_192360_, p_192364_, 3, 3, 7, 4, 3, 7, f_72324_, f_72324_, false);
                } else {
                    this.m_73441_(p_192360_, p_192364_, 3, 3, 6, 4, 3, 7, f_72324_, f_72324_, false);
                    this.m_73441_(p_192360_, p_192364_, 3, 2, 7, 4, 2, 7, f_72323_, f_72323_, false);
                    this.m_73441_(p_192360_, p_192364_, 3, 1, 6, 4, 1, 7, f_72324_, f_72324_, false);
                }
                if (this.f_72334_.f_72445_[Direction.WEST.m_122411_()]) {
                    this.m_73441_(p_192360_, p_192364_, 0, 3, 3, 0, 3, 4, f_72324_, f_72324_, false);
                } else {
                    this.m_73441_(p_192360_, p_192364_, 0, 3, 3, 1, 3, 4, f_72324_, f_72324_, false);
                    this.m_73441_(p_192360_, p_192364_, 0, 2, 3, 0, 2, 4, f_72323_, f_72323_, false);
                    this.m_73441_(p_192360_, p_192364_, 0, 1, 3, 1, 1, 4, f_72324_, f_72324_, false);
                }
                if (this.f_72334_.f_72445_[Direction.EAST.m_122411_()]) {
                    this.m_73441_(p_192360_, p_192364_, 7, 3, 3, 7, 3, 4, f_72324_, f_72324_, false);
                } else {
                    this.m_73441_(p_192360_, p_192364_, 6, 3, 3, 7, 3, 4, f_72324_, f_72324_, false);
                    this.m_73441_(p_192360_, p_192364_, 7, 2, 3, 7, 2, 4, f_72323_, f_72323_, false);
                    this.m_73441_(p_192360_, p_192364_, 6, 1, 3, 7, 1, 4, f_72324_, f_72324_, false);
                }
            } else if (this.f_72397_ == 1) {
                this.m_73441_(p_192360_, p_192364_, 2, 1, 2, 2, 3, 2, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 2, 1, 5, 2, 3, 5, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 5, 1, 5, 5, 3, 5, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 5, 1, 2, 5, 3, 2, f_72324_, f_72324_, false);
                this.m_73434_(p_192360_, f_72327_, 2, 2, 2, p_192364_);
                this.m_73434_(p_192360_, f_72327_, 2, 2, 5, p_192364_);
                this.m_73434_(p_192360_, f_72327_, 5, 2, 5, p_192364_);
                this.m_73434_(p_192360_, f_72327_, 5, 2, 2, p_192364_);
                this.m_73441_(p_192360_, p_192364_, 0, 1, 0, 1, 3, 0, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 0, 1, 1, 0, 3, 1, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 0, 1, 7, 1, 3, 7, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 0, 1, 6, 0, 3, 6, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 6, 1, 7, 7, 3, 7, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 7, 1, 6, 7, 3, 6, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 6, 1, 0, 7, 3, 0, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 7, 1, 1, 7, 3, 1, f_72324_, f_72324_, false);
                this.m_73434_(p_192360_, f_72323_, 1, 2, 0, p_192364_);
                this.m_73434_(p_192360_, f_72323_, 0, 2, 1, p_192364_);
                this.m_73434_(p_192360_, f_72323_, 1, 2, 7, p_192364_);
                this.m_73434_(p_192360_, f_72323_, 0, 2, 6, p_192364_);
                this.m_73434_(p_192360_, f_72323_, 6, 2, 7, p_192364_);
                this.m_73434_(p_192360_, f_72323_, 7, 2, 6, p_192364_);
                this.m_73434_(p_192360_, f_72323_, 6, 2, 0, p_192364_);
                this.m_73434_(p_192360_, f_72323_, 7, 2, 1, p_192364_);
                if (!this.f_72334_.f_72445_[Direction.SOUTH.m_122411_()]) {
                    this.m_73441_(p_192360_, p_192364_, 1, 3, 0, 6, 3, 0, f_72324_, f_72324_, false);
                    this.m_73441_(p_192360_, p_192364_, 1, 2, 0, 6, 2, 0, f_72323_, f_72323_, false);
                    this.m_73441_(p_192360_, p_192364_, 1, 1, 0, 6, 1, 0, f_72324_, f_72324_, false);
                }
                if (!this.f_72334_.f_72445_[Direction.NORTH.m_122411_()]) {
                    this.m_73441_(p_192360_, p_192364_, 1, 3, 7, 6, 3, 7, f_72324_, f_72324_, false);
                    this.m_73441_(p_192360_, p_192364_, 1, 2, 7, 6, 2, 7, f_72323_, f_72323_, false);
                    this.m_73441_(p_192360_, p_192364_, 1, 1, 7, 6, 1, 7, f_72324_, f_72324_, false);
                }
                if (!this.f_72334_.f_72445_[Direction.WEST.m_122411_()]) {
                    this.m_73441_(p_192360_, p_192364_, 0, 3, 1, 0, 3, 6, f_72324_, f_72324_, false);
                    this.m_73441_(p_192360_, p_192364_, 0, 2, 1, 0, 2, 6, f_72323_, f_72323_, false);
                    this.m_73441_(p_192360_, p_192364_, 0, 1, 1, 0, 1, 6, f_72324_, f_72324_, false);
                }
                if (!this.f_72334_.f_72445_[Direction.EAST.m_122411_()]) {
                    this.m_73441_(p_192360_, p_192364_, 7, 3, 1, 7, 3, 6, f_72324_, f_72324_, false);
                    this.m_73441_(p_192360_, p_192364_, 7, 2, 1, 7, 2, 6, f_72323_, f_72323_, false);
                    this.m_73441_(p_192360_, p_192364_, 7, 1, 1, 7, 1, 6, f_72324_, f_72324_, false);
                }
            } else if (this.f_72397_ == 2) {
                this.m_73441_(p_192360_, p_192364_, 0, 1, 0, 0, 1, 7, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 7, 1, 0, 7, 1, 7, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 1, 1, 0, 6, 1, 0, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 1, 1, 7, 6, 1, 7, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 0, 2, 0, 0, 2, 7, f_72325_, f_72325_, false);
                this.m_73441_(p_192360_, p_192364_, 7, 2, 0, 7, 2, 7, f_72325_, f_72325_, false);
                this.m_73441_(p_192360_, p_192364_, 1, 2, 0, 6, 2, 0, f_72325_, f_72325_, false);
                this.m_73441_(p_192360_, p_192364_, 1, 2, 7, 6, 2, 7, f_72325_, f_72325_, false);
                this.m_73441_(p_192360_, p_192364_, 0, 3, 0, 0, 3, 7, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 7, 3, 0, 7, 3, 7, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 1, 3, 0, 6, 3, 0, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 1, 3, 7, 6, 3, 7, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 0, 1, 3, 0, 2, 4, f_72325_, f_72325_, false);
                this.m_73441_(p_192360_, p_192364_, 7, 1, 3, 7, 2, 4, f_72325_, f_72325_, false);
                this.m_73441_(p_192360_, p_192364_, 3, 1, 0, 4, 2, 0, f_72325_, f_72325_, false);
                this.m_73441_(p_192360_, p_192364_, 3, 1, 7, 4, 2, 7, f_72325_, f_72325_, false);
                if (this.f_72334_.f_72445_[Direction.SOUTH.m_122411_()]) {
                    this.m_72360_(p_192360_, p_192364_, 3, 1, 0, 4, 2, 0);
                }
                if (this.f_72334_.f_72445_[Direction.NORTH.m_122411_()]) {
                    this.m_72360_(p_192360_, p_192364_, 3, 1, 7, 4, 2, 7);
                }
                if (this.f_72334_.f_72445_[Direction.WEST.m_122411_()]) {
                    this.m_72360_(p_192360_, p_192364_, 0, 1, 3, 0, 2, 4);
                }
                if (this.f_72334_.f_72445_[Direction.EAST.m_122411_()]) {
                    this.m_72360_(p_192360_, p_192364_, 7, 1, 3, 7, 2, 4);
                }
            }
            if ($$7) {
                this.m_73441_(p_192360_, p_192364_, 3, 1, 3, 4, 1, 4, f_72324_, f_72324_, false);
                this.m_73441_(p_192360_, p_192364_, 3, 2, 3, 4, 2, 4, f_72323_, f_72323_, false);
                this.m_73441_(p_192360_, p_192364_, 3, 3, 3, 4, 3, 4, f_72324_, f_72324_, false);
            }
        }
    }

    public static class OceanMonumentEntryRoom
    extends OceanMonumentPiece {
        public OceanMonumentEntryRoom(Direction p_72299_, RoomDefinition p_72300_) {
            super(StructurePieceType.f_67125_, 1, p_72299_, p_72300_, 1, 1, 1);
        }

        public OceanMonumentEntryRoom(CompoundTag p_192335_) {
            super(StructurePieceType.f_67125_, p_192335_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192337_, StructureFeatureManager p_192338_, ChunkGenerator p_192339_, Random p_192340_, BoundingBox p_192341_, ChunkPos p_192342_, BlockPos p_192343_) {
            this.m_73441_(p_192337_, p_192341_, 0, 3, 0, 2, 3, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192337_, p_192341_, 5, 3, 0, 7, 3, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192337_, p_192341_, 0, 2, 0, 1, 2, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192337_, p_192341_, 6, 2, 0, 7, 2, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192337_, p_192341_, 0, 1, 0, 0, 1, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192337_, p_192341_, 7, 1, 0, 7, 1, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192337_, p_192341_, 0, 1, 7, 7, 3, 7, f_72324_, f_72324_, false);
            this.m_73441_(p_192337_, p_192341_, 1, 1, 0, 2, 3, 0, f_72324_, f_72324_, false);
            this.m_73441_(p_192337_, p_192341_, 5, 1, 0, 6, 3, 0, f_72324_, f_72324_, false);
            if (this.f_72334_.f_72445_[Direction.NORTH.m_122411_()]) {
                this.m_72360_(p_192337_, p_192341_, 3, 1, 7, 4, 2, 7);
            }
            if (this.f_72334_.f_72445_[Direction.WEST.m_122411_()]) {
                this.m_72360_(p_192337_, p_192341_, 0, 1, 3, 1, 2, 4);
            }
            if (this.f_72334_.f_72445_[Direction.EAST.m_122411_()]) {
                this.m_72360_(p_192337_, p_192341_, 6, 1, 3, 7, 2, 4);
            }
        }
    }

    public static class MonumentBuilding
    extends OceanMonumentPiece {
        private static final int f_162988_ = 58;
        private static final int f_162989_ = 22;
        private static final int f_162990_ = 58;
        public static final int f_162992_ = 29;
        private static final int f_162991_ = 61;
        private RoomDefinition f_72156_;
        private RoomDefinition f_72157_;
        private final List<OceanMonumentPiece> f_72158_ = Lists.newArrayList();

        public MonumentBuilding(Random p_72163_, int p_72164_, int p_72165_, Direction p_72166_) {
            super(StructurePieceType.f_67118_, p_72166_, 0, MonumentBuilding.m_163541_(p_72164_, 39, p_72165_, p_72166_, 58, 23, 58));
            this.m_73519_(p_72166_);
            List<RoomDefinition> $$4 = this.m_72179_(p_72163_);
            this.f_72156_.f_72446_ = true;
            this.f_72158_.add(new OceanMonumentEntryRoom(p_72166_, this.f_72156_));
            this.f_72158_.add(new OceanMonumentCoreRoom(p_72166_, this.f_72157_));
            ArrayList $$5 = Lists.newArrayList();
            $$5.add(new FitDoubleXYRoom());
            $$5.add(new FitDoubleYZRoom());
            $$5.add(new FitDoubleZRoom());
            $$5.add(new FitDoubleXRoom());
            $$5.add(new FitDoubleYRoom());
            $$5.add(new FitSimpleTopRoom());
            $$5.add(new FitSimpleRoom());
            block0: for (RoomDefinition roomDefinition : $$4) {
                if (roomDefinition.f_72446_ || roomDefinition.m_72462_()) continue;
                for (MonumentRoomFitter $$7 : $$5) {
                    if (!$$7.m_7725_(roomDefinition)) continue;
                    this.f_72158_.add($$7.m_7924_(p_72166_, roomDefinition, p_72163_));
                    continue block0;
                }
            }
            BlockPos.MutableBlockPos $$8 = this.m_163582_(9, 0, 22);
            for (OceanMonumentPiece $$9 : this.f_72158_) {
                $$9.m_73547_().m_162373_($$8);
            }
            BoundingBox boundingBox = BoundingBox.m_162375_(this.m_163582_(1, 1, 1), this.m_163582_(23, 8, 21));
            BoundingBox $$11 = BoundingBox.m_162375_(this.m_163582_(34, 1, 1), this.m_163582_(56, 8, 21));
            BoundingBox $$12 = BoundingBox.m_162375_(this.m_163582_(22, 13, 22), this.m_163582_(35, 17, 35));
            int $$13 = p_72163_.nextInt();
            this.f_72158_.add(new OceanMonumentWingRoom(p_72166_, boundingBox, $$13++));
            this.f_72158_.add(new OceanMonumentWingRoom(p_72166_, $$11, $$13++));
            this.f_72158_.add(new OceanMonumentPenthouse(p_72166_, $$12));
        }

        public MonumentBuilding(CompoundTag p_192265_) {
            super(StructurePieceType.f_67118_, p_192265_);
        }

        private List<RoomDefinition> m_72179_(Random p_72180_) {
            RoomDefinition[] $$1 = new RoomDefinition[75];
            for (int $$2 = 0; $$2 < 5; ++$$2) {
                for (int $$3 = 0; $$3 < 4; ++$$3) {
                    boolean $$4 = false;
                    int $$5 = MonumentBuilding.m_72393_($$2, 0, $$3);
                    $$1[$$5] = new RoomDefinition($$5);
                }
            }
            for (int $$6 = 0; $$6 < 5; ++$$6) {
                for (int $$7 = 0; $$7 < 4; ++$$7) {
                    boolean $$8 = true;
                    int $$9 = MonumentBuilding.m_72393_($$6, 1, $$7);
                    $$1[$$9] = new RoomDefinition($$9);
                }
            }
            for (int $$10 = 1; $$10 < 4; ++$$10) {
                for (int $$11 = 0; $$11 < 2; ++$$11) {
                    int $$12 = 2;
                    int $$13 = MonumentBuilding.m_72393_($$10, 2, $$11);
                    $$1[$$13] = new RoomDefinition($$13);
                }
            }
            this.f_72156_ = $$1[f_72330_];
            for (int $$14 = 0; $$14 < 5; ++$$14) {
                for (int $$15 = 0; $$15 < 5; ++$$15) {
                    for (int $$16 = 0; $$16 < 3; ++$$16) {
                        int $$17 = MonumentBuilding.m_72393_($$14, $$16, $$15);
                        if ($$1[$$17] == null) continue;
                        for (Direction $$18 : Direction.values()) {
                            int $$22;
                            int $$19 = $$14 + $$18.m_122429_();
                            int $$20 = $$16 + $$18.m_122430_();
                            int $$21 = $$15 + $$18.m_122431_();
                            if ($$19 < 0 || $$19 >= 5 || $$21 < 0 || $$21 >= 5 || $$20 < 0 || $$20 >= 3 || $$1[$$22 = MonumentBuilding.m_72393_($$19, $$20, $$21)] == null) continue;
                            if ($$21 == $$15) {
                                $$1[$$17].m_72459_($$18, $$1[$$22]);
                                continue;
                            }
                            $$1[$$17].m_72459_($$18.m_122424_(), $$1[$$22]);
                        }
                    }
                }
            }
            RoomDefinition $$23 = new RoomDefinition(1003);
            RoomDefinition $$24 = new RoomDefinition(1001);
            RoomDefinition $$25 = new RoomDefinition(1002);
            $$1[f_72331_].m_72459_(Direction.UP, $$23);
            $$1[f_72332_].m_72459_(Direction.SOUTH, $$24);
            $$1[f_72333_].m_72459_(Direction.SOUTH, $$25);
            $$23.f_72446_ = true;
            $$24.f_72446_ = true;
            $$25.f_72446_ = true;
            this.f_72156_.f_72447_ = true;
            this.f_72157_ = $$1[MonumentBuilding.m_72393_(p_72180_.nextInt(4), 0, 2)];
            this.f_72157_.f_72446_ = true;
            this.f_72157_.f_72444_[Direction.EAST.m_122411_()].f_72446_ = true;
            this.f_72157_.f_72444_[Direction.NORTH.m_122411_()].f_72446_ = true;
            this.f_72157_.f_72444_[Direction.EAST.m_122411_()].f_72444_[Direction.NORTH.m_122411_()].f_72446_ = true;
            this.f_72157_.f_72444_[Direction.UP.m_122411_()].f_72446_ = true;
            this.f_72157_.f_72444_[Direction.EAST.m_122411_()].f_72444_[Direction.UP.m_122411_()].f_72446_ = true;
            this.f_72157_.f_72444_[Direction.NORTH.m_122411_()].f_72444_[Direction.UP.m_122411_()].f_72446_ = true;
            this.f_72157_.f_72444_[Direction.EAST.m_122411_()].f_72444_[Direction.NORTH.m_122411_()].f_72444_[Direction.UP.m_122411_()].f_72446_ = true;
            ArrayList $$26 = Lists.newArrayList();
            for (RoomDefinition $$27 : $$1) {
                if ($$27 == null) continue;
                $$27.m_72451_();
                $$26.add($$27);
            }
            $$23.m_72451_();
            Collections.shuffle($$26, p_72180_);
            int $$28 = 1;
            for (RoomDefinition $$29 : $$26) {
                int $$30 = 0;
                for (int $$31 = 0; $$30 < 2 && $$31 < 5; ++$$31) {
                    int $$32 = p_72180_.nextInt(6);
                    if (!$$29.f_72445_[$$32]) continue;
                    int $$33 = Direction.m_122376_($$32).m_122424_().m_122411_();
                    $$29.f_72445_[$$32] = false;
                    $$29.f_72444_[$$32].f_72445_[$$33] = false;
                    if ($$29.m_72452_($$28++) && $$29.f_72444_[$$32].m_72452_($$28++)) {
                        ++$$30;
                        continue;
                    }
                    $$29.f_72445_[$$32] = true;
                    $$29.f_72444_[$$32].f_72445_[$$33] = true;
                }
            }
            $$26.add($$23);
            $$26.add($$24);
            $$26.add($$25);
            return $$26;
        }

        @Override
        public void m_183269_(WorldGenLevel p_192267_, StructureFeatureManager p_192268_, ChunkGenerator p_192269_, Random p_192270_, BoundingBox p_192271_, ChunkPos p_192272_, BlockPos p_192273_) {
            int $$7 = Math.max(p_192267_.m_5736_(), 64) - this.f_73383_.m_162396_();
            this.m_72360_(p_192267_, p_192271_, 0, 0, 0, 58, $$7, 58);
            this.m_72181_(false, 0, p_192267_, p_192270_, p_192271_);
            this.m_72181_(true, 33, p_192267_, p_192270_, p_192271_);
            this.m_72175_(p_192267_, p_192270_, p_192271_);
            this.m_72187_(p_192267_, p_192270_, p_192271_);
            this.m_72191_(p_192267_, p_192270_, p_192271_);
            this.m_72195_(p_192267_, p_192270_, p_192271_);
            this.m_72199_(p_192267_, p_192270_, p_192271_);
            this.m_72203_(p_192267_, p_192270_, p_192271_);
            for (int $$8 = 0; $$8 < 7; ++$$8) {
                int $$9 = 0;
                while ($$9 < 7) {
                    if ($$9 == 0 && $$8 == 3) {
                        $$9 = 6;
                    }
                    int $$10 = $$8 * 9;
                    int $$11 = $$9 * 9;
                    for (int $$12 = 0; $$12 < 4; ++$$12) {
                        for (int $$13 = 0; $$13 < 4; ++$$13) {
                            this.m_73434_(p_192267_, f_72324_, $$10 + $$12, 0, $$11 + $$13, p_192271_);
                            this.m_73528_(p_192267_, f_72324_, $$10 + $$12, -1, $$11 + $$13, p_192271_);
                        }
                    }
                    if ($$8 == 0 || $$8 == 6) {
                        ++$$9;
                        continue;
                    }
                    $$9 += 6;
                }
            }
            for (int $$14 = 0; $$14 < 5; ++$$14) {
                this.m_72360_(p_192267_, p_192271_, -1 - $$14, 0 + $$14 * 2, -1 - $$14, -1 - $$14, 23, 58 + $$14);
                this.m_72360_(p_192267_, p_192271_, 58 + $$14, 0 + $$14 * 2, -1 - $$14, 58 + $$14, 23, 58 + $$14);
                this.m_72360_(p_192267_, p_192271_, 0 - $$14, 0 + $$14 * 2, -1 - $$14, 57 + $$14, 23, -1 - $$14);
                this.m_72360_(p_192267_, p_192271_, 0 - $$14, 0 + $$14 * 2, 58 + $$14, 57 + $$14, 23, 58 + $$14);
            }
            for (OceanMonumentPiece $$15 : this.f_72158_) {
                if (!$$15.m_73547_().m_71049_(p_192271_)) continue;
                $$15.m_183269_(p_192267_, p_192268_, p_192269_, p_192270_, p_192271_, p_192272_, p_192273_);
            }
        }

        private void m_72181_(boolean p_72182_, int p_72183_, WorldGenLevel p_72184_, Random p_72185_, BoundingBox p_72186_) {
            int $$5 = 24;
            if (this.m_72385_(p_72186_, p_72183_, 0, p_72183_ + 23, 20)) {
                this.m_73441_(p_72184_, p_72186_, p_72183_ + 0, 0, 0, p_72183_ + 24, 0, 20, f_72323_, f_72323_, false);
                this.m_72360_(p_72184_, p_72186_, p_72183_ + 0, 1, 0, p_72183_ + 24, 10, 20);
                for (int $$6 = 0; $$6 < 4; ++$$6) {
                    this.m_73441_(p_72184_, p_72186_, p_72183_ + $$6, $$6 + 1, $$6, p_72183_ + $$6, $$6 + 1, 20, f_72324_, f_72324_, false);
                    this.m_73441_(p_72184_, p_72186_, p_72183_ + $$6 + 7, $$6 + 5, $$6 + 7, p_72183_ + $$6 + 7, $$6 + 5, 20, f_72324_, f_72324_, false);
                    this.m_73441_(p_72184_, p_72186_, p_72183_ + 17 - $$6, $$6 + 5, $$6 + 7, p_72183_ + 17 - $$6, $$6 + 5, 20, f_72324_, f_72324_, false);
                    this.m_73441_(p_72184_, p_72186_, p_72183_ + 24 - $$6, $$6 + 1, $$6, p_72183_ + 24 - $$6, $$6 + 1, 20, f_72324_, f_72324_, false);
                    this.m_73441_(p_72184_, p_72186_, p_72183_ + $$6 + 1, $$6 + 1, $$6, p_72183_ + 23 - $$6, $$6 + 1, $$6, f_72324_, f_72324_, false);
                    this.m_73441_(p_72184_, p_72186_, p_72183_ + $$6 + 8, $$6 + 5, $$6 + 7, p_72183_ + 16 - $$6, $$6 + 5, $$6 + 7, f_72324_, f_72324_, false);
                }
                this.m_73441_(p_72184_, p_72186_, p_72183_ + 4, 4, 4, p_72183_ + 6, 4, 20, f_72323_, f_72323_, false);
                this.m_73441_(p_72184_, p_72186_, p_72183_ + 7, 4, 4, p_72183_ + 17, 4, 6, f_72323_, f_72323_, false);
                this.m_73441_(p_72184_, p_72186_, p_72183_ + 18, 4, 4, p_72183_ + 20, 4, 20, f_72323_, f_72323_, false);
                this.m_73441_(p_72184_, p_72186_, p_72183_ + 11, 8, 11, p_72183_ + 13, 8, 20, f_72323_, f_72323_, false);
                this.m_73434_(p_72184_, f_72326_, p_72183_ + 12, 9, 12, p_72186_);
                this.m_73434_(p_72184_, f_72326_, p_72183_ + 12, 9, 15, p_72186_);
                this.m_73434_(p_72184_, f_72326_, p_72183_ + 12, 9, 18, p_72186_);
                int $$7 = p_72183_ + (p_72182_ ? 19 : 5);
                int $$8 = p_72183_ + (p_72182_ ? 5 : 19);
                for (int $$9 = 20; $$9 >= 5; $$9 -= 3) {
                    this.m_73434_(p_72184_, f_72326_, $$7, 5, $$9, p_72186_);
                }
                for (int $$10 = 19; $$10 >= 7; $$10 -= 3) {
                    this.m_73434_(p_72184_, f_72326_, $$8, 5, $$10, p_72186_);
                }
                for (int $$11 = 0; $$11 < 4; ++$$11) {
                    int $$12 = p_72182_ ? p_72183_ + 24 - (17 - $$11 * 3) : p_72183_ + 17 - $$11 * 3;
                    this.m_73434_(p_72184_, f_72326_, $$12, 5, 5, p_72186_);
                }
                this.m_73434_(p_72184_, f_72326_, $$8, 5, 5, p_72186_);
                this.m_73441_(p_72184_, p_72186_, p_72183_ + 11, 1, 12, p_72183_ + 13, 7, 12, f_72323_, f_72323_, false);
                this.m_73441_(p_72184_, p_72186_, p_72183_ + 12, 1, 11, p_72183_ + 12, 7, 13, f_72323_, f_72323_, false);
            }
        }

        private void m_72175_(WorldGenLevel p_72176_, Random p_72177_, BoundingBox p_72178_) {
            if (this.m_72385_(p_72178_, 22, 5, 35, 17)) {
                this.m_72360_(p_72176_, p_72178_, 25, 0, 0, 32, 8, 20);
                for (int $$3 = 0; $$3 < 4; ++$$3) {
                    this.m_73441_(p_72176_, p_72178_, 24, 2, 5 + $$3 * 4, 24, 4, 5 + $$3 * 4, f_72324_, f_72324_, false);
                    this.m_73441_(p_72176_, p_72178_, 22, 4, 5 + $$3 * 4, 23, 4, 5 + $$3 * 4, f_72324_, f_72324_, false);
                    this.m_73434_(p_72176_, f_72324_, 25, 5, 5 + $$3 * 4, p_72178_);
                    this.m_73434_(p_72176_, f_72324_, 26, 6, 5 + $$3 * 4, p_72178_);
                    this.m_73434_(p_72176_, f_72327_, 26, 5, 5 + $$3 * 4, p_72178_);
                    this.m_73441_(p_72176_, p_72178_, 33, 2, 5 + $$3 * 4, 33, 4, 5 + $$3 * 4, f_72324_, f_72324_, false);
                    this.m_73441_(p_72176_, p_72178_, 34, 4, 5 + $$3 * 4, 35, 4, 5 + $$3 * 4, f_72324_, f_72324_, false);
                    this.m_73434_(p_72176_, f_72324_, 32, 5, 5 + $$3 * 4, p_72178_);
                    this.m_73434_(p_72176_, f_72324_, 31, 6, 5 + $$3 * 4, p_72178_);
                    this.m_73434_(p_72176_, f_72327_, 31, 5, 5 + $$3 * 4, p_72178_);
                    this.m_73441_(p_72176_, p_72178_, 27, 6, 5 + $$3 * 4, 30, 6, 5 + $$3 * 4, f_72323_, f_72323_, false);
                }
            }
        }

        private void m_72187_(WorldGenLevel p_72188_, Random p_72189_, BoundingBox p_72190_) {
            if (this.m_72385_(p_72190_, 15, 20, 42, 21)) {
                this.m_73441_(p_72188_, p_72190_, 15, 0, 21, 42, 0, 21, f_72323_, f_72323_, false);
                this.m_72360_(p_72188_, p_72190_, 26, 1, 21, 31, 3, 21);
                this.m_73441_(p_72188_, p_72190_, 21, 12, 21, 36, 12, 21, f_72323_, f_72323_, false);
                this.m_73441_(p_72188_, p_72190_, 17, 11, 21, 40, 11, 21, f_72323_, f_72323_, false);
                this.m_73441_(p_72188_, p_72190_, 16, 10, 21, 41, 10, 21, f_72323_, f_72323_, false);
                this.m_73441_(p_72188_, p_72190_, 15, 7, 21, 42, 9, 21, f_72323_, f_72323_, false);
                this.m_73441_(p_72188_, p_72190_, 16, 6, 21, 41, 6, 21, f_72323_, f_72323_, false);
                this.m_73441_(p_72188_, p_72190_, 17, 5, 21, 40, 5, 21, f_72323_, f_72323_, false);
                this.m_73441_(p_72188_, p_72190_, 21, 4, 21, 36, 4, 21, f_72323_, f_72323_, false);
                this.m_73441_(p_72188_, p_72190_, 22, 3, 21, 26, 3, 21, f_72323_, f_72323_, false);
                this.m_73441_(p_72188_, p_72190_, 31, 3, 21, 35, 3, 21, f_72323_, f_72323_, false);
                this.m_73441_(p_72188_, p_72190_, 23, 2, 21, 25, 2, 21, f_72323_, f_72323_, false);
                this.m_73441_(p_72188_, p_72190_, 32, 2, 21, 34, 2, 21, f_72323_, f_72323_, false);
                this.m_73441_(p_72188_, p_72190_, 28, 4, 20, 29, 4, 21, f_72324_, f_72324_, false);
                this.m_73434_(p_72188_, f_72324_, 27, 3, 21, p_72190_);
                this.m_73434_(p_72188_, f_72324_, 30, 3, 21, p_72190_);
                this.m_73434_(p_72188_, f_72324_, 26, 2, 21, p_72190_);
                this.m_73434_(p_72188_, f_72324_, 31, 2, 21, p_72190_);
                this.m_73434_(p_72188_, f_72324_, 25, 1, 21, p_72190_);
                this.m_73434_(p_72188_, f_72324_, 32, 1, 21, p_72190_);
                for (int $$3 = 0; $$3 < 7; ++$$3) {
                    this.m_73434_(p_72188_, f_72325_, 28 - $$3, 6 + $$3, 21, p_72190_);
                    this.m_73434_(p_72188_, f_72325_, 29 + $$3, 6 + $$3, 21, p_72190_);
                }
                for (int $$4 = 0; $$4 < 4; ++$$4) {
                    this.m_73434_(p_72188_, f_72325_, 28 - $$4, 9 + $$4, 21, p_72190_);
                    this.m_73434_(p_72188_, f_72325_, 29 + $$4, 9 + $$4, 21, p_72190_);
                }
                this.m_73434_(p_72188_, f_72325_, 28, 12, 21, p_72190_);
                this.m_73434_(p_72188_, f_72325_, 29, 12, 21, p_72190_);
                for (int $$5 = 0; $$5 < 3; ++$$5) {
                    this.m_73434_(p_72188_, f_72325_, 22 - $$5 * 2, 8, 21, p_72190_);
                    this.m_73434_(p_72188_, f_72325_, 22 - $$5 * 2, 9, 21, p_72190_);
                    this.m_73434_(p_72188_, f_72325_, 35 + $$5 * 2, 8, 21, p_72190_);
                    this.m_73434_(p_72188_, f_72325_, 35 + $$5 * 2, 9, 21, p_72190_);
                }
                this.m_72360_(p_72188_, p_72190_, 15, 13, 21, 42, 15, 21);
                this.m_72360_(p_72188_, p_72190_, 15, 1, 21, 15, 6, 21);
                this.m_72360_(p_72188_, p_72190_, 16, 1, 21, 16, 5, 21);
                this.m_72360_(p_72188_, p_72190_, 17, 1, 21, 20, 4, 21);
                this.m_72360_(p_72188_, p_72190_, 21, 1, 21, 21, 3, 21);
                this.m_72360_(p_72188_, p_72190_, 22, 1, 21, 22, 2, 21);
                this.m_72360_(p_72188_, p_72190_, 23, 1, 21, 24, 1, 21);
                this.m_72360_(p_72188_, p_72190_, 42, 1, 21, 42, 6, 21);
                this.m_72360_(p_72188_, p_72190_, 41, 1, 21, 41, 5, 21);
                this.m_72360_(p_72188_, p_72190_, 37, 1, 21, 40, 4, 21);
                this.m_72360_(p_72188_, p_72190_, 36, 1, 21, 36, 3, 21);
                this.m_72360_(p_72188_, p_72190_, 33, 1, 21, 34, 1, 21);
                this.m_72360_(p_72188_, p_72190_, 35, 1, 21, 35, 2, 21);
            }
        }

        private void m_72191_(WorldGenLevel p_72192_, Random p_72193_, BoundingBox p_72194_) {
            if (this.m_72385_(p_72194_, 21, 21, 36, 36)) {
                this.m_73441_(p_72192_, p_72194_, 21, 0, 22, 36, 0, 36, f_72323_, f_72323_, false);
                this.m_72360_(p_72192_, p_72194_, 21, 1, 22, 36, 23, 36);
                for (int $$3 = 0; $$3 < 4; ++$$3) {
                    this.m_73441_(p_72192_, p_72194_, 21 + $$3, 13 + $$3, 21 + $$3, 36 - $$3, 13 + $$3, 21 + $$3, f_72324_, f_72324_, false);
                    this.m_73441_(p_72192_, p_72194_, 21 + $$3, 13 + $$3, 36 - $$3, 36 - $$3, 13 + $$3, 36 - $$3, f_72324_, f_72324_, false);
                    this.m_73441_(p_72192_, p_72194_, 21 + $$3, 13 + $$3, 22 + $$3, 21 + $$3, 13 + $$3, 35 - $$3, f_72324_, f_72324_, false);
                    this.m_73441_(p_72192_, p_72194_, 36 - $$3, 13 + $$3, 22 + $$3, 36 - $$3, 13 + $$3, 35 - $$3, f_72324_, f_72324_, false);
                }
                this.m_73441_(p_72192_, p_72194_, 25, 16, 25, 32, 16, 32, f_72323_, f_72323_, false);
                this.m_73441_(p_72192_, p_72194_, 25, 17, 25, 25, 19, 25, f_72324_, f_72324_, false);
                this.m_73441_(p_72192_, p_72194_, 32, 17, 25, 32, 19, 25, f_72324_, f_72324_, false);
                this.m_73441_(p_72192_, p_72194_, 25, 17, 32, 25, 19, 32, f_72324_, f_72324_, false);
                this.m_73441_(p_72192_, p_72194_, 32, 17, 32, 32, 19, 32, f_72324_, f_72324_, false);
                this.m_73434_(p_72192_, f_72324_, 26, 20, 26, p_72194_);
                this.m_73434_(p_72192_, f_72324_, 27, 21, 27, p_72194_);
                this.m_73434_(p_72192_, f_72327_, 27, 20, 27, p_72194_);
                this.m_73434_(p_72192_, f_72324_, 26, 20, 31, p_72194_);
                this.m_73434_(p_72192_, f_72324_, 27, 21, 30, p_72194_);
                this.m_73434_(p_72192_, f_72327_, 27, 20, 30, p_72194_);
                this.m_73434_(p_72192_, f_72324_, 31, 20, 31, p_72194_);
                this.m_73434_(p_72192_, f_72324_, 30, 21, 30, p_72194_);
                this.m_73434_(p_72192_, f_72327_, 30, 20, 30, p_72194_);
                this.m_73434_(p_72192_, f_72324_, 31, 20, 26, p_72194_);
                this.m_73434_(p_72192_, f_72324_, 30, 21, 27, p_72194_);
                this.m_73434_(p_72192_, f_72327_, 30, 20, 27, p_72194_);
                this.m_73441_(p_72192_, p_72194_, 28, 21, 27, 29, 21, 27, f_72323_, f_72323_, false);
                this.m_73441_(p_72192_, p_72194_, 27, 21, 28, 27, 21, 29, f_72323_, f_72323_, false);
                this.m_73441_(p_72192_, p_72194_, 28, 21, 30, 29, 21, 30, f_72323_, f_72323_, false);
                this.m_73441_(p_72192_, p_72194_, 30, 21, 28, 30, 21, 29, f_72323_, f_72323_, false);
            }
        }

        private void m_72195_(WorldGenLevel p_72196_, Random p_72197_, BoundingBox p_72198_) {
            if (this.m_72385_(p_72198_, 0, 21, 6, 58)) {
                this.m_73441_(p_72196_, p_72198_, 0, 0, 21, 6, 0, 57, f_72323_, f_72323_, false);
                this.m_72360_(p_72196_, p_72198_, 0, 1, 21, 6, 7, 57);
                this.m_73441_(p_72196_, p_72198_, 4, 4, 21, 6, 4, 53, f_72323_, f_72323_, false);
                for (int $$3 = 0; $$3 < 4; ++$$3) {
                    this.m_73441_(p_72196_, p_72198_, $$3, $$3 + 1, 21, $$3, $$3 + 1, 57 - $$3, f_72324_, f_72324_, false);
                }
                for (int $$4 = 23; $$4 < 53; $$4 += 3) {
                    this.m_73434_(p_72196_, f_72326_, 5, 5, $$4, p_72198_);
                }
                this.m_73434_(p_72196_, f_72326_, 5, 5, 52, p_72198_);
                for (int $$5 = 0; $$5 < 4; ++$$5) {
                    this.m_73441_(p_72196_, p_72198_, $$5, $$5 + 1, 21, $$5, $$5 + 1, 57 - $$5, f_72324_, f_72324_, false);
                }
                this.m_73441_(p_72196_, p_72198_, 4, 1, 52, 6, 3, 52, f_72323_, f_72323_, false);
                this.m_73441_(p_72196_, p_72198_, 5, 1, 51, 5, 3, 53, f_72323_, f_72323_, false);
            }
            if (this.m_72385_(p_72198_, 51, 21, 58, 58)) {
                this.m_73441_(p_72196_, p_72198_, 51, 0, 21, 57, 0, 57, f_72323_, f_72323_, false);
                this.m_72360_(p_72196_, p_72198_, 51, 1, 21, 57, 7, 57);
                this.m_73441_(p_72196_, p_72198_, 51, 4, 21, 53, 4, 53, f_72323_, f_72323_, false);
                for (int $$6 = 0; $$6 < 4; ++$$6) {
                    this.m_73441_(p_72196_, p_72198_, 57 - $$6, $$6 + 1, 21, 57 - $$6, $$6 + 1, 57 - $$6, f_72324_, f_72324_, false);
                }
                for (int $$7 = 23; $$7 < 53; $$7 += 3) {
                    this.m_73434_(p_72196_, f_72326_, 52, 5, $$7, p_72198_);
                }
                this.m_73434_(p_72196_, f_72326_, 52, 5, 52, p_72198_);
                this.m_73441_(p_72196_, p_72198_, 51, 1, 52, 53, 3, 52, f_72323_, f_72323_, false);
                this.m_73441_(p_72196_, p_72198_, 52, 1, 51, 52, 3, 53, f_72323_, f_72323_, false);
            }
            if (this.m_72385_(p_72198_, 0, 51, 57, 57)) {
                this.m_73441_(p_72196_, p_72198_, 7, 0, 51, 50, 0, 57, f_72323_, f_72323_, false);
                this.m_72360_(p_72196_, p_72198_, 7, 1, 51, 50, 10, 57);
                for (int $$8 = 0; $$8 < 4; ++$$8) {
                    this.m_73441_(p_72196_, p_72198_, $$8 + 1, $$8 + 1, 57 - $$8, 56 - $$8, $$8 + 1, 57 - $$8, f_72324_, f_72324_, false);
                }
            }
        }

        private void m_72199_(WorldGenLevel p_72200_, Random p_72201_, BoundingBox p_72202_) {
            if (this.m_72385_(p_72202_, 7, 21, 13, 50)) {
                this.m_73441_(p_72200_, p_72202_, 7, 0, 21, 13, 0, 50, f_72323_, f_72323_, false);
                this.m_72360_(p_72200_, p_72202_, 7, 1, 21, 13, 10, 50);
                this.m_73441_(p_72200_, p_72202_, 11, 8, 21, 13, 8, 53, f_72323_, f_72323_, false);
                for (int $$3 = 0; $$3 < 4; ++$$3) {
                    this.m_73441_(p_72200_, p_72202_, $$3 + 7, $$3 + 5, 21, $$3 + 7, $$3 + 5, 54, f_72324_, f_72324_, false);
                }
                for (int $$4 = 21; $$4 <= 45; $$4 += 3) {
                    this.m_73434_(p_72200_, f_72326_, 12, 9, $$4, p_72202_);
                }
            }
            if (this.m_72385_(p_72202_, 44, 21, 50, 54)) {
                this.m_73441_(p_72200_, p_72202_, 44, 0, 21, 50, 0, 50, f_72323_, f_72323_, false);
                this.m_72360_(p_72200_, p_72202_, 44, 1, 21, 50, 10, 50);
                this.m_73441_(p_72200_, p_72202_, 44, 8, 21, 46, 8, 53, f_72323_, f_72323_, false);
                for (int $$5 = 0; $$5 < 4; ++$$5) {
                    this.m_73441_(p_72200_, p_72202_, 50 - $$5, $$5 + 5, 21, 50 - $$5, $$5 + 5, 54, f_72324_, f_72324_, false);
                }
                for (int $$6 = 21; $$6 <= 45; $$6 += 3) {
                    this.m_73434_(p_72200_, f_72326_, 45, 9, $$6, p_72202_);
                }
            }
            if (this.m_72385_(p_72202_, 8, 44, 49, 54)) {
                this.m_73441_(p_72200_, p_72202_, 14, 0, 44, 43, 0, 50, f_72323_, f_72323_, false);
                this.m_72360_(p_72200_, p_72202_, 14, 1, 44, 43, 10, 50);
                for (int $$7 = 12; $$7 <= 45; $$7 += 3) {
                    this.m_73434_(p_72200_, f_72326_, $$7, 9, 45, p_72202_);
                    this.m_73434_(p_72200_, f_72326_, $$7, 9, 52, p_72202_);
                    if ($$7 != 12 && $$7 != 18 && $$7 != 24 && $$7 != 33 && $$7 != 39 && $$7 != 45) continue;
                    this.m_73434_(p_72200_, f_72326_, $$7, 9, 47, p_72202_);
                    this.m_73434_(p_72200_, f_72326_, $$7, 9, 50, p_72202_);
                    this.m_73434_(p_72200_, f_72326_, $$7, 10, 45, p_72202_);
                    this.m_73434_(p_72200_, f_72326_, $$7, 10, 46, p_72202_);
                    this.m_73434_(p_72200_, f_72326_, $$7, 10, 51, p_72202_);
                    this.m_73434_(p_72200_, f_72326_, $$7, 10, 52, p_72202_);
                    this.m_73434_(p_72200_, f_72326_, $$7, 11, 47, p_72202_);
                    this.m_73434_(p_72200_, f_72326_, $$7, 11, 50, p_72202_);
                    this.m_73434_(p_72200_, f_72326_, $$7, 12, 48, p_72202_);
                    this.m_73434_(p_72200_, f_72326_, $$7, 12, 49, p_72202_);
                }
                for (int $$8 = 0; $$8 < 3; ++$$8) {
                    this.m_73441_(p_72200_, p_72202_, 8 + $$8, 5 + $$8, 54, 49 - $$8, 5 + $$8, 54, f_72323_, f_72323_, false);
                }
                this.m_73441_(p_72200_, p_72202_, 11, 8, 54, 46, 8, 54, f_72324_, f_72324_, false);
                this.m_73441_(p_72200_, p_72202_, 14, 8, 44, 43, 8, 53, f_72323_, f_72323_, false);
            }
        }

        private void m_72203_(WorldGenLevel p_72204_, Random p_72205_, BoundingBox p_72206_) {
            if (this.m_72385_(p_72206_, 14, 21, 20, 43)) {
                this.m_73441_(p_72204_, p_72206_, 14, 0, 21, 20, 0, 43, f_72323_, f_72323_, false);
                this.m_72360_(p_72204_, p_72206_, 14, 1, 22, 20, 14, 43);
                this.m_73441_(p_72204_, p_72206_, 18, 12, 22, 20, 12, 39, f_72323_, f_72323_, false);
                this.m_73441_(p_72204_, p_72206_, 18, 12, 21, 20, 12, 21, f_72324_, f_72324_, false);
                for (int $$3 = 0; $$3 < 4; ++$$3) {
                    this.m_73441_(p_72204_, p_72206_, $$3 + 14, $$3 + 9, 21, $$3 + 14, $$3 + 9, 43 - $$3, f_72324_, f_72324_, false);
                }
                for (int $$4 = 23; $$4 <= 39; $$4 += 3) {
                    this.m_73434_(p_72204_, f_72326_, 19, 13, $$4, p_72206_);
                }
            }
            if (this.m_72385_(p_72206_, 37, 21, 43, 43)) {
                this.m_73441_(p_72204_, p_72206_, 37, 0, 21, 43, 0, 43, f_72323_, f_72323_, false);
                this.m_72360_(p_72204_, p_72206_, 37, 1, 22, 43, 14, 43);
                this.m_73441_(p_72204_, p_72206_, 37, 12, 22, 39, 12, 39, f_72323_, f_72323_, false);
                this.m_73441_(p_72204_, p_72206_, 37, 12, 21, 39, 12, 21, f_72324_, f_72324_, false);
                for (int $$5 = 0; $$5 < 4; ++$$5) {
                    this.m_73441_(p_72204_, p_72206_, 43 - $$5, $$5 + 9, 21, 43 - $$5, $$5 + 9, 43 - $$5, f_72324_, f_72324_, false);
                }
                for (int $$6 = 23; $$6 <= 39; $$6 += 3) {
                    this.m_73434_(p_72204_, f_72326_, 38, 13, $$6, p_72206_);
                }
            }
            if (this.m_72385_(p_72206_, 15, 37, 42, 43)) {
                this.m_73441_(p_72204_, p_72206_, 21, 0, 37, 36, 0, 43, f_72323_, f_72323_, false);
                this.m_72360_(p_72204_, p_72206_, 21, 1, 37, 36, 14, 43);
                this.m_73441_(p_72204_, p_72206_, 21, 12, 37, 36, 12, 39, f_72323_, f_72323_, false);
                for (int $$7 = 0; $$7 < 4; ++$$7) {
                    this.m_73441_(p_72204_, p_72206_, 15 + $$7, $$7 + 9, 43 - $$7, 42 - $$7, $$7 + 9, 43 - $$7, f_72324_, f_72324_, false);
                }
                for (int $$8 = 21; $$8 <= 36; $$8 += 3) {
                    this.m_73434_(p_72204_, f_72326_, $$8, 13, 38, p_72206_);
                }
            }
        }
    }

    protected static abstract class OceanMonumentPiece
    extends StructurePiece {
        protected static final BlockState f_72323_ = Blocks.f_50377_.m_49966_();
        protected static final BlockState f_72324_ = Blocks.f_50378_.m_49966_();
        protected static final BlockState f_72325_ = Blocks.f_50379_.m_49966_();
        protected static final BlockState f_72326_ = f_72324_;
        protected static final BlockState f_72327_ = Blocks.f_50386_.m_49966_();
        protected static final boolean f_163020_ = true;
        protected static final BlockState f_72328_ = Blocks.f_49990_.m_49966_();
        protected static final Set<Block> f_72329_ = ImmutableSet.builder().add((Object)Blocks.f_50126_).add((Object)Blocks.f_50354_).add((Object)Blocks.f_50568_).add((Object)f_72328_.m_60734_()).build();
        protected static final int f_163021_ = 8;
        protected static final int f_163022_ = 8;
        protected static final int f_163023_ = 4;
        protected static final int f_163024_ = 5;
        protected static final int f_163025_ = 5;
        protected static final int f_163026_ = 3;
        protected static final int f_163027_ = 25;
        protected static final int f_163028_ = 75;
        protected static final int f_72330_ = OceanMonumentPiece.m_72393_(2, 0, 0);
        protected static final int f_72331_ = OceanMonumentPiece.m_72393_(2, 2, 0);
        protected static final int f_72332_ = OceanMonumentPiece.m_72393_(0, 1, 0);
        protected static final int f_72333_ = OceanMonumentPiece.m_72393_(4, 1, 0);
        protected static final int f_163029_ = 1001;
        protected static final int f_163030_ = 1002;
        protected static final int f_163031_ = 1003;
        protected RoomDefinition f_72334_;

        protected static int m_72393_(int p_72394_, int p_72395_, int p_72396_) {
            return p_72395_ * 25 + p_72396_ * 5 + p_72394_;
        }

        public OceanMonumentPiece(StructurePieceType p_163033_, Direction p_163034_, int p_163035_, BoundingBox p_163036_) {
            super(p_163033_, p_163035_, p_163036_);
            this.m_73519_(p_163034_);
        }

        protected OceanMonumentPiece(StructurePieceType p_72340_, int p_72341_, Direction p_72342_, RoomDefinition p_72343_, int p_72344_, int p_72345_, int p_72346_) {
            super(p_72340_, p_72341_, OceanMonumentPiece.m_163040_(p_72342_, p_72343_, p_72344_, p_72345_, p_72346_));
            this.m_73519_(p_72342_);
            this.f_72334_ = p_72343_;
        }

        private static BoundingBox m_163040_(Direction p_163041_, RoomDefinition p_163042_, int p_163043_, int p_163044_, int p_163045_) {
            int $$5 = p_163042_.f_72443_;
            int $$6 = $$5 % 5;
            int $$7 = $$5 / 5 % 5;
            int $$8 = $$5 / 25;
            BoundingBox $$9 = OceanMonumentPiece.m_163541_(0, 0, 0, p_163041_, p_163043_ * 8, p_163044_ * 4, p_163045_ * 8);
            switch (p_163041_) {
                case NORTH: {
                    $$9.m_162367_($$6 * 8, $$8 * 4, -($$7 + p_163045_) * 8 + 1);
                    break;
                }
                case SOUTH: {
                    $$9.m_162367_($$6 * 8, $$8 * 4, $$7 * 8);
                    break;
                }
                case WEST: {
                    $$9.m_162367_(-($$7 + p_163045_) * 8 + 1, $$8 * 4, $$6 * 8);
                    break;
                }
                default: {
                    $$9.m_162367_($$7 * 8, $$8 * 4, $$6 * 8);
                }
            }
            return $$9;
        }

        public OceanMonumentPiece(StructurePieceType p_72352_, CompoundTag p_72353_) {
            super(p_72352_, p_72353_);
        }

        @Override
        protected void m_183620_(StructurePieceSerializationContext p_192355_, CompoundTag p_192356_) {
        }

        protected void m_72360_(WorldGenLevel p_72361_, BoundingBox p_72362_, int p_72363_, int p_72364_, int p_72365_, int p_72366_, int p_72367_, int p_72368_) {
            for (int $$8 = p_72364_; $$8 <= p_72367_; ++$$8) {
                for (int $$9 = p_72363_; $$9 <= p_72366_; ++$$9) {
                    for (int $$10 = p_72365_; $$10 <= p_72368_; ++$$10) {
                        BlockState $$11 = this.m_73398_(p_72361_, $$9, $$8, $$10, p_72362_);
                        if (f_72329_.contains($$11.m_60734_())) continue;
                        if (this.m_73544_($$8) >= p_72361_.m_5736_() && $$11 != f_72328_) {
                            this.m_73434_(p_72361_, Blocks.f_50016_.m_49966_(), $$9, $$8, $$10, p_72362_);
                            continue;
                        }
                        this.m_73434_(p_72361_, f_72328_, $$9, $$8, $$10, p_72362_);
                    }
                }
            }
        }

        protected void m_72379_(WorldGenLevel p_72380_, BoundingBox p_72381_, int p_72382_, int p_72383_, boolean p_72384_) {
            if (p_72384_) {
                this.m_73441_(p_72380_, p_72381_, p_72382_ + 0, 0, p_72383_ + 0, p_72382_ + 2, 0, p_72383_ + 8 - 1, f_72323_, f_72323_, false);
                this.m_73441_(p_72380_, p_72381_, p_72382_ + 5, 0, p_72383_ + 0, p_72382_ + 8 - 1, 0, p_72383_ + 8 - 1, f_72323_, f_72323_, false);
                this.m_73441_(p_72380_, p_72381_, p_72382_ + 3, 0, p_72383_ + 0, p_72382_ + 4, 0, p_72383_ + 2, f_72323_, f_72323_, false);
                this.m_73441_(p_72380_, p_72381_, p_72382_ + 3, 0, p_72383_ + 5, p_72382_ + 4, 0, p_72383_ + 8 - 1, f_72323_, f_72323_, false);
                this.m_73441_(p_72380_, p_72381_, p_72382_ + 3, 0, p_72383_ + 2, p_72382_ + 4, 0, p_72383_ + 2, f_72324_, f_72324_, false);
                this.m_73441_(p_72380_, p_72381_, p_72382_ + 3, 0, p_72383_ + 5, p_72382_ + 4, 0, p_72383_ + 5, f_72324_, f_72324_, false);
                this.m_73441_(p_72380_, p_72381_, p_72382_ + 2, 0, p_72383_ + 3, p_72382_ + 2, 0, p_72383_ + 4, f_72324_, f_72324_, false);
                this.m_73441_(p_72380_, p_72381_, p_72382_ + 5, 0, p_72383_ + 3, p_72382_ + 5, 0, p_72383_ + 4, f_72324_, f_72324_, false);
            } else {
                this.m_73441_(p_72380_, p_72381_, p_72382_ + 0, 0, p_72383_ + 0, p_72382_ + 8 - 1, 0, p_72383_ + 8 - 1, f_72323_, f_72323_, false);
            }
        }

        protected void m_72369_(WorldGenLevel p_72370_, BoundingBox p_72371_, int p_72372_, int p_72373_, int p_72374_, int p_72375_, int p_72376_, int p_72377_, BlockState p_72378_) {
            for (int $$9 = p_72373_; $$9 <= p_72376_; ++$$9) {
                for (int $$10 = p_72372_; $$10 <= p_72375_; ++$$10) {
                    for (int $$11 = p_72374_; $$11 <= p_72377_; ++$$11) {
                        if (this.m_73398_(p_72370_, $$10, $$9, $$11, p_72371_) != f_72328_) continue;
                        this.m_73434_(p_72370_, p_72378_, $$10, $$9, $$11, p_72371_);
                    }
                }
            }
        }

        protected boolean m_72385_(BoundingBox p_72386_, int p_72387_, int p_72388_, int p_72389_, int p_72390_) {
            int $$5 = this.m_73392_(p_72387_, p_72388_);
            int $$6 = this.m_73525_(p_72387_, p_72388_);
            int $$7 = this.m_73392_(p_72389_, p_72390_);
            int $$8 = this.m_73525_(p_72389_, p_72390_);
            return p_72386_.m_71019_(Math.min($$5, $$7), Math.min($$6, $$8), Math.max($$5, $$7), Math.max($$6, $$8));
        }

        protected boolean m_72354_(WorldGenLevel p_72355_, BoundingBox p_72356_, int p_72357_, int p_72358_, int p_72359_) {
            BlockPos.MutableBlockPos $$5 = this.m_163582_(p_72357_, p_72358_, p_72359_);
            if (p_72356_.m_71051_($$5)) {
                ElderGuardian $$6 = EntityType.f_20563_.m_20615_(p_72355_.m_6018_());
                $$6.m_5634_($$6.m_21233_());
                $$6.m_7678_((double)$$5.m_123341_() + 0.5, $$5.m_123342_(), (double)$$5.m_123343_() + 0.5, 0.0f, 0.0f);
                $$6.m_6518_(p_72355_, p_72355_.m_6436_($$6.m_142538_()), MobSpawnType.STRUCTURE, null, null);
                p_72355_.m_47205_($$6);
                return true;
            }
            return false;
        }
    }
}

