/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import net.minecraft.FileUtil;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureManager {
    private static final Logger f_74325_ = LogManager.getLogger();
    private static final String f_163771_ = "structures";
    private static final String f_163772_ = ".nbt";
    private static final String f_163773_ = ".snbt";
    private final Map<ResourceLocation, Optional<StructureTemplate>> f_74326_ = Maps.newConcurrentMap();
    private final DataFixer f_74327_;
    private ResourceManager f_74328_;
    private final Path f_74329_;

    public StructureManager(ResourceManager p_74332_, LevelStorageSource.LevelStorageAccess p_74333_, DataFixer p_74334_) {
        this.f_74328_ = p_74332_;
        this.f_74327_ = p_74334_;
        this.f_74329_ = p_74333_.m_78283_(LevelResource.f_78179_).normalize();
    }

    public StructureTemplate m_74341_(ResourceLocation p_74342_) {
        Optional<StructureTemplate> $$1 = this.m_163774_(p_74342_);
        if ($$1.isPresent()) {
            return $$1.get();
        }
        StructureTemplate $$2 = new StructureTemplate();
        this.f_74326_.put(p_74342_, Optional.of($$2));
        return $$2;
    }

    public Optional<StructureTemplate> m_163774_(ResourceLocation p_163775_) {
        return this.f_74326_.computeIfAbsent(p_163775_, p_163781_ -> {
            Optional<StructureTemplate> $$1 = this.m_163778_((ResourceLocation)p_163781_);
            return $$1.isPresent() ? $$1 : this.m_163776_((ResourceLocation)p_163781_);
        });
    }

    public void m_74335_(ResourceManager p_74336_) {
        this.f_74328_ = p_74336_;
        this.f_74326_.clear();
    }

    private Optional<StructureTemplate> m_163776_(ResourceLocation p_163777_) {
        Optional<StructureTemplate> optional;
        block9: {
            ResourceLocation $$1 = new ResourceLocation(p_163777_.m_135827_(), "structures/" + p_163777_.m_135815_() + f_163772_);
            Resource $$2 = this.f_74328_.m_142591_($$1);
            try {
                optional = Optional.of(this.m_74337_($$2.m_6679_()));
                if ($$2 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if ($$2 != null) {
                        try {
                            $$2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException $$3) {
                    return Optional.empty();
                }
                catch (Throwable $$4) {
                    f_74325_.error("Couldn't load structure {}: {}", (Object)p_163777_, (Object)$$4.toString());
                    return Optional.empty();
                }
            }
            $$2.close();
        }
        return optional;
    }

    private Optional<StructureTemplate> m_163778_(ResourceLocation p_163779_) {
        Optional<StructureTemplate> optional;
        if (!this.f_74329_.toFile().isDirectory()) {
            return Optional.empty();
        }
        Path $$1 = this.m_74348_(p_163779_, f_163772_);
        FileInputStream $$2 = new FileInputStream($$1.toFile());
        try {
            optional = Optional.of(this.m_74337_($$2));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)$$2).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException $$3) {
                return Optional.empty();
            }
            catch (IOException $$4) {
                f_74325_.error("Couldn't load structure from {}", (Object)$$1, (Object)$$4);
                return Optional.empty();
            }
        }
        ((InputStream)$$2).close();
        return optional;
    }

    private StructureTemplate m_74337_(InputStream p_74338_) throws IOException {
        CompoundTag $$1 = NbtIo.m_128939_(p_74338_);
        return this.m_74339_($$1);
    }

    public StructureTemplate m_74339_(CompoundTag p_74340_) {
        if (!p_74340_.m_128425_("DataVersion", 99)) {
            p_74340_.m_128405_("DataVersion", 500);
        }
        StructureTemplate $$1 = new StructureTemplate();
        $$1.m_74638_(NbtUtils.m_129213_(this.f_74327_, DataFixTypes.STRUCTURE, p_74340_, p_74340_.m_128451_("DataVersion")));
        return $$1;
    }

    public boolean m_74351_(ResourceLocation p_74352_) {
        Optional<StructureTemplate> $$1 = this.f_74326_.get(p_74352_);
        if (!$$1.isPresent()) {
            return false;
        }
        StructureTemplate $$2 = $$1.get();
        Path $$3 = this.m_74348_(p_74352_, f_163772_);
        Path $$4 = $$3.getParent();
        if ($$4 == null) {
            return false;
        }
        try {
            Files.createDirectories(Files.exists($$4, new LinkOption[0]) ? $$4.toRealPath(new LinkOption[0]) : $$4, new FileAttribute[0]);
        }
        catch (IOException $$5) {
            f_74325_.error("Failed to create parent directory: {}", (Object)$$4);
            return false;
        }
        CompoundTag $$6 = $$2.m_74618_(new CompoundTag());
        try (FileOutputStream $$7 = new FileOutputStream($$3.toFile());){
            NbtIo.m_128947_($$6, $$7);
        }
        catch (Throwable $$8) {
            return false;
        }
        return true;
    }

    public Path m_74343_(ResourceLocation p_74344_, String p_74345_) {
        try {
            Path $$2 = this.f_74329_.resolve(p_74344_.m_135827_());
            Path $$3 = $$2.resolve(f_163771_);
            return FileUtil.m_133736_($$3, p_74344_.m_135815_(), p_74345_);
        }
        catch (InvalidPathException $$4) {
            throw new ResourceLocationException("Invalid resource path: " + p_74344_, $$4);
        }
    }

    private Path m_74348_(ResourceLocation p_74349_, String p_74350_) {
        if (p_74349_.m_135815_().contains("//")) {
            throw new ResourceLocationException("Invalid resource path: " + p_74349_);
        }
        Path $$2 = this.m_74343_(p_74349_, p_74350_);
        if (!($$2.startsWith(this.f_74329_) && FileUtil.m_133728_($$2) && FileUtil.m_133734_($$2))) {
            throw new ResourceLocationException("Invalid resource path: " + $$2);
        }
        return $$2;
    }

    public void m_74353_(ResourceLocation p_74354_) {
        this.f_74326_.remove(p_74354_);
    }
}

