/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventListener;
import net.minecraftforge.eventbus.api.IGenericEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ASMEventHandler
implements IEventListener {
    private static final String HANDLER_DESC = org.objectweb.asm.Type.getInternalName(IEventListener.class);
    private static final String HANDLER_FUNC_DESC = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(Event.class)});
    private static final HashMap<String, Method> PENDING = new HashMap();
    private final IEventListener handler;
    private final SubscribeEvent subInfo;
    private String readable;
    private Type filter = null;

    public ASMEventHandler(Object target, Method method, boolean isGeneric) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        Type type;
        this.enqueueWrapper(method);
        this.handler = Modifier.isStatic(method.getModifiers()) ? (IEventListener)Class.forName(this.getUniqueName(method), true, Thread.currentThread().getContextClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : (IEventListener)Class.forName(this.getUniqueName(method), true, Thread.currentThread().getContextClassLoader()).getConstructor(Object.class).newInstance(target);
        this.subInfo = method.getAnnotation(SubscribeEvent.class);
        this.readable = "ASM: " + target + " " + method.getName() + org.objectweb.asm.Type.getMethodDescriptor((Method)method);
        if (isGeneric && (type = method.getGenericParameterTypes()[0]) instanceof ParameterizedType) {
            WildcardType wfilter;
            this.filter = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (this.filter instanceof ParameterizedType) {
                this.filter = ((ParameterizedType)this.filter).getRawType();
            } else if (this.filter instanceof WildcardType && (wfilter = (WildcardType)this.filter).getUpperBounds().length == 1 && wfilter.getUpperBounds()[0] == Object.class && wfilter.getLowerBounds().length == 0) {
                this.filter = null;
            }
        }
    }

    public static boolean hasPendingWrapperClass(String className) {
        return PENDING.containsKey(className);
    }

    public static void processWrapperClass(String className, ClassNode node) {
        Method meth = PENDING.get(className);
        ASMEventHandler.transformNode(className, meth, node);
    }

    @Override
    public void invoke(Event event) {
        if (!(this.handler == null || event.isCancelable() && event.isCanceled() && !this.subInfo.receiveCanceled() || this.filter != null && this.filter != ((IGenericEvent)((Object)event)).getGenericType())) {
            this.handler.invoke(event);
        }
    }

    public EventPriority getPriority() {
        return this.subInfo.priority();
    }

    public void enqueueWrapper(Method callback) {
        String name = this.getUniqueName(callback);
        PENDING.putIfAbsent(name, callback);
    }

    private static void transformNode(String name, Method callback, ClassNode target) {
        boolean isStatic = Modifier.isStatic(callback.getModifiers());
        String desc = name.replace('.', '/');
        String instType = org.objectweb.asm.Type.getInternalName(callback.getDeclaringClass());
        String eventType = org.objectweb.asm.Type.getInternalName(callback.getParameterTypes()[0]);
        target.visit(60, 33, desc, null, "java/lang/Object", new String[]{HANDLER_DESC});
        target.visitSource(".dynamic", null);
        if (!isStatic) {
            target.visitField(1, "instance", "Ljava/lang/Object;", null, null).visitEnd();
        }
        MethodVisitor mv = target.visitMethod(1, "<init>", isStatic ? "()V" : "(Ljava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        if (!isStatic) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, desc, "instance", "Ljava/lang/Object;");
        }
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = target.visitMethod(1, "invoke", HANDLER_FUNC_DESC, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        if (!isStatic) {
            mv.visitFieldInsn(180, desc, "instance", "Ljava/lang/Object;");
            mv.visitTypeInsn(192, instType);
        }
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, eventType);
        mv.visitMethodInsn(isStatic ? 184 : 182, instType, callback.getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)callback), false);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        target.visitEnd();
    }

    private String getUniqueName(Method callback) {
        return String.format("%s.__%s_%s_%s", callback.getDeclaringClass().getPackageName(), callback.getDeclaringClass().getSimpleName(), callback.getName(), callback.getParameterTypes()[0].getSimpleName());
    }

    public String toString() {
        return this.readable;
    }
}

