/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import net.minecraftforge.eventbus.ASMEventHandler;
import net.minecraftforge.eventbus.EventAccessTransformer;
import net.minecraftforge.eventbus.EventSubclassTransformer;
import net.minecraftforge.eventbus.IEventBusEngine;
import net.minecraftforge.eventbus.LogMarkers;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public final class EventBusEngine
implements IEventBusEngine {
    private final EventSubclassTransformer eventTransformer;
    private final EventAccessTransformer accessTransformer;

    public EventBusEngine() {
        LogManager.getLogger().debug(LogMarkers.EVENTBUS, "Loading EventBus transformers");
        this.eventTransformer = new EventSubclassTransformer();
        this.accessTransformer = new EventAccessTransformer();
    }

    @Override
    public int processClass(ClassNode classNode, Type classType) {
        if (ASMEventHandler.hasPendingWrapperClass(classType.getClassName())) {
            ASMEventHandler.processWrapperClass(classType.getClassName(), classNode);
            LogManager.getLogger().debug(LogMarkers.EVENTBUS, "Built transformed event wrapper class {}", (Object)classType.getClassName());
            return 2;
        }
        int evtXformFlags = this.eventTransformer.transform(classNode, classType).isPresent() ? 2 : 0;
        int axXformFlags = this.accessTransformer.transform(classNode, classType) ? 256 : 0;
        return evtXformFlags | axXformFlags;
    }

    @Override
    public boolean handlesClass(Type classType) {
        String name = classType.getClassName();
        return !name.equals("net.minecraftforge.eventbus.api.Event") && !name.startsWith("net.minecraft.") && name.indexOf(46) != -1;
    }

    @Override
    public boolean findASMEventDispatcher(Type classType) {
        return ASMEventHandler.hasPendingWrapperClass(classType.getClassName());
    }
}

