/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.resource;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ResourceCacheManager {
    private final boolean supportsReloading;
    private final ForgeConfigSpec.BooleanValue indexOffThreadConfigOption;
    private final BiFunction<PackType, String, Path> pathBuilder;
    private final Map<PackTypeAndNamespace, NamespacedResourceCacheManager> managersByNamespace = Maps.newConcurrentMap();

    public ResourceCacheManager(boolean supportsReloading, ForgeConfigSpec.BooleanValue indexOffThreadConfig, BiFunction<PackType, String, Path> pathBuilder) {
        this.supportsReloading = supportsReloading;
        this.indexOffThreadConfigOption = indexOffThreadConfig;
        this.pathBuilder = pathBuilder;
    }

    public boolean shouldIndexOffThread() {
        return !ResourceCacheManager.getConfigValue(this.indexOffThreadConfigOption);
    }

    public static boolean shouldUseCache() {
        return ResourceCacheManager.getConfigValue(ForgeConfig.COMMON.cachePackAccess);
    }

    private static boolean getConfigValue(Supplier<Boolean> configValue) {
        try {
            return configValue.get();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public void index(String namespace) {
        for (PackType packType : PackType.values()) {
            PackTypeAndNamespace key = new PackTypeAndNamespace(packType, namespace);
            if (this.managersByNamespace.containsKey(key) && !this.supportsReloading) {
                return;
            }
            NamespacedResourceCacheManager newManager = new NamespacedResourceCacheManager(packType, namespace, this.shouldIndexOffThread(), this.pathBuilder, this::createWalkingStream);
            this.managersByNamespace.put(key, newManager);
            newManager.index();
        }
    }

    private Stream<Path> createWalkingStream(Path path) throws IOException {
        return Files.walk(path, new FileVisitOption[0]).filter(resourcePath -> !resourcePath.toString().endsWith(".mcmeta"));
    }

    public Collection<ResourceLocation> getResources(PackType type, String resourceNamespace, Path inputPath, Predicate<ResourceLocation> filter) {
        PackTypeAndNamespace key = new PackTypeAndNamespace(type, resourceNamespace);
        NamespacedResourceCacheManager manager = this.managersByNamespace.get(key);
        if (manager == null) {
            return Collections.emptyList();
        }
        return manager.getResources(inputPath, filter);
    }

    public Set<String> getNamespaces(PackType type) {
        return this.managersByNamespace.keySet().stream().filter(key -> key.packType() == type).map(PackTypeAndNamespace::namespace).collect(Collectors.toSet());
    }

    public boolean hasCached(PackType packType, String namespace) {
        PackTypeAndNamespace key = new PackTypeAndNamespace(packType, namespace);
        NamespacedResourceCacheManager manager = this.managersByNamespace.get(key);
        return manager != null && manager.cacheLoaded();
    }

    private record PackTypeAndNamespace(PackType packType, String namespace) {
    }

    private static class NamespacedResourceCacheManager {
        private static final Logger LOGGER = LogUtils.getLogger();
        private final PackType packType;
        private final String namespace;
        private final boolean indexOffThread;
        private final BiFunction<PackType, String, Path> pathBuilder;
        private final PathWalkerFactory pathFinder;
        private final Map<String, List<ResourceCacheEntry>> entriesByPathPrefix = Maps.newConcurrentMap();
        private final AtomicBoolean cacheLoaded = new AtomicBoolean(false);

        private NamespacedResourceCacheManager(PackType packType, String namespace, boolean indexOffThread, BiFunction<PackType, String, Path> pathBuilder, PathWalkerFactory pathFinder) {
            this.packType = packType;
            this.namespace = namespace;
            this.indexOffThread = indexOffThread;
            this.pathBuilder = pathBuilder;
            this.pathFinder = pathFinder;
        }

        public void index() {
            if (this.indexOffThread) {
                CompletableFuture.runAsync(this::doIndex, Util.m_183991_());
            } else {
                this.doIndex();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doIndex() {
            Path rootPath = this.pathBuilder.apply(this.packType, this.namespace);
            try (Stream<Path> paths = this.pathFinder.createWalkingStream(rootPath);){
                ((Stream)paths.parallel()).map(rootPath::relativize).map(path -> {
                    record PathWithLocationPath(Path path, String locationPath) {
                    }
                    return new PathWithLocationPath((Path)path, Joiner.on((char)'/').join((Iterable)path));
                }).filter(path -> ResourceLocation.m_135841_((String)path.locationPath())).map(path -> new ResourceCacheEntry(this.packType, this.namespace, path.path(), new ResourceLocation(this.namespace, path.locationPath()))).forEach(this::injectIntoCache);
            }
            catch (NoSuchFileException noSuchFileException) {
                LOGGER.debug("Failed to cache resources, the directory does not exist!", (Throwable)noSuchFileException);
            }
            catch (IOException ioException) {
                LOGGER.error("Failed to cache resources, some stuff might be missing!", (Throwable)ioException);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to cache resources, some stuff might be missing! Unknown exception!", (Throwable)exception);
            }
            finally {
                this.cacheLoaded.set(true);
            }
        }

        private void injectIntoCache(ResourceCacheEntry entry) {
            this.injectIntoCache(entry.path().getParent(), entry);
        }

        private void injectIntoCache(@Nullable Path parentPath, ResourceCacheEntry entry) {
            String pathEntry = parentPath == null ? "" : Joiner.on((String)"/").join((Iterable)parentPath);
            this.entriesByPathPrefix.computeIfAbsent(pathEntry, e -> new CopyOnWriteArrayList()).add(entry);
            if (parentPath != null && !pathEntry.isEmpty()) {
                this.injectIntoCache(parentPath.getParent(), entry);
            }
        }

        public Collection<ResourceLocation> getResources(Path inputPath, Predicate<ResourceLocation> filter) {
            if (!this.cacheLoaded()) {
                return new ArrayList<ResourceLocation>();
            }
            String pathEntry = Joiner.on((char)'/').join((Iterable)inputPath);
            return this.entriesByPathPrefix.getOrDefault(pathEntry, Collections.emptyList()).stream().map(ResourceCacheEntry::resourceLocation).filter(filter).collect(Collectors.toList());
        }

        public boolean cacheLoaded() {
            return this.cacheLoaded.get();
        }
    }

    @FunctionalInterface
    private static interface PathWalkerFactory {
        public Stream<Path> createWalkingStream(Path var1) throws IOException;
    }

    private record ResourceCacheEntry(PackType packType, String namespace, Path path, ResourceLocation resourceLocation) {
    }
}

