/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.core.Registry;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.RecipeBookManager;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientRecipeBook
extends RecipeBook {
    private static final Logger f_90618_ = LogUtils.getLogger();
    private Map<RecipeBookCategories, List<RecipeCollection>> f_90619_ = ImmutableMap.of();
    private List<RecipeCollection> f_90620_ = ImmutableList.of();

    public void m_90625_(Iterable<Recipe<?>> p_90626_) {
        Map<RecipeBookCategories, List<List<Recipe<?>>>> map = ClientRecipeBook.m_90642_(p_90626_);
        HashMap map1 = Maps.newHashMap();
        ImmutableList.Builder builder = ImmutableList.builder();
        map.forEach((p_90630_, p_90631_) -> map1.put(p_90630_, (List)p_90631_.stream().map(RecipeCollection::new).peek(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0)).collect(ImmutableList.toImmutableList())));
        RecipeBookCategories.f_92260_.forEach((p_90637_, p_90638_) -> map1.put(p_90637_, (List)p_90638_.stream().flatMap(p_167706_ -> ((List)map1.getOrDefault(p_167706_, ImmutableList.of())).stream()).collect(ImmutableList.toImmutableList())));
        this.f_90619_ = ImmutableMap.copyOf((Map)map1);
        this.f_90620_ = builder.build();
    }

    private static Map<RecipeBookCategories, List<List<Recipe<?>>>> m_90642_(Iterable<Recipe<?>> p_90643_) {
        HashMap map = Maps.newHashMap();
        HashBasedTable table = HashBasedTable.create();
        for (Recipe<?> recipe : p_90643_) {
            if (recipe.m_5598_() || recipe.m_142505_()) continue;
            RecipeBookCategories recipebookcategories = ClientRecipeBook.m_90646_(recipe);
            String s = recipe.m_6076_();
            if (s.isEmpty()) {
                map.computeIfAbsent(recipebookcategories, p_90645_ -> Lists.newArrayList()).add(ImmutableList.of(recipe));
                continue;
            }
            List list = (List)table.get((Object)recipebookcategories, (Object)s);
            if (list == null) {
                list = Lists.newArrayList();
                table.put((Object)recipebookcategories, (Object)s, (Object)list);
                map.computeIfAbsent(recipebookcategories, p_90641_ -> Lists.newArrayList()).add(list);
            }
            list.add(recipe);
        }
        return map;
    }

    private static RecipeBookCategories m_90646_(Recipe<?> p_90647_) {
        RecipeType<?> recipetype = p_90647_.m_6671_();
        if (recipetype == RecipeType.f_44107_) {
            ItemStack itemstack = p_90647_.m_8043_();
            CreativeModeTab creativemodetab = itemstack.m_41720_().m_41471_();
            if (creativemodetab == CreativeModeTab.f_40749_) {
                return RecipeBookCategories.CRAFTING_BUILDING_BLOCKS;
            }
            if (creativemodetab != CreativeModeTab.f_40756_ && creativemodetab != CreativeModeTab.f_40757_) {
                return creativemodetab == CreativeModeTab.f_40751_ ? RecipeBookCategories.CRAFTING_REDSTONE : RecipeBookCategories.CRAFTING_MISC;
            }
            return RecipeBookCategories.CRAFTING_EQUIPMENT;
        }
        if (recipetype == RecipeType.f_44108_) {
            if (p_90647_.m_8043_().m_41720_().m_41472_()) {
                return RecipeBookCategories.FURNACE_FOOD;
            }
            return p_90647_.m_8043_().m_41720_() instanceof BlockItem ? RecipeBookCategories.FURNACE_BLOCKS : RecipeBookCategories.FURNACE_MISC;
        }
        if (recipetype == RecipeType.f_44109_) {
            return p_90647_.m_8043_().m_41720_() instanceof BlockItem ? RecipeBookCategories.BLAST_FURNACE_BLOCKS : RecipeBookCategories.BLAST_FURNACE_MISC;
        }
        if (recipetype == RecipeType.f_44110_) {
            return RecipeBookCategories.SMOKER_FOOD;
        }
        if (recipetype == RecipeType.f_44112_) {
            return RecipeBookCategories.STONECUTTER;
        }
        if (recipetype == RecipeType.f_44111_) {
            return RecipeBookCategories.CAMPFIRE;
        }
        if (recipetype == RecipeType.f_44113_) {
            return RecipeBookCategories.SMITHING;
        }
        RecipeBookCategories categories = RecipeBookManager.findCategories(recipetype, p_90647_);
        if (categories != null) {
            return categories;
        }
        f_90618_.warn("Unknown recipe category: {}/{}", LogUtils.defer(() -> Registry.f_122864_.m_7981_(p_90647_.m_6671_())), LogUtils.defer(p_90647_::m_6423_));
        return RecipeBookCategories.UNKNOWN;
    }

    public List<RecipeCollection> m_90639_() {
        return this.f_90620_;
    }

    public List<RecipeCollection> m_90623_(RecipeBookCategories p_90624_) {
        return this.f_90619_.getOrDefault((Object)p_90624_, Collections.emptyList());
    }
}

