/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.base.Strings;
import com.google.gson.JsonParser;
import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.response.KeyPairResponse;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import net.minecraft.util.Signer;
import net.minecraft.world.entity.player.ProfileKeyPair;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLLoader;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ProfileKeyPairManager {
    private static final Logger f_233765_ = LogUtils.getLogger();
    private static final Path f_233766_ = Path.of("profilekeys", new String[0]);
    private final Path f_233767_;
    private final CompletableFuture<Optional<ProfilePublicKey>> f_233768_;
    private final CompletableFuture<Optional<Signer>> f_233769_;

    public ProfileKeyPairManager(UserApiService p_233772_, UUID p_233773_, Path p_233774_) {
        this.f_233767_ = p_233774_.resolve(f_233766_).resolve(p_233773_ + ".json");
        CompletableFuture<Optional<ProfileKeyPair>> completablefuture = this.m_233780_(p_233772_);
        this.f_233768_ = completablefuture.thenApply(p_233792_ -> p_233792_.map(ProfileKeyPair::f_219763_));
        this.f_233769_ = completablefuture.thenApply(p_233785_ -> p_233785_.map(p_233795_ -> Signer.m_216387_((PrivateKey)p_233795_.f_219762_(), (String)"SHA256withRSA")));
    }

    private CompletableFuture<Optional<ProfileKeyPair>> m_233780_(UserApiService p_233781_) {
        return CompletableFuture.supplyAsync(() -> {
            Optional<ProfileKeyPair> optional = this.m_233798_().filter(p_233788_ -> !p_233788_.f_219763_().f_219781_().m_219810_());
            if (optional.isPresent() && !optional.get().m_219770_()) {
                if (SharedConstants.f_136183_) {
                    return optional;
                }
                this.m_233776_(null);
            }
            try {
                ProfileKeyPair profilekeypair = this.m_233789_(p_233781_);
                this.m_233776_(profilekeypair);
                return Optional.of(profilekeypair);
            }
            catch (MinecraftClientException | IOException | CryptException ioexception) {
                if (FMLLoader.isProduction() || p_233781_ != UserApiService.OFFLINE) {
                    f_233765_.error("Failed to retrieve profile key pair", ioexception);
                }
                this.m_233776_(null);
                return optional;
            }
        }, Util.m_183991_());
    }

    private Optional<ProfileKeyPair> m_233798_() {
        if (Files.notExists(this.f_233767_, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            Optional optional;
            try (BufferedReader bufferedreader = Files.newBufferedReader(this.f_233767_);){
                optional = ProfileKeyPair.f_219761_.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)bufferedreader)).result();
            }
            return optional;
        }
        catch (Exception exception) {
            f_233765_.error("Failed to read profile key pair file {}", (Object)this.f_233767_, (Object)exception);
            return Optional.empty();
        }
    }

    private void m_233776_(@Nullable ProfileKeyPair p_233777_) {
        try {
            Files.deleteIfExists(this.f_233767_);
        }
        catch (IOException ioexception) {
            f_233765_.error("Failed to delete profile key pair file {}", (Object)this.f_233767_, (Object)ioexception);
        }
        if (p_233777_ != null && SharedConstants.f_136183_) {
            ProfileKeyPair.f_219761_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)p_233777_).result().ifPresent(p_233779_ -> {
                try {
                    Files.createDirectories(this.f_233767_.getParent(), new FileAttribute[0]);
                    Files.writeString(this.f_233767_, (CharSequence)p_233779_.toString(), new OpenOption[0]);
                }
                catch (Exception exception) {
                    f_233765_.error("Failed to write profile key pair file {}", (Object)this.f_233767_, (Object)exception);
                }
            });
        }
    }

    private ProfileKeyPair m_233789_(UserApiService p_233790_) throws CryptException, IOException {
        KeyPairResponse keypairresponse = p_233790_.getKeyPair();
        if (keypairresponse != null) {
            ProfilePublicKey.Data profilepublickey$data = ProfileKeyPairManager.m_233782_(keypairresponse);
            return new ProfileKeyPair(Crypt.m_216069_((String)keypairresponse.getPrivateKey()), ProfilePublicKey.m_219789_((ProfilePublicKey.Data)profilepublickey$data), Instant.parse(keypairresponse.getRefreshedAfter()));
        }
        throw new IOException("Could not retrieve profile key pair");
    }

    private static ProfilePublicKey.Data m_233782_(KeyPairResponse p_233783_) throws CryptException {
        if (!Strings.isNullOrEmpty((String)p_233783_.getPublicKey()) && p_233783_.getPublicKeySignature() != null && p_233783_.getPublicKeySignature().array().length != 0) {
            try {
                Instant instant = Instant.parse(p_233783_.getExpiresAt());
                PublicKey publickey = Crypt.m_216080_((String)p_233783_.getPublicKey());
                ByteBuffer bytebuffer = p_233783_.getPublicKeySignature();
                return new ProfilePublicKey.Data(instant, publickey, bytebuffer.array());
            }
            catch (IllegalArgumentException | DateTimeException datetimeexception) {
                throw new CryptException((Throwable)datetimeexception);
            }
        }
        throw new CryptException((Throwable)new InsecurePublicKeyException.MissingException());
    }

    @Nullable
    public Signer m_233775_() {
        return this.f_233769_.join().orElse(null);
    }

    public Optional<ProfilePublicKey> m_233786_() {
        return this.f_233768_.join();
    }

    public Optional<ProfilePublicKey.Data> m_233793_() {
        return this.m_233786_().map(ProfilePublicKey::f_219781_);
    }
}

