/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.slf4j.Logger;

public class FallbackResourceManager
implements ResourceManager {
    static final Logger f_10600_ = LogUtils.getLogger();
    public final List<PackEntry> f_10599_ = Lists.newArrayList();
    final PackType f_10601_;
    private final String f_10602_;

    public FallbackResourceManager(PackType p_10605_, String p_10606_) {
        this.f_10601_ = p_10605_;
        this.f_10602_ = p_10606_;
    }

    public void m_215377_(PackResources p_215378_) {
        this.m_215395_(p_215378_.m_8017_(), p_215378_, null);
    }

    public void m_215382_(PackResources p_215383_, Predicate<ResourceLocation> p_215384_) {
        this.m_215395_(p_215383_.m_8017_(), p_215383_, p_215384_);
    }

    public void m_215399_(String p_215400_, Predicate<ResourceLocation> p_215401_) {
        this.m_215395_(p_215400_, null, p_215401_);
    }

    private void m_215395_(String p_215396_, @Nullable PackResources p_215397_, @Nullable Predicate<ResourceLocation> p_215398_) {
        this.f_10599_.add(new PackEntry(p_215396_, p_215397_, p_215398_));
        if (p_215397_ != null) {
            p_215397_.initForNamespace(this.f_10602_);
        }
    }

    public Set<String> m_7187_() {
        return ImmutableSet.of((Object)this.f_10602_);
    }

    public Optional<Resource> m_213713_(ResourceLocation p_215419_) {
        if (!this.m_10628_(p_215419_)) {
            return Optional.empty();
        }
        for (int i = this.f_10599_.size() - 1; i >= 0; --i) {
            PackEntry fallbackresourcemanager$packentry = this.f_10599_.get(i);
            PackResources packresources = fallbackresourcemanager$packentry.f_215433_;
            if (packresources != null && packresources.m_7211_(this.f_10601_, p_215419_)) {
                return Optional.of(new Resource(packresources.m_8017_(), this.m_215374_(p_215419_, packresources), this.m_215368_(p_215419_, i)));
            }
            if (!fallbackresourcemanager$packentry.m_215440_(p_215419_)) continue;
            f_10600_.warn("Resource {} not found, but was filtered by pack {}", (Object)p_215419_, (Object)fallbackresourcemanager$packentry.f_215432_);
            return Optional.empty();
        }
        return Optional.empty();
    }

    Resource.IoSupplier<InputStream> m_215374_(ResourceLocation p_215375_, PackResources p_215376_) {
        return f_10600_.isDebugEnabled() ? () -> {
            InputStream inputstream = p_215376_.m_8031_(this.f_10601_, p_215375_);
            return new LeakedResourceWarningInputStream(inputstream, p_215375_, p_215376_.m_8017_());
        } : () -> p_215376_.m_8031_(this.f_10601_, p_215375_);
    }

    private boolean m_10628_(ResourceLocation p_10629_) {
        return !p_10629_.m_135815_().contains("..");
    }

    public List<Resource> m_213829_(ResourceLocation p_215367_) {
        if (!this.m_10628_(p_215367_)) {
            return List.of();
        }
        ArrayList list = Lists.newArrayList();
        ResourceLocation resourcelocation = FallbackResourceManager.m_10624_(p_215367_);
        String s = null;
        for (PackEntry fallbackresourcemanager$packentry : this.f_10599_) {
            PackResources packresources;
            if (fallbackresourcemanager$packentry.m_215440_(p_215367_)) {
                if (!list.isEmpty()) {
                    s = fallbackresourcemanager$packentry.f_215432_;
                }
                list.clear();
            } else if (fallbackresourcemanager$packentry.m_215440_(resourcelocation)) {
                list.forEach(SinglePackResourceThunkSupplier::m_215460_);
            }
            if ((packresources = fallbackresourcemanager$packentry.f_215433_) == null || !packresources.m_7211_(this.f_10601_, p_215367_)) continue;
            list.add(new SinglePackResourceThunkSupplier(p_215367_, resourcelocation, packresources));
        }
        if (list.isEmpty() && s != null) {
            f_10600_.info("Resource {} was filtered by pack {}", (Object)p_215367_, s);
        }
        return list.stream().map(SinglePackResourceThunkSupplier::m_215461_).toList();
    }

    public Map<ResourceLocation, Resource> m_214159_(String p_215413_, Predicate<ResourceLocation> p_215414_) {
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        int i = this.f_10599_.size();
        for (int j = 0; j < i; ++j) {
            PackEntry fallbackresourcemanager$packentry = this.f_10599_.get(j);
            fallbackresourcemanager$packentry.m_215442_((Collection<ResourceLocation>)object2intmap.keySet());
            if (fallbackresourcemanager$packentry.f_215433_ == null) continue;
            for (ResourceLocation resourcelocation : fallbackresourcemanager$packentry.f_215433_.m_214146_(this.f_10601_, this.f_10602_, p_215413_, p_215414_)) {
                object2intmap.put((Object)resourcelocation, j);
            }
        }
        TreeMap map = Maps.newTreeMap();
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable((Object2IntMap)object2intmap)) {
            int k = entry.getIntValue();
            ResourceLocation resourcelocation1 = (ResourceLocation)entry.getKey();
            PackResources packresources = this.f_10599_.get((int)k).f_215433_;
            map.put(resourcelocation1, new Resource(packresources.m_8017_(), this.m_215374_(resourcelocation1, packresources), this.m_215368_(resourcelocation1, k)));
        }
        return map;
    }

    private Resource.IoSupplier<ResourceMetadata> m_215368_(ResourceLocation p_215369_, int p_215370_) {
        return () -> {
            ResourceLocation resourcelocation = FallbackResourceManager.m_10624_(p_215369_);
            for (int i = this.f_10599_.size() - 1; i >= p_215370_; --i) {
                PackEntry fallbackresourcemanager$packentry = this.f_10599_.get(i);
                PackResources packresources = fallbackresourcemanager$packentry.f_215433_;
                if (packresources != null && packresources.m_7211_(this.f_10601_, resourcelocation)) {
                    ResourceMetadata resourcemetadata;
                    try (InputStream inputstream = packresources.m_8031_(this.f_10601_, resourcelocation);){
                        resourcemetadata = ResourceMetadata.m_215580_((InputStream)inputstream);
                    }
                    return resourcemetadata;
                }
                if (fallbackresourcemanager$packentry.m_215440_(resourcelocation)) break;
            }
            return ResourceMetadata.f_215577_;
        };
    }

    private static void m_215392_(PackEntry p_215393_, Map<ResourceLocation, EntryStack> p_215394_) {
        Iterator<Map.Entry<ResourceLocation, EntryStack>> iterator = p_215394_.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, EntryStack> entry = iterator.next();
            ResourceLocation resourcelocation = entry.getKey();
            EntryStack fallbackresourcemanager$entrystack = entry.getValue();
            if (p_215393_.m_215440_(resourcelocation)) {
                iterator.remove();
                continue;
            }
            if (!p_215393_.m_215440_(fallbackresourcemanager$entrystack.f_215420_())) continue;
            fallbackresourcemanager$entrystack.f_215421_.forEach(SinglePackResourceThunkSupplier::m_215460_);
        }
    }

    private void m_215387_(PackEntry p_215388_, String p_215389_, Predicate<ResourceLocation> p_215390_, Map<ResourceLocation, EntryStack> p_215391_) {
        PackResources packresources = p_215388_.f_215433_;
        if (packresources != null) {
            for (ResourceLocation resourcelocation : packresources.m_214146_(this.f_10601_, this.f_10602_, p_215389_, p_215390_)) {
                ResourceLocation resourcelocation1 = FallbackResourceManager.m_10624_(resourcelocation);
                p_215391_.computeIfAbsent(resourcelocation, p_215373_ -> new EntryStack(resourcelocation1, Lists.newArrayList())).f_215421_().add(new SinglePackResourceThunkSupplier(resourcelocation, resourcelocation1, packresources));
            }
        }
    }

    public Map<ResourceLocation, List<Resource>> m_214160_(String p_215416_, Predicate<ResourceLocation> p_215417_) {
        HashMap map = Maps.newHashMap();
        for (PackEntry fallbackresourcemanager$packentry : this.f_10599_) {
            FallbackResourceManager.m_215392_(fallbackresourcemanager$packentry, map);
            this.m_215387_(fallbackresourcemanager$packentry, p_215416_, p_215417_, map);
        }
        TreeMap treemap = Maps.newTreeMap();
        map.forEach((p_215404_, p_215405_) -> treemap.put(p_215404_, p_215405_.m_215427_()));
        return treemap;
    }

    public Stream<PackResources> m_7536_() {
        return this.f_10599_.stream().map(p_215386_ -> p_215386_.f_215433_).filter(Objects::nonNull);
    }

    static ResourceLocation m_10624_(ResourceLocation p_10625_) {
        return new ResourceLocation(p_10625_.m_135827_(), p_10625_.m_135815_() + ".mcmeta");
    }

    record PackEntry(String f_215432_, @Nullable PackResources f_215433_, @Nullable Predicate<ResourceLocation> f_215434_) {
        public void m_215442_(Collection<ResourceLocation> p_215443_) {
            if (this.f_215434_ != null) {
                p_215443_.removeIf(this.f_215434_);
            }
        }

        public boolean m_215440_(ResourceLocation p_215441_) {
            return this.f_215434_ != null && this.f_215434_.test(p_215441_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PackEntry.class, "name;resources;filter", "f_215432_", "f_215433_", "f_215434_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PackEntry.class, "name;resources;filter", "f_215432_", "f_215433_", "f_215434_"}, this);
        }

        @Override
        public final boolean equals(Object p_215447_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PackEntry.class, "name;resources;filter", "f_215432_", "f_215433_", "f_215434_"}, this, p_215447_);
        }
    }

    class SinglePackResourceThunkSupplier {
        private final ResourceLocation f_215451_;
        private final ResourceLocation f_215452_;
        private final PackResources f_215453_;
        private boolean f_215454_ = true;

        SinglePackResourceThunkSupplier(ResourceLocation p_215457_, ResourceLocation p_215458_, PackResources p_215459_) {
            this.f_215453_ = p_215459_;
            this.f_215451_ = p_215457_;
            this.f_215452_ = p_215458_;
        }

        public void m_215460_() {
            this.f_215454_ = false;
        }

        public Resource m_215461_() {
            String s = this.f_215453_.m_8017_();
            return this.f_215454_ ? new Resource(s, FallbackResourceManager.this.m_215374_(this.f_215451_, this.f_215453_), () -> {
                if (this.f_215453_.m_7211_(FallbackResourceManager.this.f_10601_, this.f_215452_)) {
                    ResourceMetadata resourcemetadata;
                    try (InputStream inputstream = this.f_215453_.m_8031_(FallbackResourceManager.this.f_10601_, this.f_215452_);){
                        resourcemetadata = ResourceMetadata.m_215580_((InputStream)inputstream);
                    }
                    return resourcemetadata;
                }
                return ResourceMetadata.f_215577_;
            }) : new Resource(s, FallbackResourceManager.this.m_215374_(this.f_215451_, this.f_215453_));
        }
    }

    record EntryStack(ResourceLocation f_215420_, List<SinglePackResourceThunkSupplier> f_215421_) {
        List<Resource> m_215427_() {
            return this.f_215421_().stream().map(SinglePackResourceThunkSupplier::m_215461_).toList();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{EntryStack.class, "metadataLocation;entries", "f_215420_", "f_215421_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EntryStack.class, "metadataLocation;entries", "f_215420_", "f_215421_"}, this);
        }

        @Override
        public final boolean equals(Object p_215429_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EntryStack.class, "metadataLocation;entries", "f_215420_", "f_215421_"}, this, p_215429_);
        }
    }

    static class LeakedResourceWarningInputStream
    extends FilterInputStream {
        private final String f_10630_;
        private boolean f_10631_;

        public LeakedResourceWarningInputStream(InputStream p_10633_, ResourceLocation p_10634_, String p_10635_) {
            super(p_10633_);
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            new Exception().printStackTrace(new PrintStream(bytearrayoutputstream));
            this.f_10630_ = "Leaked resource: '" + p_10634_ + "' loaded from pack: '" + p_10635_ + "'\n" + bytearrayoutputstream;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.f_10631_ = true;
        }

        protected void finalize() throws Throwable {
            if (!this.f_10631_) {
                f_10600_.warn(this.f_10630_);
            }
            super.finalize();
        }
    }
}

