/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Preconditions;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.Arrays;
import net.minecraft.Util;
import net.minecraft.client.renderer.LightTexture;
import net.minecraftforge.client.model.IQuadTransformer;

public final class QuadTransformers {
    private static final IQuadTransformer EMPTY = quad -> {};
    private static final IQuadTransformer[] EMISSIVE_TRANSFORMERS = (IQuadTransformer[])Util.m_137469_((Object)new IQuadTransformer[16], array -> Arrays.setAll(array, i -> QuadTransformers.applyingLightmap(LightTexture.m_109885_((int)i, (int)i))));

    public static IQuadTransformer empty() {
        return EMPTY;
    }

    public static IQuadTransformer applying(Transformation transform) {
        if (transform.isIdentity()) {
            return QuadTransformers.empty();
        }
        return quad -> {
            int offset;
            int i;
            int[] vertices = quad.m_111303_();
            for (i = 0; i < 4; ++i) {
                offset = i * IQuadTransformer.STRIDE + IQuadTransformer.POSITION;
                float x = Float.intBitsToFloat(vertices[offset]);
                float y = Float.intBitsToFloat(vertices[offset + 1]);
                float z = Float.intBitsToFloat(vertices[offset + 2]);
                Vector4f pos = new Vector4f(x, y, z, 1.0f);
                transform.transformPosition(pos);
                pos.m_123621_();
                vertices[offset] = Float.floatToRawIntBits(pos.m_123601_());
                vertices[offset + 1] = Float.floatToRawIntBits(pos.m_123615_());
                vertices[offset + 2] = Float.floatToRawIntBits(pos.m_123616_());
            }
            for (i = 0; i < 4; ++i) {
                offset = i * IQuadTransformer.STRIDE + IQuadTransformer.NORMAL;
                int normalIn = vertices[offset];
                if (normalIn >> 8 == 0) continue;
                float x = (float)((byte)(normalIn & 0xFF)) / 127.0f;
                float y = (float)((byte)(normalIn >> 8 & 0xFF)) / 127.0f;
                float z = (float)((byte)(normalIn >> 16 & 0xFF)) / 127.0f;
                Vector3f pos = new Vector3f(x, y, z);
                transform.transformNormal(pos);
                pos.m_122278_();
                vertices[offset] = (byte)(x * 127.0f) & 0xFF | ((byte)(y * 127.0f) & 0xFF) << 8 | ((byte)(z * 127.0f) & 0xFF) << 16 | normalIn & 0xFF000000;
            }
        };
    }

    public static IQuadTransformer applyingLightmap(int lightmap) {
        return quad -> {
            int[] vertices = quad.m_111303_();
            for (int i = 0; i < 4; ++i) {
                vertices[i * IQuadTransformer.STRIDE + IQuadTransformer.UV2] = lightmap;
            }
        };
    }

    public static IQuadTransformer settingEmissivity(int emissivity) {
        Preconditions.checkArgument((emissivity >= 0 && emissivity < 16 ? 1 : 0) != 0, (Object)"Emissivity must be between 0 and 15.");
        return EMISSIVE_TRANSFORMERS[emissivity];
    }

    public static IQuadTransformer settingMaxEmissivity() {
        return EMISSIVE_TRANSFORMERS[15];
    }

    private QuadTransformers() {
    }
}

