/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.mojang.serialization.DataResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.SharedConstants;
import org.apache.commons.io.FilenameUtils;

public class FileUtil {
    private static final Pattern f_133725_ = Pattern.compile("(<name>.*) \\((<count>\\d*)\\)", 66);
    private static final int f_179920_ = 255;
    private static final Pattern f_133726_ = Pattern.compile(".*\\.|(?:COM|CLOCK\\$|CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\..*)?", 2);
    private static final Pattern f_244114_ = Pattern.compile("[-._a-z0-9]+");

    public static String m_133730_(Path p_133731_, String p_133732_, String p_133733_) throws IOException {
        for (char $$3 : SharedConstants.f_136184_) {
            p_133732_ = ((String)p_133732_).replace($$3, '_');
        }
        if (f_133726_.matcher((CharSequence)(p_133732_ = ((String)p_133732_).replaceAll("[./\"]", "_"))).matches()) {
            p_133732_ = "_" + (String)p_133732_ + "_";
        }
        Matcher $$4 = f_133725_.matcher((CharSequence)p_133732_);
        int $$5 = 0;
        if ($$4.matches()) {
            p_133732_ = $$4.group("name");
            $$5 = Integer.parseInt($$4.group("count"));
        }
        if (((String)p_133732_).length() > 255 - p_133733_.length()) {
            p_133732_ = ((String)p_133732_).substring(0, 255 - p_133733_.length());
        }
        while (true) {
            Object $$6 = p_133732_;
            if ($$5 != 0) {
                String $$7 = " (" + $$5 + ")";
                int $$8 = 255 - $$7.length();
                if (((String)$$6).length() > $$8) {
                    $$6 = ((String)$$6).substring(0, $$8);
                }
                $$6 = (String)$$6 + $$7;
            }
            $$6 = (String)$$6 + p_133733_;
            Path $$9 = p_133731_.resolve((String)$$6);
            try {
                Path $$10 = Files.createDirectory($$9, new FileAttribute[0]);
                Files.deleteIfExists($$10);
                return p_133731_.relativize($$10).toString();
            }
            catch (FileAlreadyExistsException $$11) {
                ++$$5;
                continue;
            }
            break;
        }
    }

    public static boolean m_133728_(Path p_133729_) {
        Path $$1 = p_133729_.normalize();
        return $$1.equals(p_133729_);
    }

    public static boolean m_133734_(Path p_133735_) {
        for (Path $$1 : p_133735_) {
            if (!f_133726_.matcher($$1.toString()).matches()) continue;
            return false;
        }
        return true;
    }

    public static Path m_133736_(Path p_133737_, String p_133738_, String p_133739_) {
        String $$3 = p_133738_ + p_133739_;
        Path $$4 = Paths.get($$3, new String[0]);
        if ($$4.endsWith(p_133739_)) {
            throw new InvalidPathException($$3, "empty resource name");
        }
        return p_133737_.resolve($$4);
    }

    public static String m_179922_(String p_179923_) {
        return FilenameUtils.getFullPath((String)p_179923_).replace(File.separator, "/");
    }

    public static String m_179924_(String p_179925_) {
        return FilenameUtils.normalize((String)p_179925_).replace(File.separator, "/");
    }

    public static DataResult<List<String>> m_245538_(String p_248866_) {
        int $$1 = p_248866_.indexOf(47);
        if ($$1 == -1) {
            return switch (p_248866_) {
                case "", ".", ".." -> DataResult.error((String)("Invalid path '" + p_248866_ + "'"));
                default -> !FileUtil.m_245636_(p_248866_) ? DataResult.error((String)("Invalid path '" + p_248866_ + "'")) : DataResult.success(List.of(p_248866_));
            };
        }
        ArrayList<String> $$2 = new ArrayList<String>();
        int $$3 = 0;
        boolean $$4 = false;
        while (true) {
            String $$5;
            switch ($$5 = p_248866_.substring($$3, $$1)) {
                case "": 
                case ".": 
                case "..": {
                    return DataResult.error((String)("Invalid segment '" + $$5 + "' in path '" + p_248866_ + "'"));
                }
            }
            if (!FileUtil.m_245636_($$5)) {
                return DataResult.error((String)("Invalid segment '" + $$5 + "' in path '" + p_248866_ + "'"));
            }
            $$2.add($$5);
            if ($$4) {
                return DataResult.success($$2);
            }
            $$3 = $$1 + 1;
            if (($$1 = p_248866_.indexOf(47, $$3)) != -1) continue;
            $$1 = p_248866_.length();
            $$4 = true;
        }
    }

    public static Path m_245247_(Path p_251522_, List<String> p_251495_) {
        int $$2 = p_251495_.size();
        return switch ($$2) {
            case 0 -> p_251522_;
            case 1 -> p_251522_.resolve(p_251495_.get(0));
            default -> {
                String[] $$3 = new String[$$2 - 1];
                for (int $$4 = 1; $$4 < $$2; ++$$4) {
                    $$3[$$4 - 1] = p_251495_.get($$4);
                }
                yield p_251522_.resolve(p_251522_.getFileSystem().getPath(p_251495_.get(0), $$3));
            }
        };
    }

    public static boolean m_245636_(String p_249814_) {
        return f_244114_.matcher(p_249814_).matches();
    }

    public static void m_245411_(String ... p_249502_) {
        if (p_249502_.length == 0) {
            throw new IllegalArgumentException("Path must have at least one element");
        }
        for (String $$1 : p_249502_) {
            if (!$$1.equals("..") && !$$1.equals(".") && FileUtil.m_245636_($$1)) continue;
            throw new IllegalArgumentException("Illegal segment " + $$1 + " in path " + Arrays.toString(p_249502_));
        }
    }

    public static void m_257659_(Path p_259902_) throws IOException {
        Files.createDirectories(Files.exists(p_259902_, new LinkOption[0]) ? p_259902_.toRealPath(new LinkOption[0]) : p_259902_, new FileAttribute[0]);
    }
}

