/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.WorldVersion;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.PackOutput;
import net.minecraft.server.Bootstrap;
import org.slf4j.Logger;

public class DataGenerator {
    private static final Logger f_123905_ = LogUtils.getLogger();
    private final Path f_243753_;
    private final PackOutput f_244116_;
    final Set<String> f_252429_ = new HashSet<String>();
    final Map<String, DataProvider> f_236026_ = new LinkedHashMap<String, DataProvider>();
    private final WorldVersion f_236027_;
    private final boolean f_236028_;

    public DataGenerator(Path p_251724_, WorldVersion p_250554_, boolean p_251323_) {
        this.f_243753_ = p_251724_;
        this.f_244116_ = new PackOutput(this.f_243753_);
        this.f_236027_ = p_250554_;
        this.f_236028_ = p_251323_;
    }

    public void m_123917_() throws IOException {
        HashCache $$0 = new HashCache(this.f_243753_, this.f_252429_, this.f_236027_);
        Stopwatch $$1 = Stopwatch.createStarted();
        Stopwatch $$2 = Stopwatch.createUnstarted();
        this.f_236026_.forEach((p_254418_, p_253750_) -> {
            if (!this.f_236028_ && !$$0.m_253256_((String)p_254418_)) {
                f_123905_.debug("Generator {} already run for version {}", p_254418_, (Object)this.f_236027_.getName());
                return;
            }
            f_123905_.info("Starting provider: {}", p_254418_);
            $$2.start();
            $$0.m_253116_($$0.m_253234_((String)p_254418_, p_253750_::m_213708_).join());
            $$2.stop();
            f_123905_.info("{} finished after {} ms", p_254418_, (Object)$$2.elapsed(TimeUnit.MILLISECONDS));
            $$2.reset();
        });
        f_123905_.info("All providers took: {} ms", (Object)$$1.elapsed(TimeUnit.MILLISECONDS));
        $$0.m_123937_();
    }

    public PackGenerator m_253147_(boolean p_254422_) {
        return new PackGenerator(p_254422_, "vanilla", this.f_244116_);
    }

    public PackGenerator m_253030_(boolean p_253826_, String p_254134_) {
        Path $$2 = this.f_244116_.m_247566_(PackOutput.Target.DATA_PACK).resolve("minecraft").resolve("datapacks").resolve(p_254134_);
        return new PackGenerator(p_253826_, p_254134_, new PackOutput($$2));
    }

    static {
        Bootstrap.m_135870_();
    }

    public class PackGenerator {
        private final boolean f_252435_;
        private final String f_252464_;
        private final PackOutput f_252503_;

        PackGenerator(boolean p_253884_, String p_254544_, PackOutput p_254363_) {
            this.f_252435_ = p_253884_;
            this.f_252464_ = p_254544_;
            this.f_252503_ = p_254363_;
        }

        public <T extends DataProvider> T m_253108_(DataProvider.Factory<T> p_254382_) {
            T $$1 = p_254382_.m_253034_(this.f_252503_);
            String $$2 = this.f_252464_ + "/" + $$1.m_6055_();
            if (!DataGenerator.this.f_252429_.add($$2)) {
                throw new IllegalStateException("Duplicate provider: " + $$2);
            }
            if (this.f_252435_) {
                DataGenerator.this.f_236026_.put($$2, (DataProvider)$$1);
            }
            return $$1;
        }
    }
}

