/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.UpgradeRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public abstract class RecipeProvider
implements DataProvider {
    private final PackOutput.PathProvider f_236355_;
    private final PackOutput.PathProvider f_236356_;
    private static final Map<BlockFamily.Variant, BiFunction<ItemLike, ItemLike, RecipeBuilder>> f_244077_ = ImmutableMap.builder().put((Object)BlockFamily.Variant.BUTTON, (p_176733_, p_176734_) -> RecipeProvider.m_176658_(p_176733_, Ingredient.m_43929_(p_176734_))).put((Object)BlockFamily.Variant.CHISELED, (p_248037_, p_248038_) -> RecipeProvider.m_246451_(RecipeCategory.BUILDING_BLOCKS, p_248037_, Ingredient.m_43929_(p_248038_))).put((Object)BlockFamily.Variant.CUT, (p_248026_, p_248027_) -> RecipeProvider.m_245792_(RecipeCategory.BUILDING_BLOCKS, p_248026_, Ingredient.m_43929_(p_248027_))).put((Object)BlockFamily.Variant.DOOR, (p_176714_, p_176715_) -> RecipeProvider.m_176670_(p_176714_, Ingredient.m_43929_(p_176715_))).put((Object)BlockFamily.Variant.CUSTOM_FENCE, (p_176708_, p_176709_) -> RecipeProvider.m_176678_(p_176708_, Ingredient.m_43929_(p_176709_))).put((Object)BlockFamily.Variant.FENCE, (p_248031_, p_248032_) -> RecipeProvider.m_176678_(p_248031_, Ingredient.m_43929_(p_248032_))).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, (p_176698_, p_176699_) -> RecipeProvider.m_176684_(p_176698_, Ingredient.m_43929_(p_176699_))).put((Object)BlockFamily.Variant.FENCE_GATE, (p_248035_, p_248036_) -> RecipeProvider.m_176684_(p_248035_, Ingredient.m_43929_(p_248036_))).put((Object)BlockFamily.Variant.SIGN, (p_176688_, p_176689_) -> RecipeProvider.m_176726_(p_176688_, Ingredient.m_43929_(p_176689_))).put((Object)BlockFamily.Variant.SLAB, (p_248017_, p_248018_) -> RecipeProvider.m_247552_(RecipeCategory.BUILDING_BLOCKS, p_248017_, Ingredient.m_43929_(p_248018_))).put((Object)BlockFamily.Variant.STAIRS, (p_176674_, p_176675_) -> RecipeProvider.m_176710_(p_176674_, Ingredient.m_43929_(p_176675_))).put((Object)BlockFamily.Variant.PRESSURE_PLATE, (p_248039_, p_248040_) -> RecipeProvider.m_247347_(RecipeCategory.REDSTONE, p_248039_, Ingredient.m_43929_(p_248040_))).put((Object)BlockFamily.Variant.POLISHED, (p_248019_, p_248020_) -> RecipeProvider.m_247174_(RecipeCategory.BUILDING_BLOCKS, p_248019_, Ingredient.m_43929_(p_248020_))).put((Object)BlockFamily.Variant.TRAPDOOR, (p_176638_, p_176639_) -> RecipeProvider.m_176720_(p_176638_, Ingredient.m_43929_(p_176639_))).put((Object)BlockFamily.Variant.WALL, (p_248024_, p_248025_) -> RecipeProvider.m_245864_(RecipeCategory.DECORATIONS, p_248024_, Ingredient.m_43929_(p_248025_))).build();

    public RecipeProvider(PackOutput p_248933_) {
        this.f_236355_ = p_248933_.m_245269_(PackOutput.Target.DATA_PACK, "recipes");
        this.f_236356_ = p_248933_.m_245269_(PackOutput.Target.DATA_PACK, "advancements");
    }

    @Override
    public CompletableFuture<?> m_213708_(CachedOutput p_254020_) {
        HashSet $$1 = Sets.newHashSet();
        ArrayList $$2 = new ArrayList();
        this.m_245200_(p_253413_ -> {
            if (!$$1.add(p_253413_.m_6445_())) {
                throw new IllegalStateException("Duplicate recipe " + p_253413_.m_6445_());
            }
            $$2.add(DataProvider.m_253162_(p_254020_, (JsonElement)p_253413_.m_125966_(), this.f_236355_.m_245731_(p_253413_.m_6445_())));
            JsonObject $$4 = p_253413_.m_5860_();
            if ($$4 != null) {
                $$2.add(DataProvider.m_253162_(p_254020_, (JsonElement)$$4, this.f_236356_.m_245731_(p_253413_.m_6448_())));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])$$2.toArray(CompletableFuture[]::new));
    }

    protected CompletableFuture<?> m_253240_(CachedOutput p_253674_, ResourceLocation p_254102_, Advancement.Builder p_253712_) {
        return DataProvider.m_253162_(p_253674_, (JsonElement)p_253712_.m_138400_(), this.f_236356_.m_245731_(p_254102_));
    }

    protected abstract void m_245200_(Consumer<FinishedRecipe> var1);

    protected static void m_247051_(Consumer<FinishedRecipe> p_249188_, FeatureFlagSet p_251836_) {
        BlockFamilies.m_175934_().filter(p_248034_ -> p_248034_.m_245288_(p_251836_)).forEach(p_176624_ -> RecipeProvider.m_176580_(p_249188_, p_176624_));
    }

    protected static void m_176551_(Consumer<FinishedRecipe> p_176552_, ItemLike p_176553_, ItemLike p_176554_, @Nullable String p_176555_) {
        RecipeProvider.m_176556_(p_176552_, p_176553_, p_176554_, p_176555_, 1);
    }

    protected static void m_176556_(Consumer<FinishedRecipe> p_176557_, ItemLike p_176558_, ItemLike p_176559_, @Nullable String p_176560_, int p_176561_) {
        ShapelessRecipeBuilder.m_246517_(RecipeCategory.MISC, p_176558_, p_176561_).m_126209_(p_176559_).m_126145_(p_176560_).m_126132_(RecipeProvider.m_176602_(p_176559_), RecipeProvider.m_125977_(p_176559_)).m_176500_(p_176557_, RecipeProvider.m_176517_(p_176558_, p_176559_));
    }

    protected static void m_246272_(Consumer<FinishedRecipe> p_250654_, List<ItemLike> p_250172_, RecipeCategory p_250588_, ItemLike p_251868_, float p_250789_, int p_252144_, String p_251687_) {
        RecipeProvider.m_245809_(p_250654_, RecipeSerializer.f_44091_, p_250172_, p_250588_, p_251868_, p_250789_, p_252144_, p_251687_, "_from_smelting");
    }

    protected static void m_245412_(Consumer<FinishedRecipe> p_248775_, List<ItemLike> p_251504_, RecipeCategory p_248846_, ItemLike p_249735_, float p_248783_, int p_250303_, String p_251984_) {
        RecipeProvider.m_245809_(p_248775_, RecipeSerializer.f_44092_, p_251504_, p_248846_, p_249735_, p_248783_, p_250303_, p_251984_, "_from_blasting");
    }

    private static void m_245809_(Consumer<FinishedRecipe> p_250791_, RecipeSerializer<? extends AbstractCookingRecipe> p_251817_, List<ItemLike> p_249619_, RecipeCategory p_251154_, ItemLike p_250066_, float p_251871_, int p_251316_, String p_251450_, String p_249236_) {
        for (ItemLike $$9 : p_249619_) {
            SimpleCookingRecipeBuilder.m_247607_(Ingredient.m_43929_($$9), p_251154_, p_250066_, p_251871_, p_251316_, p_251817_).m_126145_(p_251450_).m_126132_(RecipeProvider.m_176602_($$9), RecipeProvider.m_125977_($$9)).m_176500_(p_250791_, RecipeProvider.m_176632_(p_250066_) + p_249236_ + "_" + RecipeProvider.m_176632_($$9));
        }
    }

    protected static void m_246630_(Consumer<FinishedRecipe> p_251614_, Item p_250046_, RecipeCategory p_248986_, Item p_250389_) {
        UpgradeRecipeBuilder.m_245746_(Ingredient.m_43929_(p_250046_), Ingredient.m_43929_(Items.f_42418_), p_248986_, p_250389_).m_126389_("has_netherite_ingot", RecipeProvider.m_125977_(Items.f_42418_)).m_126392_(p_251614_, RecipeProvider.m_176632_(p_250389_) + "_smithing");
    }

    protected static void m_247540_(Consumer<FinishedRecipe> p_248860_, RecipeCategory p_250881_, ItemLike p_252184_, ItemLike p_249710_) {
        ShapedRecipeBuilder.m_246608_(p_250881_, p_252184_, 1).m_126127_(Character.valueOf('#'), p_249710_).m_126130_("##").m_126130_("##").m_126132_(RecipeProvider.m_176602_(p_249710_), RecipeProvider.m_125977_(p_249710_)).m_176498_(p_248860_);
    }

    protected static void m_257994_(Consumer<FinishedRecipe> p_259036_, RecipeCategory p_259247_, ItemLike p_259376_, ItemLike p_259717_, String p_260308_) {
        ShapelessRecipeBuilder.m_245498_(p_259247_, p_259376_).m_126211_(p_259717_, 9).m_126132_(p_260308_, RecipeProvider.m_125977_(p_259717_)).m_176498_(p_259036_);
    }

    protected static void m_258049_(Consumer<FinishedRecipe> p_260012_, RecipeCategory p_259186_, ItemLike p_259360_, ItemLike p_259263_) {
        RecipeProvider.m_257994_(p_260012_, p_259186_, p_259360_, p_259263_, RecipeProvider.m_176602_(p_259263_));
    }

    protected static void m_257929_(Consumer<FinishedRecipe> p_259712_, ItemLike p_259052_, TagKey<Item> p_259045_, int p_259471_) {
        ShapelessRecipeBuilder.m_246517_(RecipeCategory.BUILDING_BLOCKS, p_259052_, p_259471_).m_206419_(p_259045_).m_126145_("planks").m_126132_("has_log", RecipeProvider.m_206406_(p_259045_)).m_176498_(p_259712_);
    }

    protected static void m_257424_(Consumer<FinishedRecipe> p_259910_, ItemLike p_259193_, TagKey<Item> p_259818_, int p_259807_) {
        ShapelessRecipeBuilder.m_246517_(RecipeCategory.BUILDING_BLOCKS, p_259193_, p_259807_).m_206419_(p_259818_).m_126145_("planks").m_126132_("has_logs", RecipeProvider.m_206406_(p_259818_)).m_176498_(p_259910_);
    }

    protected static void m_126002_(Consumer<FinishedRecipe> p_126003_, ItemLike p_126004_, ItemLike p_126005_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.BUILDING_BLOCKS, p_126004_, 3).m_126127_(Character.valueOf('#'), p_126005_).m_126130_("##").m_126130_("##").m_126145_("bark").m_126132_("has_log", RecipeProvider.m_125977_(p_126005_)).m_176498_(p_126003_);
    }

    protected static void m_126021_(Consumer<FinishedRecipe> p_126022_, ItemLike p_126023_, ItemLike p_126024_) {
        ShapedRecipeBuilder.m_245327_(RecipeCategory.TRANSPORTATION, p_126023_).m_126127_(Character.valueOf('#'), p_126024_).m_126130_("# #").m_126130_("###").m_126145_("boat").m_126132_("in_water", RecipeProvider.m_125979_(Blocks.f_49990_)).m_176498_(p_126022_);
    }

    protected static void m_236371_(Consumer<FinishedRecipe> p_236372_, ItemLike p_236373_, ItemLike p_236374_) {
        ShapelessRecipeBuilder.m_245498_(RecipeCategory.TRANSPORTATION, p_236373_).m_126209_(Blocks.f_50087_).m_126209_(p_236374_).m_126145_("chest_boat").m_126132_("has_boat", RecipeProvider.m_206406_(ItemTags.f_13155_)).m_176498_(p_236372_);
    }

    private static RecipeBuilder m_176658_(ItemLike p_176659_, Ingredient p_176660_) {
        return ShapelessRecipeBuilder.m_245498_(RecipeCategory.REDSTONE, p_176659_).m_126184_(p_176660_);
    }

    protected static RecipeBuilder m_176670_(ItemLike p_176671_, Ingredient p_176672_) {
        return ShapedRecipeBuilder.m_246608_(RecipeCategory.REDSTONE, p_176671_, 3).m_126124_(Character.valueOf('#'), p_176672_).m_126130_("##").m_126130_("##").m_126130_("##");
    }

    private static RecipeBuilder m_176678_(ItemLike p_176679_, Ingredient p_176680_) {
        int $$2 = p_176679_ == Blocks.f_50198_ ? 6 : 3;
        Item $$3 = p_176679_ == Blocks.f_50198_ ? Items.f_42691_ : Items.f_42398_;
        return ShapedRecipeBuilder.m_246608_(RecipeCategory.DECORATIONS, p_176679_, $$2).m_126124_(Character.valueOf('W'), p_176680_).m_126127_(Character.valueOf('#'), $$3).m_126130_("W#W").m_126130_("W#W");
    }

    private static RecipeBuilder m_176684_(ItemLike p_176685_, Ingredient p_176686_) {
        return ShapedRecipeBuilder.m_245327_(RecipeCategory.REDSTONE, p_176685_).m_126127_(Character.valueOf('#'), Items.f_42398_).m_126124_(Character.valueOf('W'), p_176686_).m_126130_("#W#").m_126130_("#W#");
    }

    protected static void m_176690_(Consumer<FinishedRecipe> p_176691_, ItemLike p_176692_, ItemLike p_176693_) {
        RecipeProvider.m_247347_(RecipeCategory.REDSTONE, p_176692_, Ingredient.m_43929_(p_176693_)).m_126132_(RecipeProvider.m_176602_(p_176693_), RecipeProvider.m_125977_(p_176693_)).m_176498_(p_176691_);
    }

    private static RecipeBuilder m_247347_(RecipeCategory p_251447_, ItemLike p_251989_, Ingredient p_249211_) {
        return ShapedRecipeBuilder.m_245327_(p_251447_, p_251989_).m_126124_(Character.valueOf('#'), p_249211_).m_126130_("##");
    }

    protected static void m_246658_(Consumer<FinishedRecipe> p_248880_, RecipeCategory p_251848_, ItemLike p_249368_, ItemLike p_252133_) {
        RecipeProvider.m_247552_(p_251848_, p_249368_, Ingredient.m_43929_(p_252133_)).m_126132_(RecipeProvider.m_176602_(p_252133_), RecipeProvider.m_125977_(p_252133_)).m_176498_(p_248880_);
    }

    protected static RecipeBuilder m_247552_(RecipeCategory p_251707_, ItemLike p_251284_, Ingredient p_248824_) {
        return ShapedRecipeBuilder.m_246608_(p_251707_, p_251284_, 6).m_126124_(Character.valueOf('#'), p_248824_).m_126130_("###");
    }

    protected static RecipeBuilder m_176710_(ItemLike p_176711_, Ingredient p_176712_) {
        return ShapedRecipeBuilder.m_246608_(RecipeCategory.BUILDING_BLOCKS, p_176711_, 4).m_126124_(Character.valueOf('#'), p_176712_).m_126130_("#  ").m_126130_("## ").m_126130_("###");
    }

    private static RecipeBuilder m_176720_(ItemLike p_176721_, Ingredient p_176722_) {
        return ShapedRecipeBuilder.m_246608_(RecipeCategory.REDSTONE, p_176721_, 2).m_126124_(Character.valueOf('#'), p_176722_).m_126130_("###").m_126130_("###");
    }

    private static RecipeBuilder m_176726_(ItemLike p_176727_, Ingredient p_176728_) {
        return ShapedRecipeBuilder.m_246608_(RecipeCategory.DECORATIONS, p_176727_, 3).m_126145_("sign").m_126124_(Character.valueOf('#'), p_176728_).m_126127_(Character.valueOf('X'), Items.f_42398_).m_126130_("###").m_126130_("###").m_126130_(" X ");
    }

    protected static void m_246977_(Consumer<FinishedRecipe> p_250663_, ItemLike p_252355_, ItemLike p_250437_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.DECORATIONS, p_252355_, 6).m_126145_("hanging_sign").m_126127_(Character.valueOf('#'), p_250437_).m_126127_(Character.valueOf('X'), Items.f_42026_).m_126130_("X X").m_126130_("###").m_126130_("###").m_126132_("has_stripped_logs", RecipeProvider.m_125977_(p_250437_)).m_176498_(p_250663_);
    }

    protected static void m_126061_(Consumer<FinishedRecipe> p_126062_, ItemLike p_126063_, ItemLike p_126064_) {
        ShapelessRecipeBuilder.m_245498_(RecipeCategory.BUILDING_BLOCKS, p_126063_).m_126209_(p_126064_).m_126209_(Blocks.f_50041_).m_126145_("wool").m_126132_("has_white_wool", RecipeProvider.m_125977_(Blocks.f_50041_)).m_176498_(p_126062_);
    }

    protected static void m_176716_(Consumer<FinishedRecipe> p_176717_, ItemLike p_176718_, ItemLike p_176719_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.DECORATIONS, p_176718_, 3).m_126127_(Character.valueOf('#'), p_176719_).m_126130_("##").m_126145_("carpet").m_126132_(RecipeProvider.m_176602_(p_176719_), RecipeProvider.m_125977_(p_176719_)).m_176498_(p_176717_);
    }

    protected static void m_126069_(Consumer<FinishedRecipe> p_126070_, ItemLike p_126071_, ItemLike p_126072_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.DECORATIONS, p_126071_, 8).m_126127_(Character.valueOf('#'), Blocks.f_50336_).m_126127_(Character.valueOf('$'), p_126072_).m_126130_("###").m_126130_("#$#").m_126130_("###").m_126145_("carpet").m_126132_("has_white_carpet", RecipeProvider.m_125977_(Blocks.f_50336_)).m_126132_(RecipeProvider.m_176602_(p_126072_), RecipeProvider.m_125977_(p_126072_)).m_176500_(p_126070_, RecipeProvider.m_176517_(p_126071_, Blocks.f_50336_));
    }

    protected static void m_126073_(Consumer<FinishedRecipe> p_126074_, ItemLike p_126075_, ItemLike p_126076_) {
        ShapedRecipeBuilder.m_245327_(RecipeCategory.DECORATIONS, p_126075_).m_126127_(Character.valueOf('#'), p_126076_).m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_126130_("###").m_126130_("XXX").m_126145_("bed").m_126132_(RecipeProvider.m_176602_(p_126076_), RecipeProvider.m_125977_(p_126076_)).m_176498_(p_126074_);
    }

    protected static void m_126077_(Consumer<FinishedRecipe> p_126078_, ItemLike p_126079_, ItemLike p_126080_) {
        ShapelessRecipeBuilder.m_245498_(RecipeCategory.DECORATIONS, p_126079_).m_126209_(Items.f_42503_).m_126209_(p_126080_).m_126145_("dyed_bed").m_126132_("has_bed", RecipeProvider.m_125977_(Items.f_42503_)).m_176500_(p_126078_, RecipeProvider.m_176517_(p_126079_, Items.f_42503_));
    }

    protected static void m_126081_(Consumer<FinishedRecipe> p_126082_, ItemLike p_126083_, ItemLike p_126084_) {
        ShapedRecipeBuilder.m_245327_(RecipeCategory.DECORATIONS, p_126083_).m_126127_(Character.valueOf('#'), p_126084_).m_126127_(Character.valueOf('|'), Items.f_42398_).m_126130_("###").m_126130_("###").m_126130_(" | ").m_126145_("banner").m_126132_(RecipeProvider.m_176602_(p_126084_), RecipeProvider.m_125977_(p_126084_)).m_176498_(p_126082_);
    }

    protected static void m_126085_(Consumer<FinishedRecipe> p_126086_, ItemLike p_126087_, ItemLike p_126088_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.BUILDING_BLOCKS, p_126087_, 8).m_126127_(Character.valueOf('#'), Blocks.f_50058_).m_126127_(Character.valueOf('X'), p_126088_).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126145_("stained_glass").m_126132_("has_glass", RecipeProvider.m_125977_(Blocks.f_50058_)).m_176498_(p_126086_);
    }

    protected static void m_126089_(Consumer<FinishedRecipe> p_126090_, ItemLike p_126091_, ItemLike p_126092_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.DECORATIONS, p_126091_, 16).m_126127_(Character.valueOf('#'), p_126092_).m_126130_("###").m_126130_("###").m_126145_("stained_glass_pane").m_126132_("has_glass", RecipeProvider.m_125977_(p_126092_)).m_176498_(p_126090_);
    }

    protected static void m_126093_(Consumer<FinishedRecipe> p_126094_, ItemLike p_126095_, ItemLike p_126096_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.DECORATIONS, p_126095_, 8).m_126127_(Character.valueOf('#'), Blocks.f_50185_).m_126127_(Character.valueOf('$'), p_126096_).m_126130_("###").m_126130_("#$#").m_126130_("###").m_126145_("stained_glass_pane").m_126132_("has_glass_pane", RecipeProvider.m_125977_(Blocks.f_50185_)).m_126132_(RecipeProvider.m_176602_(p_126096_), RecipeProvider.m_125977_(p_126096_)).m_176500_(p_126094_, RecipeProvider.m_176517_(p_126095_, Blocks.f_50185_));
    }

    protected static void m_126097_(Consumer<FinishedRecipe> p_126098_, ItemLike p_126099_, ItemLike p_126100_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.BUILDING_BLOCKS, p_126099_, 8).m_126127_(Character.valueOf('#'), Blocks.f_50352_).m_126127_(Character.valueOf('X'), p_126100_).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126145_("stained_terracotta").m_126132_("has_terracotta", RecipeProvider.m_125977_(Blocks.f_50352_)).m_176498_(p_126098_);
    }

    protected static void m_126101_(Consumer<FinishedRecipe> p_126102_, ItemLike p_126103_, ItemLike p_126104_) {
        ShapelessRecipeBuilder.m_246517_(RecipeCategory.BUILDING_BLOCKS, p_126103_, 8).m_126209_(p_126104_).m_126211_(Blocks.f_49992_, 4).m_126211_(Blocks.f_49994_, 4).m_126145_("concrete_powder").m_126132_("has_sand", RecipeProvider.m_125977_(Blocks.f_49992_)).m_126132_("has_gravel", RecipeProvider.m_125977_(Blocks.f_49994_)).m_176498_(p_126102_);
    }

    protected static void m_176542_(Consumer<FinishedRecipe> p_176543_, ItemLike p_176544_, ItemLike p_176545_) {
        ShapelessRecipeBuilder.m_245498_(RecipeCategory.DECORATIONS, p_176544_).m_126209_(Blocks.f_152482_).m_126209_(p_176545_).m_126145_("dyed_candle").m_126132_(RecipeProvider.m_176602_(p_176545_), RecipeProvider.m_125977_(p_176545_)).m_176498_(p_176543_);
    }

    protected static void m_246382_(Consumer<FinishedRecipe> p_251034_, RecipeCategory p_251148_, ItemLike p_250499_, ItemLike p_249970_) {
        RecipeProvider.m_245864_(p_251148_, p_250499_, Ingredient.m_43929_(p_249970_)).m_126132_(RecipeProvider.m_176602_(p_249970_), RecipeProvider.m_125977_(p_249970_)).m_176498_(p_251034_);
    }

    private static RecipeBuilder m_245864_(RecipeCategory p_249083_, ItemLike p_250754_, Ingredient p_250311_) {
        return ShapedRecipeBuilder.m_246608_(p_249083_, p_250754_, 6).m_126124_(Character.valueOf('#'), p_250311_).m_126130_("###").m_126130_("###");
    }

    protected static void m_245931_(Consumer<FinishedRecipe> p_251348_, RecipeCategory p_248719_, ItemLike p_250032_, ItemLike p_250021_) {
        RecipeProvider.m_247174_(p_248719_, p_250032_, Ingredient.m_43929_(p_250021_)).m_126132_(RecipeProvider.m_176602_(p_250021_), RecipeProvider.m_125977_(p_250021_)).m_176498_(p_251348_);
    }

    private static RecipeBuilder m_247174_(RecipeCategory p_249131_, ItemLike p_251242_, Ingredient p_251412_) {
        return ShapedRecipeBuilder.m_246608_(p_249131_, p_251242_, 4).m_126124_(Character.valueOf('S'), p_251412_).m_126130_("SS").m_126130_("SS");
    }

    protected static void m_247059_(Consumer<FinishedRecipe> p_248712_, RecipeCategory p_252306_, ItemLike p_249686_, ItemLike p_251100_) {
        RecipeProvider.m_245792_(p_252306_, p_249686_, Ingredient.m_43929_(p_251100_)).m_126132_(RecipeProvider.m_176602_(p_251100_), RecipeProvider.m_125977_(p_251100_)).m_176498_(p_248712_);
    }

    private static ShapedRecipeBuilder m_245792_(RecipeCategory p_250895_, ItemLike p_251147_, Ingredient p_251563_) {
        return ShapedRecipeBuilder.m_246608_(p_250895_, p_251147_, 4).m_126124_(Character.valueOf('#'), p_251563_).m_126130_("##").m_126130_("##");
    }

    protected static void m_246222_(Consumer<FinishedRecipe> p_250120_, RecipeCategory p_251604_, ItemLike p_251049_, ItemLike p_252267_) {
        RecipeProvider.m_246451_(p_251604_, p_251049_, Ingredient.m_43929_(p_252267_)).m_126132_(RecipeProvider.m_176602_(p_252267_), RecipeProvider.m_125977_(p_252267_)).m_176498_(p_250120_);
    }

    protected static void m_247239_(Consumer<FinishedRecipe> p_249200_, RecipeCategory p_248788_, ItemLike p_251925_, ItemLike p_252242_) {
        ShapedRecipeBuilder.m_245327_(p_248788_, p_251925_).m_126127_(Character.valueOf('#'), p_252242_).m_126130_("#").m_126130_("#").m_126132_(RecipeProvider.m_176602_(p_252242_), RecipeProvider.m_125977_(p_252242_)).m_176498_(p_249200_);
    }

    protected static ShapedRecipeBuilder m_246451_(RecipeCategory p_251755_, ItemLike p_249782_, Ingredient p_250087_) {
        return ShapedRecipeBuilder.m_245327_(p_251755_, p_249782_).m_126124_(Character.valueOf('#'), p_250087_).m_126130_("#").m_126130_("#");
    }

    protected static void m_247600_(Consumer<FinishedRecipe> p_251589_, RecipeCategory p_248911_, ItemLike p_251265_, ItemLike p_250033_) {
        RecipeProvider.m_247298_(p_251589_, p_248911_, p_251265_, p_250033_, 1);
    }

    protected static void m_247298_(Consumer<FinishedRecipe> p_249145_, RecipeCategory p_250609_, ItemLike p_251254_, ItemLike p_249666_, int p_251462_) {
        SingleItemRecipeBuilder.m_246944_(Ingredient.m_43929_(p_249666_), p_250609_, p_251254_, p_251462_).m_126132_(RecipeProvider.m_176602_(p_249666_), RecipeProvider.m_125977_(p_249666_)).m_176500_(p_249145_, RecipeProvider.m_176517_(p_251254_, p_249666_) + "_stonecutting");
    }

    private static void m_176739_(Consumer<FinishedRecipe> p_176740_, ItemLike p_176741_, ItemLike p_176742_) {
        SimpleCookingRecipeBuilder.m_246179_(Ingredient.m_43929_(p_176742_), RecipeCategory.BUILDING_BLOCKS, p_176741_, 0.1f, 200).m_126132_(RecipeProvider.m_176602_(p_176742_), RecipeProvider.m_125977_(p_176742_)).m_176498_(p_176740_);
    }

    protected static void m_247655_(Consumer<FinishedRecipe> p_249580_, RecipeCategory p_251203_, ItemLike p_251689_, RecipeCategory p_251376_, ItemLike p_248771_) {
        RecipeProvider.m_247368_(p_249580_, p_251203_, p_251689_, p_251376_, p_248771_, RecipeProvider.m_176644_(p_248771_), null, RecipeProvider.m_176644_(p_251689_), null);
    }

    protected static void m_246075_(Consumer<FinishedRecipe> p_250488_, RecipeCategory p_250885_, ItemLike p_251651_, RecipeCategory p_250874_, ItemLike p_248576_, String p_250171_, String p_249386_) {
        RecipeProvider.m_247368_(p_250488_, p_250885_, p_251651_, p_250874_, p_248576_, p_250171_, p_249386_, RecipeProvider.m_176644_(p_251651_), null);
    }

    protected static void m_245261_(Consumer<FinishedRecipe> p_250320_, RecipeCategory p_248979_, ItemLike p_249101_, RecipeCategory p_252036_, ItemLike p_250886_, String p_248768_, String p_250847_) {
        RecipeProvider.m_247368_(p_250320_, p_248979_, p_249101_, p_252036_, p_250886_, RecipeProvider.m_176644_(p_250886_), null, p_248768_, p_250847_);
    }

    private static void m_247368_(Consumer<FinishedRecipe> p_250423_, RecipeCategory p_250083_, ItemLike p_250042_, RecipeCategory p_248977_, ItemLike p_251911_, String p_250475_, @Nullable String p_248641_, String p_252237_, @Nullable String p_250414_) {
        ShapelessRecipeBuilder.m_246517_(p_250083_, p_250042_, 9).m_126209_(p_251911_).m_126145_(p_250414_).m_126132_(RecipeProvider.m_176602_(p_251911_), RecipeProvider.m_125977_(p_251911_)).m_126140_(p_250423_, new ResourceLocation(p_252237_));
        ShapedRecipeBuilder.m_245327_(p_248977_, p_251911_).m_126127_(Character.valueOf('#'), p_250042_).m_126130_("###").m_126130_("###").m_126130_("###").m_126145_(p_248641_).m_126132_(RecipeProvider.m_176602_(p_250042_), RecipeProvider.m_125977_(p_250042_)).m_126140_(p_250423_, new ResourceLocation(p_250475_));
    }

    protected static void m_126006_(Consumer<FinishedRecipe> p_126007_, String p_126008_, RecipeSerializer<? extends AbstractCookingRecipe> p_250529_, int p_126010_) {
        RecipeProvider.m_247434_(p_126007_, p_126008_, p_250529_, p_126010_, Items.f_42579_, Items.f_42580_, 0.35f);
        RecipeProvider.m_247434_(p_126007_, p_126008_, p_250529_, p_126010_, Items.f_42581_, Items.f_42582_, 0.35f);
        RecipeProvider.m_247434_(p_126007_, p_126008_, p_250529_, p_126010_, Items.f_42526_, Items.f_42530_, 0.35f);
        RecipeProvider.m_247434_(p_126007_, p_126008_, p_250529_, p_126010_, Items.f_41910_, Items.f_42576_, 0.1f);
        RecipeProvider.m_247434_(p_126007_, p_126008_, p_250529_, p_126010_, Items.f_42527_, Items.f_42531_, 0.35f);
        RecipeProvider.m_247434_(p_126007_, p_126008_, p_250529_, p_126010_, Items.f_42658_, Items.f_42659_, 0.35f);
        RecipeProvider.m_247434_(p_126007_, p_126008_, p_250529_, p_126010_, Items.f_42485_, Items.f_42486_, 0.35f);
        RecipeProvider.m_247434_(p_126007_, p_126008_, p_250529_, p_126010_, Items.f_42620_, Items.f_42674_, 0.35f);
        RecipeProvider.m_247434_(p_126007_, p_126008_, p_250529_, p_126010_, Items.f_42697_, Items.f_42698_, 0.35f);
    }

    private static void m_247434_(Consumer<FinishedRecipe> p_249398_, String p_249709_, RecipeSerializer<? extends AbstractCookingRecipe> p_251876_, int p_249258_, ItemLike p_250669_, ItemLike p_250224_, float p_252138_) {
        SimpleCookingRecipeBuilder.m_247607_(Ingredient.m_43929_(p_250669_), RecipeCategory.FOOD, p_250224_, p_252138_, p_249258_, p_251876_).m_126132_(RecipeProvider.m_176602_(p_250669_), RecipeProvider.m_125977_(p_250669_)).m_176500_(p_249398_, RecipeProvider.m_176632_(p_250224_) + "_from_" + p_249709_);
    }

    protected static void m_176610_(Consumer<FinishedRecipe> p_176611_) {
        HoneycombItem.f_150863_.get().forEach((p_248022_, p_248023_) -> ShapelessRecipeBuilder.m_245498_(RecipeCategory.BUILDING_BLOCKS, p_248023_).m_126209_((ItemLike)p_248022_).m_126209_(Items.f_42784_).m_126145_(RecipeProvider.m_176632_(p_248023_)).m_126132_(RecipeProvider.m_176602_(p_248022_), RecipeProvider.m_125977_(p_248022_)).m_176500_(p_176611_, RecipeProvider.m_176517_(p_248023_, Items.f_42784_)));
    }

    protected static void m_176580_(Consumer<FinishedRecipe> p_176581_, BlockFamily p_176582_) {
        p_176582_.m_175954_().forEach((p_176529_, p_176530_) -> {
            BiFunction<ItemLike, ItemLike, RecipeBuilder> $$4 = f_244077_.get(p_176529_);
            Block $$5 = RecipeProvider.m_176523_(p_176582_, p_176529_);
            if ($$4 != null) {
                RecipeBuilder $$6 = $$4.apply((ItemLike)p_176530_, $$5);
                p_176582_.m_175957_().ifPresent(p_176601_ -> $$6.m_126145_(p_176601_ + (String)(p_176529_ == BlockFamily.Variant.CUT ? "" : "_" + p_176529_.m_176020_())));
                $$6.m_126132_(p_176582_.m_175958_().orElseGet(() -> RecipeProvider.m_176602_($$5)), RecipeProvider.m_125977_($$5));
                $$6.m_176498_(p_176581_);
            }
            if (p_176529_ == BlockFamily.Variant.CRACKED) {
                RecipeProvider.m_176739_(p_176581_, p_176530_, $$5);
            }
        });
    }

    private static Block m_176523_(BlockFamily p_176524_, BlockFamily.Variant p_176525_) {
        if (p_176525_ == BlockFamily.Variant.CHISELED) {
            if (!p_176524_.m_175954_().containsKey((Object)BlockFamily.Variant.SLAB)) {
                throw new IllegalStateException("Slab is not defined for the family.");
            }
            return p_176524_.m_175952_(BlockFamily.Variant.SLAB);
        }
        return p_176524_.m_175951_();
    }

    private static EnterBlockTrigger.TriggerInstance m_125979_(Block p_125980_) {
        return new EnterBlockTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, p_125980_, StatePropertiesPredicate.f_67658_);
    }

    private static InventoryChangeTrigger.TriggerInstance m_176520_(MinMaxBounds.Ints p_176521_, ItemLike p_176522_) {
        return RecipeProvider.m_126011_(ItemPredicate.Builder.m_45068_().m_151445_(p_176522_).m_151443_(p_176521_).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance m_125977_(ItemLike p_125978_) {
        return RecipeProvider.m_126011_(ItemPredicate.Builder.m_45068_().m_151445_(p_125978_).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance m_206406_(TagKey<Item> p_206407_) {
        return RecipeProvider.m_126011_(ItemPredicate.Builder.m_45068_().m_204145_(p_206407_).m_45077_());
    }

    private static InventoryChangeTrigger.TriggerInstance m_126011_(ItemPredicate ... p_126012_) {
        return new InventoryChangeTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, p_126012_);
    }

    protected static String m_176602_(ItemLike p_176603_) {
        return "has_" + RecipeProvider.m_176632_(p_176603_);
    }

    protected static String m_176632_(ItemLike p_176633_) {
        return BuiltInRegistries.f_257033_.m_7981_(p_176633_.m_5456_()).m_135815_();
    }

    protected static String m_176644_(ItemLike p_176645_) {
        return RecipeProvider.m_176632_(p_176645_);
    }

    protected static String m_176517_(ItemLike p_176518_, ItemLike p_176519_) {
        return RecipeProvider.m_176632_(p_176518_) + "_from_" + RecipeProvider.m_176632_(p_176519_);
    }

    protected static String m_176656_(ItemLike p_176657_) {
        return RecipeProvider.m_176632_(p_176657_) + "_from_smelting";
    }

    protected static String m_176668_(ItemLike p_176669_) {
        return RecipeProvider.m_176632_(p_176669_) + "_from_blasting";
    }

    @Override
    public final String m_6055_() {
        return "Recipes";
    }
}

