/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.flag;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlagUniverse;
import org.slf4j.Logger;

public class FeatureFlagRegistry {
    private static final Logger f_244528_ = LogUtils.getLogger();
    private final FeatureFlagUniverse f_244444_;
    private final Map<ResourceLocation, FeatureFlag> f_244560_;
    private final FeatureFlagSet f_243770_;

    FeatureFlagRegistry(FeatureFlagUniverse p_249715_, FeatureFlagSet p_249277_, Map<ResourceLocation, FeatureFlag> p_249557_) {
        this.f_244444_ = p_249715_;
        this.f_244560_ = p_249557_;
        this.f_243770_ = p_249277_;
    }

    public boolean m_246363_(FeatureFlagSet p_251939_) {
        return p_251939_.m_247715_(this.f_243770_);
    }

    public FeatureFlagSet m_247355_() {
        return this.f_243770_;
    }

    public FeatureFlagSet m_247416_(Iterable<ResourceLocation> p_250759_) {
        return this.m_247021_(p_250759_, p_251224_ -> f_244528_.warn("Unknown feature flag: {}", p_251224_));
    }

    public FeatureFlagSet m_245769_(FeatureFlag ... p_252295_) {
        return FeatureFlagSet.m_247438_(this.f_244444_, Arrays.asList(p_252295_));
    }

    public FeatureFlagSet m_247021_(Iterable<ResourceLocation> p_251769_, Consumer<ResourceLocation> p_251521_) {
        Set $$2 = Sets.newIdentityHashSet();
        for (ResourceLocation $$3 : p_251769_) {
            FeatureFlag $$4 = this.f_244560_.get($$3);
            if ($$4 == null) {
                p_251521_.accept($$3);
                continue;
            }
            $$2.add($$4);
        }
        return FeatureFlagSet.m_247438_(this.f_244444_, $$2);
    }

    public Set<ResourceLocation> m_245829_(FeatureFlagSet p_251153_) {
        HashSet<ResourceLocation> $$1 = new HashSet<ResourceLocation>();
        this.f_244560_.forEach((p_252018_, p_250772_) -> {
            if (p_251153_.m_245372_((FeatureFlag)p_250772_)) {
                $$1.add((ResourceLocation)p_252018_);
            }
        });
        return $$1;
    }

    public Codec<FeatureFlagSet> m_245213_() {
        return ResourceLocation.f_135803_.listOf().comapFlatMap(p_248547_ -> {
            HashSet $$1 = new HashSet();
            FeatureFlagSet $$2 = this.m_247021_((Iterable<ResourceLocation>)p_248547_, $$1::add);
            if (!$$1.isEmpty()) {
                return DataResult.error((String)("Unknown feature ids: " + $$1), (Object)$$2);
            }
            return DataResult.success((Object)$$2);
        }, p_249796_ -> List.copyOf(this.m_245829_((FeatureFlagSet)p_249796_)));
    }

    public static class Builder {
        private final FeatureFlagUniverse f_243698_;
        private int f_244365_;
        private final Map<ResourceLocation, FeatureFlag> f_244349_ = new LinkedHashMap<ResourceLocation, FeatureFlag>();

        public Builder(String p_251576_) {
            this.f_243698_ = new FeatureFlagUniverse(p_251576_);
        }

        public FeatureFlag m_246015_(String p_251782_) {
            return this.m_247497_(new ResourceLocation("minecraft", p_251782_));
        }

        public FeatureFlag m_247497_(ResourceLocation p_250098_) {
            FeatureFlag $$1;
            FeatureFlag $$2;
            if (this.f_244365_ >= 64) {
                throw new IllegalStateException("Too many feature flags");
            }
            if (($$2 = this.f_244349_.put(p_250098_, $$1 = new FeatureFlag(this.f_243698_, this.f_244365_++))) != null) {
                throw new IllegalStateException("Duplicate feature flag " + p_250098_);
            }
            return $$1;
        }

        public FeatureFlagRegistry m_245707_() {
            FeatureFlagSet $$0 = FeatureFlagSet.m_247438_(this.f_243698_, this.f_244349_.values());
            return new FeatureFlagRegistry(this.f_243698_, $$0, Map.copyOf(this.f_244349_));
        }
    }
}

