/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.StitcherException;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class SpriteLoader {
    private static final Logger f_244357_ = LogUtils.getLogger();
    private final ResourceLocation f_244500_;
    private final int f_243676_;

    public SpriteLoader(ResourceLocation p_250575_, int p_252264_) {
        this.f_244500_ = p_250575_;
        this.f_243676_ = p_252264_;
    }

    public static SpriteLoader m_245483_(TextureAtlas p_249085_) {
        return new SpriteLoader(p_249085_.m_118330_(), p_249085_.m_245285_());
    }

    public Preparations m_261295_(List<SpriteContents> p_262029_, int p_261919_, Executor p_261665_) {
        int i = this.f_243676_;
        Stitcher<SpriteContents> stitcher = new Stitcher<SpriteContents>(i, i, p_261919_);
        int j = Integer.MAX_VALUE;
        int k = 1 << p_261919_;
        for (SpriteContents spritecontents : p_262029_) {
            j = Math.min(j, Math.min(spritecontents.m_246492_(), spritecontents.m_245330_()));
            int l = Math.min(Integer.lowestOneBit(spritecontents.m_246492_()), Integer.lowestOneBit(spritecontents.m_245330_()));
            if (l < k) {
                f_244357_.warn("Texture {} with size {}x{} limits mip level from {} to {}", new Object[]{spritecontents.m_246162_(), spritecontents.m_246492_(), spritecontents.m_245330_(), Mth.m_14173_((int)k), Mth.m_14173_((int)l)});
                k = l;
            }
            stitcher.m_246099_(spritecontents);
        }
        int i1 = Math.min(j, k);
        int j1 = Mth.m_14173_((int)i1);
        int k1 = p_261919_;
        try {
            stitcher.m_118193_();
        }
        catch (StitcherException stitcherexception) {
            CrashReport crashreport = CrashReport.m_127521_(stitcherexception, "Stitching");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Stitcher");
            crashreportcategory.m_128159_("Sprites", stitcherexception.m_118258_().stream().map(p_249576_ -> String.format(Locale.ROOT, "%s[%dx%d]", p_249576_.m_246162_(), p_249576_.m_246492_(), p_249576_.m_245330_())).collect(Collectors.joining(",")));
            crashreportcategory.m_128159_("Max Texture Size", i);
            throw new ReportedException(crashreport);
        }
        Map<ResourceLocation, TextureAtlasSprite> map = this.m_245915_(stitcher);
        TextureAtlasSprite textureatlassprite = map.get(MissingTextureAtlasSprite.m_118071_());
        CompletableFuture<Void> completablefuture = k1 > 0 ? CompletableFuture.runAsync(() -> map.values().forEach(p_251202_ -> p_251202_.m_245424_().m_246368_(k1)), p_261665_) : CompletableFuture.completedFuture(null);
        return new Preparations(stitcher.m_118174_(), stitcher.m_118187_(), k1, textureatlassprite, map, completablefuture);
    }

    public static CompletableFuture<List<SpriteContents>> m_260809_(List<Supplier<SpriteContents>> p_261516_, Executor p_261791_) {
        List<CompletableFuture> list = p_261516_.stream().map(p_261395_ -> CompletableFuture.supplyAsync(p_261395_, p_261791_)).toList();
        return Util.m_137567_(list).thenApply(p_252234_ -> p_252234_.stream().filter(Objects::nonNull).toList());
    }

    public CompletableFuture<Preparations> m_260881_(ResourceManager p_262108_, ResourceLocation p_261754_, int p_262104_, Executor p_261687_) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> SpriteResourceLoader.m_261166_((ResourceManager)p_262108_, (ResourceLocation)p_261754_).m_260886_(p_262108_), p_261687_).thenCompose(p_261390_ -> SpriteLoader.m_260809_(p_261390_, p_261687_))).thenApply(p_261393_ -> this.m_261295_((List<SpriteContents>)p_261393_, p_262104_, p_261687_));
    }

    @Nullable
    public static SpriteContents m_245083_(ResourceLocation p_251630_, Resource p_250558_) {
        NativeImage nativeimage;
        AnimationMetadataSection animationmetadatasection;
        try {
            animationmetadatasection = p_250558_.m_215509_().m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_).orElse(AnimationMetadataSection.f_119012_);
        }
        catch (Exception exception) {
            f_244357_.error("Unable to parse metadata from {}", (Object)p_251630_, (Object)exception);
            return null;
        }
        try (InputStream inputstream = p_250558_.m_215507_();){
            nativeimage = NativeImage.m_85058_((InputStream)inputstream);
        }
        catch (IOException ioexception) {
            f_244357_.error("Using missing texture, unable to load {}", (Object)p_251630_, (Object)ioexception);
            return null;
        }
        FrameSize framesize = animationmetadatasection.m_245821_(nativeimage.m_84982_(), nativeimage.m_85084_());
        if (Mth.m_246985_((int)nativeimage.m_84982_(), (int)framesize.f_244129_()) && Mth.m_246985_((int)nativeimage.m_85084_(), (int)framesize.f_244503_())) {
            SpriteContents contents = ForgeHooksClient.loadSpriteContents((ResourceLocation)p_251630_, (Resource)p_250558_, (FrameSize)framesize, (NativeImage)nativeimage, (AnimationMetadataSection)animationmetadatasection);
            if (contents != null) {
                return contents;
            }
            return new SpriteContents(p_251630_, framesize, nativeimage, animationmetadatasection);
        }
        f_244357_.error("Image {} size {},{} is not multiple of frame size {},{}", new Object[]{p_251630_, nativeimage.m_84982_(), nativeimage.m_85084_(), framesize.f_244129_(), framesize.f_244503_()});
        nativeimage.close();
        return null;
    }

    private Map<ResourceLocation, TextureAtlasSprite> m_245915_(Stitcher<SpriteContents> p_249904_) {
        HashMap<ResourceLocation, TextureAtlasSprite> map = new HashMap<ResourceLocation, TextureAtlasSprite>();
        int i = p_249904_.m_118174_();
        int j = p_249904_.m_118187_();
        p_249904_.m_118180_((p_251421_, p_250533_, p_251913_) -> {
            TextureAtlasSprite sprite = ForgeHooksClient.loadTextureAtlasSprite((ResourceLocation)this.f_244500_, (SpriteContents)p_251421_, (int)i, (int)j, (int)p_250533_, (int)p_251913_, (int)(p_251421_.f_243731_.length - 1));
            if (sprite != null) {
                map.put(p_251421_.m_246162_(), sprite);
                return;
            }
            map.put(p_251421_.m_246162_(), new TextureAtlasSprite(this.f_244500_, (SpriteContents)p_251421_, i, j, p_250533_, p_251913_));
        });
        return map;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Preparations(int f_243669_, int f_244632_, int f_244353_, TextureAtlasSprite f_243912_, Map<ResourceLocation, TextureAtlasSprite> f_243807_, CompletableFuture<Void> f_244415_) {
        public CompletableFuture<Preparations> m_246429_() {
            return this.f_244415_.thenApply(p_249056_ -> this);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Preparations.class, "width;height;mipLevel;missing;regions;readyForUpload", "f_243669_", "f_244632_", "f_244353_", "f_243912_", "f_243807_", "f_244415_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Preparations.class, "width;height;mipLevel;missing;regions;readyForUpload", "f_243669_", "f_244632_", "f_244353_", "f_243912_", "f_243807_", "f_244415_"}, this);
        }

        @Override
        public final boolean equals(Object p_250785_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Preparations.class, "width;height;mipLevel;missing;regions;readyForUpload", "f_243669_", "f_244632_", "f_244353_", "f_243912_", "f_243807_", "f_244415_"}, this, p_250785_);
        }
    }
}

