/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class MappedRegistry<T>
implements WritableRegistry<T> {
    private static final Logger f_211050_ = LogUtils.getLogger();
    final ResourceKey<? extends Registry<T>> f_256817_;
    private final ObjectList<Holder.Reference<T>> f_122672_ = new ObjectArrayList(256);
    private final Object2IntMap<T> f_122673_ = (Object2IntMap)Util.m_137469_(new Object2IntOpenCustomHashMap(Util.m_137583_()), p_194539_ -> p_194539_.defaultReturnValue(-1));
    private final Map<ResourceLocation, Holder.Reference<T>> f_205841_ = new HashMap<ResourceLocation, Holder.Reference<T>>();
    private final Map<ResourceKey<T>, Holder.Reference<T>> f_205842_ = new HashMap<ResourceKey<T>, Holder.Reference<T>>();
    private final Map<T, Holder.Reference<T>> f_205843_ = new IdentityHashMap<T, Holder.Reference<T>>();
    private final Map<T, Lifecycle> f_122676_ = new IdentityHashMap<T, Lifecycle>();
    private Lifecycle f_256989_;
    private volatile Map<TagKey<T>, HolderSet.Named<T>> f_205844_ = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    private boolean f_205845_;
    @Nullable
    protected Map<T, Holder.Reference<T>> f_244282_;
    @Nullable
    private List<Holder.Reference<T>> f_211051_;
    private int f_122678_;
    private final HolderLookup.RegistryLookup<T> f_256971_ = new HolderLookup.RegistryLookup<T>(){

        public ResourceKey<? extends Registry<? extends T>> m_254879_() {
            return MappedRegistry.this.f_256817_;
        }

        public Lifecycle m_254883_() {
            return MappedRegistry.this.m_203658_();
        }

        public Optional<Holder.Reference<T>> m_254902_(ResourceKey<T> p_255624_) {
            return MappedRegistry.this.m_203636_(p_255624_);
        }

        public Stream<Holder.Reference<T>> m_214062_() {
            return MappedRegistry.this.m_203611_();
        }

        public Optional<HolderSet.Named<T>> m_254901_(TagKey<T> p_256277_) {
            return MappedRegistry.this.m_203431_(p_256277_);
        }

        public Stream<HolderSet.Named<T>> m_214063_() {
            return MappedRegistry.this.m_203612_().map(Pair::getSecond);
        }
    };
    private static final Set<ResourceLocation> KNOWN = new LinkedHashSet<ResourceLocation>();

    public MappedRegistry(ResourceKey<? extends Registry<T>> p_249899_, Lifecycle p_252249_) {
        this(p_249899_, p_252249_, false);
    }

    public MappedRegistry(ResourceKey<? extends Registry<T>> p_252132_, Lifecycle p_249215_, boolean p_251014_) {
        Bootstrap.m_179912_(() -> "registry " + p_252132_);
        this.f_256817_ = p_252132_;
        this.f_256989_ = p_249215_;
        if (p_251014_) {
            this.f_244282_ = new IdentityHashMap<T, Holder.Reference<T>>();
        }
    }

    public ResourceKey<? extends Registry<T>> m_123023_() {
        return this.f_256817_;
    }

    public String toString() {
        return "Registry[" + this.f_256817_ + " (" + this.f_256989_ + ")]";
    }

    private List<Holder.Reference<T>> m_211053_() {
        if (this.f_211051_ == null) {
            this.f_211051_ = this.f_122672_.stream().filter(Objects::nonNull).toList();
        }
        return this.f_211051_;
    }

    private void m_245419_() {
        if (this.f_205845_) {
            throw new IllegalStateException("Registry is already frozen");
        }
    }

    private void m_205921_(ResourceKey<T> p_205922_) {
        if (this.f_205845_) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + p_205922_ + ")");
        }
    }

    public static Set<ResourceLocation> getKnownRegistries() {
        return Collections.unmodifiableSet(KNOWN);
    }

    protected final void markKnown() {
        KNOWN.add(this.m_123023_().m_135782_());
    }

    public Holder.Reference<T> m_203704_(int p_256563_, ResourceKey<T> p_256594_, T p_256374_, Lifecycle p_256469_) {
        Holder.Reference reference;
        this.markKnown();
        this.m_205921_(p_256594_);
        Validate.notNull(p_256594_);
        Validate.notNull(p_256374_);
        if (this.f_205841_.containsKey(p_256594_.m_135782_())) {
            Util.m_137570_(new IllegalStateException("Adding duplicate key '" + p_256594_ + "' to registry"));
        }
        if (this.f_205843_.containsKey(p_256374_)) {
            Util.m_137570_(new IllegalStateException("Adding duplicate value '" + p_256374_ + "' to registry"));
        }
        if (this.f_244282_ != null) {
            reference = this.f_244282_.remove(p_256374_);
            if (reference == null) {
                throw new AssertionError((Object)("Missing intrusive holder for " + p_256594_ + ":" + p_256374_));
            }
            reference.m_246870_(p_256594_);
        } else {
            reference = this.f_205842_.computeIfAbsent(p_256594_, p_258168_ -> Holder.Reference.m_254896_(this.m_255331_(), p_258168_));
        }
        this.f_205842_.put(p_256594_, reference);
        this.f_205841_.put(p_256594_.m_135782_(), reference);
        this.f_205843_.put(p_256374_, reference);
        this.f_122672_.size(Math.max(this.f_122672_.size(), p_256563_ + 1));
        this.f_122672_.set(p_256563_, (Object)reference);
        this.f_122673_.put(p_256374_, p_256563_);
        if (this.f_122678_ <= p_256563_) {
            this.f_122678_ = p_256563_ + 1;
        }
        this.f_122676_.put(p_256374_, p_256469_);
        this.f_256989_ = this.f_256989_.add(p_256469_);
        this.f_211051_ = null;
        return reference;
    }

    public Holder.Reference<T> m_255290_(ResourceKey<T> p_256252_, T p_256591_, Lifecycle p_256255_) {
        return this.m_203704_(this.f_122678_, (ResourceKey)p_256252_, (Object)p_256591_, p_256255_);
    }

    @Nullable
    public ResourceLocation m_7981_(T p_122746_) {
        Holder.Reference<T> reference = this.f_205843_.get(p_122746_);
        return reference != null ? reference.m_205785_().m_135782_() : null;
    }

    public Optional<ResourceKey<T>> m_7854_(T p_122755_) {
        return Optional.ofNullable(this.f_205843_.get(p_122755_)).map(Holder.Reference::m_205785_);
    }

    public int m_7447_(@Nullable T p_122706_) {
        return this.f_122673_.getInt(p_122706_);
    }

    @Nullable
    public T m_6246_(@Nullable ResourceKey<T> p_122714_) {
        return MappedRegistry.m_205865_(this.f_205842_.get(p_122714_));
    }

    @Nullable
    public T m_7942_(int p_122684_) {
        return p_122684_ >= 0 && p_122684_ < this.f_122672_.size() ? (T)MappedRegistry.m_205865_((Holder.Reference)this.f_122672_.get(p_122684_)) : null;
    }

    public Optional<Holder.Reference<T>> m_203300_(int p_205907_) {
        return p_205907_ >= 0 && p_205907_ < this.f_122672_.size() ? Optional.ofNullable((Holder.Reference)this.f_122672_.get(p_205907_)) : Optional.empty();
    }

    public Optional<Holder.Reference<T>> m_203636_(ResourceKey<T> p_205905_) {
        return Optional.ofNullable(this.f_205842_.get(p_205905_));
    }

    public Holder<T> m_263177_(T p_263356_) {
        Holder.Reference<T> reference = this.f_205843_.get(p_263356_);
        return reference != null ? reference : Holder.m_205709_(p_263356_);
    }

    Holder.Reference<T> m_245420_(ResourceKey<T> p_248831_) {
        return this.f_205842_.computeIfAbsent(p_248831_, p_258169_ -> {
            if (this.f_244282_ != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.m_205921_((ResourceKey<T>)p_258169_);
            return Holder.Reference.m_254896_(this.m_255331_(), p_258169_);
        });
    }

    public int m_13562_() {
        return this.f_205842_.size();
    }

    public Lifecycle m_6228_(T p_122764_) {
        return this.f_122676_.get(p_122764_);
    }

    public Lifecycle m_203658_() {
        return this.f_256989_;
    }

    public Iterator<T> iterator() {
        return Iterators.transform(this.m_211053_().iterator(), Holder::m_203334_);
    }

    @Nullable
    public T m_7745_(@Nullable ResourceLocation p_122739_) {
        Holder.Reference<T> reference = this.f_205841_.get(p_122739_);
        return MappedRegistry.m_205865_(reference);
    }

    @Nullable
    private static <T> T m_205865_(@Nullable Holder.Reference<T> p_205866_) {
        return p_205866_ != null ? (T)p_205866_.m_203334_() : null;
    }

    public Set<ResourceLocation> m_6566_() {
        return Collections.unmodifiableSet(this.f_205841_.keySet());
    }

    public Set<ResourceKey<T>> m_214010_() {
        return Collections.unmodifiableSet(this.f_205842_.keySet());
    }

    public Set<Map.Entry<ResourceKey<T>, T>> m_6579_() {
        return Collections.unmodifiableSet(Maps.transformValues(this.f_205842_, Holder::m_203334_).entrySet());
    }

    public Stream<Holder.Reference<T>> m_203611_() {
        return this.m_211053_().stream();
    }

    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> m_203612_() {
        return this.f_205844_.entrySet().stream().map(p_211060_ -> Pair.of((Object)((TagKey)p_211060_.getKey()), (Object)((HolderSet.Named)p_211060_.getValue())));
    }

    public HolderSet.Named<T> m_203561_(TagKey<T> p_205895_) {
        HolderSet.Named<T> named = this.f_205844_.get(p_205895_);
        if (named == null) {
            named = this.m_211067_(p_205895_);
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.f_205844_);
            map.put(p_205895_, named);
            this.f_205844_ = map;
        }
        return named;
    }

    private HolderSet.Named<T> m_211067_(TagKey<T> p_211068_) {
        return new HolderSet.Named<T>(this.m_255331_(), p_211068_);
    }

    public Stream<TagKey<T>> m_203613_() {
        return this.f_205844_.keySet().stream();
    }

    public boolean m_142427_() {
        return this.f_205842_.isEmpty();
    }

    public Optional<Holder.Reference<T>> m_213642_(RandomSource p_235716_) {
        return Util.m_214676_(this.m_211053_(), p_235716_);
    }

    public boolean m_7804_(ResourceLocation p_122761_) {
        return this.f_205841_.containsKey(p_122761_);
    }

    public boolean m_142003_(ResourceKey<T> p_175392_) {
        return this.f_205842_.containsKey(p_175392_);
    }

    @Deprecated
    public void unfreeze() {
        this.f_205845_ = false;
    }

    public Registry<T> m_203521_() {
        if (this.f_205845_) {
            return this;
        }
        this.f_205845_ = true;
        this.f_205843_.forEach((p_247989_, p_247990_) -> p_247990_.m_247654_(p_247989_));
        List<ResourceLocation> list = this.f_205842_.entrySet().stream().filter(p_211055_ -> !((Holder.Reference)p_211055_.getValue()).m_203633_()).map(p_211794_ -> ((ResourceKey)p_211794_.getKey()).m_135782_()).sorted().toList();
        if (!list.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + this.m_123023_() + ": " + list);
        }
        if (this.f_244282_ != null && !this.f_244282_.isEmpty()) {
            throw new IllegalStateException("Some intrusive holders were not registered: " + this.f_244282_.values());
        }
        return this;
    }

    public Holder.Reference<T> m_203693_(T p_205915_) {
        if (this.f_244282_ == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.m_245419_();
        return this.f_244282_.computeIfAbsent(p_205915_, p_258166_ -> Holder.Reference.m_255375_(this.m_255303_(), p_258166_));
    }

    public Optional<HolderSet.Named<T>> m_203431_(TagKey<T> p_205909_) {
        return Optional.ofNullable(this.f_205844_.get(p_205909_));
    }

    public void m_203652_(Map<TagKey<T>, List<Holder<T>>> p_205875_) {
        IdentityHashMap<Holder.Reference, List> map = new IdentityHashMap<Holder.Reference, List>();
        this.f_205842_.values().forEach(p_211801_ -> map.put((Holder.Reference)p_211801_, new ArrayList()));
        p_205875_.forEach((p_211806_, p_211807_) -> {
            for (Holder holder : p_211807_) {
                if (!holder.m_203401_(this.m_255303_())) {
                    throw new IllegalStateException("Can't create named set " + p_211806_ + " containing value " + holder + " from outside registry " + this);
                }
                if (!(holder instanceof Holder.Reference)) {
                    throw new IllegalStateException("Found direct holder " + holder + " value in tag " + p_211806_);
                }
                Holder.Reference reference = (Holder.Reference)holder;
                ((List)map.get(reference)).add(p_211806_);
            }
        });
        Sets.SetView set = Sets.difference(this.f_205844_.keySet(), p_205875_.keySet());
        if (!set.isEmpty()) {
            f_211050_.warn("Not all defined tags for registry {} are present in data pack: {}", this.m_123023_(), (Object)set.stream().map(p_211811_ -> p_211811_.f_203868_().toString()).sorted().collect(Collectors.joining(", ")));
        }
        IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map1 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.f_205844_);
        p_205875_.forEach((p_211797_, p_211798_) -> map1.computeIfAbsent((TagKey<T>)p_211797_, this::m_211067_).m_205835_(p_211798_));
        map.forEach(Holder.Reference::m_205769_);
        this.f_205844_ = map1;
    }

    public void m_203635_() {
        this.f_205844_.values().forEach(p_211792_ -> p_211792_.m_205835_(List.of()));
        this.f_205842_.values().forEach(p_211803_ -> p_211803_.m_205769_(Set.of()));
    }

    public HolderGetter<T> m_203505_() {
        this.m_245419_();
        return new HolderGetter<T>(){

            public Optional<Holder.Reference<T>> m_254902_(ResourceKey<T> p_259097_) {
                return Optional.of(this.m_255043_(p_259097_));
            }

            public Holder.Reference<T> m_255043_(ResourceKey<T> p_259750_) {
                return MappedRegistry.this.m_245420_(p_259750_);
            }

            public Optional<HolderSet.Named<T>> m_254901_(TagKey<T> p_259486_) {
                return Optional.of(this.m_254956_(p_259486_));
            }

            public HolderSet.Named<T> m_254956_(TagKey<T> p_260298_) {
                return MappedRegistry.this.m_203561_(p_260298_);
            }
        };
    }

    public HolderOwner<T> m_255331_() {
        return this.f_256971_;
    }

    public HolderLookup.RegistryLookup<T> m_255303_() {
        return this.f_256971_;
    }
}

