/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.extensions.IForgeTagAppender;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class TagsProvider<T>
implements DataProvider {
    private static final Logger f_126541_ = LogUtils.getLogger();
    protected final PackOutput.PathProvider f_236439_;
    protected final CompletableFuture<HolderLookup.Provider> f_254646_;
    protected final ResourceKey<? extends Registry<T>> f_254716_;
    protected final Map<ResourceLocation, TagBuilder> f_126543_ = Maps.newLinkedHashMap();
    protected final String modId;
    @Nullable
    protected final ExistingFileHelper existingFileHelper;
    private final ExistingFileHelper.IResourceType resourceType;
    private final ExistingFileHelper.IResourceType elementResourceType;

    @Deprecated
    protected TagsProvider(PackOutput p_256596_, ResourceKey<? extends Registry<T>> p_255886_, CompletableFuture<HolderLookup.Provider> p_256513_) {
        this(p_256596_, p_255886_, p_256513_, "vanilla", null);
    }

    protected TagsProvider(PackOutput p_256596_, ResourceKey<? extends Registry<T>> p_255886_, CompletableFuture<HolderLookup.Provider> p_256513_, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        this.f_236439_ = p_256596_.m_245269_(PackOutput.Target.DATA_PACK, TagManager.m_203918_(p_255886_));
        this.f_254646_ = p_256513_;
        this.f_254716_ = p_255886_;
        this.modId = modId;
        this.existingFileHelper = existingFileHelper;
        this.resourceType = new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", TagManager.m_203918_(p_255886_));
        this.elementResourceType = new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", ForgeHooks.prefixNamespace((ResourceLocation)p_255886_.m_135782_()));
    }

    @Nullable
    protected Path getPath(ResourceLocation id) {
        return this.f_236439_.m_245731_(id);
    }

    public String m_6055_() {
        return "Tags for " + this.f_254716_.m_135782_() + " mod id " + this.modId;
    }

    protected abstract void m_6577_(HolderLookup.Provider var1);

    public CompletableFuture<?> m_213708_(CachedOutput p_253684_) {
        return this.f_254646_.thenCompose(p_255494_ -> {
            this.f_126543_.clear();
            this.m_6577_((HolderLookup.Provider)p_255494_);
            HolderLookup.RegistryLookup registrylookup = (HolderLookup.RegistryLookup)p_255494_.m_254861_(this.f_254716_).orElseThrow(() -> {
                if (RegistryManager.ACTIVE.getRegistry(this.f_254716_) != null) {
                    return new IllegalStateException("Forge registry " + this.f_254716_.m_135782_() + " does not have support for tags");
                }
                return new IllegalStateException("Registry " + this.f_254716_.m_135782_() + " not found");
            });
            Predicate<ResourceLocation> predicate = p_255496_ -> registrylookup.m_254902_(ResourceKey.m_135785_(this.f_254716_, p_255496_)).isPresent();
            return CompletableFuture.allOf((CompletableFuture[])this.f_126543_.entrySet().stream().map(p_255499_ -> {
                ResourceLocation resourcelocation = (ResourceLocation)p_255499_.getKey();
                TagBuilder tagbuilder = (TagBuilder)p_255499_.getValue();
                List<TagEntry> list = tagbuilder.m_215904_();
                List<TagEntry> list1 = list.stream().filter(p_255492_ -> !p_255492_.m_215940_(predicate, this.f_126543_::containsKey)).filter(this::missing).toList();
                if (!list1.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Couldn't define tag %s as it is missing following references: %s", resourcelocation, list1.stream().map(Objects::toString).collect(Collectors.joining(","))));
                }
                JsonElement jsonelement = (JsonElement)TagFile.f_215958_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(list, false)).getOrThrow(false, arg_0 -> ((Logger)f_126541_).error(arg_0));
                Path path = this.getPath(resourcelocation);
                if (path == null) {
                    return CompletableFuture.completedFuture(null);
                }
                return DataProvider.m_253162_((CachedOutput)p_253684_, (JsonElement)jsonelement, (Path)path);
            }).toArray(CompletableFuture[]::new));
        });
    }

    private boolean missing(TagEntry reference) {
        if (reference.isRequired()) {
            return this.existingFileHelper == null || !this.existingFileHelper.exists(reference.getId(), reference.isTag() ? this.resourceType : this.elementResourceType);
        }
        return false;
    }

    protected TagAppender<T> m_206424_(TagKey<T> p_206425_) {
        TagBuilder tagbuilder = this.m_236451_(p_206425_);
        return new TagAppender(tagbuilder, this.modId);
    }

    protected TagBuilder m_236451_(TagKey<T> p_236452_) {
        return this.f_126543_.computeIfAbsent(p_236452_.f_203868_(), p_236442_ -> {
            this.existingFileHelper.trackGenerated(p_236442_, this.resourceType);
            return TagBuilder.m_215899_();
        });
    }

    public static class TagAppender<T>
    implements IForgeTagAppender<T> {
        private final TagBuilder f_126568_;
        private final String modId;

        protected TagAppender(TagBuilder p_236454_, String modId) {
            this.f_126568_ = p_236454_;
            this.modId = modId;
        }

        public final TagAppender<T> m_255204_(ResourceKey<T> p_256138_) {
            this.f_126568_.m_215900_(p_256138_.m_135782_());
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> m_211101_(ResourceKey<T> ... p_211102_) {
            for (ResourceKey<T> resourcekey : p_211102_) {
                this.f_126568_.m_215900_(resourcekey.m_135782_());
            }
            return this;
        }

        public TagAppender<T> m_176839_(ResourceLocation p_176840_) {
            this.f_126568_.m_215905_(p_176840_);
            return this;
        }

        public TagAppender<T> m_206428_(TagKey<T> p_206429_) {
            this.f_126568_.m_215907_(p_206429_.f_203868_());
            return this;
        }

        public TagAppender<T> m_176841_(ResourceLocation p_176842_) {
            this.f_126568_.m_215909_(p_176842_);
            return this;
        }

        public TagAppender<T> add(TagEntry tag) {
            this.f_126568_.m_215902_(tag);
            return this;
        }

        public TagBuilder getInternalBuilder() {
            return this.f_126568_;
        }

        public String getModID() {
            return this.modId;
        }
    }
}

