/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.resource.ResourceCacheManager;
import org.slf4j.Logger;

public class VanillaPackResources
implements PackResources {
    private static final Logger f_10315_ = LogUtils.getLogger();
    private final BuiltInMetadata f_243789_;
    private final Set<String> f_10314_;
    private final List<Path> f_244169_;
    private final Map<PackType, List<Path>> f_244459_;
    private final ResourceCacheManager cacheManager;

    VanillaPackResources(BuiltInMetadata p_249743_, Set<String> p_250468_, List<Path> p_248798_, Map<PackType, List<Path>> p_251106_) {
        this.f_243789_ = p_249743_;
        this.f_10314_ = p_250468_;
        this.f_244169_ = p_248798_;
        this.f_244459_ = p_251106_;
        this.cacheManager = new ResourceCacheManager(false, "indexVanillaPackCachesOnThread", (packType, namespace) -> {
            ArrayList<Path> validPaths = new ArrayList<Path>();
            for (Path basePath : this.f_244459_.getOrDefault(packType, List.of())) {
                Path path = basePath.resolve((String)namespace);
                if (!Files.exists(path, new LinkOption[0]) || !PathPackResources.m_246877_((Path)path)) continue;
                validPaths.add(path);
            }
            return validPaths;
        });
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... p_250530_) {
        FileUtil.m_245411_((String[])p_250530_);
        List<String> list = List.of(p_250530_);
        for (Path path : this.f_244169_) {
            Path path1 = FileUtil.m_245247_((Path)path, list);
            if (!Files.exists(path1, new LinkOption[0]) || !PathPackResources.m_246877_((Path)path1)) continue;
            return IoSupplier.m_246697_((Path)path1);
        }
        return null;
    }

    public void m_245163_(PackType p_252103_, ResourceLocation p_250441_, Consumer<Path> p_251968_) {
        FileUtil.m_245538_((String)p_250441_.m_135815_()).get().ifLeft(p_248238_ -> {
            String s = p_250441_.m_135827_();
            for (Path path : this.f_244459_.get(p_252103_)) {
                Path path1 = path.resolve(s);
                p_251968_.accept(FileUtil.m_245247_((Path)path1, (List)p_248238_));
            }
        }).ifRight(p_248232_ -> f_10315_.error("Invalid path {}: {}", (Object)p_250441_, (Object)p_248232_.message()));
    }

    @Override
    public void m_8031_(PackType p_248974_, String p_248703_, String p_250848_, PackResources.ResourceOutput p_249668_) {
        FileUtil.m_245538_((String)p_250848_).get().ifLeft(p_248228_ -> {
            List<Path> list = this.f_244459_.get(p_248974_);
            int i = list.size();
            if (i == 1) {
                VanillaPackResources.m_246310_(p_249668_, p_248703_, list.get(0), p_248228_);
            } else if (i > 1) {
                HashMap<ResourceLocation, IoSupplier<InputStream>> map = new HashMap<ResourceLocation, IoSupplier<InputStream>>();
                for (int j = 0; j < i - 1; ++j) {
                    VanillaPackResources.m_246310_(map::putIfAbsent, p_248703_, list.get(j), p_248228_);
                }
                Path path = list.get(i - 1);
                if (map.isEmpty()) {
                    VanillaPackResources.m_246310_(p_249668_, p_248703_, path, p_248228_);
                } else {
                    VanillaPackResources.m_246310_(map::putIfAbsent, p_248703_, path, p_248228_);
                    map.forEach(p_249668_);
                }
            }
        }).ifRight(p_248234_ -> f_10315_.error("Invalid path {}: {}", (Object)p_250848_, (Object)p_248234_.message()));
    }

    private static void m_246310_(PackResources.ResourceOutput p_249662_, String p_251249_, Path p_251290_, List<String> p_250451_) {
        Path path = p_251290_.resolve(p_251249_);
        PathPackResources.m_246914_((String)p_251249_, (Path)path, p_250451_, (PackResources.ResourceOutput)p_249662_);
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType p_250512_, ResourceLocation p_251554_) {
        return (IoSupplier)FileUtil.m_245538_((String)p_251554_.m_135815_()).get().map(p_248224_ -> {
            String s = p_251554_.m_135827_();
            for (Path path : this.f_244459_.get(p_250512_)) {
                Path path1 = FileUtil.m_245247_((Path)path.resolve(s), (List)p_248224_);
                if (!Files.exists(path1, new LinkOption[0]) || !PathPackResources.m_246877_((Path)path1)) continue;
                return IoSupplier.m_246697_((Path)path1);
            }
            return null;
        }, p_248230_ -> {
            f_10315_.error("Invalid path {}: {}", (Object)p_251554_, (Object)p_248230_.message());
            return null;
        });
    }

    @Override
    public Set<String> m_5698_(PackType p_10322_) {
        return this.f_10314_;
    }

    @Override
    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> p_10333_) {
        IoSupplier<InputStream> iosupplier = this.m_8017_("pack.mcmeta");
        if (iosupplier != null) {
            try {
                T object;
                block10: {
                    block9: {
                        try (InputStream inputstream = (InputStream)iosupplier.m_247737_();){
                            T t = AbstractPackResources.m_10214_(p_10333_, inputstream);
                            if (t == null) break block9;
                            object = t;
                            break block10;
                        }
                    }
                    return (T)this.f_243789_.m_245920_(p_10333_);
                }
                return object;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return (T)this.f_243789_.m_245920_(p_10333_);
    }

    @Override
    public String m_5542_() {
        return "vanilla";
    }

    @Override
    public boolean m_246538_() {
        return true;
    }

    @Override
    public void close() {
    }

    public ResourceProvider m_215363_() {
        return p_248239_ -> Optional.ofNullable(this.m_214146_(PackType.CLIENT_RESOURCES, p_248239_)).map(p_248221_ -> new Resource((PackResources)this, p_248221_));
    }

    public void initForNamespace(String namespace) {
        if (ResourceCacheManager.shouldUseCache()) {
            this.cacheManager.index(namespace);
        }
    }

    public void init(PackType packType) {
        this.initForNamespace("minecraft");
        this.initForNamespace("realms");
    }
}

