/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.CreativeModeTabSearchRegistry;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class CreativeModeTabRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation CREATIVE_MODE_TAB_ORDERING_JSON = new ResourceLocation("forge", "creative_mode_tab_ordering.json");
    private static final List<CreativeModeTab> SORTED_TABS = new ArrayList<CreativeModeTab>();
    private static final List<CreativeModeTab> SORTED_TABS_VIEW = Collections.unmodifiableList(SORTED_TABS);
    private static final BiMap<ResourceLocation, CreativeModeTab> creativeModeTabs = HashBiMap.create();
    private static final BiMap<ResourceLocation, CreativeModeTab> vanillaCreativeModeTabs = HashBiMap.create();
    private static final Multimap<ResourceLocation, ResourceLocation> edges = HashMultimap.create();
    private static final Multimap<ResourceLocation, ResourceLocation> vanillaEdges = HashMultimap.create();

    public static List<CreativeModeTab> getSortedCreativeModeTabs() {
        return SORTED_TABS_VIEW;
    }

    @Nullable
    public static CreativeModeTab getTab(ResourceLocation name) {
        return (CreativeModeTab)creativeModeTabs.get((Object)name);
    }

    @Nullable
    public static ResourceLocation getName(CreativeModeTab tab) {
        return (ResourceLocation)creativeModeTabs.inverse().get((Object)tab);
    }

    private static void processCreativeModeTab(CreativeModeTab creativeModeTab, ResourceLocation name, List<Object> afterEntries, List<Object> beforeEntries) {
        ResourceLocation other;
        creativeModeTabs.put((Object)name, (Object)creativeModeTab);
        for (Object after : afterEntries) {
            other = CreativeModeTabRegistry.getCreativeModeTabName(after);
            edges.put((Object)other, (Object)name);
        }
        for (Object before : beforeEntries) {
            other = CreativeModeTabRegistry.getCreativeModeTabName(before);
            edges.put((Object)name, (Object)other);
        }
    }

    private static ResourceLocation getCreativeModeTabName(Object entry) {
        if (entry instanceof String) {
            String s = (String)entry;
            return new ResourceLocation(s);
        }
        if (entry instanceof ResourceLocation) {
            ResourceLocation rl = (ResourceLocation)entry;
            return rl;
        }
        if (entry instanceof CreativeModeTab) {
            CreativeModeTab t = (CreativeModeTab)entry;
            return Objects.requireNonNull(CreativeModeTabRegistry.getName(t), "Can't have sorting dependencies for creative mode tabs not registered in the CreativeModeTabSortingRegistry");
        }
        throw new IllegalStateException("Invalid object type passed into the CreativeModeTab dependencies " + entry.getClass());
    }

    static PreparableReloadListener getReloadListener() {
        return new SimplePreparableReloadListener<JsonObject>(){
            final Gson gson = new GsonBuilder().create();

            @NotNull
            protected JsonObject prepare(@NotNull ResourceManager resourceManager, ProfilerFiller profiler) {
                JsonObject jsonObject;
                block9: {
                    Optional res = resourceManager.m_213713_(CREATIVE_MODE_TAB_ORDERING_JSON);
                    if (res.isEmpty()) {
                        return new JsonObject();
                    }
                    BufferedReader reader = ((Resource)res.get()).m_215508_();
                    try {
                        jsonObject = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
                        if (reader == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            LOGGER.error("Could not read CreativeModeTab sorting file " + CREATIVE_MODE_TAB_ORDERING_JSON, (Throwable)e);
                            return new JsonObject();
                        }
                    }
                    ((Reader)reader).close();
                }
                return jsonObject;
            }

            protected void apply(@NotNull JsonObject data, @NotNull ResourceManager resourceManager, ProfilerFiller p) {
                try {
                    if (data.size() > 0) {
                        JsonArray order = GsonHelper.m_13933_((JsonObject)data, (String)"order");
                        ArrayList<CreativeModeTab> customOrder = new ArrayList<CreativeModeTab>();
                        for (JsonElement entry : order) {
                            ResourceLocation id = new ResourceLocation(entry.getAsString());
                            CreativeModeTab CreativeModeTab3 = CreativeModeTabRegistry.getTab(id);
                            if (CreativeModeTab3 == null) {
                                throw new IllegalStateException("CreativeModeTab not found with name " + id);
                            }
                            customOrder.add(CreativeModeTab3);
                        }
                        List<CreativeModeTab> missingCreativeModeTabs = creativeModeTabs.values().stream().filter(CreativeModeTab2 -> !customOrder.contains(CreativeModeTab2)).toList();
                        if (!missingCreativeModeTabs.isEmpty()) {
                            throw new IllegalStateException("CreativeModeTabs missing from the ordered list: " + missingCreativeModeTabs.stream().map(CreativeModeTab2 -> Objects.toString(CreativeModeTabRegistry.getName(CreativeModeTab2))).collect(Collectors.joining(", ")));
                        }
                        CreativeModeTabRegistry.setCreativeModeTabOrder(customOrder);
                        return;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error parsing CreativeModeTab sorting file " + CREATIVE_MODE_TAB_ORDERING_JSON, (Throwable)e);
                }
                CreativeModeTabRegistry.recalculateItemCreativeModeTabs();
            }
        };
    }

    private static void recalculateItemCreativeModeTabs() {
        MutableGraph graph = GraphBuilder.directed().nodeOrder(ElementOrder.insertion()).build();
        for (CreativeModeTab CreativeModeTab2 : creativeModeTabs.values()) {
            graph.addNode((Object)CreativeModeTab2);
        }
        edges.forEach((key, value) -> {
            if (creativeModeTabs.containsKey(key) && creativeModeTabs.containsKey(value)) {
                graph.putEdge((Object)((CreativeModeTab)creativeModeTabs.get(key)), (Object)((CreativeModeTab)creativeModeTabs.get(value)));
            }
        });
        List tierList = TopologicalSort.topologicalSort((Graph)graph, null);
        CreativeModeTabRegistry.setCreativeModeTabOrder(tierList);
    }

    private static void setCreativeModeTabOrder(List<CreativeModeTab> tierList) {
        CreativeModeTabRegistry.runInServerThreadIfPossible(hasServer -> {
            SORTED_TABS.clear();
            SORTED_TABS.addAll(tierList);
        });
    }

    private static void runInServerThreadIfPossible(BooleanConsumer runnable) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.execute(() -> runnable.accept(true));
        } else {
            runnable.accept(false);
        }
    }

    @ApiStatus.Internal
    public static void fireCollectionEvent() {
        edges.clear();
        edges.putAll(vanillaEdges);
        creativeModeTabs.clear();
        creativeModeTabs.putAll(vanillaCreativeModeTabs);
        ModLoader.get().postEvent((Event)new CreativeModeTabEvent.Register(CreativeModeTabRegistry::registerCreativeModeTab));
        CreativeModeTabRegistry.recalculateItemCreativeModeTabs();
        if (FMLEnvironment.dist == Dist.CLIENT && !FMLLoader.getLaunchHandler().isData()) {
            CreativeModeTabSearchRegistry.createSearchTrees();
        }
    }

    @ApiStatus.Internal
    private static CreativeModeTab registerCreativeModeTab(Consumer<CreativeModeTab.Builder> configurator, ResourceLocation name, List<Object> afterEntries, List<Object> beforeEntries) {
        if (creativeModeTabs.containsKey((Object)name)) {
            throw new IllegalStateException("Duplicate creative mode tab with name: " + name);
        }
        CreativeModeTab.Builder builder = new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 0);
        configurator.accept(builder);
        CreativeModeTab creativeModeTab = builder.m_257652_();
        if (creativeModeTab.m_6563_()) {
            throw new IllegalStateException("CreativeModeTab " + name + " is aligned right, this is not supported!");
        }
        CreativeModeTabRegistry.processCreativeModeTab(creativeModeTab, name, afterEntries, beforeEntries);
        return creativeModeTab;
    }

    static {
        ResourceLocation buildingBlocks = new ResourceLocation("building_blocks");
        ResourceLocation coloredBlocks = new ResourceLocation("colored_blocks");
        ResourceLocation naturalBlocks = new ResourceLocation("natural_blocks");
        ResourceLocation functionalBlocks = new ResourceLocation("functional_blocks");
        ResourceLocation redstoneBlocks = new ResourceLocation("redstone_blocks");
        ResourceLocation toolsAndUtilities = new ResourceLocation("tools_and_utilities");
        ResourceLocation combat = new ResourceLocation("combat");
        ResourceLocation foodAndDrinks = new ResourceLocation("food_and_drinks");
        ResourceLocation ingredients = new ResourceLocation("ingredients");
        ResourceLocation spawnEggs = new ResourceLocation("spawn_eggs");
        CreativeModeTabRegistry.processCreativeModeTab(CreativeModeTabs.f_256788_, buildingBlocks, List.of(), List.of());
        CreativeModeTabRegistry.processCreativeModeTab(CreativeModeTabs.f_256725_, coloredBlocks, List.of(buildingBlocks), List.of(naturalBlocks));
        CreativeModeTabRegistry.processCreativeModeTab(CreativeModeTabs.f_256776_, naturalBlocks, List.of(coloredBlocks), List.of(functionalBlocks));
        CreativeModeTabRegistry.processCreativeModeTab(CreativeModeTabs.f_256791_, functionalBlocks, List.of(naturalBlocks), List.of(redstoneBlocks));
        CreativeModeTabRegistry.processCreativeModeTab(CreativeModeTabs.f_257028_, redstoneBlocks, List.of(functionalBlocks), List.of(toolsAndUtilities));
        CreativeModeTabRegistry.processCreativeModeTab(CreativeModeTabs.f_256869_, toolsAndUtilities, List.of(redstoneBlocks), List.of(combat));
        CreativeModeTabRegistry.processCreativeModeTab(CreativeModeTabs.f_256797_, combat, List.of(toolsAndUtilities), List.of(foodAndDrinks));
        CreativeModeTabRegistry.processCreativeModeTab(CreativeModeTabs.f_256839_, foodAndDrinks, List.of(combat), List.of(ingredients));
        CreativeModeTabRegistry.processCreativeModeTab(CreativeModeTabs.f_256968_, ingredients, List.of(foodAndDrinks), List.of(spawnEggs));
        CreativeModeTabRegistry.processCreativeModeTab(CreativeModeTabs.f_256731_, spawnEggs, List.of(ingredients), List.of());
        vanillaEdges.putAll(edges);
        vanillaCreativeModeTabs.putAll(creativeModeTabs);
    }
}

