/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.resource;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@ApiStatus.Internal
public class ResourceCacheManager {
    private static final Marker RESOURCE_CACHE = MarkerFactory.getMarker((String)"RESOURCE-CACHE");
    private static final Joiner SLASH_JOINER = Joiner.on((char)'/');
    private final boolean supportsReloading;
    private final String indexOnThreadConfigurationKey;
    private final BiFunction<PackType, String, List<Path>> pathBuilder;
    private final Map<PackTypeAndNamespace, NamespacedResourceCacheManager> managersByNamespace = Maps.newConcurrentMap();

    @Deprecated(since="1.19.2", forRemoval=true)
    public ResourceCacheManager(boolean supportsReloading, ForgeConfigSpec.BooleanValue indexOffThreadConfig, BiFunction<PackType, String, List<Path>> pathBuilder) {
        this.supportsReloading = supportsReloading;
        this.indexOnThreadConfigurationKey = (String)Iterators.getLast(indexOffThreadConfig.getPath().iterator());
        this.pathBuilder = pathBuilder;
    }

    public ResourceCacheManager(boolean supportsReloading, String indexOnThreadConfigurationKey, BiFunction<PackType, String, List<Path>> pathBuilder) {
        this.supportsReloading = supportsReloading;
        this.indexOnThreadConfigurationKey = indexOnThreadConfigurationKey;
        this.pathBuilder = pathBuilder;
    }

    public static boolean shouldUseCache() {
        return false;
    }

    public boolean shouldIndexOnThread() {
        return ResourceManagerBootCacheConfigurationHandler.getInstance().getConfigValue(this.indexOnThreadConfigurationKey, false);
    }

    @Deprecated(forRemoval=true, since="1.19.2")
    public boolean shouldIndexOffThread() {
        return !this.shouldIndexOnThread();
    }

    public void index(String namespace) {
        for (PackType packType : PackType.values()) {
            PackTypeAndNamespace key = new PackTypeAndNamespace(packType, namespace);
            if (this.managersByNamespace.containsKey(key) && !this.supportsReloading) {
                return;
            }
            NamespacedResourceCacheManager newManager = new NamespacedResourceCacheManager(packType, namespace, this.shouldIndexOnThread(), this.pathBuilder, this::createWalkingStream);
            this.managersByNamespace.put(key, newManager);
            newManager.index();
        }
    }

    private Stream<Path> createWalkingStream(Path path) throws IOException {
        return Files.walk(path, new FileVisitOption[0]).filter(resourcePath -> !resourcePath.toString().endsWith(".mcmeta"));
    }

    public void listResources(PackType type, String resourceNamespace, Path inputPath, BiFunction<PackType, ResourceLocation, IoSupplier<InputStream>> resourceFunction, PackResources.ResourceOutput resourceOutput) {
        PackTypeAndNamespace key = new PackTypeAndNamespace(type, resourceNamespace);
        NamespacedResourceCacheManager manager = this.managersByNamespace.get(key);
        if (manager == null) {
            return;
        }
        manager.listResources(inputPath, loc -> (IoSupplier)resourceFunction.apply(type, (ResourceLocation)loc), resourceOutput);
    }

    public Set<String> getNamespaces(PackType type) {
        return this.managersByNamespace.keySet().stream().filter(key -> key.packType() == type).map(PackTypeAndNamespace::namespace).collect(Collectors.toSet());
    }

    public boolean hasCached(PackType packType, String namespace) {
        PackTypeAndNamespace key = new PackTypeAndNamespace(packType, namespace);
        NamespacedResourceCacheManager manager = this.managersByNamespace.get(key);
        return manager != null && manager.cacheLoaded();
    }

    private static final class ResourceManagerBootCacheConfigurationHandler {
        private static final Logger LOGGER = LogUtils.getLogger();
        private static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("forge-resource-caching.toml");
        private static final ConfigSpec configSpec = new ConfigSpec();
        private static final ResourceManagerBootCacheConfigurationHandler INSTANCE;
        private final CommentedFileConfig configurationHandle = ResourceManagerBootCacheConfigurationHandler.createConfiguration();

        private ResourceManagerBootCacheConfigurationHandler() {
        }

        private static CommentedFileConfig createConfiguration() {
            CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)CONFIG_PATH).sync().onFileNotFound(ResourceManagerBootCacheConfigurationHandler::onConfigFileNotFound).autosave().autoreload().concurrent().writingMode(WritingMode.REPLACE).build();
            try {
                configData.load();
            }
            catch (ParsingException e) {
                throw new RuntimeException("Failed to load Force Resource Cache Configuration from %s".formatted(CONFIG_PATH), e);
            }
            if (!configSpec.isCorrect((Config)configData)) {
                LOGGER.warn("Configuration file {} is not correct. Correcting", (Object)CONFIG_PATH);
                configSpec.correct((Config)configData, (action, path, incorrectValue, correctedValue) -> LOGGER.warn("Incorrect key {} was corrected from {} to {}", new Object[]{path, incorrectValue, correctedValue}));
            }
            configData.save();
            return configData;
        }

        private static boolean onConfigFileNotFound(Path file, ConfigFormat<?> configFormat) throws IOException {
            Files.write(file, (Iterable<? extends CharSequence>)ImmutableList.of((Object)"# This TOML configuration file controls the resource caching system which is used before the mod loading environment starts.", (Object)"# This file is read by the Forge boot loader, and is not used by the game itself.", (Object)"#", (Object)"# Set this to false to disable the resource cache. This will cause the game to scan the resource packs everytime it needs a list of resources.", (Object)"cacheResources=true", (Object)"", (Object)"# Set this to true to force the caching of vanilla resources to happen on the main thread.", (Object)"indexVanillaPackCachesOnThread=false", (Object)"", (Object)"# Set this to true to force the caching of mod resources to happen on the main thread.", (Object)"indexModPackCachesOnThread=false"), StandardOpenOption.CREATE_NEW);
            return true;
        }

        public static ResourceManagerBootCacheConfigurationHandler getInstance() {
            return INSTANCE;
        }

        private boolean getConfigValue(String configKey, boolean defaultValue) {
            return this.configurationHandle.getOptional(configKey).orElse(defaultValue);
        }

        static {
            configSpec.define("cacheResources", (Object)Boolean.TRUE);
            configSpec.define("indexVanillaPackCachesOnThread", (Object)Boolean.FALSE);
            configSpec.define("indexModPackCachesOnThread", (Object)Boolean.FALSE);
            INSTANCE = new ResourceManagerBootCacheConfigurationHandler();
        }
    }

    private record PackTypeAndNamespace(PackType packType, String namespace) {
    }

    private static class NamespacedResourceCacheManager {
        private static final Logger LOGGER = LogUtils.getLogger();
        private final PackType packType;
        private final String namespace;
        private final boolean indexOnThread;
        private final BiFunction<PackType, String, List<Path>> pathBuilder;
        private final PathWalkerFactory pathFinder;
        private final Map<String, List<ResourceCacheEntry>> entriesByPathPrefix = Maps.newConcurrentMap();
        private final AtomicBoolean cacheLoaded = new AtomicBoolean(false);

        private NamespacedResourceCacheManager(PackType packType, String namespace, boolean indexOnThread, BiFunction<PackType, String, List<Path>> pathBuilder, PathWalkerFactory pathFinder) {
            this.packType = packType;
            this.namespace = namespace;
            this.indexOnThread = indexOnThread;
            this.pathBuilder = pathBuilder;
            this.pathFinder = pathFinder;
        }

        public void index() {
            if (this.indexOnThread) {
                this.doIndex();
            } else {
                CompletableFuture.runAsync(this::doIndex, Util.m_183991_());
            }
        }

        private void doIndex() {
            LOGGER.debug(RESOURCE_CACHE, "Indexing resources for pack type {} and namespace {}, on thread: {}", new Object[]{this.packType, this.namespace, Thread.currentThread().getName()});
            List<Path> rootPaths = this.pathBuilder.apply(this.packType, this.namespace);
            rootPaths.forEach(this::doIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doIndex(Path rootPath) {
            try (Stream<Path> paths = this.pathFinder.createWalkingStream(rootPath);){
                ((Stream)paths.parallel()).filter(Predicate.not(rootPath::equals)).map(rootPath::relativize).map(path -> {
                    record PathWithLocationPath(Path path, String locationPath) {
                    }
                    return new PathWithLocationPath((Path)path, SLASH_JOINER.join((Iterable)path));
                }).filter(path -> ResourceLocation.m_135841_((String)path.locationPath())).map(path -> new ResourceCacheEntry(this.packType, this.namespace, path.path(), new ResourceLocation(this.namespace, path.locationPath()))).forEach(this::injectIntoCache);
            }
            catch (NoSuchFileException noSuchFileException) {
                LOGGER.debug(RESOURCE_CACHE, "Failed to cache resources, the directory does not exist!", (Throwable)noSuchFileException);
            }
            catch (IOException ioException) {
                LOGGER.error(RESOURCE_CACHE, "Failed to cache resources, some stuff might be missing!", (Throwable)ioException);
            }
            catch (Exception exception) {
                LOGGER.error(RESOURCE_CACHE, "Failed to cache resources, some stuff might be missing! Unknown exception!", (Throwable)exception);
            }
            finally {
                this.cacheLoaded.set(true);
            }
        }

        private void injectIntoCache(ResourceCacheEntry entry) {
            this.injectIntoCache(entry.path().getParent(), entry);
        }

        private void injectIntoCache(@Nullable Path parentPath, ResourceCacheEntry entry) {
            String pathEntry = parentPath == null ? "" : Joiner.on((String)"/").join((Iterable)parentPath);
            this.entriesByPathPrefix.computeIfAbsent(pathEntry, e -> new CopyOnWriteArrayList()).add(entry);
            if (parentPath != null && !pathEntry.isEmpty()) {
                this.injectIntoCache(parentPath.getParent(), entry);
            }
        }

        public void listResources(Path inputPath, Function<ResourceLocation, IoSupplier<InputStream>> resourceFunction, PackResources.ResourceOutput resourceOutput) {
            if (!this.cacheLoaded()) {
                return;
            }
            String pathEntry = SLASH_JOINER.join((Iterable)inputPath);
            List<ResourceCacheEntry> entries = this.entriesByPathPrefix.get(pathEntry);
            if (entries == null) {
                return;
            }
            entries.forEach(cacheEntry -> resourceOutput.accept((Object)cacheEntry.resourceLocation(), (Object)((IoSupplier)resourceFunction.apply(cacheEntry.resourceLocation()))));
        }

        public boolean cacheLoaded() {
            return this.cacheLoaded.get();
        }
    }

    @FunctionalInterface
    private static interface PathWalkerFactory {
        public Stream<Path> createWalkingStream(Path var1) throws IOException;
    }

    private record ResourceCacheEntry(PackType packType, String namespace, Path path, ResourceLocation resourceLocation) {
    }
}

