/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class LootTableProvider
implements DataProvider {
    private static final Logger f_124431_ = LogUtils.getLogger();
    private final PackOutput.PathProvider f_236267_;
    private final Set<ResourceLocation> f_243940_;
    private final List<SubProviderEntry> f_124434_;

    public LootTableProvider(PackOutput p_254123_, Set<ResourceLocation> p_254481_, List<SubProviderEntry> p_253798_) {
        this.f_236267_ = p_254123_.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables");
        this.f_124434_ = p_253798_;
        this.f_243940_ = p_254481_;
    }

    public CompletableFuture<?> m_213708_(CachedOutput p_254060_) {
        HashMap map = Maps.newHashMap();
        this.getTables().forEach(p_248012_ -> p_248012_.f_243941_().get().m_245126_((p_248006_, p_248007_) -> {
            if (map.put(p_248006_, p_248007_.m_79165_(p_248005_.f_244144_).m_79167_()) != null) {
                throw new IllegalStateException("Duplicate loot table " + p_248006_);
            }
        }));
        ValidationContext validationcontext = new ValidationContext(LootContextParamSets.f_81420_, p_124465_ -> null, map::get);
        this.validate(map, validationcontext);
        Multimap multimap = validationcontext.m_79352_();
        if (!multimap.isEmpty()) {
            multimap.forEach((p_124446_, p_124447_) -> f_124431_.warn("Found validation problem in {}: {}", p_124446_, p_124447_));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(p_253405_ -> {
            ResourceLocation resourcelocation1 = (ResourceLocation)p_253405_.getKey();
            LootTable loottable = (LootTable)p_253405_.getValue();
            Path path = this.f_236267_.m_245731_(resourcelocation1);
            return DataProvider.m_253162_((CachedOutput)p_254060_, (JsonElement)LootTables.m_79200_(loottable), (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    public List<SubProviderEntry> getTables() {
        return this.f_124434_;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationcontext) {
        for (ResourceLocation resourcelocation : Sets.difference(this.f_243940_, map.keySet())) {
            validationcontext.m_79357_("Missing built-in table: " + resourcelocation);
        }
        map.forEach((p_124441_, p_124442_) -> LootTables.m_79202_(validationcontext, p_124441_, p_124442_));
    }

    public final String m_6055_() {
        return "Loot Tables";
    }

    public record SubProviderEntry(Supplier<LootTableSubProvider> f_243941_, LootContextParamSet f_244144_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SubProviderEntry.class, "provider;paramSet", "f_243941_", "f_244144_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SubProviderEntry.class, "provider;paramSet", "f_243941_", "f_244144_"}, this);
        }

        @Override
        public final boolean equals(Object p_249337_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SubProviderEntry.class, "provider;paramSet", "f_243941_", "f_244144_"}, this, p_249337_);
        }
    }
}

