/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ShearsItem
extends Item {
    public ShearsItem(Item.Properties p_43074_) {
        super(p_43074_);
    }

    @Override
    public boolean m_6813_(ItemStack p_43078_, Level p_43079_, BlockState p_43080_, BlockPos p_43081_, LivingEntity p_43082_) {
        if (!p_43079_.f_46443_ && !p_43080_.m_204336_(BlockTags.f_13076_)) {
            p_43078_.m_41622_(1, p_43082_, p_43076_ -> p_43076_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return !p_43080_.m_204336_(BlockTags.f_13035_) && !p_43080_.m_60713_(Blocks.f_50033_) && !p_43080_.m_60713_(Blocks.f_50034_) && !p_43080_.m_60713_(Blocks.f_50035_) && !p_43080_.m_60713_(Blocks.f_50036_) && !p_43080_.m_60713_(Blocks.f_152548_) && !p_43080_.m_60713_(Blocks.f_50191_) && !p_43080_.m_60713_(Blocks.f_50267_) && !p_43080_.m_204336_(BlockTags.f_13089_) ? super.m_6813_(p_43078_, p_43079_, p_43080_, p_43081_, p_43082_) : true;
    }

    @Override
    public boolean m_8096_(BlockState p_43087_) {
        return p_43087_.m_60713_(Blocks.f_50033_) || p_43087_.m_60713_(Blocks.f_50088_) || p_43087_.m_60713_(Blocks.f_50267_);
    }

    @Override
    public float m_8102_(ItemStack p_43084_, BlockState p_43085_) {
        if (!p_43085_.m_60713_(Blocks.f_50033_) && !p_43085_.m_204336_(BlockTags.f_13035_)) {
            if (p_43085_.m_204336_(BlockTags.f_13089_)) {
                return 5.0f;
            }
            return !p_43085_.m_60713_(Blocks.f_50191_) && !p_43085_.m_60713_(Blocks.f_152475_) ? super.m_8102_(p_43084_, p_43085_) : 2.0f;
        }
        return 15.0f;
    }

    @Override
    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof IForgeShearable) {
            IForgeShearable target = (IForgeShearable)entity;
            if (entity.f_19853_.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockPos pos = BlockPos.m_274446_((Position)entity.m_20182_());
            if (target.isShearable(stack, entity.f_19853_, pos)) {
                List drops = target.onSheared(playerIn, stack, entity.f_19853_, pos, EnchantmentHelper.m_44843_(Enchantments.f_44987_, stack));
                Random rand = new Random();
                drops.forEach(d -> {
                    ItemEntity ent = entity.m_5552_((ItemStack)((Object)d), 1.0f);
                    ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                });
                stack.m_41622_(1, playerIn, e -> e.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHEARS_ACTIONS.contains(toolAction);
    }

    @Override
    public InteractionResult m_6225_(UseOnContext p_186371_) {
        GrowingPlantHeadBlock growingplantheadblock;
        BlockPos blockpos;
        Level level = p_186371_.m_43725_();
        BlockState blockstate = level.m_8055_(blockpos = p_186371_.m_8083_());
        Block block = blockstate.m_60734_();
        if (block instanceof GrowingPlantHeadBlock && !(growingplantheadblock = (GrowingPlantHeadBlock)((Object)block)).m_187440_(blockstate)) {
            Player player = p_186371_.m_43723_();
            ItemStack itemstack = p_186371_.m_43722_();
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)player, blockpos, itemstack);
            }
            level.m_5594_(player, blockpos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState blockstate1 = growingplantheadblock.m_187438_(blockstate);
            level.m_46597_(blockpos, blockstate1);
            level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)p_186371_.m_43723_(), (BlockState)blockstate1));
            if (player != null) {
                itemstack.m_41622_(1, player, p_186374_ -> p_186374_.m_21190_(p_186371_.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6225_(p_186371_);
    }
}

