/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CombatTracker {
    public static final int f_146694_ = 100;
    public static final int f_146695_ = 300;
    private static final Style f_268553_ = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://bugs.mojang.com/browse/MCPE-28723")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, Component.m_237113_("MCPE-28723")));
    private final List<CombatEntry> f_19276_ = Lists.newArrayList();
    private final LivingEntity f_19277_;
    private int f_19278_;
    private int f_19279_;
    private int f_19280_;
    private boolean f_19281_;
    private boolean f_19282_;
    @Nullable
    private String f_19283_;

    public CombatTracker(LivingEntity p_19285_) {
        this.f_19277_ = p_19285_;
    }

    public void m_19286_() {
        this.m_19299_();
        Optional<BlockPos> $$0 = this.f_19277_.m_21227_();
        if ($$0.isPresent()) {
            BlockState $$1 = this.f_19277_.f_19853_.m_8055_($$0.get());
            this.f_19283_ = $$1.m_60713_(Blocks.f_50155_) || $$1.m_204336_(BlockTags.f_13036_) ? "ladder" : ($$1.m_60713_(Blocks.f_50191_) ? "vines" : ($$1.m_60713_(Blocks.f_50702_) || $$1.m_60713_(Blocks.f_50703_) ? "weeping_vines" : ($$1.m_60713_(Blocks.f_50704_) || $$1.m_60713_(Blocks.f_50653_) ? "twisting_vines" : ($$1.m_60713_(Blocks.f_50616_) ? "scaffolding" : "other_climbable"))));
        } else if (this.f_19277_.m_20069_()) {
            this.f_19283_ = "water";
        }
    }

    public void m_19289_(DamageSource p_19290_, float p_19291_, float p_19292_) {
        this.m_19296_();
        this.m_19286_();
        CombatEntry $$3 = new CombatEntry(p_19290_, this.f_19277_.f_19797_, p_19291_, p_19292_, this.f_19283_, this.f_19277_.f_19789_);
        this.f_19276_.add($$3);
        this.f_19278_ = this.f_19277_.f_19797_;
        this.f_19282_ = true;
        if ($$3.m_19265_() && !this.f_19281_ && this.f_19277_.m_6084_()) {
            this.f_19281_ = true;
            this.f_19280_ = this.f_19279_ = this.f_19277_.f_19797_;
            this.f_19277_.m_8108_();
        }
    }

    public Component m_19293_() {
        Component $$21;
        if (this.f_19276_.isEmpty()) {
            return Component.m_237110_("death.attack.generic", this.f_19277_.m_5446_());
        }
        CombatEntry $$0 = this.m_19298_();
        CombatEntry $$1 = this.f_19276_.get(this.f_19276_.size() - 1);
        Component $$2 = $$1.m_19267_();
        DamageSource $$3 = $$1.m_19263_();
        Entity $$4 = $$3.m_7639_();
        DeathMessageType $$5 = $$3.m_269415_().f_268472_();
        if ($$0 != null && $$5 == DeathMessageType.FALL_VARIANTS) {
            Component $$6 = $$0.m_19267_();
            DamageSource $$7 = $$0.m_19263_();
            if ($$7.m_269533_(DamageTypeTags.f_268549_) || $$7.m_269533_(DamageTypeTags.f_268518_)) {
                MutableComponent $$8 = Component.m_237110_("death.fell.accident." + this.m_19287_($$0), this.f_19277_.m_5446_());
            } else if ($$6 != null && !$$6.equals($$2)) {
                ItemStack $$11;
                Entity $$9 = $$7.m_7639_();
                if ($$9 instanceof LivingEntity) {
                    LivingEntity $$10 = (LivingEntity)$$9;
                    v0 = $$10.m_21205_();
                } else {
                    v0 = $$11 = ItemStack.f_41583_;
                }
                if (!$$11.m_41619_() && $$11.m_41788_()) {
                    MutableComponent $$12 = Component.m_237110_("death.fell.assist.item", this.f_19277_.m_5446_(), $$6, $$11.m_41611_());
                } else {
                    MutableComponent $$13 = Component.m_237110_("death.fell.assist", this.f_19277_.m_5446_(), $$6);
                }
            } else if ($$2 != null) {
                ItemStack $$15;
                if ($$4 instanceof LivingEntity) {
                    LivingEntity $$14 = (LivingEntity)$$4;
                    v1 = $$14.m_21205_();
                } else {
                    v1 = $$15 = ItemStack.f_41583_;
                }
                if (!$$15.m_41619_() && $$15.m_41788_()) {
                    MutableComponent $$16 = Component.m_237110_("death.fell.finish.item", this.f_19277_.m_5446_(), $$2, $$15.m_41611_());
                } else {
                    MutableComponent $$17 = Component.m_237110_("death.fell.finish", this.f_19277_.m_5446_(), $$2);
                }
            } else {
                MutableComponent $$18 = Component.m_237110_("death.fell.killer", this.f_19277_.m_5446_());
            }
        } else {
            if ($$5 == DeathMessageType.INTENTIONAL_GAME_DESIGN) {
                String $$19 = "death.attack." + $$3.m_19385_();
                MutableComponent $$20 = ComponentUtils.m_130748_(Component.m_237115_($$19 + ".link")).m_130948_(f_268553_);
                return Component.m_237110_($$19 + ".message", this.f_19277_.m_5446_(), $$20);
            }
            $$21 = $$3.m_6157_(this.f_19277_);
        }
        return $$21;
    }

    @Nullable
    public LivingEntity m_19294_() {
        LivingEntity $$0 = null;
        Player $$1 = null;
        float $$2 = 0.0f;
        float $$3 = 0.0f;
        for (CombatEntry $$4 : this.f_19276_) {
            Entity entity = $$4.m_19263_().m_7639_();
            if (entity instanceof Player) {
                Player $$5 = (Player)entity;
                if ($$1 == null || $$4.m_19264_() > $$3) {
                    $$3 = $$4.m_19264_();
                    $$1 = $$5;
                }
            }
            if (!((entity = $$4.m_19263_().m_7639_()) instanceof LivingEntity)) continue;
            LivingEntity $$6 = (LivingEntity)entity;
            if ($$0 != null && !($$4.m_19264_() > $$2)) continue;
            $$2 = $$4.m_19264_();
            $$0 = $$6;
        }
        if ($$1 != null && $$3 >= $$2 / 3.0f) {
            return $$1;
        }
        return $$0;
    }

    @Nullable
    private CombatEntry m_19298_() {
        CombatEntry $$0 = null;
        CombatEntry $$1 = null;
        float $$2 = 0.0f;
        float $$3 = 0.0f;
        for (int $$4 = 0; $$4 < this.f_19276_.size(); ++$$4) {
            float $$9;
            CombatEntry $$5 = this.f_19276_.get($$4);
            CombatEntry $$6 = $$4 > 0 ? this.f_19276_.get($$4 - 1) : null;
            DamageSource $$7 = $$5.m_19263_();
            boolean $$8 = $$7.m_269533_(DamageTypeTags.f_268518_);
            float f = $$9 = $$8 ? Float.MAX_VALUE : $$5.m_19268_();
            if (($$7.m_269533_(DamageTypeTags.f_268549_) || $$8) && $$9 > 0.0f && ($$0 == null || $$9 > $$3)) {
                $$0 = $$4 > 0 ? $$6 : $$5;
                $$3 = $$9;
            }
            if ($$5.m_19266_() == null || $$1 != null && !($$5.m_19264_() > $$2)) continue;
            $$1 = $$5;
            $$2 = $$5.m_19264_();
        }
        if ($$3 > 5.0f && $$0 != null) {
            return $$0;
        }
        if ($$2 > 5.0f && $$1 != null) {
            return $$1;
        }
        return null;
    }

    private String m_19287_(CombatEntry p_19288_) {
        return p_19288_.m_19266_() == null ? "generic" : p_19288_.m_19266_();
    }

    public boolean m_146696_() {
        this.m_19296_();
        return this.f_19282_;
    }

    public boolean m_146697_() {
        this.m_19296_();
        return this.f_19281_;
    }

    public int m_19295_() {
        if (this.f_19281_) {
            return this.f_19277_.f_19797_ - this.f_19279_;
        }
        return this.f_19280_ - this.f_19279_;
    }

    private void m_19299_() {
        this.f_19283_ = null;
    }

    public void m_19296_() {
        int $$0;
        int n = $$0 = this.f_19281_ ? 300 : 100;
        if (this.f_19282_ && (!this.f_19277_.m_6084_() || this.f_19277_.f_19797_ - this.f_19278_ > $$0)) {
            boolean $$1 = this.f_19281_;
            this.f_19282_ = false;
            this.f_19281_ = false;
            this.f_19280_ = this.f_19277_.f_19797_;
            if ($$1) {
                this.f_19277_.m_8098_();
            }
            this.f_19276_.clear();
        }
    }

    public LivingEntity m_19297_() {
        return this.f_19277_;
    }

    @Nullable
    public CombatEntry m_146698_() {
        if (this.f_19276_.isEmpty()) {
            return null;
        }
        return this.f_19276_.get(this.f_19276_.size() - 1);
    }

    public int m_146699_() {
        LivingEntity $$0 = this.m_19294_();
        return $$0 == null ? -1 : $$0.m_19879_();
    }
}

