/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.time.Instant;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SignatureValidator;

public record ProfilePublicKey(Data f_219781_) {
    public static final Codec<ProfilePublicKey> f_219780_ = Data.f_219798_.comapFlatMap(p_219793_ -> {
        try {
            return DataResult.success((Object)ProfilePublicKey.m_219789_(p_219793_));
        }
        catch (CryptException $$1) {
            return DataResult.error((String)"Malformed public key");
        }
    }, ProfilePublicKey::f_219781_);

    public static ProfilePublicKey m_219789_(Data p_219790_) throws CryptException {
        return new ProfilePublicKey(p_219790_);
    }

    public static ProfilePublicKey m_219786_(SignatureValidator p_219787_, Data p_219788_) throws InsecurePublicKeyException, CryptException {
        if (p_219788_.m_219810_()) {
            throw new InsecurePublicKeyException.InvalidException("Expired profile public key");
        }
        if (!p_219788_.m_219811_(p_219787_)) {
            throw new InsecurePublicKeyException.InvalidException("Invalid profile public key signature");
        }
        return ProfilePublicKey.m_219789_(p_219788_);
    }

    public SignatureValidator m_219785_() {
        return SignatureValidator.m_216369_(this.f_219781_.f_219800_, "SHA256withRSA");
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ProfilePublicKey.class, "data", "f_219781_"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ProfilePublicKey.class, "data", "f_219781_"}, this);
    }

    @Override
    public final boolean equals(Object p_219795_) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ProfilePublicKey.class, "data", "f_219781_"}, this, p_219795_);
    }

    public record Data(Instant f_219799_, PublicKey f_219800_, byte[] f_219801_) {
        private static final int f_219802_ = 4096;
        public static final Codec<Data> f_219798_ = RecordCodecBuilder.create(p_219814_ -> p_219814_.group((App)ExtraCodecs.f_216159_.fieldOf("expires_at").forGetter(Data::f_219799_), (App)Crypt.f_216063_.fieldOf("key").forGetter(Data::f_219800_), (App)ExtraCodecs.f_216160_.fieldOf("signature").forGetter(Data::f_219801_)).apply((Applicative)p_219814_, Data::new));

        public Data(FriendlyByteBuf p_219809_) {
            this(p_219809_.m_236873_(), p_219809_.m_236874_(), p_219809_.m_130101_(4096));
        }

        public void m_219815_(FriendlyByteBuf p_219816_) {
            p_219816_.m_236826_(this.f_219799_);
            p_219816_.m_236824_(this.f_219800_);
            p_219816_.m_130087_(this.f_219801_);
        }

        boolean m_219811_(SignatureValidator p_219812_) {
            return p_219812_.m_216375_(this.m_219820_().getBytes(StandardCharsets.US_ASCII), this.f_219801_);
        }

        private String m_219820_() {
            String $$0 = Crypt.m_216078_(this.f_219800_);
            return this.f_219799_.toEpochMilli() + $$0;
        }

        public boolean m_219810_() {
            return this.f_219799_.isBefore(Instant.now());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Data.class, "expiresAt;key;keySignature", "f_219799_", "f_219800_", "f_219801_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Data.class, "expiresAt;key;keySignature", "f_219799_", "f_219800_", "f_219801_"}, this);
        }

        @Override
        public final boolean equals(Object p_219822_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Data.class, "expiresAt;key;keySignature", "f_219799_", "f_219800_", "f_219801_"}, this, p_219822_);
        }
    }
}

