/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public class RenderGameOverlayEvent
extends Event {
    private final PoseStack poseStack;
    private final float partialTick;
    private final Window window;
    private final ElementType type;

    public PoseStack getPoseStack() {
        return this.poseStack;
    }

    public float getPartialTick() {
        return this.partialTick;
    }

    public Window getWindow() {
        return this.window;
    }

    public ElementType getType() {
        return this.type;
    }

    public RenderGameOverlayEvent(PoseStack poseStack, float partialTick, Window window) {
        this.poseStack = poseStack;
        this.partialTick = partialTick;
        this.window = window;
        this.type = null;
    }

    private RenderGameOverlayEvent(PoseStack poseStack, RenderGameOverlayEvent parent, ElementType type) {
        this.poseStack = poseStack;
        this.partialTick = parent.getPartialTick();
        this.window = parent.getWindow();
        this.type = type;
    }

    public static enum ElementType {
        ALL,
        LAYER,
        BOSSINFO,
        TEXT,
        CHAT,
        PLAYER_LIST,
        DEBUG;

    }

    public static class Chat
    extends Pre {
        private int posX;
        private int posY;

        public Chat(PoseStack mStack, RenderGameOverlayEvent parent, int posX, int posY) {
            super(mStack, parent, ElementType.CHAT);
            this.setPosX(posX);
            this.setPosY(posY);
        }

        public int getPosX() {
            return this.posX;
        }

        public void setPosX(int posX) {
            this.posX = posX;
        }

        public int getPosY() {
            return this.posY;
        }

        public void setPosY(int posY) {
            this.posY = posY;
        }
    }

    public static class Text
    extends Pre {
        private final ArrayList<String> left;
        private final ArrayList<String> right;

        public Text(PoseStack mStack, RenderGameOverlayEvent parent, ArrayList<String> left, ArrayList<String> right) {
            super(mStack, parent, ElementType.TEXT);
            this.left = left;
            this.right = right;
        }

        public ArrayList<String> getLeft() {
            return this.left;
        }

        public ArrayList<String> getRight() {
            return this.right;
        }
    }

    public static class BossInfo
    extends Pre {
        private final LerpingBossEvent bossEvent;
        private final int x;
        private final int y;
        private int increment;

        public BossInfo(PoseStack mStack, RenderGameOverlayEvent parent, ElementType type, LerpingBossEvent bossEvent, int x, int y, int increment) {
            super(mStack, parent, type);
            this.bossEvent = bossEvent;
            this.x = x;
            this.y = y;
            this.increment = increment;
        }

        public LerpingBossEvent getBossEvent() {
            return this.bossEvent;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getIncrement() {
            return this.increment;
        }

        public void setIncrement(int increment) {
            this.increment = increment;
        }
    }

    public static class PostLayer
    extends Post {
        private final IIngameOverlay overlay;

        public PostLayer(PoseStack mStack, RenderGameOverlayEvent parent, IIngameOverlay overlay) {
            super(mStack, parent, ElementType.LAYER);
            this.overlay = overlay;
        }

        public IIngameOverlay getOverlay() {
            return this.overlay;
        }
    }

    public static class PreLayer
    extends Pre {
        private final IIngameOverlay overlay;

        public PreLayer(PoseStack mStack, RenderGameOverlayEvent parent, IIngameOverlay overlay) {
            super(mStack, parent, ElementType.LAYER);
            this.overlay = overlay;
        }

        public IIngameOverlay getOverlay() {
            return this.overlay;
        }
    }

    public static class Post
    extends RenderGameOverlayEvent {
        public Post(PoseStack poseStack, RenderGameOverlayEvent parent, ElementType type) {
            super(poseStack, parent, type);
        }

        public boolean isCancelable() {
            return false;
        }
    }

    public static class Pre
    extends RenderGameOverlayEvent {
        public Pre(PoseStack poseStack, RenderGameOverlayEvent parent, ElementType type) {
            super(poseStack, parent, type);
        }
    }
}

