/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class ScreenEvent
extends Event {
    private final Screen screen;

    public ScreenEvent(Screen screen) {
        this.screen = Objects.requireNonNull(screen);
    }

    public Screen getScreen() {
        return this.screen;
    }

    public static class KeyboardCharTypedEvent
    extends ScreenEvent {
        private final char codePoint;
        private final int modifiers;

        public KeyboardCharTypedEvent(Screen screen, char codePoint, int modifiers) {
            super(screen);
            this.codePoint = codePoint;
            this.modifiers = modifiers;
        }

        public char getCodePoint() {
            return this.codePoint;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        @Cancelable
        public static class Post
        extends KeyboardCharTypedEvent {
            public Post(Screen screen, char codePoint, int modifiers) {
                super(screen, codePoint, modifiers);
            }
        }

        @Cancelable
        public static class Pre
        extends KeyboardCharTypedEvent {
            public Pre(Screen screen, char codePoint, int modifiers) {
                super(screen, codePoint, modifiers);
            }
        }
    }

    public static abstract class KeyboardKeyReleasedEvent
    extends KeyboardKeyEvent {
        public KeyboardKeyReleasedEvent(Screen screen, int keyCode, int scanCode, int modifiers) {
            super(screen, keyCode, scanCode, modifiers);
        }

        @Cancelable
        public static class Post
        extends KeyboardKeyReleasedEvent {
            public Post(Screen screen, int keyCode, int scanCode, int modifiers) {
                super(screen, keyCode, scanCode, modifiers);
            }
        }

        @Cancelable
        public static class Pre
        extends KeyboardKeyReleasedEvent {
            public Pre(Screen screen, int keyCode, int scanCode, int modifiers) {
                super(screen, keyCode, scanCode, modifiers);
            }
        }
    }

    public static abstract class KeyboardKeyPressedEvent
    extends KeyboardKeyEvent {
        public KeyboardKeyPressedEvent(Screen screen, int keyCode, int scanCode, int modifiers) {
            super(screen, keyCode, scanCode, modifiers);
        }

        @Cancelable
        public static class Post
        extends KeyboardKeyPressedEvent {
            public Post(Screen screen, int keyCode, int scanCode, int modifiers) {
                super(screen, keyCode, scanCode, modifiers);
            }
        }

        @Cancelable
        public static class Pre
        extends KeyboardKeyPressedEvent {
            public Pre(Screen screen, int keyCode, int scanCode, int modifiers) {
                super(screen, keyCode, scanCode, modifiers);
            }
        }
    }

    public static abstract class KeyboardKeyEvent
    extends ScreenEvent {
        private final int keyCode;
        private final int scanCode;
        private final int modifiers;

        public KeyboardKeyEvent(Screen screen, int keyCode, int scanCode, int modifiers) {
            super(screen);
            this.keyCode = keyCode;
            this.scanCode = scanCode;
            this.modifiers = modifiers;
        }

        public int getKeyCode() {
            return this.keyCode;
        }

        public int getScanCode() {
            return this.scanCode;
        }

        public int getModifiers() {
            return this.modifiers;
        }
    }

    public static abstract class MouseScrollEvent
    extends MouseInputEvent {
        private final double scrollDelta;

        public MouseScrollEvent(Screen screen, double mouseX, double mouseY, double scrollDelta) {
            super(screen, mouseX, mouseY);
            this.scrollDelta = scrollDelta;
        }

        public double getScrollDelta() {
            return this.scrollDelta;
        }

        @Cancelable
        public static class Post
        extends MouseScrollEvent {
            public Post(Screen screen, double mouseX, double mouseY, double scrollDelta) {
                super(screen, mouseX, mouseY, scrollDelta);
            }
        }

        @Cancelable
        public static class Pre
        extends MouseScrollEvent {
            public Pre(Screen screen, double mouseX, double mouseY, double scrollDelta) {
                super(screen, mouseX, mouseY, scrollDelta);
            }
        }
    }

    public static abstract class MouseDragEvent
    extends MouseInputEvent {
        private final int mouseButton;
        private final double dragX;
        private final double dragY;

        public MouseDragEvent(Screen screen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
            super(screen, mouseX, mouseY);
            this.mouseButton = mouseButton;
            this.dragX = dragX;
            this.dragY = dragY;
        }

        public int getMouseButton() {
            return this.mouseButton;
        }

        public double getDragX() {
            return this.dragX;
        }

        public double getDragY() {
            return this.dragY;
        }

        @Cancelable
        public static class Post
        extends MouseDragEvent {
            public Post(Screen screen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
                super(screen, mouseX, mouseY, mouseButton, dragX, dragY);
            }
        }

        @Cancelable
        public static class Pre
        extends MouseDragEvent {
            public Pre(Screen screen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
                super(screen, mouseX, mouseY, mouseButton, dragX, dragY);
            }
        }
    }

    public static abstract class MouseReleasedEvent
    extends MouseInputEvent {
        private final int button;

        public MouseReleasedEvent(Screen screen, double mouseX, double mouseY, int button) {
            super(screen, mouseX, mouseY);
            this.button = button;
        }

        public int getButton() {
            return this.button;
        }

        @Event.HasResult
        public static class Post
        extends MouseReleasedEvent {
            private final boolean handled;

            public Post(Screen screen, double mouseX, double mouseY, int button, boolean handled) {
                super(screen, mouseX, mouseY, button);
                this.handled = handled;
            }

            public boolean wasHandled() {
                return this.handled;
            }
        }

        @Cancelable
        public static class Pre
        extends MouseReleasedEvent {
            public Pre(Screen screen, double mouseX, double mouseY, int button) {
                super(screen, mouseX, mouseY, button);
            }
        }
    }

    public static abstract class MouseClickedEvent
    extends MouseInputEvent {
        private final int button;

        public MouseClickedEvent(Screen screen, double mouseX, double mouseY, int button) {
            super(screen, mouseX, mouseY);
            this.button = button;
        }

        public int getButton() {
            return this.button;
        }

        @Event.HasResult
        public static class Post
        extends MouseClickedEvent {
            private final boolean handled;

            public Post(Screen screen, double mouseX, double mouseY, int button, boolean handled) {
                super(screen, mouseX, mouseY, button);
                this.handled = handled;
            }

            public boolean wasHandled() {
                return this.handled;
            }
        }

        @Cancelable
        public static class Pre
        extends MouseClickedEvent {
            public Pre(Screen screen, double mouseX, double mouseY, int button) {
                super(screen, mouseX, mouseY, button);
            }
        }
    }

    public static abstract class MouseInputEvent
    extends ScreenEvent {
        private final double mouseX;
        private final double mouseY;

        public MouseInputEvent(Screen screen, double mouseX, double mouseY) {
            super(screen);
            this.mouseX = mouseX;
            this.mouseY = mouseY;
        }

        public double getMouseX() {
            return this.mouseX;
        }

        public double getMouseY() {
            return this.mouseY;
        }
    }

    @Event.HasResult
    public static class PotionSizeEvent
    extends ScreenEvent {
        public PotionSizeEvent(Screen screen) {
            super(screen);
        }
    }

    public static class BackgroundDrawnEvent
    extends ScreenEvent {
        private final PoseStack poseStack;

        public BackgroundDrawnEvent(Screen screen, PoseStack poseStack) {
            super(screen);
            this.poseStack = poseStack;
        }

        public PoseStack getPoseStack() {
            return this.poseStack;
        }
    }

    public static class DrawScreenEvent
    extends ScreenEvent {
        private final PoseStack poseStack;
        private final int mouseX;
        private final int mouseY;
        private final float partialTick;

        public DrawScreenEvent(Screen screen, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super(screen);
            this.poseStack = poseStack;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.partialTick = partialTick;
        }

        public PoseStack getPoseStack() {
            return this.poseStack;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }

        public float getPartialTick() {
            return this.partialTick;
        }

        public static class Post
        extends DrawScreenEvent {
            public Post(Screen screen, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
                super(screen, poseStack, mouseX, mouseY, partialTick);
            }
        }

        @Cancelable
        public static class Pre
        extends DrawScreenEvent {
            public Pre(Screen screen, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
                super(screen, poseStack, mouseX, mouseY, partialTick);
            }
        }
    }

    public static class InitScreenEvent
    extends ScreenEvent {
        private final Consumer<GuiEventListener> add;
        private final Consumer<GuiEventListener> remove;
        private final List<GuiEventListener> listenerList;

        public InitScreenEvent(Screen screen, List<GuiEventListener> listenerList, Consumer<GuiEventListener> add, Consumer<GuiEventListener> remove) {
            super(screen);
            this.listenerList = Collections.unmodifiableList(listenerList);
            this.add = add;
            this.remove = remove;
        }

        public List<GuiEventListener> getListenersList() {
            return this.listenerList;
        }

        public void addListener(GuiEventListener listener) {
            this.add.accept(listener);
        }

        public void removeListener(GuiEventListener listener) {
            this.remove.accept(listener);
        }

        public static class Post
        extends InitScreenEvent {
            public Post(Screen screen, List<GuiEventListener> list, Consumer<GuiEventListener> add, Consumer<GuiEventListener> remove) {
                super(screen, list, add, remove);
            }
        }

        @Cancelable
        public static class Pre
        extends InitScreenEvent {
            public Pre(Screen screen, List<GuiEventListener> list, Consumer<GuiEventListener> add, Consumer<GuiEventListener> remove) {
                super(screen, list, add, remove);
            }
        }
    }
}

