/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.client.RenderProperties;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ForgeIngameGui
extends Gui {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int WHITE = 0xFFFFFF;
    public static double rayTraceDistance = 20.0;
    public int left_height = 39;
    public int right_height = 39;
    private Font font = null;
    private RenderGameOverlayEvent eventParent;
    private ForgeDebugScreenOverlay debugOverlay;
    public static final IIngameOverlay VIGNETTE_ELEMENT = OverlayRegistry.registerOverlayTop("Vignette", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        if (Minecraft.m_91405_()) {
            gui.setupOverlayRenderState(true, false);
            gui.m_93067_(gui.f_92986_.m_91288_());
        }
    });
    public static final IIngameOverlay SPYGLASS_ELEMENT = OverlayRegistry.registerOverlayTop("Spyglass", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        gui.setupOverlayRenderState(true, false);
        gui.renderSpyglassOverlay();
    });
    public static final IIngameOverlay HELMET_ELEMENT = OverlayRegistry.registerOverlayTop("Helmet", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        gui.setupOverlayRenderState(true, false);
        gui.renderHelmet(partialTick, poseStack);
    });
    public static final IIngameOverlay FROSTBITE_ELEMENT = OverlayRegistry.registerOverlayTop("Frostbite", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        gui.setupOverlayRenderState(true, false);
        gui.renderFrostbite(poseStack);
    });
    public static final IIngameOverlay PORTAL_ELEMENT = OverlayRegistry.registerOverlayTop("Portal", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        if (!gui.f_92986_.f_91074_.m_21023_(MobEffects.f_19604_)) {
            gui.setupOverlayRenderState(true, false);
            gui.m_93007_(partialTick);
        }
    });
    public static final IIngameOverlay HOTBAR_ELEMENT = OverlayRegistry.registerOverlayTop("Hotbar", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        if (!gui.f_92986_.f_91066_.f_92062_) {
            gui.setupOverlayRenderState(true, false);
            if (gui.f_92986_.f_91072_.m_105295_() == GameType.SPECTATOR) {
                gui.f_92997_.m_193837_(poseStack);
            } else {
                gui.m_93009_(partialTick, poseStack);
            }
        }
    });
    public static final IIngameOverlay CROSSHAIR_ELEMENT = OverlayRegistry.registerOverlayTop("Crosshair", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        if (!gui.f_92986_.f_91066_.f_92062_) {
            gui.setupOverlayRenderState(true, false);
            gui.m_93250_(-90);
            gui.m_93080_(poseStack);
        }
    });
    public static final IIngameOverlay BOSS_HEALTH_ELEMENT = OverlayRegistry.registerOverlayTop("Boss Health", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        if (!gui.f_92986_.f_91066_.f_92062_) {
            gui.setupOverlayRenderState(true, false);
            gui.m_93250_(-90);
            gui.renderBossHealth(poseStack);
        }
    });
    public static final IIngameOverlay PLAYER_HEALTH_ELEMENT = OverlayRegistry.registerOverlayTop("Player Health", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        if (!gui.f_92986_.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            gui.setupOverlayRenderState(true, false);
            gui.renderHealth(screenWidth, screenHeight, poseStack);
        }
    });
    public static final IIngameOverlay ARMOR_LEVEL_ELEMENT = OverlayRegistry.registerOverlayTop("Armor Level", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        if (!gui.f_92986_.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            gui.setupOverlayRenderState(true, false);
            gui.renderArmor(poseStack, screenWidth, screenHeight);
        }
    });
    public static final IIngameOverlay FOOD_LEVEL_ELEMENT = OverlayRegistry.registerOverlayTop("Food Level", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        boolean isMounted = gui.f_92986_.f_91074_.m_20202_() instanceof LivingEntity;
        if (!isMounted && !gui.f_92986_.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            gui.setupOverlayRenderState(true, false);
            gui.renderFood(screenWidth, screenHeight, poseStack);
        }
    });
    public static final IIngameOverlay MOUNT_HEALTH_ELEMENT = OverlayRegistry.registerOverlayTop("Mount Health", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        if (!gui.f_92986_.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            gui.setupOverlayRenderState(true, false);
            gui.renderHealthMount(screenWidth, screenHeight, poseStack);
        }
    });
    public static final IIngameOverlay AIR_LEVEL_ELEMENT = OverlayRegistry.registerOverlayTop("Air Level", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        if (!gui.f_92986_.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            gui.setupOverlayRenderState(true, false);
            gui.renderAir(screenWidth, screenHeight, poseStack);
        }
    });
    public static final IIngameOverlay JUMP_BAR_ELEMENT = OverlayRegistry.registerOverlayTop("Jump Bar", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        if (gui.f_92986_.f_91074_.m_108633_() && !gui.f_92986_.f_91066_.f_92062_) {
            gui.setupOverlayRenderState(true, false);
            gui.m_93033_(poseStack, screenWidth / 2 - 91);
        }
    });
    public static final IIngameOverlay EXPERIENCE_BAR_ELEMENT = OverlayRegistry.registerOverlayTop("Experience Bar", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        if (!gui.f_92986_.f_91074_.m_108633_() && !gui.f_92986_.f_91066_.f_92062_) {
            gui.setupOverlayRenderState(true, false);
            gui.renderExperience(screenWidth / 2 - 91, poseStack);
        }
    });
    public static final IIngameOverlay ITEM_NAME_ELEMENT = OverlayRegistry.registerOverlayTop("Item Name", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        if (!gui.f_92986_.f_91066_.f_92062_) {
            gui.setupOverlayRenderState(true, false);
            if (gui.f_92986_.f_91066_.f_92130_ && gui.f_92986_.f_91072_.m_105295_() != GameType.SPECTATOR) {
                gui.m_93069_(poseStack);
            } else if (gui.f_92986_.f_91074_.m_5833_()) {
                gui.f_92997_.m_94773_(poseStack);
            }
        }
    });
    public static final IIngameOverlay SLEEP_FADE_ELEMENT = OverlayRegistry.registerOverlayTop("Sleep Fade", (gui, poseStack, partialTick, screenWidth, screenHeight) -> gui.renderSleepFade(screenWidth, screenHeight, poseStack));
    public static final IIngameOverlay HUD_TEXT_ELEMENT = OverlayRegistry.registerOverlayTop("Text Columns", (gui, poseStack, partialTick, screenWidth, screenHeight) -> gui.renderHUDText(screenWidth, screenHeight, poseStack));
    public static final IIngameOverlay FPS_GRAPH_ELEMENT = OverlayRegistry.registerOverlayTop("FPS Graph", (gui, poseStack, partialTick, screenWidth, screenHeight) -> gui.renderFPSGraph(poseStack));
    public static final IIngameOverlay POTION_ICONS_ELEMENT = OverlayRegistry.registerOverlayTop("Potion Icons", (gui, poseStack, partialTick, screenWidth, screenHeight) -> gui.m_93028_(poseStack));
    public static final IIngameOverlay RECORD_OVERLAY_ELEMENT = OverlayRegistry.registerOverlayTop("Record", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        if (!gui.f_92986_.f_91066_.f_92062_) {
            gui.renderRecordOverlay(screenWidth, screenHeight, partialTick, poseStack);
        }
    });
    public static final IIngameOverlay SUBTITLES_ELEMENT = OverlayRegistry.registerOverlayTop("Subtitles", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        if (!gui.f_92986_.f_91066_.f_92062_) {
            gui.renderSubtitles(poseStack);
        }
    });
    public static final IIngameOverlay TITLE_TEXT_ELEMENT = OverlayRegistry.registerOverlayTop("Title Text", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        if (!gui.f_92986_.f_91066_.f_92062_) {
            gui.renderTitle(screenWidth, screenHeight, partialTick, poseStack);
        }
    });
    public static final IIngameOverlay SCOREBOARD_ELEMENT = OverlayRegistry.registerOverlayTop("Scoreboard", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        Objective scoreobjective1;
        int slot;
        Scoreboard scoreboard = gui.f_92986_.f_91073_.m_6188_();
        Objective objective = null;
        PlayerTeam scoreplayerteam = scoreboard.m_83500_(gui.f_92986_.f_91074_.m_6302_());
        if (scoreplayerteam != null && (slot = scoreplayerteam.m_7414_().m_126656_()) >= 0) {
            objective = scoreboard.m_83416_(3 + slot);
        }
        Objective objective2 = scoreobjective1 = objective != null ? objective : scoreboard.m_83416_(1);
        if (scoreobjective1 != null) {
            gui.m_93036_(poseStack, scoreobjective1);
        }
    });
    public static final IIngameOverlay CHAT_PANEL_ELEMENT = OverlayRegistry.registerOverlayTop("Chat History", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
        gui.renderChat(screenWidth, screenHeight, poseStack);
    });
    public static final IIngameOverlay PLAYER_LIST_ELEMENT = OverlayRegistry.registerOverlayTop("Player List", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
        gui.renderPlayerList(screenWidth, screenHeight, poseStack);
    });

    public void setupOverlayRenderState(boolean blend, boolean depthText) {
        this.setupOverlayRenderState(blend, depthText, Gui.f_93098_);
    }

    public void setupOverlayRenderState(boolean blend, boolean depthTest, @Nullable ResourceLocation texture) {
        if (blend) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
        } else {
            RenderSystem.m_69461_();
        }
        if (depthTest) {
            RenderSystem.m_69482_();
        } else {
            RenderSystem.m_69465_();
        }
        if (texture != null) {
            RenderSystem.m_69493_();
            this.bind(texture);
        } else {
            RenderSystem.m_69472_();
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
    }

    public ForgeIngameGui(Minecraft mc) {
        super(mc, mc.m_91291_());
        this.debugOverlay = new ForgeDebugScreenOverlay(mc);
    }

    public void m_93030_(PoseStack poseStack, float partialTick) {
        this.f_92977_ = this.f_92986_.m_91268_().m_85445_();
        this.f_92978_ = this.f_92986_.m_91268_().m_85446_();
        this.eventParent = new RenderGameOverlayEvent(poseStack, partialTick, this.f_92986_.m_91268_());
        this.right_height = 39;
        this.left_height = 39;
        if (this.pre(RenderGameOverlayEvent.ElementType.ALL, poseStack)) {
            return;
        }
        this.font = this.f_92986_.f_91062_;
        this.f_92985_.m_188584_((long)this.f_92989_ * 312871L);
        OverlayRegistry.orderedEntries().forEach(entry -> {
            try {
                if (!entry.isEnabled()) {
                    return;
                }
                IIngameOverlay overlay = entry.getOverlay();
                if (this.pre(overlay, poseStack)) {
                    return;
                }
                overlay.render(this, poseStack, partialTick, this.f_92977_, this.f_92978_);
                this.post(overlay, poseStack);
            }
            catch (Exception e) {
                LOGGER.error("Error rendering overlay '{}'", (Object)entry.getDisplayName(), (Object)e);
            }
        });
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.post(RenderGameOverlayEvent.ElementType.ALL, poseStack);
    }

    public boolean shouldDrawSurvivalElements() {
        return this.f_92986_.f_91072_.m_105205_() && this.f_92986_.m_91288_() instanceof Player;
    }

    protected void renderSubtitles(PoseStack poseStack) {
        this.f_92996_.m_94642_(poseStack);
    }

    protected void renderBossHealth(PoseStack poseStack) {
        this.bind(GuiComponent.f_93098_);
        RenderSystem.m_69453_();
        this.f_92986_.m_91307_().m_6180_("bossHealth");
        this.f_92999_.m_93704_(poseStack);
        this.f_92986_.m_91307_().m_7238_();
    }

    private void renderSpyglassOverlay() {
        float deltaFrame = this.f_92986_.m_91297_();
        this.f_168664_ = Mth.m_14179_((float)(0.5f * deltaFrame), (float)this.f_168664_, (float)1.125f);
        if (this.f_92986_.f_91066_.m_92176_().m_90612_()) {
            if (this.f_92986_.f_91074_.m_150108_()) {
                this.m_168675_(this.f_168664_);
            } else {
                this.f_168664_ = 0.5f;
            }
        }
    }

    private void renderHelmet(float partialTick, PoseStack poseStack) {
        ItemStack itemstack = this.f_92986_.f_91074_.m_150109_().m_36052_(3);
        if (this.f_92986_.f_91066_.m_92176_().m_90612_() && !itemstack.m_41619_()) {
            Item item = itemstack.m_41720_();
            if (item == Blocks.f_50143_.m_5456_()) {
                this.m_168708_(f_92983_, 1.0f);
            } else {
                RenderProperties.get(item).renderHelmetOverlay(itemstack, (Player)this.f_92986_.f_91074_, this.f_92977_, this.f_92978_, partialTick);
            }
        }
    }

    private void renderFrostbite(PoseStack pStack) {
        if (this.f_92986_.f_91074_.m_146888_() > 0) {
            this.m_168708_(f_168666_, this.f_92986_.f_91074_.m_146889_());
        }
    }

    protected void renderArmor(PoseStack poseStack, int width, int height) {
        this.f_92986_.m_91307_().m_6180_("armor");
        RenderSystem.m_69478_();
        int left = width / 2 - 91;
        int top = height - this.left_height;
        int level = this.f_92986_.f_91074_.m_21230_();
        for (int i = 1; level > 0 && i < 20; i += 2) {
            if (i < level) {
                this.m_93228_(poseStack, left, top, 34, 9, 9, 9);
            } else if (i == level) {
                this.m_93228_(poseStack, left, top, 25, 9, 9, 9);
            } else if (i > level) {
                this.m_93228_(poseStack, left, top, 16, 9, 9, 9);
            }
            left += 8;
        }
        this.left_height += 10;
        RenderSystem.m_69461_();
        this.f_92986_.m_91307_().m_7238_();
    }

    protected void m_93007_(float partialTick) {
        float f1 = Mth.m_14179_((float)partialTick, (float)this.f_92986_.f_91074_.f_108590_, (float)this.f_92986_.f_91074_.f_108589_);
        if (f1 > 0.0f) {
            super.m_93007_(f1);
        }
    }

    protected void renderAir(int width, int height, PoseStack poseStack) {
        this.f_92986_.m_91307_().m_6180_("air");
        Player player = (Player)this.f_92986_.m_91288_();
        RenderSystem.m_69478_();
        int left = width / 2 + 91;
        int top = height - this.right_height;
        int air = player.m_20146_();
        if (player.m_204029_(FluidTags.f_13131_) || air < 300) {
            int full = Mth.m_14165_((double)((double)(air - 2) * 10.0 / 300.0));
            int partial = Mth.m_14165_((double)((double)air * 10.0 / 300.0)) - full;
            for (int i = 0; i < full + partial; ++i) {
                this.m_93228_(poseStack, left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
            }
            this.right_height += 10;
        }
        RenderSystem.m_69461_();
        this.f_92986_.m_91307_().m_7238_();
    }

    public void renderHealth(int width, int height, PoseStack pStack) {
        boolean highlight;
        this.bind(f_93098_);
        this.f_92986_.m_91307_().m_6180_("health");
        RenderSystem.m_69478_();
        Player player = (Player)this.f_92986_.m_91288_();
        int health = Mth.m_14167_((float)player.m_21223_());
        boolean bl = highlight = this.f_92976_ > (long)this.f_92989_ && (this.f_92976_ - (long)this.f_92989_) / 3L % 2L == 1L;
        if (health < this.f_92973_ && player.f_19802_ > 0) {
            this.f_92975_ = Util.m_137550_();
            this.f_92976_ = this.f_92989_ + 20;
        } else if (health > this.f_92973_ && player.f_19802_ > 0) {
            this.f_92975_ = Util.m_137550_();
            this.f_92976_ = this.f_92989_ + 10;
        }
        if (Util.m_137550_() - this.f_92975_ > 1000L) {
            this.f_92973_ = health;
            this.f_92974_ = health;
            this.f_92975_ = Util.m_137550_();
        }
        this.f_92973_ = health;
        int healthLast = this.f_92974_;
        AttributeInstance attrMaxHealth = player.m_21051_(Attributes.f_22276_);
        float healthMax = Math.max((float)attrMaxHealth.m_22135_(), (float)Math.max(healthLast, health));
        int absorb = Mth.m_14167_((float)player.m_6103_());
        int healthRows = Mth.m_14167_((float)((healthMax + (float)absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.f_92985_.m_188584_((long)(this.f_92989_ * 312871));
        int left = width / 2 - 91;
        int top = height - this.left_height;
        this.left_height += healthRows * rowHeight;
        if (rowHeight != 10) {
            this.left_height += 10 - rowHeight;
        }
        int regen = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            regen = this.f_92989_ % Mth.m_14167_((float)(healthMax + 5.0f));
        }
        this.m_168688_(pStack, player, left, top, rowHeight, regen, healthMax, health, healthLast, absorb, highlight);
        RenderSystem.m_69461_();
        this.f_92986_.m_91307_().m_7238_();
    }

    public void renderFood(int width, int height, PoseStack poseStack) {
        this.f_92986_.m_91307_().m_6180_("food");
        Player player = (Player)this.f_92986_.m_91288_();
        RenderSystem.m_69478_();
        int left = width / 2 + 91;
        int top = height - this.right_height;
        this.right_height += 10;
        boolean unused = false;
        FoodData stats = this.f_92986_.f_91074_.m_36324_();
        int level = stats.m_38702_();
        for (int i = 0; i < 10; ++i) {
            int idx = i * 2 + 1;
            int x = left - i * 8 - 9;
            int y = top;
            int icon = 16;
            int background = 0;
            if (this.f_92986_.f_91074_.m_21023_(MobEffects.f_19612_)) {
                icon += 36;
                background = 13;
            }
            if (unused) {
                background = 1;
            }
            if (player.m_36324_().m_38722_() <= 0.0f && this.f_92989_ % (level * 3 + 1) == 0) {
                y = top + (this.f_92985_.m_188503_(3) - 1);
            }
            this.m_93228_(poseStack, x, y, 16 + background * 9, 27, 9, 9);
            if (idx < level) {
                this.m_93228_(poseStack, x, y, icon + 36, 27, 9, 9);
                continue;
            }
            if (idx != level) continue;
            this.m_93228_(poseStack, x, y, icon + 45, 27, 9, 9);
        }
        RenderSystem.m_69461_();
        this.f_92986_.m_91307_().m_7238_();
    }

    protected void renderSleepFade(int width, int height, PoseStack poseStack) {
        if (this.f_92986_.f_91074_.m_36318_() > 0) {
            this.f_92986_.m_91307_().m_6180_("sleep");
            RenderSystem.m_69465_();
            int sleepTime = this.f_92986_.f_91074_.m_36318_();
            float opacity = (float)sleepTime / 100.0f;
            if (opacity > 1.0f) {
                opacity = 1.0f - (float)(sleepTime - 100) / 10.0f;
            }
            int color = (int)(220.0f * opacity) << 24 | 0x101020;
            ForgeIngameGui.m_93172_((PoseStack)poseStack, (int)0, (int)0, (int)width, (int)height, (int)color);
            RenderSystem.m_69482_();
            this.f_92986_.m_91307_().m_7238_();
        }
    }

    protected void renderExperience(int x, PoseStack poseStack) {
        this.bind(f_93098_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        if (this.f_92986_.f_91072_.m_105288_()) {
            super.m_93071_(poseStack, x);
        }
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void m_93033_(PoseStack poseStack, int x) {
        this.bind(f_93098_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        super.m_93033_(poseStack, x);
        RenderSystem.m_69478_();
        this.f_92986_.m_91307_().m_7238_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderHUDText(int width, int height, PoseStack poseStack) {
        RenderGameOverlayEvent.Text event;
        this.f_92986_.m_91307_().m_6180_("forgeHudText");
        RenderSystem.m_69453_();
        ArrayList<String> listL = new ArrayList<String>();
        ArrayList<String> listR = new ArrayList<String>();
        if (this.f_92986_.m_91402_()) {
            long time = this.f_92986_.f_91073_.m_46467_();
            if (time >= 120500L) {
                listR.add(I18n.m_118938_((String)"demo.demoExpired", (Object[])new Object[0]));
            } else {
                listR.add(I18n.m_118938_((String)"demo.remainingTime", (Object[])new Object[]{StringUtil.m_14404_((int)((int)(120500L - time)))}));
            }
        }
        if (this.f_92986_.f_91066_.f_92063_ && !this.pre(RenderGameOverlayEvent.ElementType.DEBUG, poseStack)) {
            this.debugOverlay.update();
            listL.addAll(this.debugOverlay.getLeft());
            listR.addAll(this.debugOverlay.getRight());
            this.post(RenderGameOverlayEvent.ElementType.DEBUG, poseStack);
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)(event = new RenderGameOverlayEvent.Text(poseStack, this.eventParent, listL, listR)))) {
            int top = 2;
            for (String msg : listL) {
                if (msg != null && !msg.isEmpty()) {
                    int n = 2 + this.font.m_92895_(msg) + 1;
                    Objects.requireNonNull(this.font);
                    ForgeIngameGui.m_93172_((PoseStack)poseStack, (int)1, (int)(top - 1), (int)n, (int)(top + 9 - 1), (int)-1873784752);
                    this.font.m_92883_(poseStack, msg, 2.0f, (float)top, 0xE0E0E0);
                }
                Objects.requireNonNull(this.font);
                top += 9;
            }
            top = 2;
            for (String msg : listR) {
                if (msg != null && !msg.isEmpty()) {
                    int w = this.font.m_92895_(msg);
                    int left = width - 2 - w;
                    Objects.requireNonNull(this.font);
                    ForgeIngameGui.m_93172_((PoseStack)poseStack, (int)(left - 1), (int)(top - 1), (int)(left + w + 1), (int)(top + 9 - 1), (int)-1873784752);
                    this.font.m_92883_(poseStack, msg, (float)left, (float)top, 0xE0E0E0);
                }
                Objects.requireNonNull(this.font);
                top += 9;
            }
        }
        this.f_92986_.m_91307_().m_7238_();
        this.post(RenderGameOverlayEvent.ElementType.TEXT, poseStack);
    }

    protected void renderFPSGraph(PoseStack poseStack) {
        if (this.f_92986_.f_91066_.f_92063_ && this.f_92986_.f_91066_.f_92065_) {
            this.debugOverlay.m_94056_(poseStack);
        }
    }

    protected void renderRecordOverlay(int width, int height, float partialTick, PoseStack pStack) {
        if (this.f_92991_ > 0) {
            this.f_92986_.m_91307_().m_6180_("overlayMessage");
            float hue = (float)this.f_92991_ - partialTick;
            int opacity = (int)(hue * 255.0f / 20.0f);
            if (opacity > 255) {
                opacity = 255;
            }
            if (opacity > 8) {
                pStack.m_85836_();
                pStack.m_85837_((double)width / 2.0, (double)(height - 68), 0.0);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                int color = this.f_92992_ ? Mth.m_14169_((float)(hue / 50.0f), (float)0.7f, (float)0.6f) & 0xFFFFFF : 0xFFFFFF;
                this.m_93039_(pStack, this.font, -4, this.font.m_92852_((FormattedText)this.f_92990_), 0xFFFFFF | opacity << 24);
                this.font.m_92877_(pStack, this.f_92990_.m_7532_(), (float)(-this.font.m_92852_((FormattedText)this.f_92990_) / 2), -4.0f, color | opacity << 24);
                RenderSystem.m_69461_();
                pStack.m_85849_();
            }
            this.f_92986_.m_91307_().m_7238_();
        }
    }

    protected void renderTitle(int width, int height, float partialTick, PoseStack pStack) {
        if (this.f_93001_ != null && this.f_93000_ > 0) {
            this.f_92986_.m_91307_().m_6180_("titleAndSubtitle");
            float age = (float)this.f_93000_ - partialTick;
            int opacity = 255;
            if (this.f_93000_ > this.f_92972_ + this.f_92971_) {
                float f3 = (float)(this.f_92970_ + this.f_92971_ + this.f_92972_) - age;
                opacity = (int)(f3 * 255.0f / (float)this.f_92970_);
            }
            if (this.f_93000_ <= this.f_92972_) {
                opacity = (int)(age * 255.0f / (float)this.f_92972_);
            }
            if ((opacity = Mth.m_14045_((int)opacity, (int)0, (int)255)) > 8) {
                pStack.m_85836_();
                pStack.m_85837_((double)width / 2.0, (double)height / 2.0, 0.0);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                pStack.m_85836_();
                pStack.m_85841_(4.0f, 4.0f, 4.0f);
                int l = opacity << 24 & 0xFF000000;
                this.m_93082_().m_92744_(pStack, this.f_93001_.m_7532_(), (float)(-this.m_93082_().m_92852_((FormattedText)this.f_93001_) / 2), -10.0f, 0xFFFFFF | l);
                pStack.m_85849_();
                if (this.f_93002_ != null) {
                    pStack.m_85836_();
                    pStack.m_85841_(2.0f, 2.0f, 2.0f);
                    this.m_93082_().m_92744_(pStack, this.f_93002_.m_7532_(), (float)(-this.m_93082_().m_92852_((FormattedText)this.f_93002_) / 2), 5.0f, 0xFFFFFF | l);
                    pStack.m_85849_();
                }
                RenderSystem.m_69461_();
                pStack.m_85849_();
            }
            this.f_92986_.m_91307_().m_7238_();
        }
    }

    protected void renderChat(int width, int height, PoseStack pStack) {
        this.f_92986_.m_91307_().m_6180_("chat");
        RenderGameOverlayEvent.Chat event = new RenderGameOverlayEvent.Chat(pStack, this.eventParent, 0, height - 48);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        pStack.m_85836_();
        pStack.m_85837_((double)event.getPosX(), (double)event.getPosY(), 0.0);
        this.f_92988_.m_93780_(pStack, this.f_92989_);
        pStack.m_85849_();
        this.post(RenderGameOverlayEvent.ElementType.CHAT, pStack);
        this.f_92986_.m_91307_().m_7238_();
    }

    protected void renderPlayerList(int width, int height, PoseStack poseStack) {
        Objective scoreobjective = this.f_92986_.f_91073_.m_6188_().m_83416_(0);
        ClientPacketListener handler = this.f_92986_.f_91074_.f_108617_;
        if (this.f_92986_.f_91066_.f_92099_.m_90857_() && (!this.f_92986_.m_91090_() || handler.m_105142_().size() > 1 || scoreobjective != null)) {
            this.f_92998_.m_94556_(true);
            if (this.pre(RenderGameOverlayEvent.ElementType.PLAYER_LIST, poseStack)) {
                return;
            }
            this.f_92998_.m_94544_(poseStack, width, this.f_92986_.f_91073_.m_6188_(), scoreobjective);
            this.post(RenderGameOverlayEvent.ElementType.PLAYER_LIST, poseStack);
        } else {
            this.f_92998_.m_94556_(false);
        }
    }

    protected void renderHealthMount(int width, int height, PoseStack poseStack) {
        Player player = (Player)this.f_92986_.m_91288_();
        Entity tmp = player.m_20202_();
        if (!(tmp instanceof LivingEntity)) {
            return;
        }
        this.bind(f_93098_);
        boolean unused = false;
        int left_align = width / 2 + 91;
        this.f_92986_.m_91307_().m_6182_("mountHealth");
        RenderSystem.m_69478_();
        LivingEntity mount = (LivingEntity)tmp;
        int health = (int)Math.ceil(mount.m_21223_());
        float healthMax = mount.m_21233_();
        int hearts = (int)(healthMax + 0.5f) / 2;
        if (hearts > 30) {
            hearts = 30;
        }
        int MARGIN = 52;
        int BACKGROUND = 52 + (unused ? 1 : 0);
        int HALF = 97;
        int FULL = 88;
        int heart = 0;
        while (hearts > 0) {
            int top = height - this.right_height;
            int rowCount = Math.min(hearts, 10);
            hearts -= rowCount;
            for (int i = 0; i < rowCount; ++i) {
                int x = left_align - i * 8 - 9;
                this.m_93228_(poseStack, x, top, BACKGROUND, 9, 9, 9);
                if (i * 2 + 1 + heart < health) {
                    this.m_93228_(poseStack, x, top, 88, 9, 9, 9);
                    continue;
                }
                if (i * 2 + 1 + heart != health) continue;
                this.m_93228_(poseStack, x, top, 97, 9, 9, 9);
            }
            this.right_height += 10;
            heart += 20;
        }
        RenderSystem.m_69461_();
    }

    private boolean pre(RenderGameOverlayEvent.ElementType type, PoseStack poseStack) {
        return MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Pre(poseStack, this.eventParent, type));
    }

    private void post(RenderGameOverlayEvent.ElementType type, PoseStack poseStack) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post(poseStack, this.eventParent, type));
    }

    private boolean pre(IIngameOverlay overlay, PoseStack poseStack) {
        return MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.PreLayer(poseStack, this.eventParent, overlay));
    }

    private void post(IIngameOverlay overlay, PoseStack poseStack) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.PostLayer(poseStack, this.eventParent, overlay));
    }

    private void bind(ResourceLocation res) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)res);
    }

    private class ForgeDebugScreenOverlay
    extends DebugScreenOverlay {
        private Minecraft mc;

        private ForgeDebugScreenOverlay(Minecraft mc) {
            super(mc);
            this.mc = mc;
        }

        public void update() {
            Entity entity = this.mc.m_91288_();
            this.f_94032_ = entity.m_19907_(rayTraceDistance, 0.0f, false);
            this.f_94033_ = entity.m_19907_(rayTraceDistance, 0.0f, true);
        }

        protected void m_94076_(PoseStack poseStack) {
        }

        protected void m_94079_(PoseStack poseStack) {
        }

        private List<String> getLeft() {
            List ret = this.m_94075_();
            ret.add("");
            boolean flag = this.mc.m_91092_() != null;
            ret.add("Debug: Pie [shift]: " + (this.mc.f_91066_.f_92064_ ? "visible" : "hidden") + (flag ? " FPS + TPS" : " FPS") + " [alt]: " + (this.mc.f_91066_.f_92065_ ? "visible" : "hidden"));
            ret.add("For help: press F3 + Q");
            return ret;
        }

        private List<String> getRight() {
            return this.m_94078_();
        }
    }
}

