/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui;

import com.google.common.base.Strings;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoadingErrorScreen
extends ErrorScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path modsDir;
    private final Path logFile;
    private final List<ModLoadingException> modLoadErrors;
    private final List<ModLoadingWarning> modLoadWarnings;
    private final Path dumpedLocation;
    private LoadingEntryList entryList;
    private Component errorHeader;
    private Component warningHeader;

    public LoadingErrorScreen(LoadingFailedException loadingException, List<ModLoadingWarning> warnings, File dumpedLocation) {
        super((Component)Component.m_237113_((String)"Loading Error"), null);
        this.modLoadWarnings = warnings;
        this.modLoadErrors = loadingException == null ? Collections.emptyList() : loadingException.getErrors();
        this.modsDir = FMLPaths.MODSDIR.get();
        this.logFile = FMLPaths.GAMEDIR.get().resolve(Paths.get("logs", "latest.log"));
        this.dumpedLocation = dumpedLocation != null ? dumpedLocation.toPath() : null;
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.errorHeader = Component.m_237113_((String)(ChatFormatting.RED + ForgeI18n.parseMessage("fml.loadingerrorscreen.errorheader", this.modLoadErrors.size()) + ChatFormatting.RESET));
        this.warningHeader = Component.m_237113_((String)(ChatFormatting.YELLOW + ForgeI18n.parseMessage("fml.loadingerrorscreen.warningheader", this.modLoadErrors.size()) + ChatFormatting.RESET));
        int yOffset = 46;
        this.m_142416_((GuiEventListener)new ExtendedButton(50, this.f_96544_ - yOffset, this.f_96543_ / 2 - 55, 20, (Component)Component.m_237113_((String)ForgeI18n.parseMessage("fml.button.open.mods.folder", new Object[0])), b -> Util.m_137581_().m_137644_(this.modsDir.toFile())));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 + 5, this.f_96544_ - yOffset, this.f_96543_ / 2 - 55, 20, (Component)Component.m_237113_((String)ForgeI18n.parseMessage("fml.button.open.file", this.logFile.getFileName())), b -> Util.m_137581_().m_137644_(this.logFile.toFile())));
        if (this.modLoadErrors.isEmpty()) {
            this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 4, this.f_96544_ - 24, this.f_96543_ / 2, 20, (Component)Component.m_237113_((String)ForgeI18n.parseMessage("fml.button.continue.launch", new Object[0])), b -> this.f_96541_.m_91152_(null)));
        } else {
            this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 4, this.f_96544_ - 24, this.f_96543_ / 2, 20, (Component)Component.m_237113_((String)ForgeI18n.parseMessage("fml.button.open.file", this.dumpedLocation.getFileName())), b -> Util.m_137581_().m_137644_(this.dumpedLocation.toFile())));
        }
        this.entryList = new LoadingEntryList(this, this.modLoadErrors, this.modLoadWarnings);
        this.m_7787_((GuiEventListener)this.entryList);
        this.m_7522_((GuiEventListener)this.entryList);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        this.entryList.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.drawMultiLineCenteredString(poseStack, this.f_96547_, this.modLoadErrors.isEmpty() ? this.warningHeader : this.errorHeader, this.f_96543_ / 2, 10);
        this.f_169369_.forEach(button -> button.m_6305_(poseStack, mouseX, mouseY, partialTick));
    }

    private void drawMultiLineCenteredString(PoseStack poseStack, Font fr, Component str, int x, int y) {
        for (FormattedCharSequence s : fr.m_92923_((FormattedText)str, this.f_96543_)) {
            fr.m_92744_(poseStack, s, (float)((double)x - (double)fr.m_92724_(s) / 2.0), (float)y, 0xFFFFFF);
            Objects.requireNonNull(fr);
            y += 9;
        }
    }

    public static class LoadingEntryList
    extends ObjectSelectionList<LoadingMessageEntry> {
        LoadingEntryList(LoadingErrorScreen parent, List<ModLoadingException> errors, List<ModLoadingWarning> warnings) {
            boolean both;
            Minecraft minecraft = parent.f_96541_;
            int n = parent.f_96543_;
            int n2 = parent.f_96544_;
            int n3 = parent.f_96544_ - 50;
            Objects.requireNonNull(((LoadingErrorScreen)parent).f_96541_.f_91062_);
            super(minecraft, n, n2, 35, n3, 2 * 9 + 8);
            boolean bl = both = !errors.isEmpty() && !warnings.isEmpty();
            if (both) {
                this.m_7085_((AbstractSelectionList.Entry)new LoadingMessageEntry(parent.errorHeader, true));
            }
            errors.forEach(e -> this.m_7085_((AbstractSelectionList.Entry)new LoadingMessageEntry((Component)Component.m_237113_((String)e.formatToString()))));
            if (both) {
                int maxChars = (this.f_93388_ - 10) / ((LoadingErrorScreen)parent).f_96541_.f_91062_.m_92895_("-");
                this.m_7085_((AbstractSelectionList.Entry)new LoadingMessageEntry((Component)Component.m_237113_((String)("\n" + Strings.repeat((String)"-", (int)maxChars) + "\n"))));
                this.m_7085_((AbstractSelectionList.Entry)new LoadingMessageEntry(parent.warningHeader, true));
            }
            warnings.forEach(w -> this.m_7085_((AbstractSelectionList.Entry)new LoadingMessageEntry((Component)Component.m_237113_((String)w.formatToString()))));
        }

        protected int m_5756_() {
            return this.getRight() - 6;
        }

        public int m_5759_() {
            return this.f_93388_;
        }

        public class LoadingMessageEntry
        extends ObjectSelectionList.Entry<LoadingMessageEntry> {
            private final Component message;
            private final boolean center;

            LoadingMessageEntry(Component message) {
                this(message, false);
            }

            LoadingMessageEntry(Component message, boolean center) {
                this.message = Objects.requireNonNull(message);
                this.center = center;
            }

            public Component m_142172_() {
                return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.message});
            }

            public void m_6311_(PoseStack poseStack, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTick) {
                Font font = Minecraft.m_91087_().f_91062_;
                List strings = font.m_92923_((FormattedText)this.message, LoadingEntryList.this.f_93388_);
                int y = top + 2;
                for (int i = 0; i < Math.min(strings.size(), 2); ++i) {
                    if (this.center) {
                        font.m_92877_(poseStack, (FormattedCharSequence)strings.get(i), (float)(left + LoadingEntryList.this.f_93388_) - (float)font.m_92724_((FormattedCharSequence)strings.get(i)) / 2.0f, (float)y, 0xFFFFFF);
                    } else {
                        font.m_92877_(poseStack, (FormattedCharSequence)strings.get(i), (float)(left + 5), (float)y, 0xFFFFFF);
                    }
                    Objects.requireNonNull(font);
                    y += 9;
                }
            }
        }
    }
}

