/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraftforge.client.gui.IIngameOverlay;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlayRegistry {
    private static final Map<IIngameOverlay, OverlayEntry> overlays = Maps.newHashMap();
    private static final List<OverlayEntry> overlaysOrdered = Lists.newArrayList();

    public static synchronized IIngameOverlay registerOverlayBottom(@NotNull String displayName, @NotNull IIngameOverlay overlay) {
        return OverlayRegistry.registerOverlay(-1, null, displayName, overlay);
    }

    public static synchronized IIngameOverlay registerOverlayBelow(@NotNull IIngameOverlay other, @NotNull String displayName, @NotNull IIngameOverlay overlay) {
        return OverlayRegistry.registerOverlay(-1, other, displayName, overlay);
    }

    public static synchronized IIngameOverlay registerOverlayAbove(@NotNull IIngameOverlay other, @NotNull String displayName, @NotNull IIngameOverlay overlay) {
        return OverlayRegistry.registerOverlay(1, other, displayName, overlay);
    }

    public static synchronized IIngameOverlay registerOverlayTop(@NotNull String displayName, @NotNull IIngameOverlay overlay) {
        return OverlayRegistry.registerOverlay(1, null, displayName, overlay);
    }

    private static IIngameOverlay registerOverlay(int sort, @Nullable IIngameOverlay other, @NotNull String displayName, @NotNull IIngameOverlay overlay) {
        int insertAt;
        OverlayEntry entry;
        block4: {
            block3: {
                entry = overlays.get(overlay);
                if (entry != null) {
                    overlaysOrdered.remove(entry);
                }
                insertAt = overlays.size();
                if (other != null) break block3;
                if (sort >= 0) break block4;
                insertAt = 0;
                break block4;
            }
            for (int i = 0; i < overlaysOrdered.size(); ++i) {
                OverlayEntry ov = overlaysOrdered.get(i);
                if (ov.getOverlay() != other) continue;
                if (sort < 0) {
                    insertAt = i;
                    break;
                }
                insertAt = i + 1;
                break;
            }
        }
        entry = new OverlayEntry(overlay, displayName);
        overlaysOrdered.add(insertAt, entry);
        overlays.put(overlay, entry);
        return overlay;
    }

    public static synchronized void enableOverlay(@NotNull IIngameOverlay overlay, boolean enable) {
        OverlayEntry entry = overlays.get(overlay);
        if (entry != null) {
            entry.setEnabled(enable);
        }
    }

    @Nullable
    public static synchronized OverlayEntry getEntry(@NotNull IIngameOverlay overlay) {
        return overlays.get(overlay);
    }

    public static List<OverlayEntry> orderedEntries() {
        return Collections.unmodifiableList(overlaysOrdered);
    }

    public static class OverlayEntry {
        private final IIngameOverlay overlay;
        private final String displayName;
        private boolean enabled = true;

        public OverlayEntry(IIngameOverlay overlay, String displayName) {
            this.overlay = overlay;
            this.displayName = displayName;
        }

        public IIngameOverlay getOverlay() {
            return this.overlay;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        private void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

